/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.purap.PurchasingAccountsPayableModuleService;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocumentTest;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.parke)
public class PurchasingAccountsPayableModuleServiceIntegTest
extends KualiTestBase {
    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public void testAddAssignedAssetNumbers() throws Exception {
        PurchaseOrderDocumentTest documentTest = new PurchaseOrderDocumentTest();
        PurchaseOrderDocument poDocument = documentTest.buildSimpleDocument();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        poDocument.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)poDocument, (DocumentService)documentService);
        PurchaseOrderDocument result = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(poDocument.getDocumentNumber());
        Integer purchaseOrderNumber = result.getPurapDocumentIdentifier();
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        assetNumbers.add(new Long("12345"));
        assetNumbers.add(new Long("12346"));
        String authorId = "khuntley";
        StringBuilder noteText = new StringBuilder("Asset Numbers have been created for this document: ");
        for (int i = 0; i < assetNumbers.size(); ++i) {
            noteText.append(((Long)assetNumbers.get(i)).toString());
            if (i >= assetNumbers.size() - 1) continue;
            noteText.append(", ");
        }
        ((PurchasingAccountsPayableModuleService)SpringContext.getBean(PurchasingAccountsPayableModuleService.class)).addAssignedAssetNumbers(purchaseOrderNumber, authorId, noteText.toString());
        PurchaseOrderDocument po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(purchaseOrderNumber);
        PurchasingAccountsPayableModuleServiceIntegTest.assertNotNull((String)"PO should not have been null", (Object)po);
        List boNotes = po.getNotes();
        boolean hasNote = false;
        for (Note note : boNotes) {
            if (!note.getNoteText().contains("Asset Numbers have been created for this document:")) continue;
            hasNote = true;
            break;
        }
        PurchasingAccountsPayableModuleServiceIntegTest.assertTrue((String)"note was missing from PO", (boolean)hasNote);
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public void testGetPurchaseOrderInquiryUrl() throws Exception {
        PurchaseOrderDocumentTest documentTest = new PurchaseOrderDocumentTest();
        PurchaseOrderDocument poDocument = documentTest.buildSimpleDocument();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        poDocument.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)poDocument, (DocumentService)documentService);
        PurchaseOrderDocument result = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(poDocument.getDocumentNumber());
        Integer purchaseOrderNumber = result.getPurapDocumentIdentifier();
        String url = ((PurchasingAccountsPayableModuleService)SpringContext.getBean(PurchasingAccountsPayableModuleService.class)).getPurchaseOrderInquiryUrl(purchaseOrderNumber);
        PurchasingAccountsPayableModuleServiceIntegTest.assertFalse((String)"url was empty", (boolean)StringUtils.isEmpty((CharSequence)url));
    }
}

