/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.identity;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.identity.RoleTestBase;

@ConfigureContext
public class PurapKFSApplicationRoleTest
extends RoleTestBase {
    public static final String PURAP_NAMESPACE = "KFS-PURAP";
    public static final String STRAIGHT_COMMODITY_USER = "season";
    public static final String WILDCARD_COMMODITY_USER = "cdbookma";
    public static final String BAD_WILDCARD_COMMODITY_USER = "fwillhit";
    public static final String COMMODITY_CAMPUS = "BL";
    public static final String COMMODITY_CODE = "1113";
    public static final String COMMODITY_REVIEWER_ROLE_NAME = "Commodity Reviewer";
    public static final String SENSITIVE_DATA_1 = "ANIM";
    public static final String SENSITIVE_DATA_2 = "RADI";
    public static final String SENSITIVE_DATA_3 = "ANIM;RADI";
    public static final String SENSITIVE_DATA_REVIEWER = "bhhallow";
    public static final String SENSITIVE_DATA_ROLE_NAME = "Sensitive Data Viewer";

    public void testCommodityReviewRoleTypeService() {
        HashMap<String, String> roleQualifiers = new HashMap<String, String>();
        roleQualifiers.put("campusCode", COMMODITY_CAMPUS);
        roleQualifiers.put("purchasingCommodityCode", COMMODITY_CODE);
        this.assertUserIsRoleMember(this.getPrincipalIdByName(STRAIGHT_COMMODITY_USER), PURAP_NAMESPACE, COMMODITY_REVIEWER_ROLE_NAME, roleQualifiers);
        this.assertUserIsRoleMember(this.getPrincipalIdByName(WILDCARD_COMMODITY_USER), PURAP_NAMESPACE, COMMODITY_REVIEWER_ROLE_NAME, roleQualifiers);
        this.assertUserIsNotRoleMember(this.getPrincipalIdByName(BAD_WILDCARD_COMMODITY_USER), PURAP_NAMESPACE, COMMODITY_REVIEWER_ROLE_NAME, roleQualifiers);
    }

    public Map<String, String> buildRoleQualificationForSensitiveData(String sensitiveDataCode) {
        HashMap<String, String> roleQualification = new HashMap<String, String>();
        roleQualification.put("sensitiveDataCode", sensitiveDataCode);
        return roleQualification;
    }

    public void testSensitiveDataRoleTypeService() {
        this.assertUserIsRoleMember(this.getPrincipalIdByName(SENSITIVE_DATA_REVIEWER), PURAP_NAMESPACE, SENSITIVE_DATA_ROLE_NAME, this.buildRoleQualificationForSensitiveData(SENSITIVE_DATA_1));
        this.assertUserIsNotRoleMember(this.getPrincipalIdByName(SENSITIVE_DATA_REVIEWER), PURAP_NAMESPACE, SENSITIVE_DATA_ROLE_NAME, this.buildRoleQualificationForSensitiveData(SENSITIVE_DATA_2));
        this.assertUserIsRoleMember(this.getPrincipalIdByName(SENSITIVE_DATA_REVIEWER), PURAP_NAMESPACE, SENSITIVE_DATA_ROLE_NAME, this.buildRoleQualificationForSensitiveData(SENSITIVE_DATA_3));
    }
}

