/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl.PurapGeneralLedgerTest;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SpringContext.class})
public class GenerateEntriesCreatePaymentRequestTest
extends PurapGeneralLedgerTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurchaseOrderService purchaseOrderSvcMock;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private AccountService accountSvcMock;
    @Mock
    private PaymentRequestDocument paymentRequestDocMock;
    @Mock
    private PurchaseOrderDocument purchaseOrderDocMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
    }

    @Test
    public void noItems() {
        Mockito.when((Object)this.paymentRequestDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1000))).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.paymentRequestDocMock.getItems()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save((PersistableBusinessObject)this.purchaseOrderDocMock)).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocMock)).thenReturn(new ArrayList());
        this.paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        this.paymentRequestDocMock.setDebitCreditCodeForGLEntries("C");
        this.paymentRequestDocMock.setGenerateEncumbranceEntries(true);
        Mockito.when((Object)this.paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        this.cut.generateEntriesCreatePaymentRequest(this.paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getItems();
        this.verifyAll();
    }

    @Test
    public void itemsNoGLPEsNoAccountingLines() {
        Mockito.when((Object)this.paymentRequestDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1000))).thenReturn((Object)this.purchaseOrderDocMock);
        ArrayList<PurApItem> preqItems = new ArrayList<PurApItem>();
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 100, null, null, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 1, null, null, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 2, null, null, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 3, KDONE, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 4, KDTWO, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 5, KDONE, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 6, KDONE, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 7, KDONE, new BigDecimal("2.00"), "ITEM"));
        Mockito.when((Object)this.paymentRequestDocMock.getItems()).thenReturn(preqItems);
        ArrayList<PurApItem> poItems = new ArrayList<PurApItem>();
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 1, null, null, null, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 2, KDONE, BigDecimal.ZERO, null, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 3, KDONE, BigDecimal.ZERO, null, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 4, KDONE, BigDecimal.ZERO, KDONE, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 5, KDTWO, BigDecimal.ZERO, KDONE, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 6, KDTWO, BigDecimal.ZERO, KDONE, KDONE, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 7, KDTWO, BigDecimal.ONE, KDONE, KDONE, new KualiDecimal("0.50"), new KualiDecimal("0.75"), "ITEM"));
        Mockito.when((Object)this.purchaseOrderDocMock.getItems()).thenReturn(poItems);
        Mockito.when((Object)this.paymentRequestDocMock.isUseTaxIndicator()).thenReturn((Object)false);
        Mockito.when((Object)this.boServiceMock.save((PersistableBusinessObject)this.purchaseOrderDocMock)).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocMock)).thenReturn(new ArrayList());
        this.paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        this.paymentRequestDocMock.setDebitCreditCodeForGLEntries("C");
        this.paymentRequestDocMock.setGenerateEncumbranceEntries(true);
        Mockito.when((Object)this.paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        this.cut.generateEntriesCreatePaymentRequest(this.paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)7))).isUseTaxIndicator();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.purchaseOrderDocMock, (VerificationMode)Mockito.times((int)8))).getItems();
        this.verifyAll();
    }

    @Test
    public void itemsNoGLPEsNoAccountingLinesMisc() {
        Mockito.when((Object)this.paymentRequestDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1000))).thenReturn((Object)this.purchaseOrderDocMock);
        ArrayList<PurApItem> preqItems = new ArrayList<PurApItem>();
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 100, null, null, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 1, null, null, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 2, null, null, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 3, KDONE, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 4, KDTWO, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 5, KDONE, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 6, KDONE, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 7, KDONE, new BigDecimal("2.00"), "MISC"));
        Mockito.when((Object)this.paymentRequestDocMock.getItems()).thenReturn(preqItems);
        ArrayList<PurApItem> poItems = new ArrayList<PurApItem>();
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 1, null, null, null, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 2, KDONE, BigDecimal.ZERO, null, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 3, KDONE, BigDecimal.ZERO, null, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 4, KDONE, BigDecimal.ZERO, KDONE, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 5, KDTWO, BigDecimal.ZERO, KDONE, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 6, KDTWO, BigDecimal.ZERO, KDONE, KDONE, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocMock, 7, KDTWO, BigDecimal.ONE, KDONE, KDONE, new KualiDecimal("0.50"), new KualiDecimal("0.75"), "MISC"));
        Mockito.when((Object)this.purchaseOrderDocMock.getItems()).thenReturn(poItems);
        Mockito.when((Object)this.paymentRequestDocMock.isUseTaxIndicator()).thenReturn((Object)false);
        Mockito.when((Object)this.boServiceMock.save((PersistableBusinessObject)this.purchaseOrderDocMock)).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocMock)).thenReturn(new ArrayList());
        this.paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        this.paymentRequestDocMock.setDebitCreditCodeForGLEntries("C");
        this.paymentRequestDocMock.setGenerateEncumbranceEntries(true);
        Mockito.when((Object)this.paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        this.cut.generateEntriesCreatePaymentRequest(this.paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)8))).isUseTaxIndicator();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.purchaseOrderDocMock, (VerificationMode)Mockito.times((int)8))).getItems();
        this.verifyAll();
    }

    @Test
    public void itemsNoGLPEsAccountingLines() {
        Mockito.when((Object)this.paymentRequestDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1000))).thenReturn((Object)this.purchaseOrderDocMock);
        ArrayList<PurApItem> preqItems = new ArrayList<PurApItem>();
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocMock, 1, KDONE, new BigDecimal("2.00"), "MISC"));
        Mockito.when((Object)this.paymentRequestDocMock.getItems()).thenReturn(preqItems);
        ArrayList<PurchaseOrderItem> poItems = new ArrayList<PurchaseOrderItem>();
        PurchaseOrderItem poItem = (PurchaseOrderItem)this.getPurchaseOrderItem(this.purchaseOrderDocMock, 1, KDTWO, BigDecimal.ONE, KDONE, KDONE, new KualiDecimal("0.50"), new KualiDecimal("0.75"), "MISC");
        ArrayList<PurchaseOrderAccount> als = new ArrayList<PurchaseOrderAccount>();
        als.add(this.getPurchaseOrderAccount(new KualiDecimal("10.00"), new KualiDecimal("5.00")));
        poItem.setSourceAccountingLines(als);
        poItems.add(poItem);
        Mockito.when((Object)SpringContext.getBean(AccountService.class)).thenReturn((Object)this.accountSvcMock);
        this.accountSvcMock.populateAccountingLineChartIfNeeded((AccountingLine)ArgumentMatchers.any());
        Mockito.when((Object)this.purchaseOrderDocMock.getItems()).thenReturn(poItems);
        Mockito.when((Object)this.paymentRequestDocMock.isUseTaxIndicator()).thenReturn((Object)false);
        Mockito.when((Object)this.boServiceMock.save((PersistableBusinessObject)this.purchaseOrderDocMock)).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocMock)).thenReturn(new ArrayList());
        this.paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        this.paymentRequestDocMock.setDebitCreditCodeForGLEntries("C");
        this.paymentRequestDocMock.setGenerateEncumbranceEntries(true);
        Mockito.when((Object)this.paymentRequestDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.any(), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        this.cut.generateEntriesCreatePaymentRequest(this.paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).isUseTaxIndicator();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.purchaseOrderDocMock)).getItems();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.any(AccountingLine.class), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any(GeneralLedgerPendingEntrySequenceHelper.class));
        this.verifyAll();
    }

    private void verifyAll() {
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getPurchaseOrderIdentifier();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setGeneralLedgerPendingEntries(new ArrayList());
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getDocumentNumber();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setDebitCreditCodeForGLEntries("C");
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setGenerateEncumbranceEntries(true);
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getGeneralLedgerPendingEntries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.paymentRequestDocMock});
        ((PurchaseOrderService)Mockito.verify((Object)this.purchaseOrderSvcMock)).getCurrentPurchaseOrder(Integer.valueOf(1000));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purchaseOrderSvcMock});
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).save(ArgumentMatchers.anyList());
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).countMatching((Class)ArgumentMatchers.eq(GeneralLedgerPendingEntry.class), ArgumentMatchers.anyMap());
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purapAccountingSvcMock});
    }
}

