/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util.cxml;

import org.kuali.kfs.module.purap.util.cxml.B2BPOResponseFileType;
import org.kuali.kfs.module.purap.util.cxml.B2BParserHelper;
import org.kuali.kfs.module.purap.util.cxml.B2BPunchOutOrderFileType;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCart;
import org.kuali.kfs.module.purap.util.cxml.PunchOutSetupResponse;
import org.kuali.kfs.module.purap.util.cxml.PunchOutSetupResponseFileType;
import org.kuali.kfs.module.purap.util.cxml.PurchaseOrderResponse;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class B2BParserHelperTest
extends KualiTestBase {
    private B2BParserHelper cut;

    public void setUp() throws Exception {
        this.cut = B2BParserHelper.getInstance();
        this.cut.setPunchOutSetupResponseFileType((PunchOutSetupResponseFileType)SpringContext.getBean(PunchOutSetupResponseFileType.class));
        this.cut.setB2BPunchOutOrderFileType((B2BPunchOutOrderFileType)SpringContext.getBean(B2BPunchOutOrderFileType.class));
        this.cut.setB2BPOResponseFileType((B2BPOResponseFileType)SpringContext.getBean(B2BPOResponseFileType.class));
    }

    public void testParsePunchOutSetupResponse() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<!DOCTYPE cXML SYSTEM \"http://xml.cXML.org/schemas/cXML/1.2.007/cXML.dtd\">").append("<cXML payloadID=\"1520963848635.9099358407421681395@sciquest.com\" xml:lang=\"en-US\" timestamp=\"2018-03-13T13:57:28.635-04:00\">").append("  <Response>").append("    <Status code=\"200\" text=\"OK\" />").append("    <PunchOutSetupResponse>").append("      <StartPage>").append("        <URL>https://usertest.sciquest.com/apps/Router/SessionLogin?Session=0%3AAES2%23CGCRiz5cobodmBFDgP%2BxbjGCT9%2FjqHrqetYwsYo1dLRlUIDjxfT6eos%3D&amp;RedirectToReq=false</URL>").append("      </StartPage>").append("    </PunchOutSetupResponse>").append("  </Response>").append("</cXML>\n");
        PunchOutSetupResponse punchOutSetupResponse = this.cut.parsePunchOutSetupResponse(stringBuilder.toString());
        B2BParserHelperTest.assertNotNull((Object)punchOutSetupResponse);
        B2BParserHelperTest.assertEquals((String)"https://usertest.sciquest.com/apps/Router/SessionLogin?Session=0%3AAES2%23CGCRiz5cobodmBFDgP%2BxbjGCT9%2FjqHrqetYwsYo1dLRlUIDjxfT6eos%3D&RedirectToReq=false", (String)punchOutSetupResponse.getPunchOutUrl());
    }

    public void testParseShoppingCartXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<cXML payloadID=\"1471450796296.2524284185056899672@sciquest.com\" timestamp=\"2018-03-13T13:57:28.635-04:00\" version=\"1.2\" xml:lang=\"en-US\">").append("   <Header>").append("       <From>").append("           <Credential domain=\"DUNS\">").append("               <Identity>15996366-t</Identity>").append("           </Credential>").append("       </From>").append("       <To>").append("           <Credential domain=\"NetworkId\">").append("               <Identity />").append("           </Credential>").append("       </To>").append("       <Sender>").append("           <Credential domain=\"DUNS\">").append("               <Identity>15996366-t</Identity>").append("           </Credential>").append("           <UserAgent>SciQuest</UserAgent>").append("       </Sender>").append("   </Header>").append("   <Message deploymentMode=\"production\">").append("       <Status code=\"200\" text=\"Success\">Success</Status>").append("       <PunchOutOrderMessage>").append("           <BuyerCookie>KHUNTLEY</BuyerCookie>").append("           <PunchOutOrderMessageHeader operationAllowed=\"edit\" quoteStatus=\"final\">").append("               <Total>").append("                   <Money currency=\"USD\">1462.70</Money>").append("               </Total>").append("           </PunchOutOrderMessageHeader>").append("           <ItemIn quantity=\"1\">").append("               <ItemID>").append("                   <SupplierPartID>30734195</SupplierPartID>").append("                   <SupplierPartAuxiliaryID>032734ed-bdcb-4539-b2b9-a5a7b6dd221a</SupplierPartAuxiliaryID>").append("               </ItemID>").append("               <ItemDetail>").append("                   <UnitPrice>").append("                       <Money currency=\"USD\">1462.70</Money>").append("                   </UnitPrice>").append("                   <Description xml:lang=\"en\">Microsoft Surface Book Core i7 32GB 1TB</Description>").append("                   <UnitOfMeasure>EA</UnitOfMeasure>").append("                   <Classification domain=\"SPSC\">43211503</Classification>").append("                   <Classification domain=\"UNSPSC\">43211503</Classification>").append("                   <Classification domain=\"CommodityCode\" />").append("                   <Classification domain=\"Controlled\">false</Classification>").append("                   <Classification domain=\"Green\">false</Classification>").append("                   <Classification domain=\"Hazardous\">false</Classification>").append("                   <Classification domain=\"Radioactive\">false</Classification>").append("                   <Classification domain=\"RadioactiveMinor\">false</Classification>").append("                   <Classification domain=\"SelectAgent\">false</Classification>").append("                   <Classification domain=\"Toxin\">false</Classification>").append("                   <Classification domain=\"EnergyStar\">false</Classification>").append("                   <Classification domain=\"GreenProduct\">false</Classification>").append("                   <Extrinsic name=\"ExternalSupplierId\">4005-0</Extrinsic>").append("                   <Extrinsic name=\"Product Source\">Punchout</Extrinsic>").append("                   <Extrinsic name=\"CartName\">Super Shopping Cart</Extrinsic>").append("                   <Extrinsic name=\"SystemInfo\">Req1641090-5151628</Extrinsic>").append("                   <Extrinsic name=\"CartID\">1641090</Extrinsic>").append("                   <Extrinsic name=\"CartLineId\">5151628</Extrinsic>").append("                   <Extrinsic name=\"SystemProductID\" />").append("                   <Extrinsic name=\"Shipping\">0.00</Extrinsic>").append("               </ItemDetail>").append("               <SupplierID domain=\"DUNS\">4005-0</SupplierID>").append("               <SupplierID domain=\"SystemSupplierID\">4059703</SupplierID>").append("           </ItemIn>").append("       </PunchOutOrderMessage>").append("   </Message>").append("</cXML>\n");
        B2BShoppingCart b2BShoppingCart = this.cut.parseShoppingCartXML(stringBuilder.toString());
        B2BParserHelperTest.assertNotNull((Object)b2BShoppingCart.getItems());
        B2BParserHelperTest.assertTrue((String)"There should be 1 item based on the XML.", (b2BShoppingCart.getItems().size() == 1 ? 1 : 0) != 0);
    }

    public void testParsePurchaseOrderResponse() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<!DOCTYPE cXML SYSTEM \"http://xml.cXML.org/schemas/cXML/1.2.007/cXML.dtd\">").append("<PurchaseOrderMessage>").append("  <Header>").append("    <MessageId>1</MessageId>").append("    <Timestamp>2018-03-13T13:57:28.635-04:00</Timestamp>").append("  </Header>").append("  <ResponseMessage>").append("    <Status>").append("        <StatusCode>200</StatusCode>").append("        <StatusText>OK</StatusText>").append("    </Status>").append("  </ResponseMessage>").append("</PurchaseOrderMessage>\n");
        PurchaseOrderResponse purchaseOrderResponse = this.cut.parsePurchaseOrderResponse(stringBuilder.toString());
        B2BParserHelperTest.assertNotNull((Object)purchaseOrderResponse);
        B2BParserHelperTest.assertEquals((String)"200", (String)purchaseOrderResponse.getStatusCode());
        B2BParserHelperTest.assertEquals((String)"OK", (String)purchaseOrderResponse.getStatusText());
    }
}

