/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.batch;

import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.purap.service.PdpExtractService;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ExtractPdpImmediatesStep
extends AbstractStep {
    private static final Logger LOG = LogManager.getLogger(ExtractPdpImmediatesStep.class);
    private PdpExtractService pdpExtractService;
    private DateTimeService dateTimeService;

    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        LOG.debug("execute() started");
        this.pdpExtractService.extractImmediatePaymentsOnly();
        return true;
    }

    public boolean execute() throws InterruptedException {
        try {
            return this.execute(null, this.dateTimeService.getCurrentDate());
        }
        catch (InterruptedException e) {
            LOG.error("Exception occured executing step", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error("Exception occured executing step", (Throwable)e);
            throw e;
        }
    }

    public void setPdpExtractService(PdpExtractService pdpExtractService) {
        this.pdpExtractService = pdpExtractService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

