/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.batch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.api.parameter.EvaluationOperator;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterContract;
import org.kuali.kfs.coreservice.api.parameter.ParameterType;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ContractManagerAssignmentDetail;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderView;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionAccount;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetLocation;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetSystem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.ContractManagerAssignmentDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.kfs.sys.batch.TestingStep;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class PurapMassRequisitionStep
extends AbstractStep
implements TestingStep {
    private static final Logger LOG = LogManager.getLogger(PurapMassRequisitionStep.class);
    private DocumentService documentService;
    private RequisitionService requisitionService;
    private PurapService purapService;
    private BusinessObjectService boService;
    private PersistenceStructureService psService;
    private final int NUM_DOCS_TO_CREATE = 25;
    private final int ROUTE_TO_FINAL_SECONDS_LIMIT = 240;
    private final String RUN_INDICATOR_PARAMETER_NAMESPACE_STEP = "PurapMassRequisitionStep";
    private final String RUN_INDICATOR_PARAMETER_VALUE = "N";
    private final String RUN_INDICATOR_PARAMETER_ALLOWED = "A";
    private final String RUN_INDICATOR_PARAMETER_DESCRIPTION = "Tells the job framework whether to run this job or not; because the PurapMassRequisitionJob needs to only be run once after database initialization.";
    private final String RUN_INDICATOR_PARAMETER_TYPE = "CONFG";

    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        LOG.debug("Starting execution of PurapMassRequisitionStep");
        Parameter runIndicatorParameter = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameter(PurapMassRequisitionStep.class, "RUN_IND");
        if (runIndicatorParameter == null || "Y".equals(runIndicatorParameter.getValue())) {
            RequisitionDocument reqDoc;
            int i;
            this.setInitiatedRunParameter();
            for (i = 0; i < 25; ++i) {
                try {
                    LOG.info("Setting user session for routing of quantity document.");
                    GlobalVariables.setUserSession((UserSession)new UserSession("khuntley"));
                    reqDoc = this.populateQuantityDocument();
                    LOG.info("Blanket approving quantity requisition document.");
                    this.documentService.blanketApproveDocument((Document)reqDoc, "auto-routing: Test Requisition Job.", null);
                }
                catch (WorkflowException e) {
                    e.printStackTrace();
                }
                Thread.sleep(5000L);
            }
            for (i = 0; i < 25; ++i) {
                try {
                    LOG.info("Setting user session for routing of non-quantity document.");
                    GlobalVariables.setUserSession((UserSession)new UserSession("khuntley"));
                    reqDoc = this.populateNonQuantityDocument();
                    LOG.info("Blanket approving non-quantity requisition document.");
                    this.documentService.blanketApproveDocument((Document)reqDoc, "auto-routing: Test Requisition Job.", null);
                }
                catch (WorkflowException e) {
                    e.printStackTrace();
                }
                Thread.sleep(5000L);
            }
        }
        Thread.sleep(60000L);
        return true;
    }

    private RequisitionDocument populateQuantityDocument() {
        LOG.debug("Creating a new requisition.");
        RequisitionDocument reqDoc = null;
        try {
            reqDoc = (RequisitionDocument)this.documentService.getNewDocument(RequisitionDocument.class);
            LOG.info("Populating a new requisition.");
            reqDoc.getDocumentHeader().setExplanation("batch created quantity document");
            DocumentHeader documentHeader = reqDoc.getDocumentHeader();
            documentHeader.setDocumentDescription("batch created quantity document");
            reqDoc.setDocumentFundingSourceCode("INST");
            reqDoc.setRequisitionSourceCode("STAN");
            reqDoc.setPurchaseOrderTransmissionMethodCode("NOPR");
            reqDoc.setPurchaseOrderCostSourceCode("EST");
            reqDoc.setChartOfAccountsCode("KO");
            reqDoc.setOrganizationCode("SBSC");
            reqDoc.setDeliveryCampusCode("KO");
            reqDoc.setRequestorPersonName("WATSON,TERRENCE G");
            reqDoc.setRequestorPersonEmailAddress("tw@localhost.localhost");
            reqDoc.setRequestorPersonPhoneNumber("812-555-5555");
            reqDoc.setDeliveryBuildingCode("ADMN");
            reqDoc.setDeliveryBuildingName("Administration");
            reqDoc.setDeliveryBuildingRoomNumber("100");
            reqDoc.setDeliveryBuildingLine1Address("98 smart street");
            reqDoc.setDeliveryCityName("brainy");
            reqDoc.setDeliveryStateCode("CA");
            reqDoc.setDeliveryPostalCode("46202");
            reqDoc.setDeliveryCountryCode("US");
            reqDoc.setDeliveryToName("front desk");
            reqDoc.setBillingName("THE UNIVERSITY");
            reqDoc.setBillingLine1Address("ACCOUNTS PAYABLE");
            reqDoc.setBillingCityName("BUTTER NUT");
            reqDoc.setBillingStateCode("SC");
            reqDoc.setBillingPostalCode("47402");
            reqDoc.setBillingCountryCode("US");
            reqDoc.setBillingPhoneNumber("111-111-1111");
            reqDoc.setPurchaseOrderAutomaticIndicator(false);
            reqDoc.setApplicationDocumentStatus("In Process");
            reqDoc.setVendorHeaderGeneratedIdentifier(1002);
            reqDoc.setVendorDetailAssignedIdentifier(0);
            reqDoc.setVendorName("MK CORPORATION ACTIVE");
            reqDoc.setVendorLine1Address("3894 SOUTH ST");
            reqDoc.setVendorLine2Address("P.O. BOX 3455");
            reqDoc.setVendorCityName("SPRINGFIELD");
            reqDoc.setVendorStateCode("IL");
            reqDoc.setVendorPostalCode("33555");
            reqDoc.setVendorCountryCode("US");
            reqDoc.setUseTaxIndicator(false);
            RequisitionItem item1 = new RequisitionItem();
            item1.setItemLineNumber(new Integer(1));
            item1.setItemUnitOfMeasureCode("PCS");
            item1.setItemCatalogNumber("P10M980");
            item1.setItemDescription("Copy Paper - 8 1/2 x 11, White, 92, 20lb");
            item1.setItemUnitPrice(new BigDecimal(30.2));
            item1.setItemTypeCode("ITEM");
            item1.setItemQuantity(new KualiDecimal(20));
            item1.setExtendedPrice(new KualiDecimal(604));
            item1.setItemAssignedToTradeInIndicator(false);
            RequisitionAccount account1 = new RequisitionAccount();
            account1.setPostingYear(2004);
            account1.setChartOfAccountsCode("BL");
            account1.setAccountNumber("1023200");
            account1.setFinancialObjectCode("4100");
            account1.setDebitCreditCode("D");
            account1.setAmount(new KualiDecimal("100"));
            account1.setAccountLinePercent(new BigDecimal("100"));
            item1.getSourceAccountingLines().add(account1);
            reqDoc.getItems().add(item1);
            reqDoc.fixItemReferences();
        }
        catch (WorkflowException e1) {
            e1.printStackTrace();
        }
        return reqDoc;
    }

    private RequisitionDocument populateNonQuantityDocument() {
        RequisitionDocument reqDoc = null;
        try {
            reqDoc = (RequisitionDocument)this.documentService.getNewDocument(RequisitionDocument.class);
            reqDoc.getDocumentHeader().setExplanation("batch created non-quantity document");
            DocumentHeader documentHeader = reqDoc.getDocumentHeader();
            documentHeader.setDocumentDescription("batch created non-quantity document");
            reqDoc.setDocumentFundingSourceCode("INST");
            reqDoc.setRequisitionSourceCode("STAN");
            reqDoc.setPurchaseOrderTransmissionMethodCode("NOPR");
            reqDoc.setPurchaseOrderCostSourceCode("EST");
            reqDoc.setChartOfAccountsCode("KO");
            reqDoc.setOrganizationCode("SBSC");
            reqDoc.setDeliveryCampusCode("KO");
            reqDoc.setDeliveryCountryCode("US");
            reqDoc.setRequestorPersonName("WATSON,TERRENCE G");
            reqDoc.setRequestorPersonEmailAddress("tw@localhost.localhost");
            reqDoc.setRequestorPersonPhoneNumber("812-555-5555");
            reqDoc.setDeliveryBuildingCode("ADMN");
            reqDoc.setDeliveryBuildingName("Administration");
            reqDoc.setDeliveryBuildingRoomNumber("100");
            reqDoc.setDeliveryBuildingLine1Address("98 smart street");
            reqDoc.setDeliveryCityName("brainy");
            reqDoc.setDeliveryStateCode("CA");
            reqDoc.setDeliveryPostalCode("46202");
            reqDoc.setDeliveryToName("front desk");
            reqDoc.setBillingName("THE UNIVERSITY");
            reqDoc.setBillingLine1Address("ACCOUNTS PAYABLE");
            reqDoc.setBillingCityName("BUTTER NUT");
            reqDoc.setBillingStateCode("SC");
            reqDoc.setBillingPostalCode("47402");
            reqDoc.setBillingCountryCode("US");
            reqDoc.setBillingPhoneNumber("111-111-1111");
            reqDoc.setPurchaseOrderAutomaticIndicator(false);
            reqDoc.setApplicationDocumentStatus("In Process");
            reqDoc.setVendorHeaderGeneratedIdentifier(1016);
            reqDoc.setVendorDetailAssignedIdentifier(0);
            reqDoc.setVendorName("PHYSIK INSTRUMENT L.P.");
            reqDoc.setVendorLine1Address("16 AUBURN ST");
            reqDoc.setVendorCityName("AUBURN");
            reqDoc.setVendorStateCode("MA");
            reqDoc.setVendorPostalCode("01501");
            reqDoc.setVendorCountryCode("US");
            reqDoc.setUseTaxIndicator(false);
            RequisitionItem item1 = new RequisitionItem();
            item1.setItemLineNumber(new Integer(1));
            item1.setItemUnitOfMeasureCode("");
            item1.setItemCatalogNumber("");
            item1.setItemDescription("consulting");
            item1.setItemUnitPrice(new BigDecimal(5000));
            item1.setItemTypeCode("SRVC");
            item1.setItemQuantity(null);
            item1.setExtendedPrice(new KualiDecimal(5000));
            item1.setItemAssignedToTradeInIndicator(false);
            RequisitionAccount account1 = new RequisitionAccount();
            account1.setPostingYear(2004);
            account1.setChartOfAccountsCode("BL");
            account1.setAccountNumber("1023200");
            account1.setFinancialObjectCode("4078");
            account1.setDebitCreditCode("D");
            account1.setAmount(new KualiDecimal("100"));
            account1.setAccountLinePercent(new BigDecimal("100"));
            item1.getSourceAccountingLines().add(account1);
            reqDoc.getItems().add(item1);
            reqDoc.fixItemReferences();
        }
        catch (WorkflowException e1) {
            e1.printStackTrace();
        }
        return reqDoc;
    }

    public RequisitionDocument populateCapitalAsset_Individual_WithAddresses_Document() {
        RequisitionDocument reqDoc = null;
        try {
            reqDoc = (RequisitionDocument)this.documentService.getNewDocument(RequisitionDocument.class);
            reqDoc.getDocumentHeader().setExplanation("batch created quantity document for cams");
            DocumentHeader documentHeader = reqDoc.getDocumentHeader();
            documentHeader.setDocumentDescription("batch created quantity document for cams");
            reqDoc.setDocumentFundingSourceCode("INST");
            reqDoc.setRequisitionSourceCode("STAN");
            reqDoc.setPurchaseOrderTransmissionMethodCode("NOPR");
            reqDoc.setPurchaseOrderCostSourceCode("EST");
            reqDoc.setChartOfAccountsCode("UA");
            reqDoc.setOrganizationCode("VPIT");
            reqDoc.setDeliveryCampusCode("KO");
            reqDoc.setRequestorPersonName("WATSON,TERRENCE G");
            reqDoc.setRequestorPersonEmailAddress("tw@localhost.localhost");
            reqDoc.setRequestorPersonPhoneNumber("812-555-5555");
            reqDoc.setDeliveryBuildingCode("ADMN");
            reqDoc.setDeliveryBuildingName("Administration");
            reqDoc.setDeliveryBuildingRoomNumber("100");
            reqDoc.setDeliveryBuildingLine1Address("98 smart street");
            reqDoc.setDeliveryCityName("brainy");
            reqDoc.setDeliveryStateCode("CA");
            reqDoc.setDeliveryPostalCode("46202");
            reqDoc.setDeliveryToName("front desk");
            reqDoc.setBillingName("THE UNIVERSITY");
            reqDoc.setBillingLine1Address("ACCOUNTS PAYABLE");
            reqDoc.setBillingCityName("BUTTER NUT");
            reqDoc.setBillingStateCode("SC");
            reqDoc.setBillingPostalCode("47402");
            reqDoc.setBillingCountryCode("US");
            reqDoc.setBillingPhoneNumber("111-111-1111");
            reqDoc.setPurchaseOrderAutomaticIndicator(false);
            reqDoc.setApplicationDocumentStatus("In Process");
            reqDoc.setVendorHeaderGeneratedIdentifier(1002);
            reqDoc.setVendorDetailAssignedIdentifier(0);
            reqDoc.setVendorName("MK CORPORATION ACTIVE");
            reqDoc.setVendorLine1Address("3984 SOUTH ST");
            reqDoc.setVendorCityName("SPRINGFIELD");
            reqDoc.setVendorStateCode("IL");
            reqDoc.setVendorPostalCode("33555");
            reqDoc.setVendorCountryCode("US");
            reqDoc.setUseTaxIndicator(false);
            RequisitionItem item1 = new RequisitionItem();
            item1.setItemLineNumber(new Integer(1));
            item1.setItemUnitOfMeasureCode("EA");
            item1.setItemCatalogNumber("P10M980");
            item1.setItemDescription("Gas Chromatograph");
            item1.setItemUnitPrice(new BigDecimal(5000));
            item1.setItemTypeCode("ITEM");
            item1.setItemQuantity(new KualiDecimal(2.0));
            item1.setExtendedPrice(new KualiDecimal(10000));
            item1.setItemAssignedToTradeInIndicator(false);
            item1.refreshReferenceObject("itemType");
            RequisitionAccount account1 = new RequisitionAccount();
            account1.setPostingYear(2004);
            account1.setChartOfAccountsCode("BL");
            account1.setAccountNumber("1023200");
            account1.setFinancialObjectCode("7000");
            account1.setDebitCreditCode("D");
            account1.setAmount(new KualiDecimal("10000"));
            account1.setAccountLinePercent(new BigDecimal("100"));
            item1.getSourceAccountingLines().add(account1);
            reqDoc.getItems().add(item1);
            reqDoc.fixItemReferences();
            reqDoc.setCapitalAssetSystemStateCode("NEW");
            reqDoc.setCapitalAssetSystemTypeCode("IND");
            this.purapService.saveDocumentNoValidation((Document)reqDoc);
            ArrayList<PurchasingCapitalAssetItem> purchasingCapitalAssetItems = new ArrayList<PurchasingCapitalAssetItem>();
            RequisitionCapitalAssetItem capitalAssetItem = (RequisitionCapitalAssetItem)this.requisitionService.createCamsItem(reqDoc, item1);
            capitalAssetItem.setCapitalAssetTransactionTypeCode("NEW");
            RequisitionCapitalAssetSystem system = (RequisitionCapitalAssetSystem)capitalAssetItem.getPurchasingCapitalAssetSystem();
            system.setCapitalAssetNoteText("CA Notes go here");
            system.setCapitalAssetNotReceivedCurrentFiscalYearIndicator(false);
            system.setCapitalAssetManufacturerName("MK CORPORATION ACTIVE");
            system.setCapitalAssetTypeCode("07034");
            system.setCapitalAssetModelDescription("XXYYZZ");
            ArrayList<CapitalAssetLocation> locations = new ArrayList<CapitalAssetLocation>();
            RequisitionCapitalAssetLocation loc1 = new RequisitionCapitalAssetLocation();
            loc1.setCapitalAssetSystemIdentifier(system.getCapitalAssetSystemIdentifier());
            loc1.setItemQuantity(new KualiDecimal("1.00"));
            loc1.setCampusCode("BL");
            loc1.setBuildingCode("BL001");
            loc1.setCapitalAssetLine1Address("211 S Indiana Ave");
            loc1.setBuildingRoomNumber("001");
            loc1.setCapitalAssetCityName("Bloomington");
            loc1.setCapitalAssetStateCode("IN");
            loc1.setCapitalAssetPostalCode("47405-7001");
            loc1.setCapitalAssetCountryCode("US");
            locations.add(loc1);
            RequisitionCapitalAssetLocation loc2 = new RequisitionCapitalAssetLocation();
            loc2.setCapitalAssetSystemIdentifier(system.getCapitalAssetSystemIdentifier());
            loc2.setItemQuantity(new KualiDecimal("1.00"));
            loc2.setCampusCode("BL");
            loc2.setBuildingCode("BL001");
            loc2.setCapitalAssetLine1Address("211 S Indiana Ave");
            loc2.setBuildingRoomNumber("001A");
            loc2.setCapitalAssetCityName("Bloomington");
            loc2.setCapitalAssetStateCode("IN");
            loc2.setCapitalAssetPostalCode("47405-7001");
            loc2.setCapitalAssetCountryCode("US");
            locations.add(loc2);
            system.setCapitalAssetLocations(locations);
            purchasingCapitalAssetItems.add(capitalAssetItem);
            reqDoc.setPurchasingCapitalAssetItems(purchasingCapitalAssetItems);
        }
        catch (WorkflowException e1) {
            e1.printStackTrace();
        }
        return reqDoc;
    }

    private RequisitionDocument populateCapitalAsset_Individual_Unfilled_Document() {
        RequisitionDocument reqDoc = null;
        try {
            reqDoc = (RequisitionDocument)this.documentService.getNewDocument(RequisitionDocument.class);
            reqDoc.getDocumentHeader().setExplanation("batch created quantity document BAS");
            DocumentHeader documentHeader = reqDoc.getDocumentHeader();
            documentHeader.setDocumentDescription("batch created quantity document BAS");
            reqDoc.setDocumentFundingSourceCode("INST");
            reqDoc.setRequisitionSourceCode("STAN");
            reqDoc.setPurchaseOrderTransmissionMethodCode("NOPR");
            reqDoc.setPurchaseOrderCostSourceCode("EST");
            reqDoc.setChartOfAccountsCode("UA");
            reqDoc.setOrganizationCode("VPIT");
            reqDoc.setDeliveryCampusCode("KO");
            reqDoc.setRequestorPersonName("WATSON,TERRENCE G");
            reqDoc.setRequestorPersonEmailAddress("tw@localhost.localhost");
            reqDoc.setRequestorPersonPhoneNumber("812-555-5555");
            reqDoc.setDeliveryBuildingCode("ADMN");
            reqDoc.setDeliveryBuildingName("Administration");
            reqDoc.setDeliveryBuildingRoomNumber("100");
            reqDoc.setDeliveryBuildingLine1Address("98 smart street");
            reqDoc.setDeliveryCityName("brainy");
            reqDoc.setDeliveryStateCode("CA");
            reqDoc.setDeliveryPostalCode("46202");
            reqDoc.setDeliveryToName("front desk");
            reqDoc.setBillingName("THE UNIVERSITY");
            reqDoc.setBillingLine1Address("ACCOUNTS PAYABLE");
            reqDoc.setBillingCityName("BUTTER NUT");
            reqDoc.setBillingStateCode("SC");
            reqDoc.setBillingPostalCode("47402");
            reqDoc.setBillingCountryCode("US");
            reqDoc.setBillingPhoneNumber("111-111-1111");
            reqDoc.setPurchaseOrderAutomaticIndicator(false);
            reqDoc.setApplicationDocumentStatus("In Process");
            reqDoc.setVendorHeaderGeneratedIdentifier(1002);
            reqDoc.setVendorDetailAssignedIdentifier(0);
            reqDoc.setVendorName("MK CORPORATION ACTIVE");
            reqDoc.setVendorLine1Address("3984 SOUTH ST");
            reqDoc.setVendorCityName("SPRINGFIELD");
            reqDoc.setVendorStateCode("IL");
            reqDoc.setVendorPostalCode("33555");
            reqDoc.setVendorCountryCode("US");
            reqDoc.setUseTaxIndicator(false);
            RequisitionItem item1 = new RequisitionItem();
            item1.setItemLineNumber(new Integer(1));
            item1.setItemUnitOfMeasureCode("EA");
            item1.setItemCatalogNumber("");
            item1.setItemDescription("Gas Chromatograph");
            item1.setItemUnitPrice(new BigDecimal(6000));
            item1.setItemTypeCode("ITEM");
            item1.setItemQuantity(new KualiDecimal(1.0));
            item1.setExtendedPrice(new KualiDecimal(6000));
            item1.setItemAssignedToTradeInIndicator(false);
            RequisitionAccount account1 = new RequisitionAccount();
            account1.setPostingYear(2004);
            account1.setChartOfAccountsCode("BL");
            account1.setAccountNumber("1023200");
            account1.setFinancialObjectCode("7000");
            account1.setDebitCreditCode("D");
            account1.setAmount(new KualiDecimal("10000"));
            account1.setAccountLinePercent(new BigDecimal("100"));
            item1.getSourceAccountingLines().add(account1);
            reqDoc.getItems().add(item1);
            reqDoc.fixItemReferences();
            reqDoc.setCapitalAssetSystemStateCode("NEW");
            reqDoc.setCapitalAssetSystemTypeCode("IND");
            this.purapService.saveDocumentNoValidation((Document)reqDoc);
            ArrayList<PurchasingCapitalAssetItem> purchasingCapitalAssetItems = new ArrayList<PurchasingCapitalAssetItem>();
            RequisitionCapitalAssetItem capitalAssetItem = (RequisitionCapitalAssetItem)this.requisitionService.createCamsItem(reqDoc, item1);
            capitalAssetItem.setCapitalAssetTransactionTypeCode("NEW");
            RequisitionCapitalAssetSystem system = (RequisitionCapitalAssetSystem)capitalAssetItem.getPurchasingCapitalAssetSystem();
            system.setCapitalAssetNoteText("");
            system.setCapitalAssetNotReceivedCurrentFiscalYearIndicator(false);
            system.setCapitalAssetManufacturerName("");
            system.setCapitalAssetTypeCode("");
            system.setCapitalAssetModelDescription("");
            purchasingCapitalAssetItems.add(capitalAssetItem);
            reqDoc.setPurchasingCapitalAssetItems(purchasingCapitalAssetItems);
        }
        catch (WorkflowException e1) {
            e1.printStackTrace();
        }
        return reqDoc;
    }

    private void setInitiatedRunParameter() {
        Parameter runIndicatorParameter = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameter(PurapMassRequisitionStep.class, "RUN_IND");
        if (runIndicatorParameter == null) {
            Parameter.Builder newParameter = Parameter.Builder.create((String)"KFS", (String)"KFS-PURAP", (String)"PurapMassRequisitionStep", (String)"RUN_IND", (ParameterType.Builder)ParameterType.Builder.create((String)"CONFG"));
            newParameter.setDescription("Tells the job framework whether to run this job or not; because the PurapMassRequisitionJob needs to only be run once after database initialization.");
            newParameter.setEvaluationOperator(EvaluationOperator.ALLOW);
            newParameter.setValue("N");
            ((ParameterService)SpringContext.getBean(ParameterService.class)).createParameter(newParameter.build());
        } else {
            Parameter.Builder newParameter = Parameter.Builder.create((ParameterContract)runIndicatorParameter);
            newParameter.setValue("N");
            ((ParameterService)SpringContext.getBean(ParameterService.class)).updateParameter(newParameter.build());
        }
    }

    private Map<String, Object> buildRunParameterSearchKeyMap() {
        HashMap<String, Object> pkMapForParameter = new HashMap<String, Object>();
        HashMap<String, String> fieldNamesValuesForParameter = new HashMap<String, String>();
        fieldNamesValuesForParameter.put("parameterNamespaceCode", "KFS-PURAP");
        fieldNamesValuesForParameter.put("parameterDetailTypeCode", "PurapMassRequisitionStep");
        fieldNamesValuesForParameter.put("parameterName", "RUN_IND");
        fieldNamesValuesForParameter.put("parameterConstraintCode", "A");
        fieldNamesValuesForParameter.put("parameterTypeCode", "CONFG");
        List parameterPKFields = this.psService.getPrimaryKeys(Parameter.class);
        for (String pkFieldName : parameterPKFields) {
            pkMapForParameter.put(pkFieldName, fieldNamesValuesForParameter.get(pkFieldName));
        }
        return pkMapForParameter;
    }

    private ContractManagerAssignmentDocument createAndRouteContractManagerAssignmentDocument(RequisitionDocument reqDoc) {
        ContractManagerAssignmentDocument acmDoc = null;
        try {
            acmDoc = (ContractManagerAssignmentDocument)this.documentService.getNewDocument(ContractManagerAssignmentDocument.class);
            ArrayList<ContractManagerAssignmentDetail> contractManagerAssignmentDetails = new ArrayList<ContractManagerAssignmentDetail>();
            ContractManagerAssignmentDetail detail = new ContractManagerAssignmentDetail(acmDoc, reqDoc);
            detail.setContractManagerCode(new Integer("10"));
            detail.refreshReferenceObject("contractManager");
            contractManagerAssignmentDetails.add(detail);
            acmDoc.setContractManagerAssignmentDetailss(contractManagerAssignmentDetails);
            acmDoc.getDocumentHeader().setDocumentDescription("batch-created");
            this.documentService.routeDocument((Document)acmDoc, "Routing batch-created Contract Manager Assignment Document", null);
            ChangeWaiter waiter = new ChangeWaiter(this.documentService, acmDoc.getDocumentNumber(), "F");
            try {
                waiter.waitUntilChange(waiter, 240, 5);
            }
            catch (Exception e) {
                throw new RuntimeException("ContractManagerAssignmentDocument timed out in routing to final.");
            }
        }
        catch (WorkflowException we) {
            we.printStackTrace();
        }
        catch (ValidationException ve) {
            ve.printStackTrace();
        }
        return acmDoc;
    }

    private void createAndRoutePurchaseOrderDocument(RequisitionDocument reqDoc, ContractManagerAssignmentDocument acmDoc) {
        List<PurchaseOrderView> poViews = reqDoc.getRelatedViews().getRelatedPurchaseOrderViews();
        if (poViews != null && poViews.size() >= 1) {
            PurchaseOrderView poView = poViews.get(0);
            String relatedPOWorkflowDocumentId = poView.getDocumentNumber();
            PurchaseOrderDocument poDoc = null;
            try {
                poDoc = (PurchaseOrderDocument)this.documentService.getByDocumentHeaderId(relatedPOWorkflowDocumentId);
                this.documentService.blanketApproveDocument((Document)poDoc, "auto-routing: Test Requisition Job", null);
                ChangeWaiter waiter = new ChangeWaiter(this.documentService, poDoc.getDocumentNumber(), "F");
                try {
                    waiter.waitUntilChange(waiter, 240, 5);
                }
                catch (Exception e) {
                    throw new RuntimeException("ContractManagerAssignmentDocument timed out in routing to final.");
                }
            }
            catch (WorkflowException e) {
                e.printStackTrace();
            }
            catch (ValidationException ve) {
                ve.printStackTrace();
            }
        }
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public RequisitionService getRequisitionService() {
        return this.requisitionService;
    }

    public void setRequisitionService(RequisitionService requisitionService) {
        this.requisitionService = requisitionService;
    }

    public PurapService getPurapService() {
        return this.purapService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public BusinessObjectService getBoService() {
        return this.boService;
    }

    public void setBoService(BusinessObjectService boService) {
        this.boService = boService;
    }

    public PersistenceStructureService getPsService() {
        return this.psService;
    }

    public void setPsService(PersistenceStructureService psService) {
        this.psService = psService;
    }

    private class ChangeWaiter {
        final DocumentService documentService;
        private final String docHeaderId;
        private final String[] desiredWorkflowStates;

        public ChangeWaiter(DocumentService documentService, String docHeaderId, String desiredWorkflowStatus) {
            this.documentService = documentService;
            this.docHeaderId = docHeaderId;
            this.desiredWorkflowStates = new String[]{desiredWorkflowStatus};
        }

        public boolean valueChanged() throws Exception {
            Document d = this.documentService.getByDocumentHeaderId(this.docHeaderId.toString());
            String currentStatus = d.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
            for (int i = 0; i < this.desiredWorkflowStates.length; ++i) {
                if (!StringUtils.equals((CharSequence)this.desiredWorkflowStates[i], (CharSequence)currentStatus)) continue;
                return true;
            }
            return false;
        }

        public boolean waitUntilChange(ChangeWaiter monitor, int maxWaitSeconds, int pauseSeconds) throws Exception {
            long maxWaitMs = maxWaitSeconds * 1000;
            long pauseMs = pauseSeconds * 1000;
            boolean valueChanged = false;
            boolean interrupted = false;
            long startTimeMs = System.currentTimeMillis();
            long endTimeMs = startTimeMs + maxWaitMs;
            Thread.sleep(pauseMs / 10L);
            valueChanged = monitor.valueChanged();
            LOG.debug("starting wait loop");
            while (!interrupted && !valueChanged && System.currentTimeMillis() < endTimeMs) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("sleeping for " + pauseMs + " ms");
                    }
                    Thread.sleep(pauseMs);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                LOG.debug("checking wait loop sentinel");
                valueChanged = monitor.valueChanged();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("finished wait loop (" + valueChanged + ")");
            }
            return valueChanged;
        }
    }
}

