/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceContact;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoicePostalAddress;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.module.purap.util.cxml.CxmlExtrinsic;
import org.kuali.kfs.sys.util.KfsDateUtils;

public class ElectronicInvoiceDetailRequestHeader {
    private String invoiceId;
    private String purpose = "standard";
    private String operation = "new";
    private String invoiceDateString;
    private Date invoiceDate;
    private boolean isInformationOnly;
    private boolean isHeaderInvoiceIndicator;
    private boolean isTaxInLine;
    private boolean isSpecialHandlingInLine;
    private boolean isShippingInLine;
    private boolean isDiscountInLine;
    private String shippingDateString;
    private Date shippingDate;
    private String invoiceCustomerNumber;
    private List invoicePartnerContacts = new ArrayList();
    private List invoiceShippingContacts = new ArrayList();
    private List extrinsics = new ArrayList();
    private boolean isAccountingInLine;
    private String idReferenceCreator;
    private String idReferenceDescription;
    private String idReferenceDomain;
    private String idReferenceIdentifier;
    private int payInNumberOfDays;
    private String percentageRate;

    public ElectronicInvoiceDetailRequestHeader() {
    }

    public ElectronicInvoiceDetailRequestHeader(String invoiceId, String invoiceDate, String purpose, String operation) {
        this.invoiceId = invoiceId;
        this.purpose = purpose;
        this.operation = operation;
        this.setInvoiceDateString(invoiceDate);
    }

    public ElectronicInvoicePostalAddress getCxmlPostalAddressByRoleID(String roleID, String addressName) {
        ElectronicInvoiceContact contact;
        if (roleID != null && (contact = this.getCxmlContactByRoleID(roleID)) != null) {
            for (ElectronicInvoicePostalAddress cpa : contact.getPostalAddresses()) {
                if (addressName == null) {
                    return cpa;
                }
                if (!addressName.equalsIgnoreCase(cpa.getName())) continue;
                return cpa;
            }
        }
        return null;
    }

    public ElectronicInvoiceContact getCxmlContactByRoleID(String roleID) {
        if (roleID != null) {
            for (ElectronicInvoiceContact contact : this.invoicePartnerContacts) {
                if (!roleID.equalsIgnoreCase(contact.getRole())) continue;
                return contact;
            }
            for (ElectronicInvoiceContact shipContact : this.invoiceShippingContacts) {
                if (!roleID.equalsIgnoreCase(shipContact.getRole())) continue;
                return shipContact;
            }
        }
        return null;
    }

    public String getInvoiceDateString() {
        return this.invoiceDateString;
    }

    public void setInvoiceDateString(String invoiceDateString) {
        this.invoiceDateString = invoiceDateString;
        this.setInvoiceDate(ElectronicInvoiceUtils.getDate(invoiceDateString));
    }

    public String getShippingDateString() {
        return this.shippingDateString;
    }

    public void setShippingDateString(String shippingDateString) {
        this.shippingDateString = shippingDateString;
        this.setShippingDate(ElectronicInvoiceUtils.getDate(shippingDateString));
    }

    public List getExtrinsics() {
        return this.extrinsics;
    }

    public void setExtrinsics(List extrinsics) {
        this.extrinsics = extrinsics;
    }

    public String getInvoiceCustomerNumber() {
        return this.invoiceCustomerNumber;
    }

    public void setInvoiceCustomerNumber(String invoiceCustomerNumber) {
        this.invoiceCustomerNumber = invoiceCustomerNumber;
    }

    public java.sql.Date getInvoiceDate() {
        if (this.invoiceDate != null) {
            return KfsDateUtils.convertToSqlDate((Date)this.invoiceDate);
        }
        return null;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public List getInvoicePartnerContacts() {
        return this.invoicePartnerContacts;
    }

    public void setInvoicePartnerContacts(List invoicePartnerContacts) {
        this.invoicePartnerContacts = invoicePartnerContacts;
    }

    public List getInvoiceShippingContacts() {
        return this.invoiceShippingContacts;
    }

    public void setInvoiceShippingContacts(List invoiceShippingContacts) {
        this.invoiceShippingContacts = invoiceShippingContacts;
    }

    public boolean isDiscountInLine() {
        return this.isDiscountInLine;
    }

    public void setDiscountInfoProvidedIndicator(String isDiscountInLine) {
        this.isDiscountInLine = StringUtils.equalsIgnoreCase((CharSequence)StringUtils.defaultString((String)isDiscountInLine), (CharSequence)"yes");
    }

    public boolean isHeaderInvoiceIndicator() {
        return this.isHeaderInvoiceIndicator;
    }

    public void setHeaderInvoiceInd(String isHeaderInvoiceIndicator) {
        this.isHeaderInvoiceIndicator = StringUtils.equalsIgnoreCase((CharSequence)StringUtils.defaultString((String)isHeaderInvoiceIndicator), (CharSequence)"yes");
    }

    public boolean isInformationOnly() {
        return this.isInformationOnly;
    }

    public void setbuyerInformationOnlyIndicator(String informationOnly) {
        this.isInformationOnly = StringUtils.equalsIgnoreCase((CharSequence)StringUtils.defaultString((String)informationOnly), (CharSequence)"yes");
    }

    public boolean isShippingInLine() {
        return this.isShippingInLine;
    }

    public void setShippingInfoProvidedIndicator(String isShippingInLine) {
        this.isShippingInLine = StringUtils.equalsIgnoreCase((CharSequence)StringUtils.defaultString((String)isShippingInLine), (CharSequence)"yes");
    }

    public boolean isSpecialHandlingInLine() {
        return this.isSpecialHandlingInLine;
    }

    public void setSpecialHandlingInfoProvidedIndicator(String isSpecialHandlingInLine) {
        this.isSpecialHandlingInLine = StringUtils.equalsIgnoreCase((CharSequence)StringUtils.defaultString((String)isSpecialHandlingInLine), (CharSequence)"yes");
    }

    public boolean isTaxInLine() {
        return this.isTaxInLine;
    }

    public void setTaxInfoProvidedIndicator(String isTaxInLine) {
        this.isTaxInLine = StringUtils.equalsIgnoreCase((CharSequence)StringUtils.defaultString((String)isTaxInLine), (CharSequence)"yes");
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public Date getShippingDate() {
        return this.shippingDate;
    }

    public void setShippingDate(Date shippingDate) {
        this.shippingDate = shippingDate;
    }

    public boolean isAccountingInLine() {
        return this.isAccountingInLine;
    }

    public void setAccountingInfoProvidedIndicator(String isAccountingInLine) {
        this.isAccountingInLine = StringUtils.equalsIgnoreCase((CharSequence)StringUtils.defaultString((String)isAccountingInLine), (CharSequence)"yes");
    }

    public String getIdReferenceCreator() {
        return this.idReferenceCreator;
    }

    public void setIdReferenceCreator(String idReferenceCreator) {
        this.idReferenceCreator = idReferenceCreator;
    }

    public String getIdReferenceDescription() {
        return this.idReferenceDescription;
    }

    public void setIdReferenceDescription(String idReferenceDescription) {
        this.idReferenceDescription = idReferenceDescription;
    }

    public String getIdReferenceDomain() {
        return this.idReferenceDomain;
    }

    public void setIdReferenceDomain(String idReferenceDomain) {
        this.idReferenceDomain = idReferenceDomain;
    }

    public String getIdReferenceIdentifier() {
        return this.idReferenceIdentifier;
    }

    public void setIdReferenceIdentifier(String idReferenceIdentifier) {
        this.idReferenceIdentifier = idReferenceIdentifier;
    }

    public void addInvoicePartnerContact(ElectronicInvoiceContact electronicInvoiceContact) {
        if (electronicInvoiceContact != null) {
            this.invoicePartnerContacts.add(electronicInvoiceContact);
        }
    }

    public ElectronicInvoiceContact[] getInvoicePartnerContactsAsArray() {
        if (this.invoicePartnerContacts.size() > 0) {
            ElectronicInvoiceContact[] tempContacts = new ElectronicInvoiceContact[this.invoicePartnerContacts.size()];
            this.invoicePartnerContacts.toArray(tempContacts);
            return tempContacts;
        }
        return null;
    }

    public void addInvoiceShippingContacts(ElectronicInvoiceContact electronicInvoiceContact) {
        this.invoiceShippingContacts.add(electronicInvoiceContact);
    }

    public ElectronicInvoiceContact[] getInvoiceShippingContactsAsArray() {
        if (this.invoiceShippingContacts.size() > 0) {
            ElectronicInvoiceContact[] tempContacts = new ElectronicInvoiceContact[this.invoiceShippingContacts.size()];
            this.invoiceShippingContacts.toArray(tempContacts);
            return tempContacts;
        }
        return null;
    }

    public void addExtrinsic(CxmlExtrinsic extrinsic) {
        this.extrinsics.add(extrinsic);
    }

    public CxmlExtrinsic[] getExtrinsicAsArray() {
        if (this.extrinsics.size() > 0) {
            CxmlExtrinsic[] extrinsics = new CxmlExtrinsic[this.extrinsics.size()];
            this.extrinsics.toArray(extrinsics);
            return extrinsics;
        }
        return null;
    }

    public int getPayInNumberOfDays() {
        return this.payInNumberOfDays;
    }

    public void setPayInNumberOfDays(int payInNumberOfDays) {
        this.payInNumberOfDays = payInNumberOfDays;
    }

    public String getPercentageRate() {
        return this.percentageRate;
    }

    public void setPercentageRate(String percentageRate) {
        this.percentageRate = percentageRate;
    }

    public String toString() {
        ToStringBuilder toString = new ToStringBuilder((Object)this);
        toString.append("invoiceID", (Object)this.getInvoiceId());
        toString.append("purpose", (Object)this.getPurpose());
        toString.append("operation", (Object)this.getOperation());
        toString.append("invoiceDate", (Object)this.getInvoiceDateString());
        toString.append("isInformationOnly", this.isInformationOnly());
        toString.append("isHeaderInvoiceIndicator", this.isHeaderInvoiceIndicator());
        toString.append("isTaxInLine", this.isTaxInLine());
        toString.append("isSpecialHandlingInLine", this.isSpecialHandlingInLine());
        toString.append("isShippingInLine", this.isShippingInLine());
        toString.append("isDiscountInLine", this.isDiscountInLine());
        toString.append("isAccountingInLine", this.isAccountingInLine());
        toString.append("idReferenceCreator", (Object)this.getIdReferenceCreator());
        toString.append("idReferenceDescription", (Object)this.getIdReferenceDescription());
        toString.append("idReferenceDomain", (Object)this.getIdReferenceDomain());
        toString.append("idReferenceIdentifier", (Object)this.getIdReferenceIdentifier());
        toString.append("shippingDate", (Object)this.getShippingDateString());
        toString.append("invoiceCustomerNumber", (Object)this.getInvoiceCustomerNumber());
        toString.append("payInNumberOfDays", this.getPayInNumberOfDays());
        toString.append("percentageRate", (Object)this.getPercentageRate());
        toString.append("invoicePartnerContacts", (Object)this.getInvoicePartnerContacts());
        toString.append("invoiceShippingContacts", (Object)this.getInvoiceShippingContacts());
        toString.append("extrinsics", (Object)this.getExtrinsics());
        return toString.toString();
    }
}

