/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceContact;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;
import org.kuali.kfs.module.purap.util.PurApDateFormatUtils;
import org.kuali.kfs.module.purap.util.cxml.CxmlExtrinsic;

public class ElectronicInvoiceItem {
    private static final Logger LOG = LogManager.getLogger(ElectronicInvoiceItem.class);
    private String catalogNumber;
    private String invoiceLineNumber;
    private String quantity;
    private String unitOfMeasure;
    private String unitPrice;
    private String unitPriceCurrency;
    private String subTotalAmount;
    private String subTotalAmountCurrency;
    private String invoiceLineSpecialHandlingAmount;
    private String invoiceLineSpecialHandlingAmountCurrency;
    private String invoiceLineShippingAmount;
    private String invoiceLineShippingAmountCurrency;
    private String taxAmount;
    private String taxAmountCurrency;
    private String taxDescription;
    private String invoiceLineGrossAmount;
    private String invoiceLineGrossAmountCurrency;
    private String invoiceLineDiscountAmount;
    private String invoiceLineDiscountAmountCurrency;
    private String invoiceLineDiscountPercentageRate;
    private String invoiceLineNetAmount;
    private String invoiceLineNetAmountCurrency;
    private String shippingDateString;
    private Date shippingDate;
    private List invoiceShippingContacts = new ArrayList();
    private List comments = new ArrayList();
    private List extrinsic = new ArrayList();
    private String referenceLineNumber;
    private String referenceSerialNumber;
    private List<String> referenceSerialNumbers = new ArrayList<String>();
    private String referenceItemIDSupplierPartID;
    private String referenceItemIDSupplierPartAuxID;
    private String referenceDescription;
    private String referenceManufacturerPartID;
    private String referenceManufacturerName;
    private String referenceCountryCode;
    private String referenceCountryName;
    private ElectronicInvoiceRejectDocument electronicInvoiceRejectDocument;

    public Integer getReferenceLineNumberInteger() {
        if (this.referenceLineNumber != null) {
            return new Integer(Integer.parseInt(this.referenceLineNumber));
        }
        return null;
    }

    public String getInvoiceLineShippingDescription() {
        return "";
    }

    public BigDecimal getInvoiceLineQuantityBigDecimal() {
        if (StringUtils.isNotEmpty((CharSequence)this.quantity)) {
            return new BigDecimal(this.quantity);
        }
        return null;
    }

    public BigDecimal getInvoiceLineUnitCostBigDecimal() {
        BigDecimal unitprice = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)this.unitPrice)) {
            try {
                unitprice = new BigDecimal(this.unitPrice);
            }
            catch (NumberFormatException nfe) {
                LOG.info("invalid unit price" + this.unitPrice);
            }
        }
        return unitprice;
    }

    public BigDecimal getInvoiceLineSubTotalAmountBigDecimal() {
        BigDecimal subTotalAmount = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)this.subTotalAmount)) {
            try {
                subTotalAmount = new BigDecimal(this.subTotalAmount);
            }
            catch (NumberFormatException nfe) {
                LOG.info("invalid sub Total Amount " + this.subTotalAmount);
            }
        }
        return subTotalAmount;
    }

    public BigDecimal getInvoiceLineTaxAmountBigDecimal() {
        if (StringUtils.isNotEmpty((CharSequence)this.taxAmount)) {
            return new BigDecimal(this.taxAmount);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getInvoiceLineSpecialHandlingAmountBigDecimal() {
        if (StringUtils.isNotEmpty((CharSequence)this.invoiceLineSpecialHandlingAmount)) {
            return new BigDecimal(this.invoiceLineSpecialHandlingAmount);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getInvoiceLineShippingAmountBigDecimal() {
        if (StringUtils.isNotEmpty((CharSequence)this.invoiceLineShippingAmount)) {
            return new BigDecimal(this.invoiceLineShippingAmount);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getInvoiceLineGrossAmountBigDecimal() {
        if (StringUtils.isNotEmpty((CharSequence)this.invoiceLineGrossAmount)) {
            return new BigDecimal(this.invoiceLineGrossAmount);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getInvoiceLineDiscountAmountBigDecimal() {
        if (StringUtils.isNotEmpty((CharSequence)this.invoiceLineDiscountAmount)) {
            return new BigDecimal(this.invoiceLineDiscountAmount);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getInvoiceLineNetAmountBigDecimal() {
        if (StringUtils.isNotEmpty((CharSequence)this.invoiceLineNetAmount)) {
            return new BigDecimal(this.invoiceLineNetAmount);
        }
        return BigDecimal.ZERO;
    }

    public String getShippingDateString() {
        return this.shippingDateString;
    }

    public void setShippingDateString(String shippingDateString) {
        this.shippingDateString = shippingDateString;
        if (shippingDateString != null && !"".equals(shippingDateString)) {
            SimpleDateFormat sdf = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.CXML_DATE_FORMAT);
            try {
                this.shippingDate = sdf.parse(shippingDateString);
            }
            catch (ParseException e) {
                LOG.error("setShippingDateString() SimpleDateFormat parser error attempting to set invalid date string " + shippingDateString + " in ShippingDate field... setting date to null");
                this.shippingDate = null;
            }
        } else {
            this.shippingDate = null;
        }
    }

    public String getCatalogNumber() {
        return this.catalogNumber;
    }

    public void setCatalogNumber(String catalogNumber) {
        this.catalogNumber = catalogNumber;
    }

    public List getComments() {
        return this.comments;
    }

    public void setComments(List comments) {
        this.comments = comments;
    }

    public List getExtrinsic() {
        return this.extrinsic;
    }

    public void setExtrinsic(List extrinsic) {
        this.extrinsic = extrinsic;
    }

    public String getInvoiceLineDiscountAmount() {
        return this.invoiceLineDiscountAmount;
    }

    public void setInvoiceLineDiscountAmount(String invoiceLineDiscountAmount) {
        this.invoiceLineDiscountAmount = invoiceLineDiscountAmount;
    }

    public String getInvoiceLineDiscountAmountCurrency() {
        return this.invoiceLineDiscountAmountCurrency;
    }

    public void setInvoiceLineDiscountAmountCurrency(String invoiceLineDiscountAmountCurrency) {
        this.invoiceLineDiscountAmountCurrency = invoiceLineDiscountAmountCurrency;
    }

    public String getInvoiceLineGrossAmount() {
        return this.invoiceLineGrossAmount;
    }

    public void setInvoiceLineGrossAmount(String invoiceLineGrossAmount) {
        this.invoiceLineGrossAmount = invoiceLineGrossAmount;
    }

    public String getInvoiceLineGrossAmountCurrency() {
        return this.invoiceLineGrossAmountCurrency;
    }

    public void setInvoiceLineGrossAmountCurrency(String invoiceLineGrossAmountCurrency) {
        this.invoiceLineGrossAmountCurrency = invoiceLineGrossAmountCurrency;
    }

    public String getInvoiceLineNetAmount() {
        return this.invoiceLineNetAmount;
    }

    public void setInvoiceLineNetAmount(String invoiceLineNetAmount) {
        this.invoiceLineNetAmount = invoiceLineNetAmount;
    }

    public String getInvoiceLineNetAmountCurrency() {
        return this.invoiceLineNetAmountCurrency;
    }

    public void setInvoiceLineNetAmountCurrency(String invoiceLineNetAmountCurrency) {
        this.invoiceLineNetAmountCurrency = invoiceLineNetAmountCurrency;
    }

    public String getInvoiceLineNumber() {
        return this.invoiceLineNumber;
    }

    public void setInvoiceLineNumber(String invoiceLineNumber) {
        this.invoiceLineNumber = invoiceLineNumber;
    }

    public String getInvoiceLineShippingAmount() {
        return this.invoiceLineShippingAmount;
    }

    public void setInvoiceLineShippingAmount(String invoiceLineShippingAmount) {
        this.invoiceLineShippingAmount = invoiceLineShippingAmount;
    }

    public String getInvoiceLineShippingAmountCurrency() {
        return this.invoiceLineShippingAmountCurrency;
    }

    public void setInvoiceLineShippingAmountCurrency(String invoiceLineShippingAmountCurrency) {
        this.invoiceLineShippingAmountCurrency = invoiceLineShippingAmountCurrency;
    }

    public String getInvoiceLineSpecialHandlingAmount() {
        return this.invoiceLineSpecialHandlingAmount;
    }

    public void setInvoiceLineSpecialHandlingAmount(String invoiceLineSpecialHandlingAmount) {
        this.invoiceLineSpecialHandlingAmount = invoiceLineSpecialHandlingAmount;
    }

    public String getInvoiceLineSpecialHandlingAmountCurrency() {
        return this.invoiceLineSpecialHandlingAmountCurrency;
    }

    public void setInvoiceLineSpecialHandlingAmountCurrency(String invoiceLineSpecialHandlingAmountCurrency) {
        this.invoiceLineSpecialHandlingAmountCurrency = invoiceLineSpecialHandlingAmountCurrency;
    }

    public List getInvoiceShippingContacts() {
        return this.invoiceShippingContacts;
    }

    public void setInvoiceShippingContacts(List invoiceShippingContacts) {
        this.invoiceShippingContacts = invoiceShippingContacts;
    }

    public void addInvoiceShippingContacts(ElectronicInvoiceContact contact) {
        this.invoiceShippingContacts.add(contact);
    }

    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public String getReferenceCountryCode() {
        return this.referenceCountryCode;
    }

    public void setReferenceCountryCode(String referenceCountryCode) {
        this.referenceCountryCode = referenceCountryCode;
    }

    public String getReferenceCountryName() {
        return this.referenceCountryName;
    }

    public void setReferenceCountryName(String referenceCountryName) {
        this.referenceCountryName = referenceCountryName;
    }

    public String getReferenceDescription() {
        return this.referenceDescription;
    }

    public void setReferenceDescription(String referenceDescription) {
        this.referenceDescription = referenceDescription;
    }

    public String getReferenceItemIDSupplierPartAuxID() {
        return this.referenceItemIDSupplierPartAuxID;
    }

    public void setReferenceItemIDSupplierPartAuxID(String referenceItemIDSupplierPartAuxID) {
        this.referenceItemIDSupplierPartAuxID = referenceItemIDSupplierPartAuxID;
    }

    public String getReferenceItemIDSupplierPartID() {
        return this.referenceItemIDSupplierPartID;
    }

    public void setReferenceItemIDSupplierPartID(String referenceItemIDSupplierPartID) {
        this.referenceItemIDSupplierPartID = referenceItemIDSupplierPartID;
    }

    public String getReferenceLineNumber() {
        return this.referenceLineNumber;
    }

    public void setReferenceLineNumber(String referenceLineNumber) {
        this.referenceLineNumber = referenceLineNumber;
    }

    public String getReferenceManufacturerName() {
        return this.referenceManufacturerName;
    }

    public void setReferenceManufacturerName(String referenceManufacturerName) {
        this.referenceManufacturerName = referenceManufacturerName;
    }

    public String getReferenceManufacturerPartID() {
        return this.referenceManufacturerPartID;
    }

    public void setReferenceManufacturerPartID(String referenceManufacturerPartID) {
        this.referenceManufacturerPartID = referenceManufacturerPartID;
    }

    public String getReferenceSerialNumber() {
        return this.referenceSerialNumber;
    }

    public void setReferenceSerialNumber(String referenceSerialNumber) {
        this.referenceSerialNumber = referenceSerialNumber;
    }

    public List getReferenceSerialNumbers() {
        return this.referenceSerialNumbers;
    }

    public void setReferenceSerialNumbers(List referenceSerialNumbers) {
        this.referenceSerialNumbers = referenceSerialNumbers;
    }

    public Date getShippingDate() {
        return this.shippingDate;
    }

    public void setShippingDate(Date shippingDate) {
        this.shippingDate = shippingDate;
    }

    public String getSubTotalAmount() {
        return this.subTotalAmount;
    }

    public void setSubTotalAmount(String subTotalAmount) {
        this.subTotalAmount = subTotalAmount;
    }

    public String getSubTotalAmountCurrency() {
        return this.subTotalAmountCurrency;
    }

    public void setSubTotalAmountCurrency(String subTotalAmountCurrency) {
        this.subTotalAmountCurrency = subTotalAmountCurrency;
    }

    public String getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getTaxAmountCurrency() {
        return this.taxAmountCurrency;
    }

    public void setTaxAmountCurrency(String taxAmountCurrency) {
        this.taxAmountCurrency = taxAmountCurrency;
    }

    public String getTaxDescription() {
        return this.taxDescription;
    }

    public void setTaxDescription(String taxDescription) {
        this.taxDescription = taxDescription;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
    }

    public String getUnitPriceCurrency() {
        return this.unitPriceCurrency;
    }

    public void setUnitPriceCurrency(String unitPriceCurrency) {
        this.unitPriceCurrency = unitPriceCurrency;
    }

    public ElectronicInvoiceRejectDocument getElectronicInvoiceRejectDocument() {
        return this.electronicInvoiceRejectDocument;
    }

    public void setElectronicInvoiceRejectDocument(ElectronicInvoiceRejectDocument electronicInvoiceRejectDocument) {
        this.electronicInvoiceRejectDocument = electronicInvoiceRejectDocument;
    }

    public void addReferenceSerialNumber(String referenceSerialNumber) {
        this.referenceSerialNumbers.add(referenceSerialNumber);
    }

    public String[] getReferenceSerialNumbersAsArray() {
        if (this.referenceSerialNumbers.size() > 0) {
            String[] serialNumbers = new String[this.referenceSerialNumbers.size()];
            this.referenceSerialNumbers.toArray(serialNumbers);
            return serialNumbers;
        }
        return null;
    }

    public void addExtrinsic(CxmlExtrinsic extrinsic) {
        this.extrinsic.add(extrinsic);
    }

    public CxmlExtrinsic[] getExtrinsicAsArray() {
        if (this.extrinsic.size() > 0) {
            CxmlExtrinsic[] extrinsics = new CxmlExtrinsic[this.extrinsic.size()];
            this.extrinsic.toArray(extrinsics);
            return extrinsics;
        }
        return null;
    }

    public void addComments(String comment) {
        this.comments.add(comment);
    }

    public String getInvoiceLineDiscountPercentageRate() {
        return this.invoiceLineDiscountPercentageRate;
    }

    public void setInvoiceLineDiscountPercentageRate(String invoiceLineDiscountPercentageRate) {
        this.invoiceLineDiscountPercentageRate = invoiceLineDiscountPercentageRate;
    }

    public String toString() {
        ToStringBuilder toString = new ToStringBuilder((Object)this);
        toString.append("invoiceLineNumber", (Object)this.getInvoiceLineNumber());
        toString.append("quantity", (Object)this.getQuantity());
        toString.append("catalogNumber", (Object)this.getCatalogNumber());
        toString.append("unitOfMeasure", (Object)this.getUnitOfMeasure());
        toString.append("unitPrice", (Object)this.getUnitPrice());
        toString.append("unitPriceCurrency", (Object)this.getUnitPriceCurrency());
        toString.append("subTotalAmount", (Object)this.getSubTotalAmount());
        toString.append("subTotalAmountCurrency", (Object)this.getSubTotalAmountCurrency());
        toString.append("invoiceLineSpecialHandlingAmount", (Object)this.getInvoiceLineSpecialHandlingAmount());
        toString.append("invoiceLineSpecialHandlingAmountCurrency", (Object)this.getInvoiceLineSpecialHandlingAmountCurrency());
        toString.append("invoiceLineShippingAmount", (Object)this.getInvoiceLineShippingAmount());
        toString.append("invoiceLineShippingAmountCurrency", (Object)this.getInvoiceLineShippingAmountCurrency());
        toString.append("taxAmount", (Object)this.getTaxAmount());
        toString.append("taxAmountCurrency", (Object)this.getTaxAmountCurrency());
        toString.append("taxDescription", (Object)this.getTaxDescription());
        toString.append("invoiceLineGrossAmount", (Object)this.getInvoiceLineGrossAmount());
        toString.append("invoiceLineGrossAmountCurrency", (Object)this.getInvoiceLineGrossAmountCurrency());
        toString.append("invoiceLineDiscountAmount", (Object)this.getInvoiceLineDiscountAmount());
        toString.append("invoiceLineDiscountAmountCurrency", (Object)this.getInvoiceLineDiscountAmountCurrency());
        toString.append("invoiceLineNetAmount", (Object)this.getInvoiceLineNetAmount());
        toString.append("invoiceLineNetAmountCurrency", (Object)this.getInvoiceLineNetAmountCurrency());
        toString.append("shippingDateString", (Object)this.getShippingDateString());
        toString.append("referenceLineNumber", (Object)this.getReferenceLineNumber());
        toString.append("referenceSerialNumber", (Object)this.getReferenceSerialNumber());
        toString.append("referenceSerialNumbersList", (Object)this.getReferenceSerialNumbers());
        toString.append("referenceItemIDSupplierPartID", (Object)this.getReferenceItemIDSupplierPartID());
        toString.append("referenceItemIDSupplierPartAuxID", (Object)this.getReferenceItemIDSupplierPartAuxID());
        toString.append("referenceDescription", (Object)this.getReferenceDescription());
        toString.append("referenceManufacturerPartID", (Object)this.getReferenceManufacturerPartID());
        toString.append("referenceManufacturerName", (Object)this.getReferenceManufacturerName());
        toString.append("referenceCountryCode", (Object)this.getReferenceCountryCode());
        toString.append("referenceCountryName", (Object)this.getReferenceCountryName());
        toString.append("invoiceShippingContacts", (Object)this.getInvoiceShippingContacts());
        toString.append("comments", (Object)this.getComments());
        toString.append("extrinsic", (Object)this.getExtrinsic());
        return toString.toString();
    }
}

