/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public abstract class PurApAccountingLineBase
extends SourceAccountingLine
implements PurApAccountingLine,
Comparable {
    protected Integer accountIdentifier;
    private Integer itemIdentifier;
    private BigDecimal accountLinePercent;
    private String postingPeriodCode;
    private KualiDecimal alternateAmountForGLEntryCreation;
    public Integer purApSequenceNumber;
    private PurApItem purapItem;

    public PurApAccountingLineBase() {
        this.setSequenceNumber(0);
        this.setAmount(null);
    }

    @Override
    public Integer getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @Override
    public void setAccountIdentifier(Integer requisitionAccountIdentifier) {
        this.accountIdentifier = requisitionAccountIdentifier;
    }

    @Override
    public Integer getItemIdentifier() {
        return this.itemIdentifier;
    }

    @Override
    public void setItemIdentifier(Integer requisitionItemIdentifier) {
        this.itemIdentifier = requisitionItemIdentifier;
    }

    @Override
    public BigDecimal getAccountLinePercent() {
        if (this.accountLinePercent != null) {
            this.accountLinePercent = this.accountLinePercent.setScale(2, 4);
            return this.accountLinePercent;
        }
        return BigDecimal.ZERO.setScale(2, 2);
    }

    @Override
    public void setAccountLinePercent(BigDecimal accountLinePercent) {
        this.accountLinePercent = accountLinePercent;
    }

    @Override
    public boolean isEmpty() {
        return !StringUtils.isNotEmpty((CharSequence)this.getAccountNumber()) && !StringUtils.isNotEmpty((CharSequence)this.getChartOfAccountsCode()) && !StringUtils.isNotEmpty((CharSequence)this.getFinancialObjectCode()) && !StringUtils.isNotEmpty((CharSequence)this.getFinancialSubObjectCode()) && !StringUtils.isNotEmpty((CharSequence)this.getOrganizationReferenceId()) && !StringUtils.isNotEmpty((CharSequence)this.getProjectCode()) && !StringUtils.isNotEmpty((CharSequence)this.getSubAccountNumber()) && !ObjectUtils.isNotNull((Object)this.getAccountLinePercent());
    }

    @Override
    public PurApAccountingLine createBlankAmountsCopy() {
        PurApAccountingLine newAccount = (PurApAccountingLine)((Object)ObjectUtils.deepCopy((Serializable)((Object)this)));
        newAccount.setSequenceNumber(0);
        newAccount.setAccountLinePercent(null);
        newAccount.setAmount(null);
        return newAccount;
    }

    @Override
    public boolean accountStringsAreEqual(SourceAccountingLine accountingLine) {
        if (accountingLine == null) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getChartOfAccountsCode(), (Object)accountingLine.getChartOfAccountsCode()).append((Object)this.getAccountNumber(), (Object)accountingLine.getAccountNumber()).append((Object)this.getSubAccountNumber(), (Object)accountingLine.getSubAccountNumber()).append((Object)this.getFinancialObjectCode(), (Object)accountingLine.getFinancialObjectCode()).append((Object)this.getFinancialSubObjectCode(), (Object)accountingLine.getFinancialSubObjectCode()).append((Object)this.getProjectCode(), (Object)accountingLine.getProjectCode()).append((Object)this.getOrganizationReferenceId(), (Object)accountingLine.getOrganizationReferenceId()).isEquals();
    }

    @Override
    public boolean accountStringsAreEqual(PurApAccountingLine accountingLine) {
        return this.accountStringsAreEqual((SourceAccountingLine)accountingLine);
    }

    @Override
    public SourceAccountingLine generateSourceAccountingLine() {
        SourceAccountingLine sourceLine = new SourceAccountingLine();
        sourceLine.setChartOfAccountsCode(this.getChartOfAccountsCode());
        sourceLine.setAccountNumber(this.getAccountNumber());
        sourceLine.setSubAccountNumber(this.getSubAccountNumber());
        sourceLine.setFinancialObjectCode(this.getFinancialObjectCode());
        sourceLine.setFinancialSubObjectCode(this.getFinancialSubObjectCode());
        sourceLine.setProjectCode(this.getProjectCode());
        sourceLine.setOrganizationReferenceId(this.getOrganizationReferenceId());
        sourceLine.setAmount(this.getAmount());
        sourceLine.setSequenceNumber(this.getSequenceNumber());
        return sourceLine;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof PurApAccountingLine) {
            PurApAccountingLine account = (PurApAccountingLine)arg0;
            return this.getString().compareTo(account.getString());
        }
        return -1;
    }

    @Override
    public String getString() {
        return this.getChartOfAccountsCode() + "~" + this.getAccountNumber() + "~" + this.getSubAccountNumber() + "~" + this.getFinancialObjectCode() + "~" + this.getFinancialSubObjectCode() + "~" + this.getProjectCode() + "~" + this.getOrganizationReferenceId();
    }

    @Override
    public KualiDecimal getAlternateAmountForGLEntryCreation() {
        return this.alternateAmountForGLEntryCreation;
    }

    @Override
    public void setAlternateAmountForGLEntryCreation(KualiDecimal alternateAmount) {
        this.alternateAmountForGLEntryCreation = alternateAmount;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.getAccountIdentifier();
    }

    public void copyFrom(AccountingLine other) {
        super.copyFrom(other);
        if (other instanceof PurApAccountingLine) {
            PurApAccountingLine purapOther = (PurApAccountingLine)other;
            this.setAccountIdentifier(purapOther.getAccountIdentifier());
            this.setSequenceNumber(purapOther.getPurApSequenceNumber());
            this.setAccountLinePercent(purapOther.getAccountLinePercent());
            this.setAmount(purapOther.getAmount());
            this.setAlternateAmountForGLEntryCreation(purapOther.getAlternateAmountForGLEntryCreation());
        }
    }

    public void refreshNonUpdateableReferences() {
        PurApItem item = null;
        Object tempItem = this.getPurapItem();
        if (tempItem != null && tempItem.getItemIdentifier() != null) {
            item = (PurApItem)tempItem;
        }
        super.refreshNonUpdateableReferences();
        if (ObjectUtils.isNotNull(item)) {
            this.setPurapItem(item);
        }
    }

    @Override
    public <T extends PurApItem> T getPurapItem() {
        return (T)this.purapItem;
    }

    @Override
    public void setPurapItem(PurApItem item) {
        this.purapItem = item;
    }

    @Override
    public String getPostingPeriodCode() {
        return this.postingPeriodCode;
    }

    @Override
    public void setPostingPeriodCode(String postingPeriodCode) {
        this.postingPeriodCode = postingPeriodCode;
    }

    public Map getValuesMap() {
        Map valuesMap = super.getValuesMap();
        valuesMap.remove("documentNumber");
        return valuesMap;
    }

    @Override
    public Integer getPurApSequenceNumber() {
        return super.getSequenceNumber();
    }
}

