/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.integration.purap.ItemCapitalAsset;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderCapitalAssetLocation;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItemCapitalAsset;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetSystemBase;

public class PurchaseOrderCapitalAssetSystem
extends PurchasingCapitalAssetSystemBase {
    private String documentNumber;

    public PurchaseOrderCapitalAssetSystem() {
    }

    public PurchaseOrderCapitalAssetSystem(CapitalAssetSystem originalSystem) {
        if (originalSystem != null) {
            this.setCapitalAssetSystemDescription(originalSystem.getCapitalAssetSystemDescription());
            this.setCapitalAssetNotReceivedCurrentFiscalYearIndicator(originalSystem.isCapitalAssetNotReceivedCurrentFiscalYearIndicator());
            this.setCapitalAssetTypeCode(originalSystem.getCapitalAssetTypeCode());
            this.setCapitalAssetManufacturerName(originalSystem.getCapitalAssetManufacturerName());
            this.setCapitalAssetModelDescription(originalSystem.getCapitalAssetModelDescription());
            this.setCapitalAssetNoteText(originalSystem.getCapitalAssetNoteText());
            this.populatePurchaseOrderItemCapitalAssets(originalSystem);
            this.populateCapitalAssetLocations(originalSystem);
            this.setCapitalAssetCountAssetNumber(originalSystem.getCapitalAssetCountAssetNumber());
        }
    }

    private void populatePurchaseOrderItemCapitalAssets(CapitalAssetSystem originalSystem) {
        for (ItemCapitalAsset reqAsset : originalSystem.getItemCapitalAssets()) {
            PurchaseOrderItemCapitalAsset poAsset = new PurchaseOrderItemCapitalAsset(reqAsset.getCapitalAssetNumber());
            this.getItemCapitalAssets().add(poAsset);
        }
    }

    private void populateCapitalAssetLocations(CapitalAssetSystem originalSystem) {
        for (CapitalAssetLocation reqLocation : originalSystem.getCapitalAssetLocations()) {
            PurchaseOrderCapitalAssetLocation poLocation = new PurchaseOrderCapitalAssetLocation();
            poLocation.setItemQuantity(reqLocation.getItemQuantity());
            poLocation.setCampusCode(reqLocation.getCampusCode());
            poLocation.setOffCampusIndicator(reqLocation.isOffCampusIndicator());
            poLocation.setBuildingCode(reqLocation.getBuildingCode());
            poLocation.setBuildingRoomNumber(reqLocation.getBuildingRoomNumber());
            poLocation.setCapitalAssetLine1Address(reqLocation.getCapitalAssetLine1Address());
            poLocation.setCapitalAssetCityName(reqLocation.getCapitalAssetCityName());
            poLocation.setCapitalAssetStateCode(reqLocation.getCapitalAssetStateCode());
            poLocation.setCapitalAssetPostalCode(reqLocation.getCapitalAssetPostalCode());
            poLocation.setCapitalAssetCountryCode(reqLocation.getCapitalAssetCountryCode());
            this.getCapitalAssetLocations().add(poLocation);
        }
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public Class getCapitalAssetLocationClass() {
        return PurchaseOrderCapitalAssetLocation.class;
    }

    @Override
    public Class getItemCapitalAssetClass() {
        return PurchaseOrderItemCapitalAsset.class;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }
}

