/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.dataaccess.impl;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.platforms.PlatformMySQLImpl;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.kfs.module.purap.dataaccess.impl.KualiQueryCustomizerDefaultImpl;

public class PurapItemQueryCustomizer
extends KualiQueryCustomizerDefaultImpl {
    protected static final String MYSQL_NEGATION = "-";
    public static final String ORDER_BY_FIELD = "orderByField.";
    public static final String ASCENDING = "ASC";
    public static final String DESCENDING = "DESC";

    public Query customizeQuery(Object anObject, PersistenceBroker broker, CollectionDescriptor cod, QueryByCriteria query) {
        boolean platformMySQL = broker.serviceSqlGenerator().getPlatform() instanceof PlatformMySQLImpl;
        Map<String, String> attributes = this.getAttributes();
        for (String attributeName : attributes.keySet()) {
            if (!attributeName.startsWith(ORDER_BY_FIELD)) continue;
            String fieldName = attributeName.substring(ORDER_BY_FIELD.length());
            ClassDescriptor itemClassDescriptor = broker.getClassDescriptor(cod.getItemClass());
            FieldDescriptor orderByFieldDescriptior = itemClassDescriptor.getFieldDescriptorByName(fieldName);
            String orderByColumnName = orderByFieldDescriptior.getColumnName();
            String fieldValue = attributes.get(attributeName);
            boolean ascending = StringUtils.equals((CharSequence)fieldValue, (CharSequence)ASCENDING);
            if (!ascending && StringUtils.equals((CharSequence)fieldValue, (CharSequence)DESCENDING)) {
                throw new RuntimeException("neither ASC nor DESC was specified in ojb file for " + fieldName);
            }
            if (platformMySQL) {
                String mysqlPrefix = ascending ? MYSQL_NEGATION : "";
                query.addOrderBy(mysqlPrefix + orderByColumnName, false);
                continue;
            }
            query.addOrderBy(orderByColumnName, ascending);
        }
        return query;
    }
}

