/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.NoteType;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurApItemBase;
import org.kuali.kfs.module.purap.businessobject.PurApItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderView;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.document.PurchaseOrderAmendmentDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderCloseDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderPaymentHoldDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderRemoveHoldDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderReopenDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderRetransmitDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderSplitDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderVoidDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocumentBase;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.impl.PurapServiceImpl;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.SensitiveDataService;
import org.kuali.kfs.module.purap.util.PurApRelatedViews;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentBase;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.location.framework.country.CountryEbo;

public abstract class PurchasingAccountsPayableDocumentBase
extends AccountingDocumentBase
implements PurchasingAccountsPayableDocument,
AmountTotaling {
    private static final Logger LOG = LogManager.getLogger(PurchasingAccountsPayableDocumentBase.class);
    protected Integer purapDocumentIdentifier;
    protected Integer vendorHeaderGeneratedIdentifier;
    protected Integer vendorDetailAssignedIdentifier;
    protected String vendorCustomerNumber;
    protected String vendorName;
    protected String vendorLine1Address;
    protected String vendorLine2Address;
    protected String vendorCityName;
    protected String vendorStateCode;
    protected String vendorAddressInternationalProvinceName;
    protected String vendorPostalCode;
    protected String vendorCountryCode;
    protected Integer accountsPayablePurchasingDocumentLinkIdentifier;
    protected boolean useTaxIndicator;
    protected String vendorAttentionName;
    protected String accountDistributionMethod;
    protected String vendorNumber;
    protected Integer vendorAddressGeneratedIdentifier;
    protected Boolean overrideWorkflowButtons = null;
    protected transient PurApRelatedViews relatedViews;
    protected boolean sensitive;
    protected boolean calculated;
    protected List<PurApItem> items = new ArrayList<PurApItem>();
    protected List<SourceAccountingLine> accountsForRouting;
    protected VendorDetail vendorDetail;
    protected CountryEbo vendorCountry;
    public transient String[] belowTheLineTypes;
    public boolean allowDeleteAwareCollection = true;

    protected GeneralLedgerPendingEntry getFirstPendingGLEntry() {
        if (ObjectUtils.isNotNull((Object)this.getGeneralLedgerPendingEntries()) && !this.getGeneralLedgerPendingEntries().isEmpty()) {
            return (GeneralLedgerPendingEntry)this.getGeneralLedgerPendingEntries().get(0);
        }
        return null;
    }

    public Integer getPostingYearFromPendingGLEntries() {
        GeneralLedgerPendingEntry glpe = this.getFirstPendingGLEntry();
        if (ObjectUtils.isNotNull((Object)glpe)) {
            return glpe.getUniversityFiscalYear();
        }
        return null;
    }

    public String getPostingPeriodCodeFromPendingGLEntries() {
        GeneralLedgerPendingEntry glpe = this.getFirstPendingGLEntry();
        if (ObjectUtils.isNotNull((Object)glpe)) {
            return glpe.getUniversityFiscalPeriodCode();
        }
        return null;
    }

    public List<SourceAccountingLine> getAccountsForRouting() {
        if (this.accountsForRouting == null) {
            this.populateAccountsForRouting();
        }
        return this.accountsForRouting;
    }

    public void setAccountsForRouting(List<SourceAccountingLine> accountsForRouting) {
        this.accountsForRouting = accountsForRouting;
    }

    protected void populateAccountsForRouting() {
        ((PurapAccountingService)SpringContext.getBean(PurapAccountingService.class)).updateAccountAmounts(this);
        this.setAccountsForRouting(((PurapAccountingService)SpringContext.getBean(PurapAccountingService.class)).generateSummary(this.getItems()));
        this.refreshNonUpdateableReferences();
        for (SourceAccountingLine sourceLine : this.getAccountsForRouting()) {
            sourceLine.refreshNonUpdateableReferences();
        }
    }

    public boolean isSensitive() {
        List<SensitiveData> sensitiveData = ((SensitiveDataService)SpringContext.getBean(SensitiveDataService.class)).getSensitiveDatasAssignedByRelatedDocId(this.getAccountsPayablePurchasingDocumentLinkIdentifier());
        return ObjectUtils.isNotNull(sensitiveData) && !sensitiveData.isEmpty();
    }

    @Override
    public boolean isInquiryRendered() {
        return this.isPostingYearPrior();
    }

    @Override
    public boolean isPostingYearNext() {
        Integer currentFY = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
        return this.getPostingYear().compareTo(currentFY) > 0;
    }

    @Override
    public boolean isPostingYearPrior() {
        Integer currentFY = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
        return this.getPostingYear().compareTo(currentFY) < 0;
    }

    @Override
    public Integer getPostingYearNextOrCurrent() {
        if (this.isPostingYearNext()) {
            return this.getPostingYear();
        }
        return ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
    }

    @Override
    public abstract Class getItemClass();

    public abstract Class getItemUseTaxClass();

    @Override
    public abstract PurchasingAccountsPayableDocument getPurApSourceDocumentIfPossible();

    @Override
    public abstract String getPurApSourceDocumentLabelIfPossible();

    public void prepareForSave(KualiDocumentEvent event) {
        this.customPrepareForSave(event);
        super.prepareForSave(event);
        this.fixItemReferences();
    }

    public boolean documentPerformsSufficientFundsCheck() {
        return false;
    }

    @Override
    public boolean isDocumentStoppedInRouteNode(String nodeName) {
        ArrayList currentRouteLevels;
        WorkflowDocument workflowDocument = this.getFinancialSystemDocumentHeader().getWorkflowDocument();
        Set names = workflowDocument.getCurrentNodeNames();
        return CollectionUtils.isNotEmpty((Collection)names) && (currentRouteLevels = new ArrayList(names)).contains(nodeName) && workflowDocument.isApprovalRequested();
    }

    protected void logAndThrowRuntimeException(String errorMessage) {
        this.logAndThrowRuntimeException(errorMessage, null);
    }

    protected void logAndThrowRuntimeException(String errorMessage, Exception e) {
        if (ObjectUtils.isNotNull((Object)e)) {
            LOG.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
        LOG.error(errorMessage);
        throw new RuntimeException(errorMessage);
    }

    public void customPrepareForSave(KualiDocumentEvent event) {
        ((PurapAccountingService)SpringContext.getBean(PurapAccountingService.class)).updateAccountAmounts(this);
        if (event instanceof RouteDocumentEvent || event instanceof ApproveDocumentEvent) {
            if (this instanceof VendorCreditMemoDocument && ((VendorCreditMemoDocument)this).isSourceVendor()) {
                return;
            }
            ((PurapServiceImpl)SpringContext.getBean(PurapServiceImpl.class)).calculateTax(this);
        }
    }

    public List buildListOfDeletionAwareLists() {
        ArrayList<List> managedLists = new ArrayList<List>();
        managedLists.add(this.getDeletionAwareAccountingLines());
        if (this.allowDeleteAwareCollection) {
            managedLists.add(this.getItems());
            managedLists.add(this.getDeletionAwareUseTaxItems());
        }
        return managedLists;
    }

    protected List getDeletionAwareAccountingLines() {
        ArrayList<PurApAccountingLine> deletionAwareAccountingLines = new ArrayList<PurApAccountingLine>();
        for (Object itemAsObject : this.getItems()) {
            PurApItem item = (PurApItem)itemAsObject;
            for (PurApAccountingLine accountingLine : item.getSourceAccountingLines()) {
                deletionAwareAccountingLines.add(accountingLine);
            }
        }
        return deletionAwareAccountingLines;
    }

    protected List getDeletionAwareUseTaxItems() {
        ArrayList<PurApItemUseTax> deletionAwareUseTaxItems = new ArrayList<PurApItemUseTax>();
        List subManageList = this.getItems();
        for (PurApItemBase subManage : subManageList) {
            deletionAwareUseTaxItems.addAll(subManage.getUseTaxItems());
        }
        return deletionAwareUseTaxItems;
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        this.refreshNonUpdateableReferences();
    }

    @Override
    public void addItem(PurApItem item) {
        int itemLinePosition = this.getItemLinePosition();
        if (ObjectUtils.isNotNull((Object)item.getItemLineNumber()) && item.getItemLineNumber() > 0 && item.getItemLineNumber() <= itemLinePosition) {
            itemLinePosition = item.getItemLineNumber() - 1;
        }
        item.setPurapDocumentIdentifier(this.purapDocumentIdentifier);
        item.setPurapDocument(this);
        this.items.add(itemLinePosition, item);
        this.renumberItems(itemLinePosition);
    }

    @Override
    public void deleteItem(int lineNum) {
        if (this.items.remove(lineNum) == null) {
            // empty if block
        }
        this.renumberItems(lineNum);
    }

    @Override
    public void renumberItems(int start) {
        for (int i = start; i < this.items.size(); ++i) {
            PurApItem item = this.items.get(i);
            item.refreshReferenceObject("itemType");
            if (!item.getItemType().isLineItemIndicator()) continue;
            item.setItemLineNumber(new Integer(i + 1));
        }
    }

    @Override
    public void itemSwap(int positionFrom, int positionTo) {
        if (positionTo < 0 || positionTo >= this.getItemLinePosition()) {
            return;
        }
        PurApItem item1 = this.getItem(positionFrom);
        PurApItem item2 = this.getItem(positionTo);
        Integer oldFirstPos = item1.getItemLineNumber();
        item1.setItemLineNumber(item2.getItemLineNumber());
        item2.setItemLineNumber(oldFirstPos);
        this.items.remove(positionFrom);
        this.items.add(positionTo, item1);
    }

    @Override
    public int getItemLinePosition() {
        int belowTheLineCount = 0;
        for (PurApItem item : this.items) {
            item.refreshReferenceObject("itemType");
            if (!item.getItemType().isAdditionalChargeIndicator()) continue;
            ++belowTheLineCount;
        }
        return this.items.size() - belowTheLineCount;
    }

    @Override
    public PurApItem getItem(int pos) {
        return this.items.get(pos);
    }

    public PurApItem getItemByLineNumber(int lineNumber) {
        for (PurApItem item : this.items) {
            if (item.getItemLineNumber() != lineNumber) continue;
            return item;
        }
        return null;
    }

    public PurApItem getItemByStringIdentifier(String itemStrID) {
        for (PurApItem item : this.items) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)item.getItemIdentifierString(), (CharSequence)itemStrID)) continue;
            return item;
        }
        return null;
    }

    public PurApItem getItemByItemIdentifier(Integer itemID) {
        for (PurApItem item : this.items) {
            if (item.getItemIdentifier() != itemID) continue;
            return item;
        }
        return null;
    }

    public void setPostingYear(Integer postingYear) {
        this.postingYear = postingYear;
    }

    @Override
    public KualiDecimal getTotalDollarAmount() {
        return this.getTotalDollarAmountAllItems(null);
    }

    @Override
    public void setTotalDollarAmount(KualiDecimal amount) {
    }

    @Override
    public KualiDecimal getTotalDollarAmountAllItems(String[] excludedTypes) {
        return this.getTotalDollarAmountWithExclusions(excludedTypes, true);
    }

    @Override
    public KualiDecimal getTotalDollarAmountAboveLineItems() {
        return this.getTotalDollarAmountAboveLineItems(null);
    }

    public KualiDecimal getTotalDollarAmountAboveLineItems(String[] excludedTypes) {
        return this.getTotalDollarAmountWithExclusions(excludedTypes, false);
    }

    public KualiDecimal getTotalDollarAmountWithExclusions(String[] excludedTypes, boolean includeBelowTheLine) {
        List itemsForTotal = this.getItems();
        return this.getTotalDollarAmountWithExclusionsSubsetItems(excludedTypes, includeBelowTheLine, itemsForTotal);
    }

    protected KualiDecimal getTotalDollarAmountWithExclusionsSubsetItems(String[] excludedTypes, boolean includeBelowTheLine, List<PurApItem> itemsForTotal) {
        if (excludedTypes == null) {
            excludedTypes = new String[]{};
        }
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurApItem item : itemsForTotal) {
            item.refreshReferenceObject("itemType");
            ItemType it = item.getItemType();
            if (!includeBelowTheLine && !it.isLineItemIndicator() || ArrayUtils.contains((Object[])excludedTypes, (Object)it.getItemTypeCode())) continue;
            KualiDecimal totalAmount = item.getTotalAmount();
            KualiDecimal itemTotal = totalAmount != null ? totalAmount : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    @Override
    public KualiDecimal getTotalDollarAmountForTradeIn() {
        List<PurApItem> tradeInItems = this.getTradeInItems();
        return this.getTotalDollarAmountWithExclusionsSubsetItems(null, false, tradeInItems);
    }

    @Override
    public List<PurApItem> getTradeInItems() {
        ArrayList<PurApItem> tradeInItems = new ArrayList<PurApItem>();
        for (PurApItem purApItem : this.getItems()) {
            if (!purApItem.getItemAssignedToTradeInIndicator()) continue;
            tradeInItems.add(purApItem);
        }
        return tradeInItems;
    }

    @Override
    public KualiDecimal getTotalPreTaxDollarAmount() {
        return this.getTotalPreTaxDollarAmountAllItems(null);
    }

    @Override
    public void setTotalPreTaxDollarAmount(KualiDecimal amount) {
    }

    @Override
    public KualiDecimal getTotalPreTaxDollarAmountAllItems(String[] excludedTypes) {
        return this.getTotalPreTaxDollarAmountWithExclusions(excludedTypes, true);
    }

    public KualiDecimal getTotalPreTaxDollarAmountAboveLineItems() {
        return this.getTotalPreTaxDollarAmountAboveLineItems(null);
    }

    public KualiDecimal getTotalPreTaxDollarAmountAboveLineItems(String[] excludedTypes) {
        return this.getTotalPreTaxDollarAmountWithExclusions(excludedTypes, false);
    }

    public KualiDecimal getTotalPreTaxDollarAmountWithExclusions(String[] excludedTypes, boolean includeBelowTheLine) {
        if (excludedTypes == null) {
            excludedTypes = new String[]{};
        }
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurApItem item : this.getItems()) {
            item.refreshReferenceObject("itemType");
            ItemType it = item.getItemType();
            if (!includeBelowTheLine && !it.isLineItemIndicator() || ArrayUtils.contains((Object[])excludedTypes, (Object)it.getItemTypeCode())) continue;
            KualiDecimal extendedPrice = item.getExtendedPrice();
            KualiDecimal itemTotal = extendedPrice != null ? extendedPrice : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    @Override
    public KualiDecimal getTotalTaxAmount() {
        return this.getTotalTaxAmountAllItems(null);
    }

    @Override
    public void setTotalTaxAmount(KualiDecimal amount) {
    }

    @Override
    public KualiDecimal getTotalTaxAmountAllItems(String[] excludedTypes) {
        return this.getTotalTaxAmountWithExclusions(excludedTypes, true);
    }

    @Override
    public KualiDecimal getTotalTaxAmountAboveLineItems() {
        return this.getTotalTaxAmountAboveLineItems(null);
    }

    @Override
    public KualiDecimal getTotalTaxAmountAboveLineItems(String[] excludedTypes) {
        return this.getTotalTaxAmountWithExclusions(excludedTypes, false);
    }

    @Override
    public KualiDecimal getTotalTaxAmountWithExclusions(String[] excludedTypes, boolean includeBelowTheLine) {
        if (excludedTypes == null) {
            excludedTypes = new String[]{};
        }
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurApItem item : this.getItems()) {
            item.refreshReferenceObject("itemType");
            ItemType it = item.getItemType();
            if (!includeBelowTheLine && !it.isLineItemIndicator() || ArrayUtils.contains((Object[])excludedTypes, (Object)it.getItemTypeCode())) continue;
            KualiDecimal taxAmount = item.getItemTaxAmount();
            KualiDecimal itemTotal = taxAmount != null ? taxAmount : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    @Override
    public boolean isUseTaxIndicator() {
        return this.useTaxIndicator;
    }

    @Override
    public void setUseTaxIndicator(boolean useTaxIndicator) {
        this.useTaxIndicator = useTaxIndicator;
    }

    @Override
    public void templateVendorAddress(VendorAddress vendorAddress) {
        if (vendorAddress == null) {
            return;
        }
        this.setVendorLine1Address(vendorAddress.getVendorLine1Address());
        this.setVendorLine2Address(vendorAddress.getVendorLine2Address());
        this.setVendorCityName(vendorAddress.getVendorCityName());
        this.setVendorStateCode(vendorAddress.getVendorStateCode());
        this.setVendorPostalCode(vendorAddress.getVendorZipCode());
        this.setVendorCountryCode(vendorAddress.getVendorCountryCode());
    }

    @Override
    public String getVendorNumber() {
        if (StringUtils.isNotEmpty((CharSequence)this.vendorNumber)) {
            return this.vendorNumber;
        }
        if (ObjectUtils.isNotNull((Object)this.vendorDetail)) {
            return this.vendorDetail.getVendorNumber();
        }
        return "";
    }

    @Override
    public void setVendorNumber(String vendorNumber) {
        this.vendorNumber = vendorNumber;
    }

    public Boolean getOverrideWorkflowButtons() {
        return this.overrideWorkflowButtons;
    }

    public void setOverrideWorkflowButtons(Boolean overrideWorkflowButtons) {
        this.overrideWorkflowButtons = overrideWorkflowButtons;
    }

    @Override
    public Integer getVendorHeaderGeneratedIdentifier() {
        return this.vendorHeaderGeneratedIdentifier;
    }

    @Override
    public void setVendorHeaderGeneratedIdentifier(Integer vendorHeaderGeneratedIdentifier) {
        this.vendorHeaderGeneratedIdentifier = vendorHeaderGeneratedIdentifier;
    }

    @Override
    public Integer getVendorDetailAssignedIdentifier() {
        return this.vendorDetailAssignedIdentifier;
    }

    @Override
    public void setVendorDetailAssignedIdentifier(Integer vendorDetailAssignedIdentifier) {
        this.vendorDetailAssignedIdentifier = vendorDetailAssignedIdentifier;
    }

    @Override
    public String getVendorCustomerNumber() {
        return this.vendorCustomerNumber;
    }

    @Override
    public void setVendorCustomerNumber(String vendorCustomerNumber) {
        this.vendorCustomerNumber = vendorCustomerNumber;
    }

    @Override
    public Integer getPurapDocumentIdentifier() {
        return this.purapDocumentIdentifier;
    }

    @Override
    public void setPurapDocumentIdentifier(Integer identifier) {
        this.purapDocumentIdentifier = identifier;
    }

    @Override
    public VendorDetail getVendorDetail() {
        return this.vendorDetail;
    }

    public void setVendorDetail(VendorDetail vendorDetail) {
        this.vendorDetail = vendorDetail;
    }

    @Override
    public List getItems() {
        return this.items;
    }

    public void setItems(List items) {
        this.items = items;
    }

    @Override
    public String getVendorCityName() {
        return this.vendorCityName;
    }

    @Override
    public void setVendorCityName(String vendorCityName) {
        this.vendorCityName = vendorCityName;
    }

    @Override
    public String getVendorCountryCode() {
        return this.vendorCountryCode;
    }

    @Override
    public void setVendorCountryCode(String vendorCountryCode) {
        this.vendorCountryCode = vendorCountryCode;
    }

    @Override
    public String getVendorLine1Address() {
        return this.vendorLine1Address;
    }

    @Override
    public void setVendorLine1Address(String vendorLine1Address) {
        this.vendorLine1Address = vendorLine1Address;
    }

    @Override
    public String getVendorLine2Address() {
        return this.vendorLine2Address;
    }

    @Override
    public void setVendorLine2Address(String vendorLine2Address) {
        this.vendorLine2Address = vendorLine2Address;
    }

    @Override
    public String getVendorName() {
        return this.vendorName;
    }

    @Override
    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    @Override
    public String getVendorPostalCode() {
        return this.vendorPostalCode;
    }

    @Override
    public void setVendorPostalCode(String vendorPostalCode) {
        this.vendorPostalCode = vendorPostalCode;
    }

    @Override
    public String getVendorStateCode() {
        return this.vendorStateCode;
    }

    @Override
    public void setVendorStateCode(String vendorStateCode) {
        this.vendorStateCode = vendorStateCode;
    }

    @Override
    public String getVendorAddressInternationalProvinceName() {
        return this.vendorAddressInternationalProvinceName;
    }

    @Override
    public void setVendorAddressInternationalProvinceName(String vendorAddressInternationalProvinceName) {
        this.vendorAddressInternationalProvinceName = vendorAddressInternationalProvinceName;
    }

    @Override
    public Integer getVendorAddressGeneratedIdentifier() {
        return this.vendorAddressGeneratedIdentifier;
    }

    @Override
    public void setVendorAddressGeneratedIdentifier(Integer vendorAddressGeneratedIdentifier) {
        this.vendorAddressGeneratedIdentifier = vendorAddressGeneratedIdentifier;
    }

    @Override
    public Integer getAccountsPayablePurchasingDocumentLinkIdentifier() {
        return this.accountsPayablePurchasingDocumentLinkIdentifier;
    }

    @Override
    public void setAccountsPayablePurchasingDocumentLinkIdentifier(Integer accountsPayablePurchasingDocumentLinkIdentifier) {
        this.accountsPayablePurchasingDocumentLinkIdentifier = accountsPayablePurchasingDocumentLinkIdentifier;
    }

    @Override
    public String[] getBelowTheLineTypes() {
        if (this.belowTheLineTypes == null) {
            this.belowTheLineTypes = ((PurapService)SpringContext.getBean(PurapService.class)).getBelowTheLineForDocument(this);
        }
        return this.belowTheLineTypes;
    }

    @Override
    public CountryEbo getVendorCountry() {
        if (StringUtils.isBlank((CharSequence)this.vendorCountryCode)) {
            this.vendorCountry = null;
        } else if (this.vendorCountry == null || !StringUtils.equals((CharSequence)this.vendorCountry.getCode(), (CharSequence)this.vendorCountryCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(CountryEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(1);
                keys.put("code", this.vendorCountryCode);
                this.vendorCountry = (CountryEbo)moduleService.getExternalizableBusinessObject(CountryEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.vendorCountry;
    }

    @Deprecated
    public void setVendorCountry(CountryEbo vendorCountry) {
        this.vendorCountry = vendorCountry;
    }

    public String getVendorAttentionName() {
        return this.vendorAttentionName;
    }

    public void setVendorAttentionName(String vendorAttentionName) {
        this.vendorAttentionName = vendorAttentionName;
    }

    public String getAccountDistributionMethod() {
        return this.accountDistributionMethod;
    }

    public void setAccountDistributionMethod(String accountDistributionMethod) {
        this.accountDistributionMethod = accountDistributionMethod;
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return false;
    }

    public PurApRelatedViews getRelatedViews() {
        if (this.relatedViews == null) {
            this.relatedViews = new PurApRelatedViews(this.documentNumber, this.accountsPayablePurchasingDocumentLinkIdentifier);
        }
        return this.relatedViews;
    }

    public void setRelatedViews(PurApRelatedViews relatedViews) {
        this.relatedViews = relatedViews;
    }

    public void refreshNonUpdateableReferences() {
        super.refreshNonUpdateableReferences();
        for (PurApItem item : this.getItems()) {
            for (PurApAccountingLine account : item.getSourceAccountingLines()) {
                account.refreshNonUpdateableReferences();
            }
        }
        this.fixItemReferences();
    }

    @Override
    public void fixItemReferences() {
        if (ObjectUtils.isNull((Object)this.purapDocumentIdentifier)) {
            for (PurApItem item : this.getItems()) {
                item.setPurapDocument(this);
                item.fixAccountReferences();
            }
        }
    }

    @Override
    public PurApItem getTradeInItem() {
        for (PurApItem item : this.getItems()) {
            if (!item.getItemTypeCode().equals("TRDI")) continue;
            return item;
        }
        return null;
    }

    @Override
    public boolean getIsATypeOfPurAPRecDoc() {
        return true;
    }

    @Override
    public boolean getIsATypeOfPurDoc() {
        return this instanceof PurchasingDocumentBase;
    }

    @Override
    public boolean getIsATypeOfPODoc() {
        return this instanceof PurchaseOrderDocument;
    }

    @Override
    public boolean getIsPODoc() {
        return this instanceof PurchaseOrderDocument && !(this instanceof PurchaseOrderAmendmentDocument) && !(this instanceof PurchaseOrderCloseDocument) && !(this instanceof PurchaseOrderPaymentHoldDocument) && !(this instanceof PurchaseOrderRemoveHoldDocument) && !(this instanceof PurchaseOrderReopenDocument) && !(this instanceof PurchaseOrderRetransmitDocument) && !(this instanceof PurchaseOrderSplitDocument) && !(this instanceof PurchaseOrderVoidDocument);
    }

    @Override
    public boolean getIsReqsDoc() {
        return this instanceof RequisitionDocument;
    }

    protected String buildDocumentTitle(String title) {
        if (this.getVendorDetail() == null) {
            return title;
        }
        Integer vendorHeaderGeneratedIdentifier = this.getVendorDetail().getVendorHeaderGeneratedIdentifier();
        VendorService vendorService = (VendorService)SpringContext.getBean(VendorService.class);
        Object[] indicators = new String[2];
        boolean isEmployeeVendor = vendorService.isVendorInstitutionEmployee(vendorHeaderGeneratedIdentifier);
        indicators[0] = isEmployeeVendor ? "E" : "N";
        boolean isVendorForeign = vendorService.isVendorForeign(vendorHeaderGeneratedIdentifier);
        indicators[1] = isVendorForeign ? "A" : "N";
        for (String string : indicators) {
            if ("N".equals(string)) continue;
            String titlePattern = title + " [{0}:{1}]";
            return MessageFormat.format(titlePattern, indicators);
        }
        return title;
    }

    public List getSourceAccountingLines() {
        if (ObjectUtils.isNotNull((Object)this.sourceAccountingLines) && !this.sourceAccountingLines.isEmpty()) {
            return this.sourceAccountingLines;
        }
        ArrayList<AccountingLine> sourceAccountingLines = new ArrayList<AccountingLine>();
        for (Object itemAsObject : this.getItems()) {
            PurApItem item = (PurApItem)itemAsObject;
            for (PurApAccountingLine accountingLine : item.getSourceAccountingLines()) {
                if (this.isDuplicateAccountingLine(sourceAccountingLines, accountingLine)) continue;
                sourceAccountingLines.add(accountingLine);
            }
        }
        return sourceAccountingLines;
    }

    protected boolean isDuplicateAccountingLine(List<AccountingLine> sourceAccountingLines, PurApAccountingLine accountingLine) {
        for (AccountingLine sourceLine : sourceAccountingLines) {
            PurApAccountingLine purapAccountLine = (PurApAccountingLine)sourceLine;
            if (!purapAccountLine.accountStringsAreEqual(accountingLine)) continue;
            return true;
        }
        return false;
    }

    protected KualiDecimal getAccountTotalGLEntryAmount(AccountingLine matchingAccountingLine) {
        KualiDecimal accountTotalGLEntryAmount = KualiDecimal.ZERO;
        for (Object itemAsObject : this.getItems()) {
            PurApItem item = (PurApItem)itemAsObject;
            for (PurApAccountingLine accountingLine : item.getSourceAccountingLines()) {
                if (!accountingLine.accountStringsAreEqual((SourceAccountingLine)matchingAccountingLine)) continue;
                accountTotalGLEntryAmount = (KualiDecimal)accountTotalGLEntryAmount.add((AbstractKualiDecimal)accountingLine.getAmount());
            }
        }
        return accountTotalGLEntryAmount;
    }

    public boolean getNeedWarningRelatedPOs() {
        List<PurchaseOrderView> poViews = this.getRelatedViews().getRelatedPurchaseOrderViews();
        for (PurchaseOrderView poView : poViews) {
            if (!poView.getNeedWarning()) continue;
            return true;
        }
        return false;
    }

    protected List getPersistedSourceAccountingLinesForComparison() {
        LOG.info("Checking persisted source accounting lines for read-only fields");
        ArrayList restrictedItemTypesList = new ArrayList();
        try {
            restrictedItemTypesList = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(this.getClass(), "ITEM_TYPES_RESTRICTING_ACCOUNT_EDIT"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PurapAccountingService purApAccountingService = (PurapAccountingService)SpringContext.getBean(PurapAccountingService.class);
        ArrayList<PurApAccountingLine> persistedSourceLines = new ArrayList<PurApAccountingLine>();
        for (PurApItem item : this.getItems()) {
            boolean isNotReadOnly;
            if (!ObjectUtils.isNotNull((Object)item.getItemIdentifier()) || !(isNotReadOnly = restrictedItemTypesList == null || !restrictedItemTypesList.contains(item.getItemTypeCode()))) continue;
            persistedSourceLines.addAll(purApAccountingService.getAccountsFromItem(item));
        }
        return persistedSourceLines;
    }

    protected List getSourceAccountingLinesForComparison() {
        LOG.info("Checking source accounting lines for read-only fields");
        ArrayList restrictedItemTypesList = new ArrayList();
        try {
            restrictedItemTypesList = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(this.getClass(), "ITEM_TYPES_RESTRICTING_ACCOUNT_EDIT"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PurapAccountingService purApAccountingService = (PurapAccountingService)SpringContext.getBean(PurapAccountingService.class);
        ArrayList<PurApAccountingLine> currentSourceLines = new ArrayList<PurApAccountingLine>();
        for (PurApItem item : this.getItems()) {
            boolean isNotReadOnly = restrictedItemTypesList == null || !restrictedItemTypesList.contains(item.getItemTypeCode());
            if (!isNotReadOnly) continue;
            currentSourceLines.addAll(item.getSourceAccountingLines());
        }
        return currentSourceLines;
    }

    @Override
    public boolean isCalculated() {
        return this.calculated;
    }

    @Override
    public void setCalculated(boolean calculated) {
        this.calculated = calculated;
    }

    public NoteType getNoteType() {
        return NoteType.BUSINESS_OBJECT;
    }
}

