/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.authorization.PurchasingAccountsPayableDocumentPresentationController;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.kew.api.WorkflowDocument;

public class RequisitionDocumentPresentationController
extends PurchasingAccountsPayableDocumentPresentationController {
    @Override
    public boolean canEdit(Document document) {
        RequisitionDocument reqDocument = (RequisitionDocument)document;
        if (!("In Process".equals(reqDocument.getApplicationDocumentStatus()) || "Awaiting Content Approval".equals(reqDocument.getApplicationDocumentStatus()) || "Awaiting Accounting Lines".equals(reqDocument.getApplicationDocumentStatus()) || "Awaiting Fiscal Officer".equals(reqDocument.getApplicationDocumentStatus()) || "Awaiting Commodity Code".equals(reqDocument.getApplicationDocumentStatus()))) {
            return false;
        }
        return super.canEdit(document);
    }

    public Set<String> getEditModes(Document document) {
        WorkflowDocument workflowDocument;
        boolean lockAddressToVendor;
        boolean displayReceivingAddress;
        boolean salesTaxInd;
        Set editModes = super.getEditModes(document);
        RequisitionDocument reqDocument = (RequisitionDocument)document;
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        boolean enableCommodityCode = parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_COMMODITY_CODE_IND");
        if (enableCommodityCode) {
            editModes.add("enableCommodityCode");
        }
        if (ObjectUtils.isNotNull((Object)reqDocument.getVendorHeaderGeneratedIdentifier())) {
            editModes.add("lockVendorEntry");
        }
        if ("B2B".equals(reqDocument.getRequisitionSourceCode())) {
            editModes.add("lockB2BEntry");
        }
        if (!"B2B".equals(reqDocument.getRequisitionSourceCode()) && ((PurapService)SpringContext.getBean(PurapService.class)).allowEncumberNextFiscalYear()) {
            editModes.add("allowPostingYearEntry");
        }
        if (salesTaxInd = parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND").booleanValue()) {
            editModes.add("purapTaxEnabled");
            editModes.add("clearAllTaxes");
            if (reqDocument.isUseTaxIndicator()) {
                editModes.add("lockTaxAmountEntry");
            }
        }
        if (displayReceivingAddress = parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_RECEIVING_ADDRESS_IND").booleanValue()) {
            editModes.add("displayReceivingAddress");
        }
        boolean bl = lockAddressToVendor = parameterService.getParameterValueAsBoolean("KFS-PURAP", "Requisition", "ENABLE_ADDRESS_TO_VENDOR_SELECTION_IND") == false;
        if (lockAddressToVendor) {
            editModes.add("lockAddressToVendor");
        }
        if (reqDocument.isDocumentStoppedInRouteNode("Organization") || reqDocument.isDocumentStoppedInRouteNode("Initiator")) {
            editModes.add("lockContentEntry");
        } else if (reqDocument.isDocumentStoppedInRouteNode("Account")) {
            editModes.add("restrictFullEntry");
            ArrayList<PurApAccountingLine> lineList = new ArrayList<PurApAccountingLine>();
            for (RequisitionItem item : reqDocument.getItems()) {
                lineList.addAll(item.getSourceAccountingLines());
                if (item.getSourceAccountingLines().size() != 0) continue;
                editModes.add("restrictFullEntry");
            }
        } else if (reqDocument.isDocumentStoppedInRouteNode("Commodity")) {
            editModes.add("restrictFullEntry");
        }
        String reqDocumentStatus = reqDocument.getApplicationDocumentStatus();
        if ("Awaiting Fiscal Officer".equals(reqDocumentStatus) || "In Process".equals(reqDocumentStatus) || "Awaiting Content Approval".equals(reqDocumentStatus) || "Awaiting Commodity Code".equals(reqDocumentStatus)) {
            editModes.add("allowCapitalAssetEdit");
        }
        if ((workflowDocument = document.getDocumentHeader().getWorkflowDocument()).isEnroute()) {
            Set nodeNames = workflowDocument.getNodeNames();
            for (String nodeNamesNode : nodeNames) {
                if (!"Account".equals(nodeNamesNode)) continue;
                editModes.add("disableSetupAccountDistribution");
                editModes.add("disableRemoveAccounts");
            }
        }
        return editModes;
    }

    public boolean canCopy(Document document) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isInitiated() && !workflowDocument.isSaved()) {
            return false;
        }
        return super.canCopy(document);
    }

    @Override
    public boolean canEditDocumentOverview(Document document) {
        RequisitionDocument reqDocument = (RequisitionDocument)document;
        if (reqDocument.isDocumentStoppedInRouteNode("Commodity")) {
            return false;
        }
        return super.canEditDocumentOverview(document);
    }

    public boolean canReload(Document document) {
        RequisitionDocument reqDocument = (RequisitionDocument)document;
        WorkflowDocument workflowDocument = ((PurchasingAccountsPayableDocument)document).getFinancialSystemDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isAcknowledgeRequested()) {
            return false;
        }
        if (reqDocument.isDocumentStoppedInRouteNode("SubAccount")) {
            return false;
        }
        if (this.isDocInRouteNodeNotForCurrentUser((Document)reqDocument, "SubAccount")) {
            return true;
        }
        if (reqDocument.isDocumentStoppedInRouteNode("AccountingOrganizationHierarchy")) {
            return false;
        }
        if (this.isDocInRouteNodeNotForCurrentUser((Document)reqDocument, "AccountingOrganizationHierarchy")) {
            return true;
        }
        if (reqDocument.isDocumentStoppedInRouteNode("SeparationOfDuties")) {
            return false;
        }
        if (this.isDocInRouteNodeNotForCurrentUser((Document)reqDocument, "SeparationOfDuties")) {
            return true;
        }
        return super.canReload(document);
    }

    public boolean canSave(Document document) {
        RequisitionDocument reqDocument = (RequisitionDocument)document;
        if (reqDocument.isDocumentStoppedInRouteNode("AccountingOrganizationHierarchy")) {
            return false;
        }
        return super.canSave(document);
    }

    protected boolean isDocInRouteNodeNotForCurrentUser(Document document, String nodeName) {
        ArrayList currentRouteLevels;
        WorkflowDocument workflowDocument = ((PurchasingAccountsPayableDocument)document).getFinancialSystemDocumentHeader().getWorkflowDocument();
        Set names = workflowDocument.getCurrentNodeNames();
        return CollectionUtils.isNotEmpty((Collection)names) && (currentRouteLevels = new ArrayList(names)).contains(nodeName) && !workflowDocument.isApprovalRequested();
    }
}

