/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.purap.document.BulkReceivingDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.dataaccess.BulkReceivingDao;
import org.kuali.kfs.module.purap.document.service.BulkReceivingService;
import org.kuali.kfs.module.purap.document.service.PrintService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedContinuePurapEvent;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BulkReceivingServiceImpl
implements BulkReceivingService {
    private static final Logger LOG = LogManager.getLogger(BulkReceivingServiceImpl.class);
    protected PurchaseOrderService purchaseOrderService;
    protected BulkReceivingDao bulkReceivingDao;
    protected DocumentService documentService;
    protected WorkflowDocumentService workflowDocumentService;
    protected ConfigurationService configurationService;
    protected PrintService printService;

    @Override
    public boolean canPrintReceivingTicket(BulkReceivingDocument blkRecDoc) {
        boolean canCreate = false;
        WorkflowDocument workflowDocument = null;
        try {
            workflowDocument = this.workflowDocumentService.createWorkflowDocument(blkRecDoc.getDocumentHeader().getWorkflowDocument().getDocumentTypeName(), GlobalVariables.getUserSession().getPerson());
        }
        catch (WorkflowException we) {
            throw new RuntimeException(we);
        }
        if (workflowDocument.isFinal()) {
            canCreate = true;
        }
        return canCreate;
    }

    @Override
    public void populateAndSaveBulkReceivingDocument(BulkReceivingDocument blkRecDoc) throws WorkflowException {
        try {
            this.documentService.saveDocument((Document)blkRecDoc, AttributedContinuePurapEvent.class);
        }
        catch (WorkflowException we) {
            String errorMsg = "Error saving document # " + blkRecDoc.getDocumentHeader().getDocumentNumber() + " " + we.getMessage();
            throw new RuntimeException(errorMsg, we);
        }
    }

    @Override
    public HashMap<String, String> bulkReceivingDuplicateMessages(BulkReceivingDocument blkRecDoc) {
        HashMap<String, String> msgs = new HashMap<String, String>();
        Integer poId = blkRecDoc.getPurchaseOrderIdentifier();
        StringBuffer currentMessage = new StringBuffer("");
        List<String> docNumbers = null;
        if (blkRecDoc.getShipmentReceivedDate() != null && this.hasDuplicateEntry(docNumbers = this.bulkReceivingDao.duplicateVendorDate(poId, blkRecDoc.getShipmentReceivedDate()))) {
            this.appendDuplicateMessage(currentMessage, "message.duplicate.receivngLine.vendorDate", blkRecDoc.getPurchaseOrderIdentifier());
        }
        if (!StringUtils.isEmpty((CharSequence)blkRecDoc.getShipmentPackingSlipNumber()) && this.hasDuplicateEntry(docNumbers = this.bulkReceivingDao.duplicatePackingSlipNumber(poId, blkRecDoc.getShipmentPackingSlipNumber()))) {
            this.appendDuplicateMessage(currentMessage, "message.duplicate.receivingLine.packingSlipNumber", blkRecDoc.getPurchaseOrderIdentifier());
        }
        if (!StringUtils.isEmpty((CharSequence)blkRecDoc.getShipmentBillOfLadingNumber()) && this.hasDuplicateEntry(docNumbers = this.bulkReceivingDao.duplicateBillOfLadingNumber(poId, blkRecDoc.getShipmentBillOfLadingNumber()))) {
            this.appendDuplicateMessage(currentMessage, "message.duplicate.receivingLine.billOfLadingNumber", blkRecDoc.getPurchaseOrderIdentifier());
        }
        if (currentMessage.length() > 0) {
            this.appendDuplicateMessage(currentMessage, "message.duplicate.receivingLine.suffix", blkRecDoc.getPurchaseOrderIdentifier());
            msgs.put("DuplicateBulkReceiving", currentMessage.toString());
        }
        return msgs;
    }

    protected boolean hasDuplicateEntry(List<String> docNumbers) {
        boolean isDuplicate = false;
        WorkflowDocument workflowDocument = null;
        for (String docNumber : docNumbers) {
            try {
                workflowDocument = this.workflowDocumentService.loadWorkflowDocument(docNumber, GlobalVariables.getUserSession().getPerson());
            }
            catch (WorkflowException we) {
                throw new RuntimeException(we);
            }
            if (!workflowDocument.isFinal()) continue;
            isDuplicate = true;
            break;
        }
        return isDuplicate;
    }

    protected void appendDuplicateMessage(StringBuffer currentMessage, String duplicateMessageKey, Integer poId) {
        if (currentMessage.length() == 0) {
            String messageText = this.configurationService.getPropertyValueAsString("message.bulkReceiving.duplicate.prefix");
            String prefix = MessageFormat.format(messageText, poId.toString());
            currentMessage.append(prefix);
        }
        currentMessage.append(this.configurationService.getPropertyValueAsString(duplicateMessageKey));
    }

    @Override
    public String getBulkReceivingDocumentNumberInProcessForPurchaseOrder(Integer poId, String bulkReceivingDocumentNumber) {
        String docNumberInProcess = "";
        List<String> docNumbers = this.bulkReceivingDao.getDocumentNumbersByPurchaseOrderId(poId);
        WorkflowDocument workflowDocument = null;
        for (String docNumber : docNumbers) {
            try {
                workflowDocument = this.workflowDocumentService.loadWorkflowDocument(docNumber, GlobalVariables.getUserSession().getPerson());
            }
            catch (WorkflowException we) {
                throw new RuntimeException(we);
            }
            if (workflowDocument.isCanceled() || workflowDocument.isException() || workflowDocument.isFinal() || docNumber.equals(bulkReceivingDocumentNumber)) continue;
            docNumberInProcess = docNumber;
            break;
        }
        return docNumberInProcess;
    }

    @Override
    public void populateBulkReceivingFromPurchaseOrder(BulkReceivingDocument blkRecDoc) {
        PurchaseOrderDocument poDoc;
        if (blkRecDoc != null && (poDoc = this.purchaseOrderService.getCurrentPurchaseOrder(blkRecDoc.getPurchaseOrderIdentifier())) != null) {
            blkRecDoc.populateBulkReceivingFromPurchaseOrder(poDoc);
        }
    }

    public BulkReceivingDocument getBulkReceivingByDocumentNumber(String documentNumber) {
        if (ObjectUtils.isNotNull((Object)documentNumber)) {
            try {
                BulkReceivingDocument doc = (BulkReceivingDocument)this.documentService.getByDocumentHeaderId(documentNumber);
                if (ObjectUtils.isNotNull((Object)doc)) {
                    WorkflowDocument workflowDocument = doc.getDocumentHeader().getWorkflowDocument();
                    doc.refreshReferenceObject("documentHeader");
                    doc.getDocumentHeader().setWorkflowDocument(workflowDocument);
                }
                return doc;
            }
            catch (WorkflowException e) {
                String errorMessage = "Error getting bulk receiving document from document service";
                throw new RuntimeException(errorMessage, e);
            }
        }
        return null;
    }

    @Override
    public void performPrintReceivingTicketPDF(String blkDocId, ByteArrayOutputStream baosPDF) {
        BulkReceivingDocument blkRecDoc = this.getBulkReceivingByDocumentNumber(blkDocId);
        Collection generatePDFErrors = this.printService.generateBulkReceivingPDF(blkRecDoc, baosPDF);
        if (!generatePDFErrors.isEmpty()) {
            this.addStringErrorMessagesToMessageMap("error.bulkreceiving.pdf", generatePDFErrors);
            throw new ValidationException("printing bulk receiving ticket failed");
        }
    }

    protected void addStringErrorMessagesToMessageMap(String errorKey, Collection<String> errors) {
        if (ObjectUtils.isNotNull(errors)) {
            for (String error : errors) {
                LOG.error("Adding error message using error key '" + errorKey + "' with text '" + error + "'");
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", errorKey, new String[]{error});
            }
        }
    }

    public void setPrintService(PrintService printService) {
        this.printService = printService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setBulkReceivingDao(BulkReceivingDao bulkReceivingDao) {
        this.bulkReceivingDao = bulkReceivingDao;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

