/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.CreditMemoAccount;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.dataaccess.CreditMemoDao;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedContinuePurapEvent;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.PurapGeneralLedgerService;
import org.kuali.kfs.module.purap.util.ExpiredOrClosedAccountEntry;
import org.kuali.kfs.module.purap.util.VendorGroupingHelper;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.kfs.vnd.VendorUtils;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CreditMemoServiceImpl
implements CreditMemoService {
    private static final Logger LOG = LogManager.getLogger(CreditMemoServiceImpl.class);
    protected AccountsPayableService accountsPayableService;
    protected CreditMemoDao creditMemoDao;
    protected DataDictionaryService dataDictionaryService;
    protected DocumentService documentService;
    protected ConfigurationService kualiConfigurationService;
    protected NoteService noteService;
    protected PaymentRequestService paymentRequestService;
    protected PurapAccountingService purapAccountingService;
    protected PurapGeneralLedgerService purapGeneralLedgerService;
    protected PurapService purapService;
    protected PurchaseOrderService purchaseOrderService;
    protected VendorService vendorService;
    protected WorkflowDocumentService workflowDocumentService;
    protected FinancialSystemDocumentService financialSystemDocumentService;

    public void setAccountsPayableService(AccountsPayableService accountsPayableService) {
        this.accountsPayableService = accountsPayableService;
    }

    public void setCreditMemoDao(CreditMemoDao creditMemoDao) {
        this.creditMemoDao = creditMemoDao;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setPaymentRequestService(PaymentRequestService paymentRequestService) {
        this.paymentRequestService = paymentRequestService;
    }

    public void setPurapAccountingService(PurapAccountingService purapAccountingService) {
        this.purapAccountingService = purapAccountingService;
    }

    public void setPurapGeneralLedgerService(PurapGeneralLedgerService purapGeneralLedgerService) {
        this.purapGeneralLedgerService = purapGeneralLedgerService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    @Override
    public List<VendorCreditMemoDocument> getCreditMemosToExtract(String chartCode) {
        LOG.debug("getCreditMemosToExtract() started");
        List docs = this.creditMemoDao.getCreditMemosToExtract(chartCode);
        docs = (List)this.filterCreditMemoByAppDocStatus(docs, PurapConstants.CreditMemoStatuses.STATUSES_ALLOWED_FOR_EXTRACTION);
        return docs;
    }

    @Override
    public Collection<VendorCreditMemoDocument> getCreditMemosToExtractByVendor(String chartCode, VendorGroupingHelper vendor) {
        LOG.debug("getCreditMemosToExtractByVendor() started");
        Collection<VendorCreditMemoDocument> docs = this.creditMemoDao.getCreditMemosToExtractByVendor(chartCode, vendor);
        docs = this.filterCreditMemoByAppDocStatus(docs, PurapConstants.CreditMemoStatuses.STATUSES_ALLOWED_FOR_EXTRACTION);
        return docs;
    }

    @Override
    public Set<VendorGroupingHelper> getVendorsOnCreditMemosToExtract(String chartCode) {
        LOG.debug("getVendorsOnCreditMemosToExtract() started");
        HashSet<VendorGroupingHelper> vendors = new HashSet<VendorGroupingHelper>();
        List<VendorCreditMemoDocument> docs = this.getCreditMemosToExtract(chartCode);
        for (VendorCreditMemoDocument doc : docs) {
            vendors.add(new VendorGroupingHelper(doc));
        }
        return vendors;
    }

    @Deprecated
    protected List<String> filterCreditMemoByAppDocStatus(List<String> lookupDocNumbers, String ... appDocStatus) {
        ArrayList<String> creditMemoDocNumbers = new ArrayList<String>();
        List<String> appDocStatusList = Arrays.asList(appDocStatus);
        for (String docNumber : lookupDocNumbers) {
            if (!appDocStatusList.contains(this.financialSystemDocumentService.findByDocumentNumber(docNumber).getApplicationDocumentStatus())) continue;
            creditMemoDocNumbers.add(docNumber);
        }
        return creditMemoDocNumbers;
    }

    protected Collection<VendorCreditMemoDocument> filterCreditMemoByAppDocStatus(Collection<VendorCreditMemoDocument> creditMemoDocuments, String ... appDocStatus) {
        List<String> appDocStatusList = Arrays.asList(appDocStatus);
        ArrayList<VendorCreditMemoDocument> filteredCreditMemoDocuments = new ArrayList<VendorCreditMemoDocument>();
        for (VendorCreditMemoDocument creditMemo : creditMemoDocuments) {
            if (!appDocStatusList.contains(creditMemo.getApplicationDocumentStatus())) continue;
            filteredCreditMemoDocuments.add(creditMemo);
        }
        return filteredCreditMemoDocuments;
    }

    private Iterator<VendorCreditMemoDocument> filterCreditMemoByAppDocStatus(Iterator<VendorCreditMemoDocument> creditMemoIterator, String ... appDocStatus) {
        ArrayList<VendorCreditMemoDocument> creditMemoDocuments = new ArrayList<VendorCreditMemoDocument>();
        while (creditMemoIterator.hasNext()) {
            creditMemoDocuments.add(creditMemoIterator.next());
        }
        return this.filterCreditMemoByAppDocStatus((Collection<VendorCreditMemoDocument>)creditMemoDocuments, appDocStatus).iterator();
    }

    @Override
    public String creditMemoDuplicateMessages(VendorCreditMemoDocument cmDocument) {
        PurchasingAccountsPayableDocument sourceDocument;
        String duplicateMessage = null;
        String vendorNumber = cmDocument.getVendorNumber();
        if (StringUtils.isEmpty((CharSequence)vendorNumber) && ObjectUtils.isNotNull((Object)(sourceDocument = cmDocument.getPurApSourceDocumentIfPossible()))) {
            vendorNumber = sourceDocument.getVendorNumber();
        }
        if (StringUtils.isNotEmpty((CharSequence)vendorNumber)) {
            if (this.creditMemoDao.duplicateExists(VendorUtils.getVendorHeaderId((String)vendorNumber), VendorUtils.getVendorDetailId((String)vendorNumber), cmDocument.getCreditMemoNumber())) {
                duplicateMessage = this.kualiConfigurationService.getPropertyValueAsString("message.duplicate.creditMemo.vendorNumber");
            }
            if (this.creditMemoDao.duplicateExists(VendorUtils.getVendorHeaderId((String)vendorNumber), VendorUtils.getVendorDetailId((String)vendorNumber), cmDocument.getCreditMemoDate(), cmDocument.getCreditMemoAmount())) {
                duplicateMessage = this.kualiConfigurationService.getPropertyValueAsString("message.duplicate.creditMemo.vendorNumber.date.amount");
            }
        }
        return duplicateMessage;
    }

    @Override
    public List<PurchaseOrderItem> getPOInvoicedItems(PurchaseOrderDocument poDocument) {
        ArrayList<PurchaseOrderItem> invoicedItems = new ArrayList<PurchaseOrderItem>();
        for (PurchaseOrderItem poItem : poDocument.getItems()) {
            poItem.refreshReferenceObject("itemType");
            if (poItem.getItemType().isQuantityBasedGeneralLedgerIndicator() && poItem.getItemInvoicedTotalQuantity().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                invoicedItems.add(poItem);
                continue;
            }
            BigDecimal bigDecimal = poItem.getItemUnitPrice() == null ? new BigDecimal(0) : poItem.getItemUnitPrice();
            BigDecimal unitPrice = bigDecimal;
            if (!(unitPrice.doubleValue() > poItem.getItemOutstandingEncumberedAmount().doubleValue())) continue;
            invoicedItems.add(poItem);
        }
        return invoicedItems;
    }

    @Override
    public void calculateCreditMemo(VendorCreditMemoDocument cmDocument) {
        cmDocument.updateExtendedPriceOnItems();
        for (CreditMemoItem item : cmDocument.getItems()) {
            if (!StringUtils.equals((CharSequence)"RSTO", (CharSequence)item.getItemTypeCode()) || item.getItemUnitPrice() == null) continue;
            item.setExtendedPrice((KualiDecimal)((KualiDecimal)item.getExtendedPrice().abs()).negated());
            item.setItemUnitPrice(item.getItemUnitPrice().abs().negate());
        }
        if (!cmDocument.isSourceVendor()) {
            this.purapService.calculateTax(cmDocument);
        }
        if (cmDocument.isSourceVendor()) {
            return;
        }
        for (CreditMemoItem item : cmDocument.getItems()) {
            item.refreshReferenceObject("itemType");
            if (item.getItemType().isLineItemIndicator() || !item.getSourceAccountingLines().isEmpty() || !ObjectUtils.isNotNull((Object)item.getExtendedPrice()) || KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)item.getExtendedPrice()) == 0) continue;
            KualiDecimal totalAmount = KualiDecimal.ZERO;
            List<PurApAccountingLine> distributedAccounts = null;
            List<SourceAccountingLine> summaryAccounts = null;
            totalAmount = cmDocument.getPurApSourceDocumentIfPossible().getTotalDollarAmount();
            this.purapAccountingService.updateAccountAmounts(cmDocument.getPurApSourceDocumentIfPossible());
            summaryAccounts = this.purapAccountingService.generateSummary(cmDocument.getPurApSourceDocumentIfPossible().getItems());
            distributedAccounts = this.purapAccountingService.generateAccountDistributionForProration(summaryAccounts, totalAmount, PurapConstants.PRORATION_SCALE, CreditMemoAccount.class);
            if (!CollectionUtils.isNotEmpty(distributedAccounts) || !CollectionUtils.isEmpty(item.getSourceAccountingLines())) continue;
            item.setSourceAccountingLines(distributedAccounts);
        }
    }

    @Override
    public VendorCreditMemoDocument getCreditMemoByDocumentNumber(String documentNumber) {
        LOG.debug("getCreditMemoByDocumentNumber() started");
        if (ObjectUtils.isNotNull((Object)documentNumber)) {
            try {
                VendorCreditMemoDocument doc = (VendorCreditMemoDocument)this.documentService.getByDocumentHeaderId(documentNumber);
                return doc;
            }
            catch (WorkflowException e) {
                String errorMessage = "Error getting credit memo document from document service";
                LOG.error("getCreditMemoByDocumentNumber() " + errorMessage, (Throwable)e);
                throw new RuntimeException(errorMessage, e);
            }
        }
        return null;
    }

    @Override
    public VendorCreditMemoDocument getCreditMemoDocumentById(Integer purchasingDocumentIdentifier) {
        return this.getCreditMemoByDocumentNumber(this.creditMemoDao.getDocumentNumberByCreditMemoId(purchasingDocumentIdentifier));
    }

    @Override
    public void populateAndSaveCreditMemo(VendorCreditMemoDocument document) {
        try {
            document.updateAndSaveAppDocStatus("In Process");
            if (document.isSourceDocumentPaymentRequest()) {
                document.setBankCode(document.getPaymentRequestDocument().getBankCode());
                document.setBank(document.getPaymentRequestDocument().getBank());
            } else {
                Bank defaultBank = ((BankService)SpringContext.getBean(BankService.class)).getDefaultBankByDocType(document.getClass());
                if (defaultBank != null) {
                    document.setBankCode(defaultBank.getBankCode());
                    document.setBank(defaultBank);
                }
            }
            this.documentService.saveDocument((Document)document, AttributedContinuePurapEvent.class);
        }
        catch (ValidationException ve) {
            try {
                document.updateAndSaveAppDocStatus("Initiated");
            }
            catch (WorkflowException workflowException) {}
        }
        catch (WorkflowException we) {
            try {
                document.updateAndSaveAppDocStatus("Initiated");
            }
            catch (WorkflowException workflowException) {
                // empty catch block
            }
            String errorMsg = "Error saving document # " + document.getDocumentNumber() + " " + we.getMessage();
            LOG.error(errorMsg, (Throwable)we);
            throw new RuntimeException(errorMsg, we);
        }
    }

    @Override
    public void reopenClosedPO(VendorCreditMemoDocument cmDocument) {
        PurchaseOrderDocument purchaseOrderDocument;
        Integer purchaseOrderDocumentId = cmDocument.getPurchaseOrderIdentifier();
        if (cmDocument.isSourceDocumentPaymentRequest() && ObjectUtils.isNull((Object)purchaseOrderDocumentId)) {
            PaymentRequestDocument paymentRequestDocument = this.paymentRequestService.getPaymentRequestById(cmDocument.getPaymentRequestIdentifier());
            purchaseOrderDocumentId = paymentRequestDocument.getPurchaseOrderIdentifier();
        }
        if (!ObjectUtils.isNotNull((Object)purchaseOrderDocumentId) || !ObjectUtils.isNotNull((Object)(purchaseOrderDocument = this.purchaseOrderService.getCurrentPurchaseOrder(purchaseOrderDocumentId))) || purchaseOrderDocument.isPendingActionIndicator() || "Closed".equals(purchaseOrderDocument.getApplicationDocumentStatus())) {
            // empty if block
        }
    }

    @Override
    public VendorCreditMemoDocument addHoldOnCreditMemo(VendorCreditMemoDocument cmDocument, String note) throws Exception {
        Note noteObj = this.documentService.createNoteFromDocument((Document)cmDocument, note);
        cmDocument.addNote(noteObj);
        this.noteService.save(noteObj);
        VendorCreditMemoDocument cmDoc = this.getCreditMemoDocumentById(cmDocument.getPurapDocumentIdentifier());
        cmDoc.setHoldIndicator(true);
        cmDoc.setLastActionPerformedByPersonId(GlobalVariables.getUserSession().getPerson().getPrincipalId());
        this.purapService.saveDocumentNoValidation((Document)cmDoc);
        cmDocument.setHoldIndicator(true);
        cmDocument.setLastActionPerformedByPersonId(GlobalVariables.getUserSession().getPerson().getPrincipalId());
        return cmDoc;
    }

    @Override
    public VendorCreditMemoDocument removeHoldOnCreditMemo(VendorCreditMemoDocument cmDocument, String note) throws Exception {
        Note noteObj = this.documentService.createNoteFromDocument((Document)cmDocument, note);
        cmDocument.addNote(noteObj);
        this.noteService.save(noteObj);
        VendorCreditMemoDocument cmDoc = this.getCreditMemoDocumentById(cmDocument.getPurapDocumentIdentifier());
        cmDoc.setHoldIndicator(false);
        cmDoc.setLastActionPerformedByPersonId(null);
        this.purapService.saveDocumentNoValidation((Document)cmDoc);
        cmDocument.setHoldIndicator(false);
        cmDocument.setLastActionPerformedByPersonId(null);
        return cmDoc;
    }

    @Override
    public String updateStatusByNode(String currentNodeName, AccountsPayableDocument apDoc) {
        return this.updateStatusByNode(currentNodeName, (VendorCreditMemoDocument)apDoc);
    }

    protected String updateStatusByNode(String currentNodeName, VendorCreditMemoDocument cmDoc) {
        String cancelledStatusCode = "";
        cancelledStatusCode = StringUtils.isEmpty((CharSequence)currentNodeName) ? "Cancelled" : PurapConstants.CreditMemoStatuses.getCreditMemoAppDocDisapproveStatuses().get(currentNodeName);
        if (StringUtils.isNotBlank((CharSequence)cancelledStatusCode)) {
            try {
                cmDoc.updateAndSaveAppDocStatus(cancelledStatusCode);
            }
            catch (WorkflowException we) {
                throw new RuntimeException("Unable to save the workflow document with document id: " + cmDoc.getDocumentNumber());
            }
            this.purapService.saveDocumentNoValidation((Document)cmDoc);
            return cancelledStatusCode;
        }
        this.logAndThrowRuntimeException("No status found to set for document being disapproved in node '" + currentNodeName + "'");
        return cancelledStatusCode;
    }

    @Override
    public void cancelExtractedCreditMemo(VendorCreditMemoDocument cmDocument, String note) {
        LOG.debug("cancelExtractedCreditMemo() started");
        if (PurapConstants.CreditMemoStatuses.CANCELLED_STATUSES.contains(cmDocument.getApplicationDocumentStatus())) {
            LOG.debug("cancelExtractedCreditMemo() ended");
            return;
        }
        try {
            Note noteObj = this.documentService.createNoteFromDocument((Document)cmDocument, note);
            cmDocument.addNote(noteObj);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        this.accountsPayableService.cancelAccountsPayableDocument(cmDocument, "");
        if (LOG.isDebugEnabled()) {
            LOG.debug("cancelExtractedCreditMemo() CM " + cmDocument.getPurapDocumentIdentifier() + " Cancelled Without Workflow");
        }
        LOG.debug("cancelExtractedCreditMemo() ended");
    }

    @Override
    public void resetExtractedCreditMemo(VendorCreditMemoDocument cmDocument, String note) {
        LOG.debug("resetExtractedCreditMemo() started");
        if (PurapConstants.CreditMemoStatuses.CANCELLED_STATUSES.contains(cmDocument.getApplicationDocumentStatus())) {
            LOG.debug("resetExtractedCreditMemo() ended");
            return;
        }
        cmDocument.setExtractedTimestamp(null);
        cmDocument.setCreditMemoPaidTimestamp(null);
        try {
            Note noteObj = this.documentService.createNoteFromDocument((Document)cmDocument, note);
            cmDocument.addNote(noteObj);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        this.purapService.saveDocumentNoValidation((Document)cmDocument);
        if (LOG.isDebugEnabled()) {
            LOG.debug("resetExtractedCreditMemo() CM " + cmDocument.getPurapDocumentIdentifier() + " Cancelled Without Workflow");
        }
        LOG.debug("resetExtractedCreditMemo() ended");
    }

    @Override
    public boolean shouldPurchaseOrderBeReversed(AccountsPayableDocument apDoc) {
        return false;
    }

    @Override
    public Person getPersonForCancel(AccountsPayableDocument apDoc) {
        return null;
    }

    @Override
    public void takePurchaseOrderCancelAction(AccountsPayableDocument apDoc) {
        VendorCreditMemoDocument cmDocument = (VendorCreditMemoDocument)apDoc;
        if (cmDocument.isReopenPurchaseOrderIndicator()) {
            String docType = "POC";
            this.purchaseOrderService.createAndRoutePotentialChangeDocument(cmDocument.getPurchaseOrderDocument().getDocumentNumber(), docType, "reopened by Payment Request " + apDoc.getPurapDocumentIdentifier() + "cancel", new ArrayList(), "Pending Close");
        }
    }

    @Override
    public void markPaid(VendorCreditMemoDocument cm, Date processDate) {
        LOG.debug("markPaid() started");
        cm.setCreditMemoPaidTimestamp(new Timestamp(processDate.getTime()));
        this.purapService.saveDocumentNoValidation((Document)cm);
    }

    @Override
    public boolean poItemEligibleForAp(AccountsPayableDocument apDoc, PurchaseOrderItem poItem) {
        BigDecimal unitPrice;
        poItem.refreshReferenceObject("itemType");
        if (!poItem.isItemActiveIndicator()) {
            return false;
        }
        if (poItem.getItemType().isQuantityBasedGeneralLedgerIndicator() && poItem.getItemInvoicedTotalQuantity().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            return true;
        }
        BigDecimal bigDecimal = unitPrice = poItem.getItemUnitPrice() == null ? new BigDecimal(0) : poItem.getItemUnitPrice();
        return unitPrice.doubleValue() > poItem.getItemOutstandingEncumberedAmount().doubleValue();
    }

    @Override
    public void generateGLEntriesCreateAccountsPayableDocument(AccountsPayableDocument apDocument) {
        VendorCreditMemoDocument creditMemo = (VendorCreditMemoDocument)apDocument;
        this.purapGeneralLedgerService.generateEntriesCreateCreditMemo(creditMemo);
    }

    protected void logAndThrowRuntimeException(String errorMessage) {
        this.logAndThrowRuntimeException(errorMessage, null);
    }

    protected void logAndThrowRuntimeException(String errorMessage, Exception e) {
        if (ObjectUtils.isNotNull((Object)e)) {
            LOG.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
        LOG.error(errorMessage);
        throw new RuntimeException(errorMessage);
    }

    @Override
    public boolean hasActiveCreditMemosForPurchaseOrder(Integer purchaseOrderIdentifier) {
        boolean hasActiveCreditMemos = false;
        WorkflowDocument workflowDocument = null;
        List<String> docNumbers = this.creditMemoDao.getActiveCreditMemoDocumentNumbersForPurchaseOrder(purchaseOrderIdentifier);
        ArrayList docHeaders = new ArrayList();
        for (String appDocStatus : PurapConstants.CreditMemoStatuses.STATUSES_POTENTIALLY_ACTIVE) {
            docHeaders.addAll(this.financialSystemDocumentService.findByApplicationDocumentStatus(appDocStatus));
        }
        for (FinancialSystemDocumentHeader docHeader : docHeaders) {
            if (!docNumbers.contains(docHeader.getDocumentNumber())) continue;
            try {
                workflowDocument = this.workflowDocumentService.loadWorkflowDocument(docHeader.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
            }
            catch (WorkflowException we) {
                throw new RuntimeException(we);
            }
            if (workflowDocument.isCanceled() || workflowDocument.isException() || workflowDocument.isFinal()) continue;
            hasActiveCreditMemos = true;
            break;
        }
        return hasActiveCreditMemos;
    }

    @Override
    public void populateDocumentAfterInit(VendorCreditMemoDocument cmDocument) {
        HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList = this.accountsPayableService.getExpiredOrClosedAccountList(cmDocument);
        if (cmDocument.isSourceDocumentPaymentRequest()) {
            this.populateDocumentFromPreq(cmDocument, expiredOrClosedAccountList);
        } else if (cmDocument.isSourceDocumentPurchaseOrder()) {
            this.populateDocumentFromPO(cmDocument, expiredOrClosedAccountList);
        } else {
            this.populateDocumentFromVendor(cmDocument);
        }
        this.populateDocumentDescription(cmDocument);
        this.accountsPayableService.generateExpiredOrClosedAccountNote(cmDocument, expiredOrClosedAccountList);
        if (ObjectUtils.isNotNull(expiredOrClosedAccountList) && !expiredOrClosedAccountList.isEmpty()) {
            cmDocument.setContinuationAccountIndicator(true);
        }
    }

    protected void populateDocumentFromPreq(VendorCreditMemoDocument cmDocument, HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList) {
        PaymentRequestDocument paymentRequestDocument = this.paymentRequestService.getPaymentRequestById(cmDocument.getPaymentRequestIdentifier());
        cmDocument.getDocumentHeader().setOrganizationDocumentNumber(paymentRequestDocument.getDocumentHeader().getOrganizationDocumentNumber());
        cmDocument.setPaymentRequestDocument(paymentRequestDocument);
        cmDocument.setPurchaseOrderDocument(paymentRequestDocument.getPurchaseOrderDocument());
        cmDocument.setUseTaxIndicator(paymentRequestDocument.isUseTaxIndicator());
        cmDocument.setVendorHeaderGeneratedIdentifier(paymentRequestDocument.getVendorHeaderGeneratedIdentifier());
        cmDocument.setVendorDetailAssignedIdentifier(paymentRequestDocument.getVendorDetailAssignedIdentifier());
        cmDocument.setVendorAddressGeneratedIdentifier(paymentRequestDocument.getVendorAddressGeneratedIdentifier());
        cmDocument.setVendorCustomerNumber(paymentRequestDocument.getVendorCustomerNumber());
        cmDocument.setVendorName(paymentRequestDocument.getVendorName());
        cmDocument.setVendorLine1Address(paymentRequestDocument.getVendorLine1Address());
        cmDocument.setVendorLine2Address(paymentRequestDocument.getVendorLine2Address());
        cmDocument.setVendorCityName(paymentRequestDocument.getVendorCityName());
        cmDocument.setVendorStateCode(paymentRequestDocument.getVendorStateCode());
        cmDocument.setVendorPostalCode(paymentRequestDocument.getVendorPostalCode());
        cmDocument.setVendorCountryCode(paymentRequestDocument.getVendorCountryCode());
        cmDocument.setVendorAttentionName(paymentRequestDocument.getVendorAttentionName());
        cmDocument.setAccountsPayablePurchasingDocumentLinkIdentifier(paymentRequestDocument.getAccountsPayablePurchasingDocumentLinkIdentifier());
        this.purapAccountingService.convertMoneyToPercent(paymentRequestDocument);
        this.populateItemLinesFromPreq(cmDocument, expiredOrClosedAccountList);
    }

    protected void populateItemLinesFromPreq(VendorCreditMemoDocument cmDocument, HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList) {
        PaymentRequestDocument preqDocument = cmDocument.getPaymentRequestDocument();
        for (PaymentRequestItem preqItemToTemplate : preqDocument.getItems()) {
            preqItemToTemplate.refreshReferenceObject("itemType");
            if (!preqItemToTemplate.getItemType().isLineItemIndicator() || (!preqItemToTemplate.getItemType().isQuantityBasedGeneralLedgerIndicator() || !preqItemToTemplate.getItemQuantity().isNonZero()) && (!preqItemToTemplate.getItemType().isAmountBasedGeneralLedgerIndicator() || !preqItemToTemplate.getTotalAmount().isNonZero())) continue;
            cmDocument.getItems().add(new CreditMemoItem(cmDocument, preqItemToTemplate, preqItemToTemplate.getPurchaseOrderItem(), expiredOrClosedAccountList));
        }
        this.purapService.addBelowLineItems(cmDocument);
        cmDocument.fixItemReferences();
    }

    protected void populateDocumentFromPO(VendorCreditMemoDocument cmDocument, HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList) {
        PurchaseOrderDocument purchaseOrderDocument = this.purchaseOrderService.getCurrentPurchaseOrder(cmDocument.getPurchaseOrderIdentifier());
        cmDocument.setPurchaseOrderDocument(purchaseOrderDocument);
        cmDocument.getDocumentHeader().setOrganizationDocumentNumber(purchaseOrderDocument.getDocumentHeader().getOrganizationDocumentNumber());
        cmDocument.setUseTaxIndicator(cmDocument.isUseTaxIndicator());
        cmDocument.setVendorHeaderGeneratedIdentifier(purchaseOrderDocument.getVendorHeaderGeneratedIdentifier());
        cmDocument.setVendorDetailAssignedIdentifier(purchaseOrderDocument.getVendorDetailAssignedIdentifier());
        cmDocument.setVendorCustomerNumber(purchaseOrderDocument.getVendorCustomerNumber());
        cmDocument.setVendorName(purchaseOrderDocument.getVendorName());
        cmDocument.setAccountsPayablePurchasingDocumentLinkIdentifier(purchaseOrderDocument.getAccountsPayablePurchasingDocumentLinkIdentifier());
        String userCampus = GlobalVariables.getUserSession().getPerson().getCampusCode();
        VendorAddress vendorAddress = this.vendorService.getVendorDefaultAddress(purchaseOrderDocument.getVendorHeaderGeneratedIdentifier(), purchaseOrderDocument.getVendorDetailAssignedIdentifier(), "RM", userCampus, false);
        if (vendorAddress != null) {
            cmDocument.templateVendorAddress(vendorAddress);
            cmDocument.setVendorAddressGeneratedIdentifier(vendorAddress.getVendorAddressGeneratedIdentifier());
            cmDocument.setVendorAttentionName(StringUtils.defaultString((String)vendorAddress.getVendorAttentionName()));
        } else {
            cmDocument.setVendorAddressGeneratedIdentifier(purchaseOrderDocument.getVendorAddressGeneratedIdentifier());
            cmDocument.setVendorLine1Address(purchaseOrderDocument.getVendorLine1Address());
            cmDocument.setVendorLine2Address(purchaseOrderDocument.getVendorLine2Address());
            cmDocument.setVendorCityName(purchaseOrderDocument.getVendorCityName());
            cmDocument.setVendorStateCode(purchaseOrderDocument.getVendorStateCode());
            cmDocument.setVendorPostalCode(purchaseOrderDocument.getVendorPostalCode());
            cmDocument.setVendorCountryCode(purchaseOrderDocument.getVendorCountryCode());
            boolean blankAttentionLine = StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString("KFS-PURAP", "Document", "BLANK_ATTENTION_LINE_FOR_PO_TYPE_ADDRESS"));
            if (blankAttentionLine) {
                cmDocument.setVendorAttentionName("");
            } else {
                cmDocument.setVendorAttentionName(StringUtils.defaultString((String)purchaseOrderDocument.getVendorAttentionName()));
            }
        }
        this.populateItemLinesFromPO(cmDocument, expiredOrClosedAccountList);
    }

    protected void populateItemLinesFromPO(VendorCreditMemoDocument cmDocument, HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList) {
        List<PurchaseOrderItem> invoicedItems = this.getPOInvoicedItems(cmDocument.getPurchaseOrderDocument());
        for (PurchaseOrderItem poItem : invoicedItems) {
            poItem.refreshReferenceObject("itemType");
            if ((!poItem.getItemType().isQuantityBasedGeneralLedgerIndicator() || !poItem.getItemInvoicedTotalQuantity().isNonZero()) && (!poItem.getItemType().isAmountBasedGeneralLedgerIndicator() || !poItem.getItemInvoicedTotalAmount().isNonZero())) continue;
            CreditMemoItem creditMemoItem = new CreditMemoItem(cmDocument, poItem, expiredOrClosedAccountList);
            cmDocument.getItems().add(creditMemoItem);
            PurchasingCapitalAssetItem purchasingCAMSItem = cmDocument.getPurchaseOrderDocument().getPurchasingCapitalAssetItemByItemIdentifier(poItem.getItemIdentifier());
            if (purchasingCAMSItem == null) continue;
            creditMemoItem.setCapitalAssetTransactionTypeCode(purchasingCAMSItem.getCapitalAssetTransactionTypeCode());
        }
        this.purapService.addBelowLineItems(cmDocument);
        cmDocument.fixItemReferences();
    }

    protected void populateDocumentFromVendor(VendorCreditMemoDocument cmDocument) {
        Integer vendorHeaderId = VendorUtils.getVendorHeaderId((String)cmDocument.getVendorNumber());
        Integer vendorDetailId = VendorUtils.getVendorDetailId((String)cmDocument.getVendorNumber());
        VendorDetail vendorDetail = this.vendorService.getVendorDetail(vendorHeaderId, vendorDetailId);
        cmDocument.setVendorDetail(vendorDetail);
        cmDocument.setVendorHeaderGeneratedIdentifier(vendorDetail.getVendorHeaderGeneratedIdentifier());
        cmDocument.setVendorDetailAssignedIdentifier(vendorDetail.getVendorDetailAssignedIdentifier());
        cmDocument.setVendorCustomerNumber(vendorDetail.getVendorNumber());
        cmDocument.setVendorName(vendorDetail.getVendorName());
        String userCampus = GlobalVariables.getUserSession().getPerson().getCampusCode();
        VendorAddress vendorAddress = this.vendorService.getVendorDefaultAddress(vendorHeaderId, vendorDetailId, "RM", userCampus, false);
        if (vendorAddress == null) {
            vendorAddress = this.vendorService.getVendorDefaultAddress(vendorHeaderId, vendorDetailId, "PO", userCampus, false);
        }
        cmDocument.setVendorAddressGeneratedIdentifier(vendorAddress.getVendorAddressGeneratedIdentifier());
        cmDocument.templateVendorAddress(vendorAddress);
        this.purapService.addBelowLineItems(cmDocument);
    }

    protected void populateDocumentDescription(VendorCreditMemoDocument cmDocument) {
        String description = "";
        description = cmDocument.isSourceVendor() ? "Vendor: " + cmDocument.getVendorName() : "PO: " + cmDocument.getPurchaseOrderDocument().getPurapDocumentIdentifier() + " Vendor: " + cmDocument.getVendorName();
        int noteTextMaxLength = this.dataDictionaryService.getAttributeMaxLength(DocumentHeader.class, "documentDescription");
        if (noteTextMaxLength < description.length()) {
            description = description.substring(0, noteTextMaxLength);
        }
        cmDocument.getDocumentHeader().setDocumentDescription(description);
    }
}

