/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.document.service.DisbursementVoucherValidationService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.InfrastructureException;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.AutoApproveExclude;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.NegativePaymentRequestApprovalLimit;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccount;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.dataaccess.PaymentRequestDao;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.NegativePaymentRequestApprovalLimitService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurApWorkflowIntegrationService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedContinuePurapEvent;
import org.kuali.kfs.module.purap.document.validation.event.PurchasingAccountsPayableItemPreCalculateEvent;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.PurapGeneralLedgerService;
import org.kuali.kfs.module.purap.util.ExpiredOrClosedAccountEntry;
import org.kuali.kfs.module.purap.util.PurApItemUtils;
import org.kuali.kfs.module.purap.util.VendorGroupingHelper;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.PaymentTermType;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.transaction.annotation.Transactional;

public class PaymentRequestServiceImpl
implements PaymentRequestService {
    private static final Logger LOG = LogManager.getLogger(PaymentRequestServiceImpl.class);
    protected AccountsPayableService accountsPayableService;
    protected BankService bankService;
    protected BusinessObjectService businessObjectService;
    protected ConfigurationService configurationService;
    protected DataDictionaryService dataDictionaryService;
    protected DateTimeService dateTimeService;
    protected DisbursementVoucherValidationService disbursementVoucherValidationService;
    protected DocumentService documentService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected KualiRuleService kualiRuleService;
    protected NegativePaymentRequestApprovalLimitService negativePaymentRequestApprovalLimitService;
    protected NoteService noteService;
    protected ParameterService parameterService;
    protected PaymentRequestDao paymentRequestDao;
    protected PurapAccountingService purapAccountingService;
    protected PurapService purapService;
    protected PurApWorkflowIntegrationService purapWorkflowIntegrationService;
    protected PurchaseOrderService purchaseOrderService;
    protected UniversityDateService universityDateService;
    protected VendorService vendorService;

    @Override
    @Deprecated
    @NonTransactional
    public Collection<PaymentRequestDocument> getPaymentRequestsToExtractByCM(String campusCode, VendorCreditMemoDocument cmd) {
        LOG.debug("getPaymentRequestsByCM() started");
        java.sql.Date currentSqlDateMidnight = this.dateTimeService.getCurrentSqlDateMidnight();
        List<PaymentRequestDocument> paymentRequestIterator = this.paymentRequestDao.getPaymentRequestsToExtract(campusCode, null, null, cmd.getVendorHeaderGeneratedIdentifier(), cmd.getVendorDetailAssignedIdentifier(), currentSqlDateMidnight);
        return this.filterPaymentRequestByAppDocStatus(paymentRequestIterator, "Auto-Approved", "Department-Approved");
    }

    @Override
    @NonTransactional
    public Collection<PaymentRequestDocument> getPaymentRequestsToExtractByVendor(String campusCode, VendorGroupingHelper vendor, java.sql.Date onOrBeforePaymentRequestPayDate) {
        LOG.debug("getPaymentRequestsByVendor() started");
        Collection<PaymentRequestDocument> paymentRequestDocuments = this.paymentRequestDao.getPaymentRequestsToExtractForVendor(campusCode, vendor, onOrBeforePaymentRequestPayDate);
        return this.filterPaymentRequestByAppDocStatus(paymentRequestDocuments, "Auto-Approved", "Department-Approved");
    }

    @Override
    @NonTransactional
    public Collection<PaymentRequestDocument> getPaymentRequestsToExtract(java.sql.Date onOrBeforePaymentRequestPayDate) {
        LOG.debug("getPaymentRequestsToExtract() started");
        List<PaymentRequestDocument> paymentRequestIterator = this.paymentRequestDao.getPaymentRequestsToExtract(false, null, onOrBeforePaymentRequestPayDate);
        return this.filterPaymentRequestByAppDocStatus(paymentRequestIterator, PurapConstants.PaymentRequestStatuses.STATUSES_ALLOWED_FOR_EXTRACTION);
    }

    @Override
    @NonTransactional
    public Collection<PaymentRequestDocument> getPaymentRequestsToExtractSpecialPayments(String chartCode, java.sql.Date onOrBeforePaymentRequestPayDate) {
        LOG.debug("getPaymentRequestsToExtractSpecialPayments() started");
        List<PaymentRequestDocument> paymentRequestIterator = this.paymentRequestDao.getPaymentRequestsToExtract(true, chartCode, onOrBeforePaymentRequestPayDate);
        return this.filterPaymentRequestByAppDocStatus(paymentRequestIterator, PurapConstants.PaymentRequestStatuses.STATUSES_ALLOWED_FOR_EXTRACTION);
    }

    @Override
    @NonTransactional
    public Collection<PaymentRequestDocument> getImmediatePaymentRequestsToExtract(String chartCode) {
        LOG.debug("getImmediatePaymentRequestsToExtract() started");
        List<PaymentRequestDocument> paymentRequestIterator = this.paymentRequestDao.getImmediatePaymentRequestsToExtract(chartCode);
        return this.filterPaymentRequestByAppDocStatus(paymentRequestIterator, PurapConstants.PaymentRequestStatuses.STATUSES_ALLOWED_FOR_EXTRACTION);
    }

    @Override
    @NonTransactional
    public Collection<PaymentRequestDocument> getPaymentRequestToExtractByChart(String chartCode, java.sql.Date onOrBeforePaymentRequestPayDate) {
        LOG.debug("getPaymentRequestToExtractByChart() started");
        List<PaymentRequestDocument> paymentRequestIterator = this.paymentRequestDao.getPaymentRequestsToExtract(false, chartCode, onOrBeforePaymentRequestPayDate);
        return this.filterPaymentRequestByAppDocStatus(paymentRequestIterator, PurapConstants.PaymentRequestStatuses.STATUSES_ALLOWED_FOR_EXTRACTION);
    }

    @Override
    @NonTransactional
    public boolean autoApprovePaymentRequests() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Starting autoApprovePaymentRequests.");
        }
        boolean hadErrorAtLeastOneError = true;
        java.sql.Date todayAtMidnight = this.dateTimeService.getCurrentSqlDateMidnight();
        List<String> docNumbers = this.paymentRequestDao.getEligibleForAutoApproval(todayAtMidnight);
        if (LOG.isInfoEnabled()) {
            LOG.info(" -- Initial filtering complete, returned " + new Integer(docNumbers.size()).toString() + " docs.");
        }
        String samt = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "DEFAULT_POS_APRVL_LMT");
        KualiDecimal defaultMinimumLimit = new KualiDecimal(samt);
        if (LOG.isInfoEnabled()) {
            LOG.info(" -- Using default limit value of " + defaultMinimumLimit.toString() + ".");
        }
        for (String docNumber : docNumbers) {
            PaymentRequestDocument paymentRequestDocument = this.getPaymentRequestByDocumentNumber(docNumber);
            if (!ObjectUtils.isNotNull((Object)paymentRequestDocument)) continue;
            hadErrorAtLeastOneError |= !this.autoApprovePaymentRequest(paymentRequestDocument, defaultMinimumLimit);
        }
        return hadErrorAtLeastOneError;
    }

    @Override
    @NonTransactional
    public boolean autoApprovePaymentRequest(String docNumber, KualiDecimal defaultMinimumLimit) {
        try {
            PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)this.documentService.getByDocumentHeaderId(docNumber);
            if (paymentRequestDocument.isHoldIndicator() || paymentRequestDocument.isPaymentRequestedCancelIndicator() || !Arrays.asList(PurapConstants.PaymentRequestStatuses.PREQ_STATUSES_FOR_AUTO_APPROVE).contains(paymentRequestDocument.getApplicationDocumentStatus())) {
                LOG.warn("Payment Request Document " + paymentRequestDocument.getDocumentNumber() + " could not be auto-approved because it has either been placed on hold,  requested cancel, or does not have one of the PREQ statuses for auto-approve.");
                return true;
            }
            if (this.autoApprovePaymentRequest(paymentRequestDocument, defaultMinimumLimit)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Auto-approval for payment request successful.  Doc number: " + docNumber);
                }
                return true;
            }
            LOG.error("Payment Request Document " + docNumber + " could not be auto-approved.");
            return false;
        }
        catch (WorkflowException we) {
            LOG.error("Exception encountered when retrieving document number " + docNumber + ".", (Throwable)we);
            throw new RuntimeException("Exception encountered when retrieving document number " + docNumber + ".", we);
        }
    }

    @Override
    @Transactional
    public boolean autoApprovePaymentRequest(PaymentRequestDocument doc, KualiDecimal defaultMinimumLimit) {
        if (this.isEligibleForAutoApproval(doc, defaultMinimumLimit)) {
            try {
                try {
                    ObjectUtils.materializeUpdateableCollections((Object)doc);
                    for (PaymentRequestItem item : doc.getItems()) {
                        ObjectUtils.materializeUpdateableCollections((Object)item);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                doc = (PaymentRequestDocument)((Object)ObjectUtils.deepCopy((Serializable)((Object)doc)));
                doc.setAutoApprovedIndicator(true);
                LOG.info("About to blanketApproveDocument, doc.getDocumentNumber()=" + doc.getDocumentNumber());
                this.documentService.superUserApproveDocument((Document)doc, "auto-approving: Total is below threshold.");
            }
            catch (WorkflowException we) {
                LOG.error("Exception encountered when approving document number " + doc.getDocumentNumber() + ".", (Throwable)we);
                throw new RuntimeException("Exception encountered when approving document number " + doc.getDocumentNumber() + ".", we);
            }
        }
        return true;
    }

    protected boolean isEligibleForAutoApproval(PaymentRequestDocument document, KualiDecimal defaultMinimumLimit) {
        if (document.getVendorDetail().getVendorHeader().getVendorForeignIndicator().booleanValue()) {
            if (LOG.isInfoEnabled()) {
                LOG.info(" -- PayReq [" + document.getDocumentNumber() + "] skipped due to a Foreign Vendor.");
            }
            return false;
        }
        if (this.purapWorkflowIntegrationService.willDocumentStopAtGivenFutureRouteNode(document, "Tax")) {
            if (LOG.isInfoEnabled()) {
                LOG.info(" -- PayReq [" + document.getDocumentNumber() + "] skipped due to requiring Tax Review.");
            }
            return false;
        }
        if (document.isPaymentRequestPositiveApprovalIndicator()) {
            if (LOG.isInfoEnabled()) {
                LOG.info(" -- PayReq [" + document.getDocumentNumber() + "] skipped due to a Positive Approval Required Indicator set to Yes.");
            }
            return false;
        }
        KualiDecimal minimumAmount = null;
        List<SourceAccountingLine> summaryLines = this.purapAccountingService.generateSummary(document.getItems());
        for (SourceAccountingLine line : summaryLines) {
            HashMap<String, Object> autoApproveMap = new HashMap<String, Object>();
            autoApproveMap.put("chartOfAccountsCode", line.getChartOfAccountsCode());
            autoApproveMap.put("accountNumber", line.getAccountNumber());
            autoApproveMap.put("active", true);
            AutoApproveExclude autoApproveExclude = (AutoApproveExclude)this.businessObjectService.findByPrimaryKey(AutoApproveExclude.class, autoApproveMap);
            if (autoApproveExclude != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(" -- PayReq [" + document.getDocumentNumber() + "] skipped due to source accounting line " + line.getSequenceNumber() + " using Chart/Account [" + line.getChartOfAccountsCode() + "-" + line.getAccountNumber() + "], which is excluded in the Auto Approve Exclusions table.");
                }
                return false;
            }
            minimumAmount = this.getMinimumLimitAmount(this.negativePaymentRequestApprovalLimitService.findByChart(line.getChartOfAccountsCode()), minimumAmount);
            minimumAmount = this.getMinimumLimitAmount(this.negativePaymentRequestApprovalLimitService.findByChartAndAccount(line.getChartOfAccountsCode(), line.getAccountNumber()), minimumAmount);
            minimumAmount = this.getMinimumLimitAmount(this.negativePaymentRequestApprovalLimitService.findByChartAndOrganization(line.getChartOfAccountsCode(), line.getOrganizationReferenceId()), minimumAmount);
        }
        if (document.isReceivingDocumentRequiredIndicator()) {
            if (LOG.isInfoEnabled()) {
                LOG.info(" -- PayReq [" + document.getDocumentNumber() + "] auto-approved (ignored dollar limit) due to Receiving Document Required Indicator set to Yes.");
            }
            return true;
        }
        if (ObjectUtils.isNull(minimumAmount) || defaultMinimumLimit.compareTo((AbstractKualiDecimal)minimumAmount) < 0) {
            minimumAmount = defaultMinimumLimit;
        }
        if (document.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount().isLessThan((AbstractKualiDecimal)minimumAmount)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(" -- PayReq [" + document.getDocumentNumber() + "] auto-approved due to document Total [" + document.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount() + "] being less than " + (minimumAmount == defaultMinimumLimit ? "Default Auto-Approval Limit " : "Configured Auto-Approval Limit ") + "of " + (minimumAmount == null ? "null" : minimumAmount.toString()) + ".");
            }
            return true;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(" -- PayReq [" + document.getDocumentNumber() + "] skipped due to document Total [" + document.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount() + "] being greater than " + (minimumAmount == defaultMinimumLimit ? "Default Auto-Approval Limit " : "Configured Auto-Approval Limit ") + "of " + (minimumAmount == null ? "null" : minimumAmount.toString()) + ".");
        }
        return false;
    }

    protected KualiDecimal getMinimumLimitAmount(Collection<NegativePaymentRequestApprovalLimit> limits, KualiDecimal minimumAmount) {
        for (NegativePaymentRequestApprovalLimit limit : limits) {
            KualiDecimal amount = limit.getNegativePaymentRequestApprovalLimitAmount();
            if (null == minimumAmount) {
                minimumAmount = amount;
                continue;
            }
            if (!minimumAmount.isGreaterThan((AbstractKualiDecimal)amount)) continue;
            minimumAmount = amount;
        }
        return minimumAmount;
    }

    @Override
    @NonTransactional
    public List<PaymentRequestDocument> getPaymentRequestsByVendorNumber(Integer vendorHeaderGeneratedId, Integer vendorDetailAssignedId) {
        LOG.debug("getActivePaymentRequestsByVendorNumber() started");
        return this.paymentRequestDao.getActivePaymentRequestsByVendorNumber(vendorHeaderGeneratedId, vendorDetailAssignedId);
    }

    @Override
    @NonTransactional
    public List getPaymentRequestsByVendorNumberInvoiceNumber(Integer vendorHeaderGeneratedId, Integer vendorDetailAssignedId, String invoiceNumber) {
        LOG.debug("getActivePaymentRequestsByVendorNumberInvoiceNumber() started");
        return this.paymentRequestDao.getActivePaymentRequestsByVendorNumberInvoiceNumber(vendorHeaderGeneratedId, vendorDetailAssignedId, invoiceNumber);
    }

    @Override
    @NonTransactional
    public HashMap<String, String> checkForDuplicatePayments(PaymentRequestDocument document) {
        HashMap<String, String> msgs = new HashMap<String, String>();
        boolean checkForDuplicateDisbursementVouchers = this.parameterService.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_DISBURSEMENT_VOUCHER_IND");
        boolean checkForDuplicatePaymentRequests = this.parameterService.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_PAYMENT_REQUEST_IND");
        PurchaseOrderDocument po = document.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        if (checkForDuplicateDisbursementVouchers) {
            msgs.putAll(this.disbursementVoucherValidationService.checkForDuplicateDisbursementVouchers(document.getInvoiceNumber(), disbVchrPayeeIdNumber, document.getInvoiceDate(), document.getVendorInvoiceAmount(), true));
        }
        if (checkForDuplicatePaymentRequests) {
            msgs.putAll(this.checkForDuplicatePaymentRequests(document));
        }
        return msgs;
    }

    private HashMap<String, String> checkForDuplicatePaymentRequests(PaymentRequestDocument document) {
        PurchaseOrderDocument po;
        HashMap<String, String> msgs = new HashMap<String, String>();
        if (ObjectUtils.isNotNull((Object)document.getInvoiceDate()) && this.purapService.isDateAYearBeforeToday(document.getInvoiceDate())) {
            msgs.put("PREQDuplicateInvoice", this.configurationService.getPropertyValueAsString("message.invoice.date.a.year.or.more.past"));
        }
        if ((po = document.getPurchaseOrderDocument()) != null) {
            msgs.putAll(this.checkForDuplicatesByVendorNumberAndInvoiceNumber(po.getVendorHeaderGeneratedIdentifier(), po.getVendorDetailAssignedIdentifier(), document.getInvoiceNumber(), "vendor ID", true));
            msgs.putAll(this.checkForDuplicatesByPoIdInvoiceNumberAndInvoiceDate(document.getPurchaseOrderIdentifier(), document.getVendorInvoiceAmount(), document.getInvoiceDate()));
        }
        return msgs;
    }

    @Override
    @NonTransactional
    public HashMap<String, String> checkForDuplicatePaymentRequests(Integer vendorHeaderGeneratedId, Integer vendorDetailAssignedId, String invoiceNumber, KualiDecimal invoiceAmount, java.sql.Date invoiceDate, String vendorToken, String specifiedSourceToken, boolean questionFormat) {
        HashMap<String, String> messages = new HashMap<String, String>();
        if (ObjectUtils.isNotNull((Object)invoiceDate) && this.purapService.isDateAYearBeforeToday(invoiceDate)) {
            messages.put("PREQDuplicateInvoice", this.configurationService.getPropertyValueAsString("message.invoice.date.a.year.or.more.past"));
        }
        messages.putAll(this.checkForDuplicatesByVendorNumberAndInvoiceNumber(vendorHeaderGeneratedId, vendorDetailAssignedId, invoiceNumber, vendorToken, questionFormat));
        messages.putAll(this.checkForDuplicatesByInvoiceNumberAndInvoiceDate(vendorHeaderGeneratedId, vendorDetailAssignedId, invoiceAmount, invoiceDate, specifiedSourceToken, questionFormat));
        return messages;
    }

    private Map<String, String> checkForDuplicatesByVendorNumberAndInvoiceNumber(Integer vendorHeaderGeneratedId, Integer vendorDetailAssignedId, String invoiceNumber, String vendorToken, boolean questionFormat) {
        String invoiceNumberForComparison = this.buildInvoiceNumberForComparison(invoiceNumber);
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        List<PaymentRequestDocument> possibleDuplicatePaymentRequests = this.getPaymentRequestsByVendorNumber(vendorHeaderGeneratedId, vendorDetailAssignedId);
        for (PaymentRequestDocument possibleDuplicatePaymentRequest : possibleDuplicatePaymentRequests) {
            if (!this.buildInvoiceNumberForComparison(possibleDuplicatePaymentRequest.getInvoiceNumber()).equals(invoiceNumberForComparison)) continue;
            duplicatePaymentRequests.add(possibleDuplicatePaymentRequest);
        }
        return this.buildWarningMessagesForDuplicatesByInvoiceNumberAndAmount(duplicatePaymentRequests, vendorToken, DuplicatePaymentRequestMessages.DUPLICATE_INVOICE_VENDOR_INVOICE_NUMBER, questionFormat);
    }

    private String buildInvoiceNumberForComparison(String invoiceNumber) {
        return invoiceNumber.replaceAll("[^\\w\\s]", "").toUpperCase();
    }

    private Map<String, String> checkForDuplicatesByPoIdInvoiceNumberAndInvoiceDate(Integer purchaseOrderId, KualiDecimal invoiceAmount, java.sql.Date invoiceDate) {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.getPaymentRequestsByPOIdInvoiceAmountInvoiceDate(purchaseOrderId, invoiceAmount, invoiceDate);
        return this.buildWarningMessagesForDuplicatesByInvoiceNumberAndAmount(duplicatePaymentRequests, "on the specified PO", DuplicatePaymentRequestMessages.DUPLICATE_INVOICE_DATE_AMOUNT, true);
    }

    private Map<String, String> checkForDuplicatesByInvoiceNumberAndInvoiceDate(Integer vendorHeaderGeneratedId, Integer vendorDetailAssignedId, KualiDecimal invoiceAmount, java.sql.Date invoiceDate, String specifiedSourceToken, boolean questionFormat) {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.getPaymentRequestsByInvoiceAmountInvoiceDate(vendorHeaderGeneratedId, vendorDetailAssignedId, invoiceAmount, invoiceDate);
        return this.buildWarningMessagesForDuplicatesByInvoiceNumberAndAmount(duplicatePaymentRequests, specifiedSourceToken, DuplicatePaymentRequestMessages.DUPLICATE_INVOICE_DATE_AMOUNT, questionFormat);
    }

    private Map<String, String> buildWarningMessagesForDuplicatesByInvoiceNumberAndAmount(List<PaymentRequestDocument> duplicatePaymentRequests, String specifiedSourceToken, DuplicatePaymentRequestMessages duplicatePaymentRequestMessages, boolean questionFormat) {
        HashMap<String, String> messages = new HashMap<String, String>();
        if (duplicatePaymentRequests.size() > 0) {
            String messageText = "";
            boolean foundCanceled = false;
            boolean foundVoided = false;
            for (PaymentRequestDocument duplicatePaymentRequest : duplicatePaymentRequests) {
                if (StringUtils.equalsIgnoreCase((CharSequence)duplicatePaymentRequest.getApplicationDocumentStatus(), (CharSequence)"Cancelled")) {
                    if (foundVoided) {
                        messageText = this.configurationService.getPropertyValueAsString(duplicatePaymentRequestMessages.duplicateInvoiceCanceledOrVoidedKey);
                        continue;
                    }
                    messageText = this.configurationService.getPropertyValueAsString(duplicatePaymentRequestMessages.duplicateInvoiceCancelledKey);
                    foundCanceled = true;
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)duplicatePaymentRequest.getApplicationDocumentStatus(), (CharSequence)"Cancelled In Process")) {
                    if (foundCanceled) {
                        messageText = this.configurationService.getPropertyValueAsString(duplicatePaymentRequestMessages.duplicateInvoiceCanceledOrVoidedKey);
                        continue;
                    }
                    messageText = this.configurationService.getPropertyValueAsString(duplicatePaymentRequestMessages.duplicateInvoiceVoidedKey);
                    foundVoided = true;
                    continue;
                }
                messageText = this.configurationService.getPropertyValueAsString(duplicatePaymentRequestMessages.duplicateInvoiceKey);
                break;
            }
            String formattedQuestion = questionFormat ? this.configurationService.getPropertyValueAsString("warning.duplicate.invoice.question") : "";
            String formattedMessage = MessageFormat.format(messageText, specifiedSourceToken, formattedQuestion);
            messages.put("PREQDuplicateInvoice", formattedMessage);
        }
        return messages;
    }

    @Override
    @NonTransactional
    public PaymentRequestDocument getPaymentRequestByDocumentNumber(String documentNumber) {
        LOG.debug("getPaymentRequestByDocumentNumber() started");
        if (ObjectUtils.isNotNull((Object)documentNumber)) {
            try {
                PaymentRequestDocument doc = (PaymentRequestDocument)this.documentService.getByDocumentHeaderId(documentNumber);
                return doc;
            }
            catch (WorkflowException e) {
                String errorMessage = "Error getting payment request document from document service";
                LOG.error("getPaymentRequestByDocumentNumber() " + errorMessage, (Throwable)e);
                throw new RuntimeException(errorMessage, e);
            }
        }
        return null;
    }

    @Override
    @NonTransactional
    public PaymentRequestDocument getPaymentRequestById(Integer poDocId) {
        return this.getPaymentRequestByDocumentNumber(this.paymentRequestDao.getDocumentNumberByPaymentRequestId(poDocId));
    }

    @Override
    @NonTransactional
    public List<PaymentRequestDocument> getPaymentRequestsByPurchaseOrderId(Integer poDocId) {
        ArrayList<PaymentRequestDocument> preqs = new ArrayList<PaymentRequestDocument>();
        List<String> docNumbers = this.paymentRequestDao.getDocumentNumbersByPurchaseOrderId(poDocId);
        for (String docNumber : docNumbers) {
            PaymentRequestDocument preq = this.getPaymentRequestByDocumentNumber(docNumber);
            if (!ObjectUtils.isNotNull((Object)preq)) continue;
            preqs.add(preq);
        }
        return preqs;
    }

    @Override
    @NonTransactional
    public Map<String, String> getPaymentRequestsByStatusAndPurchaseOrderId(String applicationDocumentStatus, Integer purchaseOrderId) {
        List<String> paymentRequestDocNumbers = this.paymentRequestDao.getDocumentNumbersByPurchaseOrderId(purchaseOrderId);
        HashMap<String, String> paymentRequestResults = new HashMap<String, String>();
        paymentRequestResults.put("hasInProcess", "N");
        paymentRequestResults.put("checkInProcess", "N");
        if (paymentRequestDocNumbers == null || paymentRequestDocNumbers.isEmpty()) {
            return paymentRequestResults;
        }
        this.filterPaymentRequestByAppDocStatus(paymentRequestResults, paymentRequestDocNumbers, applicationDocumentStatus);
        return paymentRequestResults;
    }

    @Override
    @NonTransactional
    public List<PaymentRequestDocument> getPaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer poId, KualiDecimal invoiceAmount, java.sql.Date invoiceDate) {
        LOG.debug("getPaymentRequestsByPOIdInvoiceAmountInvoiceDate() started");
        return this.paymentRequestDao.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(poId, invoiceAmount, invoiceDate);
    }

    @NonTransactional
    private List<PaymentRequestDocument> getPaymentRequestsByInvoiceAmountInvoiceDate(Integer vendorHeaderGeneratedId, Integer vendorDetailAssignedId, KualiDecimal invoiceAmount, java.sql.Date invoiceDate) {
        LOG.debug("getPaymentRequestsByInvoiceAmountInvoiceDate() started");
        return this.paymentRequestDao.getActivePaymentRequestsByInvoiceAmountInvoiceDate(vendorHeaderGeneratedId, vendorDetailAssignedId, invoiceAmount, invoiceDate);
    }

    @Override
    @NonTransactional
    public boolean isInvoiceDateAfterToday(java.sql.Date invoiceDate) {
        Calendar now = Calendar.getInstance();
        now.set(10, 11);
        now.set(12, 59);
        now.set(13, 59);
        now.set(14, 59);
        Timestamp nowTime = new Timestamp(now.getTimeInMillis());
        Calendar invoiceDateC = Calendar.getInstance();
        invoiceDateC.setTime(invoiceDate);
        invoiceDateC.set(10, 0);
        invoiceDateC.set(12, 0);
        invoiceDateC.set(13, 0);
        invoiceDateC.set(14, 0);
        Timestamp invoiceDateTime = new Timestamp(invoiceDateC.getTimeInMillis());
        return invoiceDateTime.compareTo(nowTime) > 0;
    }

    @Override
    @NonTransactional
    public java.sql.Date calculatePayDate(java.sql.Date invoiceDate, PaymentTermType terms) {
        LOG.debug("calculatePayDate() started");
        Calendar invoicedDateCalendar = this.dateTimeService.getCalendar((Date)invoiceDate);
        Calendar processedDateCalendar = this.dateTimeService.getCurrentCalendar();
        String defaultDays = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "NUMBER_OF_DAYS_USED_TO_CALCULATE_DEFAULT_PAY_DATE");
        processedDateCalendar.add(5, Integer.parseInt(defaultDays));
        if (ObjectUtils.isNull((Object)terms) || StringUtils.isEmpty((CharSequence)terms.getVendorPaymentTermsCode())) {
            invoicedDateCalendar.add(5, 28);
            return this.returnLaterDate(invoicedDateCalendar, processedDateCalendar);
        }
        String payDateVariance = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "NUMBER_OF_DAYS_USED_TO_DECREASE_CALCULATED_PAY_DATE");
        Integer payDateVarianceInt = Integer.valueOf(payDateVariance);
        Integer discountDueNumber = terms.getVendorDiscountDueNumber();
        Integer netDueNumber = terms.getVendorNetDueNumber();
        if (ObjectUtils.isNotNull((Object)discountDueNumber)) {
            if ((discountDueNumber = Integer.valueOf(discountDueNumber - payDateVarianceInt)) < 0) {
                discountDueNumber = 0;
            }
            String discountDueTypeDescription = terms.getVendorDiscountDueTypeDescription();
            this.paymentTermsDateCalculation(discountDueTypeDescription, invoicedDateCalendar, discountDueNumber);
        } else if (ObjectUtils.isNotNull((Object)netDueNumber)) {
            if ((netDueNumber = Integer.valueOf(netDueNumber - payDateVarianceInt)) < 0) {
                netDueNumber = 0;
            }
            String netDueTypeDescription = terms.getVendorNetDueTypeDescription();
            this.paymentTermsDateCalculation(netDueTypeDescription, invoicedDateCalendar, netDueNumber);
        } else {
            throw new RuntimeException("Neither discount or net number were specified for this payment terms type");
        }
        return this.returnLaterDate(invoicedDateCalendar, processedDateCalendar);
    }

    protected java.sql.Date returnLaterDate(Calendar invoicedDateCalendar, Calendar processedDateCalendar) {
        if (invoicedDateCalendar.after(processedDateCalendar)) {
            return new java.sql.Date(invoicedDateCalendar.getTimeInMillis());
        }
        return new java.sql.Date(processedDateCalendar.getTimeInMillis());
    }

    protected void paymentTermsDateCalculation(String dueTypeDescription, Calendar invoicedDateCalendar, Integer dueNumber) {
        if (StringUtils.equals((CharSequence)dueTypeDescription, (CharSequence)"date")) {
            invoicedDateCalendar.add(2, 1);
            invoicedDateCalendar.set(5, dueNumber);
        } else if (StringUtils.equals((CharSequence)"days", (CharSequence)dueTypeDescription)) {
            invoicedDateCalendar.add(5, dueNumber);
        } else {
            throw new RuntimeException("missing payment terms description or not properly enterred on payment term maintenance doc");
        }
    }

    @Override
    @NonTransactional
    public void calculatePaymentRequest(PaymentRequestDocument paymentRequest, boolean updateDiscount) {
        LOG.debug("calculatePaymentRequest() started");
        if (ObjectUtils.isNull((Object)paymentRequest.getPaymentRequestPayDate())) {
            paymentRequest.setPaymentRequestPayDate(this.calculatePayDate(paymentRequest.getInvoiceDate(), paymentRequest.getVendorPaymentTerms()));
        }
        this.distributeAccounting(paymentRequest);
        this.purapService.calculateTax(paymentRequest);
        this.purapService.prorateForTradeInAndFullOrderDiscount(paymentRequest);
        if (updateDiscount) {
            this.calculateDiscount(paymentRequest);
        }
        this.distributeAccounting(paymentRequest);
    }

    protected void calculateDiscount(PaymentRequestDocument paymentRequestDocument) {
        PaymentRequestItem discountItem = this.findDiscountItem(paymentRequestDocument);
        PaymentTermType pt = paymentRequestDocument.getVendorPaymentTerms();
        if (pt != null && pt.getVendorPaymentTermsPercent() != null && BigDecimal.ZERO.compareTo(pt.getVendorPaymentTermsPercent()) != 0) {
            if (discountItem == null) {
                this.purapService.addBelowLineItems(paymentRequestDocument);
                this.removeIneligibleAdditionalCharges(paymentRequestDocument);
                discountItem = this.findDiscountItem(paymentRequestDocument);
            }
            PaymentRequestItem fullOrderItem = this.findFullOrderDiscountItem(paymentRequestDocument);
            KualiDecimal fullOrderAmount = KualiDecimal.ZERO;
            KualiDecimal fullOrderTaxAmount = KualiDecimal.ZERO;
            if (fullOrderItem != null) {
                fullOrderAmount = ObjectUtils.isNotNull((Object)fullOrderItem.getExtendedPrice()) ? fullOrderItem.getExtendedPrice() : KualiDecimal.ZERO;
                fullOrderTaxAmount = ObjectUtils.isNotNull((Object)fullOrderItem.getItemTaxAmount()) ? fullOrderItem.getItemTaxAmount() : KualiDecimal.ZERO;
            }
            KualiDecimal totalCost = (KualiDecimal)paymentRequestDocument.getTotalPreTaxDollarAmountAboveLineItems().add((AbstractKualiDecimal)fullOrderAmount);
            PurApItem tradeInItem = paymentRequestDocument.getTradeInItem();
            if (ObjectUtils.isNotNull((Object)tradeInItem)) {
                totalCost = (KualiDecimal)totalCost.add((AbstractKualiDecimal)tradeInItem.getTotalAmount());
            }
            BigDecimal discountAmount = pt.getVendorPaymentTermsPercent().multiply(totalCost.bigDecimalValue()).multiply(new BigDecimal("-0.01"));
            discountItem.setItemUnitPrice(discountAmount.setScale(2, 4));
            discountItem.setExtendedPrice(new KualiDecimal(discountAmount));
            boolean salesTaxInd = this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND");
            boolean useTaxIndicator = paymentRequestDocument.isUseTaxIndicator();
            if (salesTaxInd && !useTaxIndicator) {
                KualiDecimal totalTax = (KualiDecimal)paymentRequestDocument.getTotalTaxAmountAboveLineItems().add((AbstractKualiDecimal)fullOrderTaxAmount);
                BigDecimal discountTaxAmount = null;
                discountTaxAmount = totalCost.isNonZero() ? discountAmount.divide(totalCost.bigDecimalValue()).multiply(totalTax.bigDecimalValue()) : BigDecimal.ZERO;
                discountItem.setItemTaxAmount(new KualiDecimal(discountTaxAmount.setScale(2, 4)));
            }
            discountItem.setPurapDocument(paymentRequestDocument);
        } else if (discountItem != null) {
            paymentRequestDocument.getItems().remove(discountItem);
        }
    }

    @Override
    @NonTransactional
    public void clearTax(PaymentRequestDocument document) {
        this.removeTaxItems(document);
        document.setTaxClassificationCode(null);
        document.setTaxFederalPercent(null);
        document.setTaxStatePercent(null);
        document.setTaxCountryCode(null);
        document.setTaxNQIId(null);
        document.setTaxForeignSourceIndicator(false);
        document.setTaxExemptTreatyIndicator(false);
        document.setTaxOtherExemptIndicator(false);
        document.setTaxGrossUpIndicator(false);
        document.setTaxUSAIDPerDiemIndicator(false);
        document.setTaxSpecialW4Amount(null);
    }

    @Override
    @NonTransactional
    public void calculateTaxArea(PaymentRequestDocument preq) {
        LOG.debug("calculateTaxArea() started");
        this.removeTaxItems(preq);
        if (StringUtils.equalsIgnoreCase((CharSequence)preq.getTaxClassificationCode(), (CharSequence)"N")) {
            return;
        }
        BigDecimal taxableAmount = preq.getGrandPreTaxTotal().bigDecimalValue();
        if (preq.getTaxGrossUpIndicator().booleanValue() && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
            this.addTaxItem(preq, "STGR", taxableAmount);
        }
        if (preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
            this.addTaxItem(preq, "STTX", taxableAmount);
        }
        if (preq.getTaxGrossUpIndicator().booleanValue() && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
            this.addTaxItem(preq, "FDGR", taxableAmount);
        }
        if (preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
            this.addTaxItem(preq, "FDTX", taxableAmount);
        }
    }

    protected void removeTaxItems(PaymentRequestDocument preq) {
        List items = preq.getItems();
        for (int i = 0; i < items.size(); ++i) {
            PurApItem item = (PurApItem)items.get(i);
            String code = item.getItemTypeCode();
            if (!"FDTX".equals(code) && !"STTX".equals(code) && !"FDGR".equals(code) && !"STGR".equals(code)) continue;
            items.remove(i--);
        }
    }

    protected void addTaxItem(PaymentRequestDocument preq, String itemTypeCode, BigDecimal taxableAmount) {
        PurApItem taxItem;
        try {
            taxItem = (PurApItem)preq.getItemClass().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new InfrastructureException("Unable to access itemClass", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new InfrastructureException("Unable to instantiate itemClass", (Exception)e);
        }
        taxItem.setItemTypeCode(itemTypeCode);
        preq.addItem(taxItem);
        PurApAccountingLine taxLine = this.addTaxAccountingLine(taxItem, taxableAmount);
        taxItem.setItemUnitPrice(taxLine.getAmount().bigDecimalValue());
        taxItem.setExtendedPrice(taxLine.getAmount());
        ItemType itemType = new ItemType();
        itemType.setItemTypeCode(itemTypeCode);
        itemType = (ItemType)this.businessObjectService.retrieve((PersistableBusinessObject)itemType);
        taxItem.setItemType(itemType);
        taxItem.setItemDescription(itemType.getItemTypeDescription());
    }

    protected PurApAccountingLine addTaxAccountingLine(PurApItem taxItem, BigDecimal taxableAmount) {
        PurApAccountingLine taxLine;
        PaymentRequestDocument preq = (PaymentRequestDocument)taxItem.getPurapDocument();
        try {
            taxLine = (PurApAccountingLine)taxItem.getAccountingLineClass().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new InfrastructureException("Unable to access sourceAccountingLineClass", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new InfrastructureException("Unable to instantiate sourceAccountingLineClass", (Exception)e);
        }
        boolean isFederalTax = "FDTX".equals(taxItem.getItemTypeCode());
        boolean isFederalGross = "FDGR".equals(taxItem.getItemTypeCode());
        boolean isStateTax = "STTX".equals(taxItem.getItemTypeCode());
        boolean isStateGross = "STGR".equals(taxItem.getItemTypeCode());
        boolean isFederal = isFederalTax || isFederalGross;
        boolean isGross = isFederalGross || isStateGross;
        String taxChart = null;
        String taxAccount = null;
        String taxObjectCode = null;
        if (isGross) {
            PurApAccountingLine line1 = preq.getFirstAccount();
            taxChart = line1.getChartOfAccountsCode();
            taxAccount = line1.getAccountNumber();
            taxObjectCode = line1.getFinancialObjectCode();
        } else if (isFederalTax) {
            taxChart = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_FEDERAL_CHART");
            taxAccount = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_FEDERAL_ACCOUNT");
            taxObjectCode = this.parameterService.getSubParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_FEDERAL_OBJECT_CODE_BY_INCOME_CLASS", preq.getTaxClassificationCode());
            if (StringUtils.isBlank((CharSequence)taxChart) || StringUtils.isBlank((CharSequence)taxAccount) || StringUtils.isBlank((CharSequence)taxObjectCode)) {
                LOG.error("Unable to retrieve federal tax parameters.");
                throw new RuntimeException("Unable to retrieve federal tax parameters.");
            }
        } else if (isStateTax) {
            taxChart = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_STATE_CHART");
            taxAccount = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_STATE_ACCOUNT");
            taxObjectCode = this.parameterService.getSubParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_STATE_OBJECT_CODE_BY_INCOME_CLASS", preq.getTaxClassificationCode());
            if (StringUtils.isBlank((CharSequence)taxChart) || StringUtils.isBlank((CharSequence)taxAccount) || StringUtils.isBlank((CharSequence)taxObjectCode)) {
                LOG.error("Unable to retrieve state tax parameters.");
                throw new RuntimeException("Unable to retrieve state tax parameters.");
            }
        }
        BigDecimal taxPercentFederal = preq.getTaxFederalPercent();
        BigDecimal taxPercentState = preq.getTaxStatePercent();
        BigDecimal taxPercent = isFederal ? taxPercentFederal : taxPercentState;
        BigDecimal taxDivider = new BigDecimal(100);
        if (preq.getTaxGrossUpIndicator().booleanValue()) {
            taxDivider = taxDivider.subtract(taxPercentFederal.add(taxPercentState));
        }
        BigDecimal taxAmount = taxableAmount.multiply(taxPercent);
        taxAmount = taxAmount.divide(taxDivider, 5, 4);
        if (!isGross) {
            taxAmount = taxAmount.negate();
        }
        taxLine.setDocumentNumber(preq.getDocumentNumber());
        taxLine.setSequenceNumber(preq.getNextSourceLineNumber());
        taxLine.setChartOfAccountsCode(taxChart);
        taxLine.setAccountNumber(taxAccount);
        taxLine.setFinancialObjectCode(taxObjectCode);
        taxLine.setAmount(new KualiDecimal(taxAmount));
        taxLine.setItemIdentifier(taxItem.getItemIdentifier());
        taxLine.setPurapItem(taxItem);
        taxItem.getSourceAccountingLines().add(taxLine);
        return taxLine;
    }

    protected PaymentRequestItem findDiscountItem(PaymentRequestDocument paymentRequestDocument) {
        PaymentRequestItem discountItem = null;
        for (PaymentRequestItem preqItem : paymentRequestDocument.getItems()) {
            if (!StringUtils.equals((CharSequence)preqItem.getItemTypeCode(), (CharSequence)"DISC")) continue;
            discountItem = preqItem;
            break;
        }
        return discountItem;
    }

    protected PaymentRequestItem findFullOrderDiscountItem(PaymentRequestDocument paymentRequestDocument) {
        PaymentRequestItem discountItem = null;
        for (PaymentRequestItem preqItem : paymentRequestDocument.getItems()) {
            if (!StringUtils.equals((CharSequence)preqItem.getItemTypeCode(), (CharSequence)"ORDS")) continue;
            discountItem = preqItem;
            break;
        }
        return discountItem;
    }

    protected void distributeAccounting(PaymentRequestDocument paymentRequestDocument) {
        this.purapAccountingService.updateAccountAmounts(paymentRequestDocument);
        String accountDistributionMethod = paymentRequestDocument.getAccountDistributionMethod();
        for (PaymentRequestItem item : paymentRequestDocument.getItems()) {
            List<SourceAccountingLine> summaryAccounts;
            KualiDecimal totalAmount;
            List<PurApAccountingLine> distributedAccounts = null;
            if (item.getItemType().isLineItemIndicator() || !item.getSourceAccountingLines().isEmpty() || !ObjectUtils.isNotNull((Object)item.getExtendedPrice()) || KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)item.getExtendedPrice()) == 0) continue;
            if (StringUtils.equals((CharSequence)"DISC", (CharSequence)item.getItemType().getItemTypeCode()) && paymentRequestDocument.getGrandTotal() != null && KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)paymentRequestDocument.getGrandTotal()) != 0) {
                totalAmount = paymentRequestDocument.getLineItemTotal();
                HashSet<String> includedItemTypeCodes = new HashSet<String>();
                includedItemTypeCodes.add("ITEM");
                includedItemTypeCodes.add("SRVC");
                summaryAccounts = this.purapAccountingService.generateSummaryIncludeItemTypesAndNoZeroTotals(paymentRequestDocument.getItems(), includedItemTypeCodes);
                if (summaryAccounts != null) {
                    distributedAccounts = this.purapAccountingService.generateAccountDistributionForProration(summaryAccounts, totalAmount, PurapConstants.PRORATION_SCALE, PaymentRequestAccount.class);
                }
                if ("S".equalsIgnoreCase(accountDistributionMethod)) {
                    this.purapAccountingService.updatePreqAccountAmountsWithTotal(distributedAccounts, item.getTotalAmount());
                } else {
                    boolean rulePassed = true;
                    if (rulePassed &= this.kualiRuleService.applyRules((KualiDocumentEvent)new PurchasingAccountsPayableItemPreCalculateEvent((Document)paymentRequestDocument, item))) {
                        this.purapAccountingService.updatePreqProporationalAccountAmountsWithTotal(distributedAccounts, item.getTotalAmount());
                    }
                }
            } else {
                PurchaseOrderItem poi = item.getPurchaseOrderItem();
                if (poi != null && poi.getSourceAccountingLines() != null && !poi.getSourceAccountingLines().isEmpty() && poi.getExtendedPrice() != null && KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)poi.getExtendedPrice()) != 0) {
                    item.generateAccountListFromPoItemAccounts(poi.getSourceAccountingLines());
                } else {
                    totalAmount = paymentRequestDocument.getPurchaseOrderDocument().getTotalDollarAmountAboveLineItems();
                    this.purapAccountingService.updateAccountAmounts(paymentRequestDocument.getPurchaseOrderDocument());
                    summaryAccounts = this.purapAccountingService.generateSummary(PurApItemUtils.getAboveTheLineOnly(paymentRequestDocument.getPurchaseOrderDocument().getItems()));
                    if (summaryAccounts != null) {
                        distributedAccounts = this.purapAccountingService.generateAccountDistributionForProration(summaryAccounts, totalAmount, new Integer("6"), PaymentRequestAccount.class);
                    }
                }
            }
            if (!CollectionUtils.isNotEmpty(distributedAccounts) || !CollectionUtils.isEmpty(item.getSourceAccountingLines())) continue;
            item.setSourceAccountingLines(distributedAccounts);
        }
        this.purapAccountingService.updateAccountAmounts(paymentRequestDocument);
    }

    @Override
    @NonTransactional
    public PaymentRequestDocument addHoldOnPaymentRequest(PaymentRequestDocument document, String note) {
        Note noteObj = this.documentService.createNoteFromDocument((Document)document, note);
        document.addNote(noteObj);
        this.noteService.save(noteObj);
        document.setHoldIndicator(true);
        document.setLastActionPerformedByPersonId(GlobalVariables.getUserSession().getPerson().getPrincipalId());
        this.purapService.saveDocumentNoValidation((Document)document);
        return document;
    }

    @Override
    @NonTransactional
    public PaymentRequestDocument removeHoldOnPaymentRequest(PaymentRequestDocument document, String note) {
        Note noteObj = this.documentService.createNoteFromDocument((Document)document, note);
        document.addNote(noteObj);
        this.noteService.save(noteObj);
        document.setHoldIndicator(false);
        document.setLastActionPerformedByPersonId(null);
        this.purapService.saveDocumentNoValidation((Document)document);
        return document;
    }

    @Override
    @NonTransactional
    public void requestCancelOnPaymentRequest(PaymentRequestDocument document, String note) {
        Note noteObj = this.documentService.createNoteFromDocument((Document)document, note);
        document.addNote(noteObj);
        this.noteService.save(noteObj);
        document.setPaymentRequestedCancelIndicator(true);
        document.setLastActionPerformedByPersonId(GlobalVariables.getUserSession().getPerson().getPrincipalId());
        document.setAccountsPayableRequestCancelIdentifier(GlobalVariables.getUserSession().getPerson().getPrincipalId());
        this.purapService.saveDocumentNoValidation((Document)document);
    }

    @Override
    @NonTransactional
    public void removeRequestCancelOnPaymentRequest(PaymentRequestDocument document, String note) {
        Note noteObj = this.documentService.createNoteFromDocument((Document)document, note);
        document.addNote(noteObj);
        this.noteService.save(noteObj);
        this.clearRequestCancelFields(document);
        this.purapService.saveDocumentNoValidation((Document)document);
    }

    protected void clearRequestCancelFields(PaymentRequestDocument document) {
        document.setPaymentRequestedCancelIndicator(false);
        document.setLastActionPerformedByPersonId(null);
        document.setAccountsPayableRequestCancelIdentifier(null);
    }

    @Override
    @NonTransactional
    public boolean isExtracted(PaymentRequestDocument document) {
        return !ObjectUtils.isNull((Object)document.getExtractedTimestamp());
    }

    @Override
    @NonTransactional
    public void cancelExtractedPaymentRequest(PaymentRequestDocument paymentRequest, String note) {
        LOG.debug("cancelExtractedPaymentRequest() started");
        if (PurapConstants.PaymentRequestStatuses.CANCELLED_STATUSES.contains(paymentRequest.getApplicationDocumentStatus())) {
            LOG.debug("cancelExtractedPaymentRequest() ended");
            return;
        }
        try {
            Note cancelNote = this.documentService.createNoteFromDocument((Document)paymentRequest, note);
            paymentRequest.addNote(cancelNote);
            this.noteService.save(cancelNote);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create a note on this document.", e);
        }
        paymentRequest.setReopenPurchaseOrderIndicator(false);
        this.accountsPayableService.cancelAccountsPayableDocument(paymentRequest, "");
        if (LOG.isDebugEnabled()) {
            LOG.debug("cancelExtractedPaymentRequest() PREQ " + paymentRequest.getPurapDocumentIdentifier() + " Cancelled Without Workflow");
            LOG.debug("cancelExtractedPaymentRequest() ended");
        }
    }

    @Override
    @NonTransactional
    public void resetExtractedPaymentRequest(PaymentRequestDocument paymentRequest, String note) {
        LOG.debug("resetExtractedPaymentRequest() started");
        if (PurapConstants.PaymentRequestStatuses.CANCELLED_STATUSES.contains(paymentRequest.getApplicationDocumentStatus())) {
            LOG.debug("resetExtractedPaymentRequest() ended");
            return;
        }
        paymentRequest.setExtractedTimestamp(null);
        paymentRequest.setPaymentPaidTimestamp(null);
        String noteText = "This Payment Request is being reset for extraction by PDP " + note;
        try {
            Note resetNote = this.documentService.createNoteFromDocument((Document)paymentRequest, noteText);
            paymentRequest.addNote(resetNote);
            this.noteService.save(resetNote);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create a note on this document. " + e);
        }
        this.purapService.saveDocumentNoValidation((Document)paymentRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug("resetExtractedPaymentRequest() PREQ " + paymentRequest.getPurapDocumentIdentifier() + " Reset from Extracted status");
        }
    }

    @Override
    @NonTransactional
    public void populatePaymentRequest(PaymentRequestDocument paymentRequestDocument) {
        PurchaseOrderDocument purchaseOrderDocument = paymentRequestDocument.getPurchaseOrderDocument();
        HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList = this.accountsPayableService.getExpiredOrClosedAccountList(paymentRequestDocument);
        paymentRequestDocument.populatePaymentRequestFromPurchaseOrder(purchaseOrderDocument, expiredOrClosedAccountList);
        paymentRequestDocument.getDocumentHeader().setDocumentDescription(this.createPreqDocumentDescription(paymentRequestDocument.getPurchaseOrderIdentifier(), paymentRequestDocument.getVendorName()));
        this.accountsPayableService.generateExpiredOrClosedAccountNote(paymentRequestDocument, expiredOrClosedAccountList);
        if (!expiredOrClosedAccountList.isEmpty()) {
            paymentRequestDocument.setContinuationAccountIndicator(true);
        }
        this.calculateDiscount(paymentRequestDocument);
        this.distributeAccounting(paymentRequestDocument);
        Bank defaultBank = this.bankService.getDefaultBankByDocType(paymentRequestDocument.getClass());
        if (defaultBank != null) {
            paymentRequestDocument.setBankCode(defaultBank.getBankCode());
            paymentRequestDocument.setBank(defaultBank);
        }
    }

    @Override
    @NonTransactional
    public String createPreqDocumentDescription(Integer purchaseOrderIdentifier, String vendorName) {
        StringBuilder descr = new StringBuilder();
        descr.append("PO: ");
        descr.append(purchaseOrderIdentifier);
        descr.append(" Vendor: ");
        descr.append(StringUtils.trimToEmpty((String)vendorName));
        int noteTextMaxLength = this.dataDictionaryService.getAttributeMaxLength(DocumentHeader.class, "documentDescription");
        if (noteTextMaxLength >= descr.length()) {
            return descr.toString();
        }
        return descr.toString().substring(0, noteTextMaxLength);
    }

    @Override
    @NonTransactional
    public void populateAndSavePaymentRequest(PaymentRequestDocument preq) throws WorkflowException {
        try {
            preq.updateAndSaveAppDocStatus("In Process");
            this.documentService.saveDocument((Document)preq, AttributedContinuePurapEvent.class);
        }
        catch (ValidationException ve) {
            preq.updateAndSaveAppDocStatus("Initiated");
        }
        catch (WorkflowException we) {
            preq.updateAndSaveAppDocStatus("Initiated");
            String errorMsg = "Error saving document # " + preq.getDocumentHeader().getDocumentNumber() + " " + we.getMessage();
            LOG.error(errorMsg, (Throwable)we);
            throw new RuntimeException(errorMsg, we);
        }
    }

    @Override
    @NonTransactional
    public boolean shouldPurchaseOrderBeReversed(AccountsPayableDocument apDoc) {
        PurchaseOrderDocument po = apDoc.getPurchaseOrderDocument();
        if (ObjectUtils.isNull((Object)po)) {
            throw new RuntimeException("po should never be null on PREQ");
        }
        return this.purapService.isFullDocumentEntryCompleted(apDoc) && StringUtils.equalsIgnoreCase((CharSequence)"Closed", (CharSequence)po.getApplicationDocumentStatus());
    }

    @Override
    @NonTransactional
    public Person getPersonForCancel(AccountsPayableDocument apDoc) {
        PaymentRequestDocument preqDoc = (PaymentRequestDocument)apDoc;
        Person user = null;
        if (preqDoc.isPaymentRequestedCancelIndicator()) {
            user = preqDoc.getLastActionPerformedByUser();
        }
        return user;
    }

    @Override
    @NonTransactional
    public void takePurchaseOrderCancelAction(AccountsPayableDocument apDoc) {
        PaymentRequestDocument preqDocument = (PaymentRequestDocument)apDoc;
        if (preqDocument.isReopenPurchaseOrderIndicator()) {
            String docType = "POR";
            this.purchaseOrderService.createAndRoutePotentialChangeDocument(preqDocument.getPurchaseOrderDocument().getDocumentNumber(), docType, "reopened by Credit Memo " + apDoc.getPurapDocumentIdentifier() + "cancel", new ArrayList(), "Pending Reopen");
        }
    }

    @Override
    @NonTransactional
    public String updateStatusByNode(String currentNodeName, AccountsPayableDocument apDoc) {
        return this.updateStatusByNode(currentNodeName, (PaymentRequestDocument)apDoc);
    }

    protected String updateStatusByNode(String currentNodeName, PaymentRequestDocument preqDoc) {
        this.clearRequestCancelFields(preqDoc);
        String cancelledStatus = StringUtils.isEmpty((CharSequence)currentNodeName) ? "Cancelled" : PurapConstants.PaymentRequestStatuses.getPaymentRequestAppDocDisapproveStatuses().get(currentNodeName);
        if (StringUtils.isNotBlank((CharSequence)cancelledStatus)) {
            try {
                preqDoc.updateAndSaveAppDocStatus(cancelledStatus);
            }
            catch (WorkflowException we) {
                throw new RuntimeException("Unable to save the route status data for document: " + preqDoc.getDocumentNumber(), we);
            }
            this.purapService.saveDocumentNoValidation((Document)preqDoc);
        } else {
            this.logAndThrowRuntimeException("No status found to set for document being disapproved in node '" + currentNodeName + "'");
        }
        return cancelledStatus;
    }

    @Override
    @NonTransactional
    public void markPaid(PaymentRequestDocument pr, java.sql.Date processDate) {
        LOG.debug("markPaid() started");
        pr.setPaymentPaidTimestamp(new Timestamp(processDate.getTime()));
        this.purapService.saveDocumentNoValidation((Document)pr);
    }

    @Override
    @NonTransactional
    public boolean hasDiscountItem(PaymentRequestDocument preq) {
        return ObjectUtils.isNotNull((Object)this.findDiscountItem(preq));
    }

    @Override
    @NonTransactional
    public boolean poItemEligibleForAp(AccountsPayableDocument apDoc, PurchaseOrderItem poi) {
        if (ObjectUtils.isNull((Object)poi)) {
            throw new RuntimeException("item null in purchaseOrderItemEligibleForPayment ... this should never happen");
        }
        if (!poi.isItemActiveIndicator()) {
            return false;
        }
        ItemType poiType = poi.getItemType();
        if (ObjectUtils.isNull((Object)((Object)poiType))) {
            return false;
        }
        if (poiType.isQuantityBasedGeneralLedgerIndicator()) {
            return poi.getItemQuantity().isGreaterThan((AbstractKualiDecimal)poi.getItemInvoicedTotalQuantity());
        }
        return poi.getItemOutstandingEncumberedAmount() != null;
    }

    @Override
    @NonTransactional
    public void removeIneligibleAdditionalCharges(PaymentRequestDocument document) {
        ArrayList<PaymentRequestItem> itemsToRemove = new ArrayList<PaymentRequestItem>();
        for (PaymentRequestItem item : document.getItems()) {
            PaymentTermType pt;
            if (ObjectUtils.isNull((Object)item.getPurchaseOrderItemUnitPrice()) && ("ORDS".equals(item.getItemTypeCode()) || "TRDI".equals(item.getItemTypeCode()))) {
                itemsToRemove.add(item);
                continue;
            }
            if (!StringUtils.equals((CharSequence)item.getItemTypeCode(), (CharSequence)"DISC") || (pt = document.getVendorPaymentTerms()) != null && pt.getVendorPaymentTermsPercent() != null && BigDecimal.ZERO.compareTo(pt.getVendorPaymentTermsPercent()) != 0) continue;
            itemsToRemove.add(item);
        }
        for (PaymentRequestItem item : itemsToRemove) {
            document.getItems().remove(item);
        }
    }

    @Override
    @NonTransactional
    public void changeVendor(PaymentRequestDocument preq, Integer headerId, Integer detailId) {
        VendorDetail primaryVendor = this.vendorService.getVendorDetail(preq.getOriginalVendorHeaderGeneratedIdentifier(), preq.getOriginalVendorDetailAssignedIdentifier());
        if (primaryVendor == null) {
            LOG.error("useAlternateVendor() primaryVendorDetail from database for header id " + headerId + " and detail id " + detailId + "is null");
            throw new PurError("AlternateVendor: VendorDetail from database for header id " + headerId + " and detail id " + detailId + "is null");
        }
        VendorDetail vd = this.vendorService.getVendorDetail(headerId, detailId);
        if (vd == null) {
            LOG.error("changeVendor() VendorDetail from database for header id " + headerId + " and detail id " + detailId + "is null");
            throw new PurError("changeVendor: VendorDetail from database for header id " + headerId + " and detail id " + detailId + "is null");
        }
        preq.setVendorDetail(vd);
        preq.setVendorName(vd.getVendorName());
        preq.setVendorNumber(vd.getVendorNumber());
        preq.setVendorHeaderGeneratedIdentifier(vd.getVendorHeaderGeneratedIdentifier());
        preq.setVendorDetailAssignedIdentifier(vd.getVendorDetailAssignedIdentifier());
        preq.setVendorPaymentTermsCode(vd.getVendorPaymentTermsCode());
        preq.setVendorShippingPaymentTermsCode(vd.getVendorShippingPaymentTermsCode());
        preq.setVendorShippingTitleCode(vd.getVendorShippingTitleCode());
        preq.refreshReferenceObject("vendorPaymentTerms");
        preq.refreshReferenceObject("vendorShippingPaymentTerms");
        String deliveryCampus = preq.getPurchaseOrderDocument().getDeliveryCampusCode();
        VendorAddress va = this.vendorService.getVendorDefaultAddress(headerId, detailId, "RM", deliveryCampus);
        if (va == null) {
            va = this.vendorService.getVendorDefaultAddress(headerId, detailId, "PO", deliveryCampus);
        }
        if (va == null) {
            LOG.error("changeVendor() VendorAddress from database for header id " + headerId + " and detail id " + detailId + "is null");
            throw new PurError("changeVendor  VendorAddress from database for header id " + headerId + " and detail id " + detailId + "is null");
        }
        if (preq == null) {
            LOG.error("changeVendor(): Null link back to the Purchase Order.");
            throw new PurError("Null link back to the Purchase Order.");
        }
        this.setVendorAddress(va, preq);
        preq.getDocumentHeader().setDocumentDescription(this.createPreqDocumentDescription(preq.getPurchaseOrderIdentifier(), preq.getVendorName()));
    }

    protected void setVendorAddress(VendorAddress va, PaymentRequestDocument preq) {
        if (va != null) {
            preq.setVendorAddressGeneratedIdentifier(va.getVendorAddressGeneratedIdentifier());
            preq.setVendorAddressInternationalProvinceName(va.getVendorAddressInternationalProvinceName());
            preq.setVendorLine1Address(va.getVendorLine1Address());
            preq.setVendorLine2Address(va.getVendorLine2Address());
            preq.setVendorCityName(va.getVendorCityName());
            preq.setVendorStateCode(va.getVendorStateCode());
            preq.setVendorPostalCode(va.getVendorZipCode());
            preq.setVendorCountryCode(va.getVendorCountryCode());
        }
    }

    protected void logAndThrowRuntimeException(String errorMessage) {
        LOG.error(errorMessage);
        throw new RuntimeException(errorMessage);
    }

    @Override
    @NonTransactional
    public void generateGLEntriesCreateAccountsPayableDocument(AccountsPayableDocument apDocument) {
        PaymentRequestDocument paymentRequest = (PaymentRequestDocument)apDocument;
        ((PurapGeneralLedgerService)SpringContext.getBean(PurapGeneralLedgerService.class)).generateEntriesCreatePaymentRequest(paymentRequest);
    }

    @Override
    @NonTransactional
    public boolean hasActivePaymentRequestsForPurchaseOrder(Integer purchaseOrderIdentifier) {
        int activePaymentRequestCount = this.paymentRequestDao.getActivePaymentRequestCountForPurchaseOrder(purchaseOrderIdentifier);
        return activePaymentRequestCount > 0;
    }

    @Deprecated
    protected List<String> getPaymentRequestDocNumberForAutoApprove() {
        java.sql.Date todayAtMidnight = this.dateTimeService.getCurrentSqlDateMidnight();
        return this.paymentRequestDao.getEligibleForAutoApproval(todayAtMidnight);
    }

    protected void filterPaymentRequestByAppDocStatus(Map<String, String> paymentRequestResults, List<String> lookupDocNumbers, String ... applicationDocumentStatus) {
        boolean hasInProcess = false;
        boolean checkInProcess = false;
        for (String docId : lookupDocNumbers) {
            FinancialSystemDocumentHeader hdr = this.financialSystemDocumentService.findByDocumentNumber(docId);
            if (Arrays.asList(applicationDocumentStatus).contains(hdr.getApplicationDocumentStatus())) {
                hasInProcess = true;
            } else {
                checkInProcess = true;
            }
            if (!hasInProcess || !checkInProcess) continue;
            break;
        }
        if (hasInProcess) {
            paymentRequestResults.put("hasInProcess", "Y");
        }
        if (checkInProcess) {
            paymentRequestResults.put("checkInProcess", "Y");
        }
    }

    protected Collection<PaymentRequestDocument> filterPaymentRequestByAppDocStatus(Collection<PaymentRequestDocument> paymentRequestDocuments, String ... appDocStatus) {
        ArrayList<PaymentRequestDocument> filteredPaymentRequestDocuments = new ArrayList<PaymentRequestDocument>();
        List<String> status = Arrays.asList(appDocStatus);
        for (PaymentRequestDocument paymentRequest : paymentRequestDocuments) {
            long start = System.currentTimeMillis();
            if (status.contains(paymentRequest.getApplicationDocumentStatus())) {
                filteredPaymentRequestDocuments.add(paymentRequest);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(System.currentTimeMillis() - start + "ms to check app doc status");
        }
        return filteredPaymentRequestDocuments;
    }

    @Override
    @Transactional
    public void processPaymentRequestInReceivingStatus() {
        List<PaymentRequestDocument> preqs = this.paymentRequestDao.getPaymentRequestInReceivingStatus();
        for (PaymentRequestDocument preqDoc : preqs) {
            if (!ObjectUtils.isNotNull((Object)preqDoc) || !preqDoc.isReceivingRequirementMet()) continue;
            try {
                this.documentService.approveDocument((Document)preqDoc, "Approved by Receiving Required PREQ job", null);
            }
            catch (WorkflowException e) {
                LOG.error("processPaymentRequestInReceivingStatus() Error approving payment request document from awaiting receiving", (Throwable)e);
                throw new RuntimeException("Error approving payment request document from awaiting receiving", e);
            }
        }
    }

    @Override
    @NonTransactional
    public boolean allowBackpost(PaymentRequestDocument paymentRequestDocument) {
        int allowBackpost = Integer.parseInt(this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "ALLOW_BACKPOST_DAYS"));
        Calendar today = this.dateTimeService.getCurrentCalendar();
        Integer currentFY = this.universityDateService.getCurrentUniversityDate().getUniversityFiscalYear();
        Date priorClosingDateTemp = this.universityDateService.getLastDateOfFiscalYear(Integer.valueOf(currentFY - 1));
        Calendar priorClosingDate = Calendar.getInstance();
        priorClosingDate.setTime(priorClosingDateTemp);
        Calendar allowBackpostDate = Calendar.getInstance();
        allowBackpostDate.setTime(priorClosingDate.getTime());
        allowBackpostDate.add(5, allowBackpost + 1);
        Calendar preqInvoiceDate = Calendar.getInstance();
        preqInvoiceDate.setTime(paymentRequestDocument.getInvoiceDate());
        if (today.compareTo(priorClosingDate) > 0 && today.compareTo(allowBackpostDate) <= 0 && preqInvoiceDate.compareTo(priorClosingDate) <= 0) {
            LOG.debug("allowBackpost() within range to allow backpost; posting entry to period 12 of previous FY");
            return true;
        }
        LOG.debug("allowBackpost() not within range to allow backpost; posting entry to current FY");
        return false;
    }

    @Override
    @NonTransactional
    public boolean isPurchaseOrderValidForPaymentRequestDocumentCreation(PaymentRequestDocument paymentRequestDocument, PurchaseOrderDocument po) {
        boolean valid = true;
        PurchaseOrderDocument purchaseOrderDocument = paymentRequestDocument.getPurchaseOrderDocument();
        if (ObjectUtils.isNull((Object)purchaseOrderDocument)) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.invoice.purchaseOrder.notExist", new String[0]);
            valid = false;
        } else if (purchaseOrderDocument.isPendingActionIndicator()) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.invoice.purchaseOrder.pending.action", new String[0]);
            valid = false;
        } else if (!StringUtils.equals((CharSequence)purchaseOrderDocument.getApplicationDocumentStatus(), (CharSequence)"Open")) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.invoice.purchaseOrder.notOpen", new String[0]);
            valid = false;
        }
        return valid;
    }

    @Override
    @NonTransactional
    public boolean encumberedItemExistsForInvoicing(PurchaseOrderDocument document) {
        boolean zeroDollar = true;
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        for (PurchaseOrderItem poi : document.getItems()) {
            KualiDecimal encumberedAmount;
            if (poi.getItemType().isLineItemIndicator() && poi.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
                KualiDecimal encumberedQuantity = poi.getItemOutstandingEncumberedQuantity() == null ? KualiDecimal.ZERO : poi.getItemOutstandingEncumberedQuantity();
                if (encumberedQuantity.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) != 1) continue;
                zeroDollar = false;
                break;
            }
            if (!poi.getItemType().isAmountBasedGeneralLedgerIndicator() && !poi.getItemType().isAdditionalChargeIndicator() || (encumberedAmount = poi.getItemOutstandingEncumberedAmount() == null ? KualiDecimal.ZERO : poi.getItemOutstandingEncumberedAmount()).compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) != 1) continue;
            zeroDollar = false;
            break;
        }
        return !zeroDollar;
    }

    @NonTransactional
    public void setAccountsPayableService(AccountsPayableService accountsPayableService) {
        this.accountsPayableService = accountsPayableService;
    }

    @NonTransactional
    public void setBankService(BankService bankService) {
        this.bankService = bankService;
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @NonTransactional
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @NonTransactional
    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    @NonTransactional
    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    @NonTransactional
    public void setDisbursementVoucherValidationService(DisbursementVoucherValidationService disbursementVoucherValidationService) {
        this.disbursementVoucherValidationService = disbursementVoucherValidationService;
    }

    @NonTransactional
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @NonTransactional
    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    @NonTransactional
    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    @NonTransactional
    public void setNegativePaymentRequestApprovalLimitService(NegativePaymentRequestApprovalLimitService negativePaymentRequestApprovalLimitService) {
        this.negativePaymentRequestApprovalLimitService = negativePaymentRequestApprovalLimitService;
    }

    @NonTransactional
    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    @NonTransactional
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @NonTransactional
    public void setPaymentRequestDao(PaymentRequestDao paymentRequestDao) {
        this.paymentRequestDao = paymentRequestDao;
    }

    @NonTransactional
    public void setPurapAccountingService(PurapAccountingService purapAccountingService) {
        this.purapAccountingService = purapAccountingService;
    }

    @NonTransactional
    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    @NonTransactional
    public void setPurapWorkflowIntegrationService(PurApWorkflowIntegrationService purapWorkflowIntegrationService) {
        this.purapWorkflowIntegrationService = purapWorkflowIntegrationService;
    }

    @NonTransactional
    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    @NonTransactional
    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    @NonTransactional
    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    private static enum DuplicatePaymentRequestMessages {
        DUPLICATE_INVOICE_DATE_AMOUNT("message.duplicate.invoice.date.amount", "message.duplicate.invoice.date.amount.cancelledOrVoided", "message.duplicate.invoice.date.amount.cancelled", "message.duplicate.invoice.date.amount.voided"),
        DUPLICATE_INVOICE_VENDOR_INVOICE_NUMBER("errors.duplicate.vendor.invoice", "errors.duplicate.vendor.invoice.cancelledOrVoided", "errors.duplicate.vendor.invoice.cancelled", "errors.duplicate.vendor.invoice.voided");

        final String duplicateInvoiceKey;
        final String duplicateInvoiceCanceledOrVoidedKey;
        final String duplicateInvoiceCancelledKey;
        final String duplicateInvoiceVoidedKey;

        private DuplicatePaymentRequestMessages(String duplicateInvoiceKey, String duplicateInvoiceCanceledOrVoidedKey, String duplicateInvoiceCancelledKey, String duplicateInvoiceVoidedKey) {
            this.duplicateInvoiceKey = duplicateInvoiceKey;
            this.duplicateInvoiceCanceledOrVoidedKey = duplicateInvoiceCanceledOrVoidedKey;
            this.duplicateInvoiceCancelledKey = duplicateInvoiceCancelledKey;
            this.duplicateInvoiceVoidedKey = duplicateInvoiceVoidedKey;
        }
    }
}

