/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.document.BulkReceivingDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PrintService;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.exception.PurapConfigurationException;
import org.kuali.kfs.module.purap.pdf.BulkReceivingPdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderParameters;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderPdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderQuotePdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderQuoteRequestsPdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderTransmitParameters;
import org.kuali.kfs.module.purap.service.ImageService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PrintServiceImpl
implements PrintService {
    private static Log LOG = LogFactory.getLog(PrintServiceImpl.class);
    protected static final boolean TRANSMISSION_IS_RETRANSMIT = true;
    protected static final boolean TRANSMISSION_IS_NOT_RETRANSMIT = false;
    private ImageService imageService;
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;
    private ConfigurationService kualiConfigurationService;
    private PurchaseOrderParameters purchaseOrderParameters;

    @Override
    public Collection generatePurchaseOrderQuoteRequestsListPdf(PurchaseOrderDocument po, ByteArrayOutputStream byteArrayOutputStream) {
        LOG.debug((Object)"generatePurchaseOrderQuoteRequestsListPdf() started");
        ArrayList<String> errors = new ArrayList<String>();
        PurchaseOrderQuoteRequestsPdf poQuoteRequestsPdf = new PurchaseOrderQuoteRequestsPdf();
        try {
            PurchaseOrderTransmitParameters pdfParameters = this.getPurchaseOrderQuoteRequestsListPdfParameters(po);
            String deliveryCampusName = pdfParameters.getCampusParameter().getCampus().getName();
            poQuoteRequestsPdf.generatePOQuoteRequestsListPdf(po, byteArrayOutputStream, pdfParameters.getCampusParameter().getPurchasingInstitutionName());
        }
        catch (PurError pe) {
            LOG.error((Object)"Caught exception ", (Throwable)pe);
            errors.add(pe.getMessage());
        }
        catch (PurapConfigurationException pce) {
            LOG.error((Object)"Caught exception ", (Throwable)pce);
            errors.add(pce.getMessage());
        }
        catch (Exception e) {
            LOG.error((Object)"Caught exception ", (Throwable)e);
            errors.add(e.getMessage());
        }
        LOG.debug((Object)"generatePurchaseOrderQuoteRequestsListPdf() ended");
        return errors;
    }

    @Override
    public Collection savePurchaseOrderQuoteRequestsListPdf(PurchaseOrderDocument po) {
        return null;
    }

    protected PurchaseOrderTransmitParameters getPurchaseOrderQuoteRequestsListPdfParameters(PurchaseOrderDocument po) {
        PurchaseOrderParameters purchaseOrderParameters = this.getPurchaseOrderParameters();
        purchaseOrderParameters.setPurchaseOrderPdfParameters(po);
        return (PurchaseOrderTransmitParameters)purchaseOrderParameters;
    }

    @Override
    public Collection generatePurchaseOrderQuotePdf(PurchaseOrderDocument po, PurchaseOrderVendorQuote povq, ByteArrayOutputStream byteArrayOutputStream, String environment) {
        LOG.debug((Object)"generatePurchaseOrderQuotePdf() started");
        PurchaseOrderQuotePdf poQuotePdf = new PurchaseOrderQuotePdf();
        ArrayList<String> errors = new ArrayList<String>();
        try {
            PurchaseOrderParameters purchaseOrderParameters = this.getPurchaseOrderParameters();
            purchaseOrderParameters.setPurchaseOrderPdfParameters(po, povq);
            PurchaseOrderTransmitParameters pdfParameters = (PurchaseOrderTransmitParameters)purchaseOrderParameters;
            String deliveryCampusName = pdfParameters.getCampusParameter().getCampus().getName();
            poQuotePdf.generatePOQuotePDF(po, povq, deliveryCampusName, pdfParameters.getContractManagerCampusCode(), pdfParameters.getLogoImage(), byteArrayOutputStream, environment);
        }
        catch (PurError pe) {
            LOG.error((Object)"Caught exception ", (Throwable)pe);
            errors.add(pe.getMessage());
        }
        catch (PurapConfigurationException pce) {
            LOG.error((Object)"Caught exception ", (Throwable)pce);
            errors.add(pce.getMessage());
        }
        LOG.debug((Object)"generatePurchaseOrderQuotePdf() ended");
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection savePurchaseOrderQuotePdf(PurchaseOrderDocument po, PurchaseOrderVendorQuote povq, String environment) {
        LOG.debug((Object)"savePurchaseOrderQuotePdf() started");
        String pdfQuoteFilename = "PURAP_PO_" + po.getPurapDocumentIdentifier().toString() + "_Quote_" + povq.getPurchaseOrderVendorQuoteIdentifier().toString() + "_" + System.currentTimeMillis() + ".pdf";
        PurchaseOrderQuotePdf poQuotePdf = new PurchaseOrderQuotePdf();
        ArrayList<String> errors = new ArrayList<String>();
        PurchaseOrderTransmitParameters pdfParameters = null;
        try {
            PurchaseOrderParameters purchaseOrderParameters = this.getPurchaseOrderParameters();
            purchaseOrderParameters.setPurchaseOrderPdfParameters(po, povq);
            pdfParameters = (PurchaseOrderTransmitParameters)purchaseOrderParameters;
            String deliveryCampusName = pdfParameters.getCampusParameter().getCampus().getName();
            poQuotePdf.savePOQuotePDF(po, povq, pdfParameters, environment);
        }
        catch (PurError e) {
            LOG.error((Object)"Caught exception ", (Throwable)e);
            errors.add(e.getMessage());
        }
        catch (PurapConfigurationException pce) {
            LOG.error((Object)"Caught exception ", (Throwable)pce);
            errors.add(pce.getMessage());
        }
        finally {
            try {
                poQuotePdf.deletePdf(pdfParameters.getPdfFileLocation(), pdfQuoteFilename);
            }
            catch (Throwable e) {
                LOG.error((Object)("savePurchaseOrderQuotePdf() Error deleting Quote PDF" + pdfQuoteFilename + " - Exception was " + e.getMessage()), e);
                errors.add(e.getMessage());
            }
        }
        LOG.debug((Object)"savePurchaseOrderQuotePdf() ended");
        return errors;
    }

    protected Collection generatePurchaseOrderPdf(PurchaseOrderDocument po, ByteArrayOutputStream byteArrayOutputStream, boolean isRetransmit, String environment, List<PurchaseOrderItem> retransmitItems) {
        LOG.debug((Object)"generatePurchaseOrderPdf() started");
        PurchaseOrderPdf poPdf = new PurchaseOrderPdf();
        ArrayList<String> errors = new ArrayList<String>();
        try {
            PurchaseOrderParameters purchaseOrderParameters = this.getPurchaseOrderParameters();
            purchaseOrderParameters.setPurchaseOrderPdfParameters(po);
            PurchaseOrderTransmitParameters pdfParameters = (PurchaseOrderTransmitParameters)purchaseOrderParameters;
            poPdf.generatePdf(po, pdfParameters, byteArrayOutputStream, isRetransmit, environment, retransmitItems);
        }
        catch (PurError e) {
            LOG.error((Object)"Caught exception ", (Throwable)e);
            errors.add(e.getMessage());
        }
        catch (PurapConfigurationException pce) {
            LOG.error((Object)"Caught exception ", (Throwable)pce);
            errors.add(pce.getMessage());
        }
        LOG.debug((Object)"generatePurchaseOrderPdf() ended");
        return errors;
    }

    @Override
    public Collection generatePurchaseOrderPdf(PurchaseOrderDocument po, ByteArrayOutputStream byteArrayOutputStream, String environment, List<PurchaseOrderItem> retransmitItems) {
        return this.generatePurchaseOrderPdf(po, byteArrayOutputStream, false, environment, retransmitItems);
    }

    @Override
    public Collection generatePurchaseOrderPdfForRetransmission(PurchaseOrderDocument po, ByteArrayOutputStream byteArrayOutputStream, String environment, List<PurchaseOrderItem> retransmitItems) {
        return this.generatePurchaseOrderPdf(po, byteArrayOutputStream, true, environment, retransmitItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection savePurchaseOrderPdf(PurchaseOrderDocument po, boolean isRetransmit, String environment) {
        LOG.debug((Object)"savePurchaseOrderPdf() started");
        PurchaseOrderPdf poPdf = new PurchaseOrderPdf();
        ArrayList<String> errors = new ArrayList<String>();
        PurchaseOrderTransmitParameters pdfParameters = null;
        try {
            PurchaseOrderParameters purchaseOrderParameters = this.getPurchaseOrderParameters();
            purchaseOrderParameters.setPurchaseOrderPdfParameters(po);
            pdfParameters = (PurchaseOrderTransmitParameters)purchaseOrderParameters;
            poPdf.savePdf(po, pdfParameters, isRetransmit, environment);
        }
        catch (PurError e) {
            LOG.error((Object)"Caught exception ", (Throwable)e);
            errors.add(e.getMessage());
        }
        catch (PurapConfigurationException pce) {
            LOG.error((Object)"Caught exception ", (Throwable)pce);
            errors.add(pce.getMessage());
        }
        finally {
            try {
                poPdf.deletePdf(pdfParameters.getPdfFileLocation(), pdfParameters.getPdfFileName());
            }
            catch (Throwable e) {
                LOG.error((Object)("savePurchaseOrderPdf() Error deleting PDF" + pdfParameters.getPdfFileName() + " - Exception was " + e.getMessage()), e);
                errors.add("Error while deleting the pdf after savePurchaseOrderPdf" + e.getMessage());
            }
        }
        LOG.debug((Object)"savePurchaseOrderPdf() ended");
        return errors;
    }

    @Override
    public Collection savePurchaseOrderPdf(PurchaseOrderDocument po, String environment) {
        return this.savePurchaseOrderPdf(po, false, environment);
    }

    @Override
    public Collection savePurchaseOrderPdfForRetransmission(PurchaseOrderDocument po, String environment) {
        return this.savePurchaseOrderPdf(po, true, environment);
    }

    @Override
    public Collection generateBulkReceivingPDF(BulkReceivingDocument blkRecDoc, ByteArrayOutputStream baosPDF) {
        LOG.debug((Object)"generateBulkReceivingPDF() started");
        BulkReceivingPdf recBlkTicketPDF = new BulkReceivingPdf();
        ArrayList<String> errors = new ArrayList<String>();
        String imageTempLocation = "";
        String logoImage = "";
        String key = blkRecDoc.getDocumentNumber().toString();
        String campusCode = blkRecDoc.getDeliveryCampusCode().toLowerCase();
        String environment = this.kualiConfigurationService.getPropertyValueAsString("environment");
        boolean useImage = true;
        if (this.parameterService.parameterExists(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_IMAGES_AVAILABLE_IND").booleanValue()) {
            useImage = this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_IMAGES_AVAILABLE_IND");
        }
        if (useImage) {
            imageTempLocation = this.kualiConfigurationService.getPropertyValueAsString("temp.directory") + "/";
            if (imageTempLocation == null) {
                throw new PurapConfigurationException("IMAGE_TEMP_PATH is missing");
            }
            logoImage = this.imageService.getLogo(key, campusCode, imageTempLocation);
            if (StringUtils.isEmpty((CharSequence)logoImage)) {
                throw new PurapConfigurationException("logoImage is null.");
            }
        }
        try {
            recBlkTicketPDF.generatePdf(blkRecDoc, baosPDF, logoImage, environment);
        }
        catch (PurapConfigurationException pce) {
            LOG.error((Object)"Caught exception ", (Throwable)pce);
            errors.add(pce.getMessage());
        }
        LOG.debug((Object)"generateBulkReceivingPDF() ended");
        return errors;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setPurchaseOrderParameters(PurchaseOrderParameters purchaseOrderParameters) {
        this.purchaseOrderParameters = purchaseOrderParameters;
    }

    public PurchaseOrderParameters getPurchaseOrderParameters() {
        return (PurchaseOrderParameters)SpringContext.getBean(PurchaseOrderParameters.class);
    }
}

