/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PurApWorkflowIntegrationService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PurApWorkflowIntegrationServiceImpl
implements PurApWorkflowIntegrationService {
    private static final Logger LOG = LogManager.getLogger(PurApWorkflowIntegrationServiceImpl.class);
    private org.kuali.kfs.krad.workflow.service.WorkflowDocumentService workflowDocumentService;
    private PersonService personService;

    public void setWorkflowDocumentService(org.kuali.kfs.krad.workflow.service.WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    protected void superUserApproveAllActionRequests(Person superUser, String documentNumber, String nodeName, Person user, String annotation) throws WorkflowException {
        block1: {
            WorkflowDocument workflowDoc = this.workflowDocumentService.loadWorkflowDocument(documentNumber, superUser);
            List<ActionRequest> actionRequests = this.getActiveActionRequestsForCriteria(documentNumber, nodeName, user);
            Iterator<ActionRequest> iterator = actionRequests.iterator();
            if (!iterator.hasNext()) break block1;
            ActionRequest actionRequestDTO = iterator.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Active Action Request list size to process is " + actionRequests.size());
                LOG.debug("Attempting to super user approve action request with id " + actionRequestDTO.getId());
            }
            ((org.kuali.rice.kew.routeheader.service.WorkflowDocumentService)SpringContext.getBean(org.kuali.rice.kew.routeheader.service.WorkflowDocumentService.class)).superUserActionRequestApproveAction(superUser.getPrincipalId(), documentNumber, actionRequestDTO.getId(), annotation, true);
        }
    }

    @Override
    public boolean takeAllActionsForGivenCriteria(Document document, String potentialAnnotation, String nodeName, Person userToCheck, String superUserNetworkId) {
        try {
            String documentNumber = document.getDocumentNumber();
            String networkIdString = ObjectUtils.isNotNull((Object)userToCheck) ? userToCheck.getPrincipalName() : "none";
            List<ActionRequest> activeActionRequests = this.getActiveActionRequestsForCriteria(documentNumber, nodeName, userToCheck);
            if (activeActionRequests.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No action requests found on document id " + documentNumber + " for given criteria:  principalName - " + networkIdString + "; nodeName - " + nodeName);
                }
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)superUserNetworkId)) {
                Person superUser = this.getPersonService().getPersonByPrincipalName(superUserNetworkId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attempting to super user approve all action requests found on document id " + documentNumber + " for given criteria:  principalName - " + networkIdString + "; nodeName - " + nodeName);
                }
                this.superUserApproveAllActionRequests(superUser, documentNumber, nodeName, userToCheck, potentialAnnotation);
                return true;
            }
            if (ObjectUtils.isNotNull((Object)userToCheck)) {
                WorkflowDocument workflowDocument = this.workflowDocumentService.loadWorkflowDocument(documentNumber, userToCheck);
                boolean containsFyiRequest = false;
                boolean containsAckRequest = false;
                boolean containsApproveRequest = false;
                boolean containsCompleteRequest = false;
                if (StringUtils.isBlank((CharSequence)nodeName)) {
                    containsCompleteRequest = workflowDocument.isCompletionRequested();
                    containsApproveRequest = workflowDocument.isApprovalRequested();
                    containsAckRequest = workflowDocument.isAcknowledgeRequested();
                    containsFyiRequest = workflowDocument.isFYIRequested();
                } else {
                    for (ActionRequest actionRequestDTO : activeActionRequests) {
                        containsFyiRequest |= "F".equals(actionRequestDTO.getActionRequested().getCode());
                        containsAckRequest |= "K".equals(actionRequestDTO.getActionRequested().getCode());
                        containsApproveRequest |= "A".equals(actionRequestDTO.getActionRequested().getCode());
                        containsCompleteRequest |= "C".equals(actionRequestDTO.getActionRequested().getCode());
                    }
                }
                if (containsCompleteRequest || containsApproveRequest) {
                    this.workflowDocumentService.approve(workflowDocument, potentialAnnotation, new ArrayList());
                    return true;
                }
                if (containsAckRequest) {
                    this.workflowDocumentService.acknowledge(workflowDocument, potentialAnnotation, new ArrayList());
                    return true;
                }
                if (containsFyiRequest) {
                    this.workflowDocumentService.clearFyi(workflowDocument, new ArrayList());
                    return true;
                }
            } else {
                String errorMessage = "No super user network id and no user to check given.  Need at least one or both";
                LOG.error(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            return false;
        }
        catch (WorkflowException e) {
            String errorMessage = "Error trying to get action requests of document id '" + document.getDocumentNumber() + "'";
            LOG.error("takeAllActionsForGivenCriteria() " + errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
        catch (Exception e) {
            String errorMessage = "Error trying to get user for network id '" + superUserNetworkId + "'";
            LOG.error("takeAllActionsForGivenCriteria() " + errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    protected List<ActionRequest> getActiveActionRequestsForCriteria(String documentNumber, String nodeName, Person user) throws WorkflowException {
        if (StringUtils.isBlank((CharSequence)documentNumber)) {
            // empty if block
        }
        WorkflowDocumentService workflowDocService = KewApiServiceLocator.getWorkflowDocumentService();
        List actionRequests = workflowDocService.getActionRequestsForPrincipalAtNode(documentNumber, nodeName, user.getPrincipalId());
        ArrayList<ActionRequest> activeRequests = new ArrayList<ActionRequest>();
        for (ActionRequest actionRequest : actionRequests) {
            if (!actionRequest.isActivated()) continue;
            activeRequests.add(actionRequest);
        }
        return activeRequests;
    }

    @Override
    public boolean willDocumentStopAtGivenFutureRouteNode(PurchasingAccountsPayableDocument document, String givenNodeName) {
        if (givenNodeName == null) {
            throw new InvalidParameterException("Given Node Detail object was null");
        }
        try {
            String[] nodeNames;
            String activeNode = null;
            Set currentNodes = document.getDocumentHeader().getWorkflowDocument().getCurrentNodeNames();
            if (CollectionUtils.isNotEmpty((Collection)currentNodes) && (nodeNames = currentNodes.toArray(new String[0])).length == 1) {
                activeNode = nodeNames[0];
            }
            if (this.isGivenNodeAfterCurrentNode((Document)document, activeNode, givenNodeName)) {
                RoutingReportCriteria.Builder builder;
                if (document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
                    builder = RoutingReportCriteria.Builder.createByDocumentTypeName((String)document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
                    builder.setXmlContent(document.getXmlForRouteReport());
                    builder.setRoutingPrincipalId(GlobalVariables.getUserSession().getPerson().getPrincipalId());
                    builder.setTargetNodeName(givenNodeName);
                    RoutingReportCriteria reportCriteria = builder.build();
                    boolean value = ((WorkflowDocumentActionsService)SpringContext.getBean(WorkflowDocumentActionsService.class)).documentWillHaveAtLeastOneActionRequest(reportCriteria, Arrays.asList("A", "C"), false);
                    return value;
                }
                builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentNumber());
                builder.setXmlContent(document.getXmlForRouteReport());
                builder.setTargetNodeName(givenNodeName);
                RoutingReportCriteria reportCriteria = builder.build();
                boolean value = ((WorkflowDocumentActionsService)SpringContext.getBean(WorkflowDocumentActionsService.class)).documentWillHaveAtLeastOneActionRequest(reportCriteria, Arrays.asList("A", "C"), false);
                return value;
            }
            return false;
        }
        catch (Exception e) {
            String errorMessage = "Error trying to test document id '" + document.getDocumentNumber() + "' for action requests at node name '" + givenNodeName + "'";
            LOG.error("isDocumentStoppingAtRouteLevel() " + errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    protected boolean isGivenNodeAfterCurrentNode(Document document, String currentNodeName, String givenNodeName) {
        if (ObjectUtils.isNull((Object)givenNodeName)) {
            return false;
        }
        if (ObjectUtils.isNull((Object)currentNodeName)) {
            return true;
        }
        List routeNodes = KewApiServiceLocator.getWorkflowDocumentService().getRouteNodeInstances(document.getDocumentNumber());
        int currentNodeIndex = 0;
        int givenNodeIndex = 0;
        RouteNodeInstance node = null;
        for (int i = 0; i < routeNodes.size(); ++i) {
            node = (RouteNodeInstance)routeNodes.get(i);
            if (node.getName().equals(currentNodeName)) {
                currentNodeIndex = i;
            }
            if (!node.getName().equals(givenNodeName)) continue;
            givenNodeIndex = i;
        }
        return givenNodeIndex > currentNodeIndex;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = (PersonService)SpringContext.getBean(PersonService.class);
        }
        return this.personService;
    }
}

