/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.BulkReceivingDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.BulkReceivingService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class BulkReceivingPurchaseOrderIdValidation
extends GenericValidation {
    private PurchaseOrderService purchaseOrderService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        BulkReceivingDocument bulkReceivingDocument = (BulkReceivingDocument)event.getDocument();
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        return this.canCreateBulkReceivingDocument(bulkReceivingDocument);
    }

    protected boolean canCreateBulkReceivingDocument(BulkReceivingDocument bulkReceivingDocument) {
        boolean valid = true;
        if (bulkReceivingDocument.getPurchaseOrderIdentifier() != null) {
            PurchaseOrderDocument po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(bulkReceivingDocument.getPurchaseOrderIdentifier());
            if (ObjectUtils.isNull((Object)po)) {
                GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.bulkReceiving.invalidPo", new String[]{bulkReceivingDocument.getDocumentNumber(), bulkReceivingDocument.getPurchaseOrderIdentifier().toString()});
                valid = false;
            } else if (!po.getApplicationDocumentStatus().equals("Open") && !po.getApplicationDocumentStatus().equals("Closed")) {
                valid = false;
                GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.bulkReceiving.purchaseOrder.notOpen", new String[]{bulkReceivingDocument.getDocumentNumber(), bulkReceivingDocument.getPurchaseOrderIdentifier().toString()});
            } else {
                String docNumberInProcess = ((BulkReceivingService)SpringContext.getBean(BulkReceivingService.class)).getBulkReceivingDocumentNumberInProcessForPurchaseOrder(po.getPurapDocumentIdentifier(), bulkReceivingDocument.getDocumentNumber());
                if (StringUtils.isNotEmpty((CharSequence)docNumberInProcess)) {
                    valid = false;
                    GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.bulkReceiving.documentActiveForPo", new String[]{docNumberInProcess, bulkReceivingDocument.getPurchaseOrderIdentifier().toString()});
                }
            }
        }
        return valid;
    }

    public PurchaseOrderService getPurchaseOrderService() {
        return this.purchaseOrderService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }
}

