/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class ItemTypeTaxPolicyValidation
extends GenericValidation {
    protected PurapService purapService;
    public static final String ERROR_INVALID_ITEM_TYPE_FOR_ACCOUNT_TAX_POLICY = "error.itemTypeCode.taxPolicy";
    public static final String FIELD_NAME_ITEM_TYPE_CODE = "itemTypeCode";

    public boolean validate(AttributedDocumentEvent event) {
        boolean isValid = true;
        PurchasingDocument purchasingDocument = (PurchasingDocument)event.getDocument();
        boolean salesTaxInd = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND");
        boolean useTaxIndicator = purchasingDocument.isUseTaxIndicator();
        boolean callCode = false;
        if (callCode && (salesTaxInd || useTaxIndicator)) {
            String errorPath = "document.items";
            GlobalVariables.getMessageMap().clearErrorPath();
            GlobalVariables.getMessageMap().addToErrorPath(errorPath);
            for (PurApItem item : purchasingDocument.getItems()) {
                if (!this.getPurapService().isItemTypeConflictWithTaxPolicy(purchasingDocument, item)) continue;
                String itemIdentifier = item.getItemIdentifierString();
                GlobalVariables.getMessageMap().putError(FIELD_NAME_ITEM_TYPE_CODE, ERROR_INVALID_ITEM_TYPE_FOR_ACCOUNT_TAX_POLICY, new String[]{itemIdentifier});
                isValid = false;
            }
        }
        return isValid;
    }

    public PurapService getPurapService() {
        return this.purapService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }
}

