/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.module.purap.businessobject.NegativePaymentRequestApprovalLimit;
import org.kuali.kfs.module.purap.document.service.NegativePaymentRequestApprovalLimitService;
import org.kuali.kfs.sys.context.SpringContext;

public class NegativePaymentRequestApprovalLimitRule
extends MaintenanceDocumentRuleBase {
    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomApproveDocumentBusinessRules(document);
        NegativePaymentRequestApprovalLimit limit = (NegativePaymentRequestApprovalLimit)((Object)this.getNewBo());
        result &= this.checkExclusiveOrganizationCodeAndAccountNumber(limit);
        if (document.isNew() || document.isNewWithExisting()) {
            result &= this.checkUniqueConstraint(limit);
        }
        return result;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomRouteDocumentBusinessRules(document);
        NegativePaymentRequestApprovalLimit limit = (NegativePaymentRequestApprovalLimit)((Object)this.getNewBo());
        result &= this.checkExclusiveOrganizationCodeAndAccountNumber(limit);
        if (document.isNew() || document.isNewWithExisting()) {
            result &= this.checkUniqueConstraint(limit);
        }
        return result;
    }

    private boolean checkUniqueConstraint(NegativePaymentRequestApprovalLimit limit) {
        Collection<NegativePaymentRequestApprovalLimit> negativePaymentRequestApprovalLimits;
        boolean result = true;
        String chartCode = limit.getChartOfAccountsCode();
        String acctNumber = limit.getAccountNumber();
        String organizationCode = limit.getOrganizationCode();
        if (!StringUtils.isBlank((CharSequence)organizationCode)) {
            Collection<NegativePaymentRequestApprovalLimit> negativePaymentRequestApprovalLimits2 = ((NegativePaymentRequestApprovalLimitService)SpringContext.getBean(NegativePaymentRequestApprovalLimitService.class)).findByChartAndOrganization(chartCode, organizationCode);
            if (negativePaymentRequestApprovalLimits2.size() > 0) {
                this.putFieldError("organizationCode", "error.negativePaymentRequestApprovalLimit.organizationAndAccountUniqueEntry", new String[0]);
                result = false;
            }
        } else if (!StringUtils.isBlank((CharSequence)acctNumber) && (negativePaymentRequestApprovalLimits = ((NegativePaymentRequestApprovalLimitService)SpringContext.getBean(NegativePaymentRequestApprovalLimitService.class)).findByChartAndAccount(chartCode, acctNumber)).size() > 0) {
            this.putFieldError("accountNumber", "error.negativePaymentRequestApprovalLimit.organizationAndAccountUniqueEntry", new String[0]);
            result = false;
        }
        return result;
    }

    protected boolean checkExclusiveOrganizationCodeAndAccountNumber(NegativePaymentRequestApprovalLimit limit) {
        if (!StringUtils.isBlank((CharSequence)limit.getOrganizationCode()) && !StringUtils.isBlank((CharSequence)limit.getAccountNumber())) {
            this.putFieldError("organizationCode", "error.negativePaymentRequestApprovalLimit.organizationAndAccountMutuallyExclusive", new String[0]);
            this.putFieldError("accountNumber", "error.negativePaymentRequestApprovalLimit.organizationAndAccountMutuallyExclusive", new String[0]);
            return false;
        }
        return true;
    }
}

