/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderTransmissionMethod;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.sys.context.SpringContext;

public class PurchaseOrderTransmissionMethodRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger(PurchaseOrderTransmissionMethodRule.class);

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomApproveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence();
        return success && super.processCustomApproveDocumentBusinessRules(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomRouteDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence();
        return success && super.processCustomRouteDocumentBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomSaveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence();
        return success && super.processCustomSaveDocumentBusinessRules(document);
    }

    protected boolean checkForSystemParametersExistence() {
        LOG.info("checkForSystemParametersExistence called");
        boolean success = true;
        ArrayList defaultParameterValues = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(RequisitionDocument.class, "DEFAULT_METHOD_OF_PO_TRANSMISSION"));
        ArrayList retransmitParameterValues = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PurchaseOrderDocument.class, "RETRANSMIT_TRANSMISSION_METHOD_TYPES"));
        PurchaseOrderTransmissionMethod newBo = (PurchaseOrderTransmissionMethod)((Object)this.getNewBo());
        PurchaseOrderTransmissionMethod oldBo = (PurchaseOrderTransmissionMethod)((Object)this.getOldBo());
        if ((defaultParameterValues.contains(newBo.getPurchaseOrderTransmissionMethodCode()) || retransmitParameterValues.contains(newBo.getPurchaseOrderTransmissionMethodCode())) && !newBo.isActive() && oldBo.isActive()) {
            success = false;
            String documentLabel = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentLabelByTypeName("PMTM");
            this.putGlobalError("error.document.cannot.inactivate.used.in.system.parameters", documentLabel);
        }
        return success;
    }
}

