/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;

public class PurchasingAccountsPayableErrorPathUtil {
    private static final Logger LOG = LogManager.getLogger(PurchasingAccountsPayableErrorPathUtil.class);

    public static void fixErrorPath(AccountingDocument financialDocument, AccountingLine accountingLine) {
        List<PurApItem> items = ((PurchasingAccountsPayableDocument)financialDocument).getItems();
        if (accountingLine.isSourceAccountingLine()) {
            PurApAccountingLine targetAccountingLineToBeFound = (PurApAccountingLine)accountingLine;
            String errorPath = "document";
            boolean done = false;
            int itemLineIndex = 0;
            Iterator<PurApItem> iterItemEntries = items.iterator();
            while (!done && iterItemEntries.hasNext()) {
                PurApItem item = iterItemEntries.next();
                int accountingLineCounter = 0;
                Iterator<PurApAccountingLine> iterSourceAccountingLines = item.getSourceAccountingLines().iterator();
                while (!done && iterSourceAccountingLines.hasNext()) {
                    PurApAccountingLine sourceAccountingLine = iterSourceAccountingLines.next();
                    if (targetAccountingLineToBeFound.getSequenceNumber().equals(sourceAccountingLine.getSequenceNumber())) {
                        errorPath = errorPath + "." + "item" + "[" + itemLineIndex + "]." + "sourceAccountingLines" + "[" + accountingLineCounter + "]";
                        done = true;
                    }
                    ++accountingLineCounter;
                }
                ++itemLineIndex;
            }
            if (!done) {
                LOG.warn("fixErrorPath failed to locate item accountingLine=" + accountingLine.toString());
            }
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.clearErrorPath();
            errorMap.addToErrorPath(errorPath);
        }
    }
}

