/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Date;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class PurchasingPaymentInfoValidation
extends GenericValidation {
    DateTimeService dateTimeService;
    UniversityDateService universityDateService;

    public boolean validate(AttributedDocumentEvent event) {
        PurchasingDocument purDocument = (PurchasingDocument)event.getDocument();
        GlobalVariables.getMessageMap().addToErrorPath("document.paymentInfo");
        boolean valid = this.checkBeginDateBeforeEndDate(purDocument);
        if (valid && (ObjectUtils.isNotNull((Object)purDocument.getPurchaseOrderBeginDate()) || ObjectUtils.isNotNull((Object)purDocument.getPurchaseOrderEndDate()))) {
            if (ObjectUtils.isNotNull((Object)purDocument.getPurchaseOrderBeginDate()) && ObjectUtils.isNull((Object)purDocument.getPurchaseOrderEndDate())) {
                GlobalVariables.getMessageMap().putError("purchaseOrderEndDate", "error.purchaseOrder.beginDateNoEndDate", new String[0]);
                valid = false;
            } else if (ObjectUtils.isNull((Object)purDocument.getPurchaseOrderBeginDate()) && ObjectUtils.isNotNull((Object)purDocument.getPurchaseOrderEndDate())) {
                GlobalVariables.getMessageMap().putError("purchaseOrderBeginDate", "error.purchaseOrder.endDateNoBeginDate", new String[0]);
                valid = false;
            }
        }
        if (valid && ObjectUtils.isNotNull((Object)purDocument.getPurchaseOrderBeginDate()) && ObjectUtils.isNotNull((Object)purDocument.getPurchaseOrderEndDate())) {
            if (ObjectUtils.isNull((Object)purDocument.getRecurringPaymentTypeCode())) {
                GlobalVariables.getMessageMap().putError("recurringPaymentTypeCode", "errors.recurring.type", new String[0]);
                valid = false;
            }
        } else if (valid && ObjectUtils.isNotNull((Object)purDocument.getRecurringPaymentTypeCode())) {
            GlobalVariables.getMessageMap().putError("purchaseOrderBeginDate", "errors.recurring.dates", new String[0]);
            valid = false;
        }
        if (purDocument.isPostingYearNext()) {
            Integer currentFY = this.universityDateService.getCurrentFiscalYear();
            Date closingDate = this.universityDateService.getLastDateOfFiscalYear(currentFY);
            if (ObjectUtils.isNotNull((Object)purDocument.getPurchaseOrderBeginDate()) && (purDocument.getPurchaseOrderBeginDate().before(closingDate) || purDocument.getPurchaseOrderBeginDate().equals(closingDate))) {
                GlobalVariables.getMessageMap().putError("purchaseOrderBeginDate", "error.nextFY.beginDate.invalid", new String[0]);
                valid = false;
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document.paymentInfo");
        return valid;
    }

    protected boolean checkBeginDateBeforeEndDate(PurchasingDocument purDocument) {
        boolean valid = true;
        java.sql.Date beginDate = purDocument.getPurchaseOrderBeginDate();
        java.sql.Date endDate = purDocument.getPurchaseOrderEndDate();
        if (ObjectUtils.isNotNull((Object)beginDate) && ObjectUtils.isNotNull((Object)endDate) && this.dateTimeService.dateDiff((Date)beginDate, (Date)endDate, false) <= 0) {
            valid = false;
            GlobalVariables.getMessageMap().putError("purchaseOrderEndDate", "error.purchaseOrder.beginDateAfterEnd", new String[0]);
        }
        return valid;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }
}

