/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.sql.Date;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocumentBase;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableProcessVendorValidation;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.PostalCodeValidationService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorContract;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.businessobject.VendorHeader;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class PurchasingProcessVendorValidation
extends PurchasingAccountsPayableProcessVendorValidation {
    private VendorService vendorService;
    private ParameterService parameterService;
    private PostalCodeValidationService postalCodeValidationService;

    @Override
    public boolean validate(AttributedDocumentEvent event) {
        ArrayList allowedVendorTypes;
        VendorDetail vendorDetail;
        PurchasingDocument purDocument = (PurchasingDocument)event.getDocument();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.clearErrorPath();
        errorMap.addToErrorPath("document.vendor*,document.purchaseOrderVendorChoiceCode,document.alternateVendorName,document.shipmentReceivedDate,document.vendorContractEndDate");
        boolean valid = super.validate(event);
        if (!purDocument.getRequisitionSourceCode().equals("B2B") && purDocument.getVendorHeaderGeneratedIdentifier() != null && purDocument.getPurchaseOrderTransmissionMethodCode().equals("FAX") && StringUtils.isBlank((CharSequence)purDocument.getVendorFaxNumber())) {
            valid = false;
            String attributeLabel = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(VendorAddress.class.getName()).getAttributeDefinition("vendorFaxNumber").getLabel();
            errorMap.putError("vendorFaxNumber", "error.required", new String[]{attributeLabel});
        }
        if (ObjectUtils.isNull((Object)(vendorDetail = this.vendorService.getVendorDetail(purDocument.getVendorHeaderGeneratedIdentifier(), purDocument.getVendorDetailAssignedIdentifier())))) {
            return valid;
        }
        VendorHeader vendorHeader = vendorDetail.getVendorHeader();
        if (vendorDetail.isVendorDebarred()) {
            if (this.parameterService.getParameterValueAsBoolean("KFS-PURAP", "Requisition", "SHOW_DEBARRED_VENDOR_WARNING_IND").booleanValue()) {
                if (StringUtils.isEmpty((CharSequence)((PurchasingDocumentBase)purDocument).getJustification())) {
                    errorMap.putWarning("vendorName", "warning.debarred.vendor", new String[]{vendorDetail.getVendorName()});
                    valid = false;
                }
            } else {
                errorMap.putError("vendorName", "error.debarred.vendor", new String[0]);
                valid = false;
            }
        }
        if (!(allowedVendorTypes = new ArrayList(this.parameterService.getParameterValuesAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "REQ_AND_PO_VENDOR_TYPES"))).isEmpty() && ObjectUtils.isNotNull((Object)vendorHeader) && ObjectUtils.isNotNull((Object)vendorHeader.getVendorTypeCode()) && !allowedVendorTypes.contains(vendorHeader.getVendorTypeCode())) {
            valid = false;
            errorMap.putError("vendorName", "error.vendorType.invalid", new String[0]);
        }
        if (!vendorDetail.isActiveIndicator()) {
            valid = false;
            errorMap.putError("vendorName", "error.inactive.vendor", new String[0]);
        }
        if (ObjectUtils.isNotNull((Object)purDocument.getVendorContractGeneratedIdentifier())) {
            VendorContract vendorContract = (VendorContract)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findBySinglePrimaryKey(VendorContract.class, (Object)purDocument.getVendorContractGeneratedIdentifier());
            Date currentDate = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
            if (currentDate.compareTo(vendorContract.getVendorContractEndDate()) > 0 || !vendorContract.isActive()) {
                valid = false;
                errorMap.putError("vendorContractName", "error.inactive.or.expired.vendor.contract", new String[0]);
            }
        }
        this.postalCodeValidationService.validateAddress(purDocument.getVendorCountryCode(), purDocument.getVendorStateCode(), purDocument.getVendorPostalCode(), "vendorStateCode", "vendorPostalCode");
        errorMap.clearErrorPath();
        return valid;
    }

    public VendorService getVendorService() {
        return this.vendorService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public PostalCodeValidationService getPostalCodeValidationService() {
        return this.postalCodeValidationService;
    }

    public void setPostalCodeValidationService(PostalCodeValidationService postalCodeValidationService) {
        this.postalCodeValidationService = postalCodeValidationService;
    }
}

