/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class VendorCreditMemoPurchaseOrderForInvoicedItemsValidation
extends GenericValidation {
    private PurchaseOrderService purchaseOrderService;
    private CreditMemoService creditMemoService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean hasInvoicedItems = true;
        VendorCreditMemoDocument cmDocument = (VendorCreditMemoDocument)event.getDocument();
        if (cmDocument.isSourceDocumentPurchaseOrder()) {
            GlobalVariables.getMessageMap().clearErrorPath();
            GlobalVariables.getMessageMap().addToErrorPath("document");
            PurchaseOrderDocument poDocument = this.purchaseOrderService.getCurrentPurchaseOrder(cmDocument.getPurchaseOrderIdentifier());
            List<PurchaseOrderItem> invoicedItems = this.creditMemoService.getPOInvoicedItems(poDocument);
            if (invoicedItems == null || invoicedItems.isEmpty()) {
                GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.creditMemo.po.noItems", new String[0]);
                hasInvoicedItems = false;
            }
            GlobalVariables.getMessageMap().clearErrorPath();
        }
        return hasInvoicedItems;
    }

    public PurchaseOrderService getPurchaseOrderService() {
        return this.purchaseOrderService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public CreditMemoService getCreditMemoService() {
        return this.creditMemoService;
    }

    public void setCreditMemoService(CreditMemoService creditMemoService) {
        this.creditMemoService = creditMemoService;
    }
}

