/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.action.KualiTransactionalDocumentActionBase;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.BulkReceivingDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.BulkReceivingService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.web.struts.BulkReceivingForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.kfs.vnd.service.PhoneNumberService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.BusinessObject;

public class BulkReceivingAction
extends KualiTransactionalDocumentActionBase {
    protected static final Logger LOG = LogManager.getLogger(BulkReceivingAction.class);

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        BulkReceivingForm blkForm = (BulkReceivingForm)kualiDocumentFormBase;
        BulkReceivingDocument blkRecDoc = (BulkReceivingDocument)blkForm.getDocument();
        blkRecDoc.setPurchaseOrderIdentifier(blkForm.getPurchaseOrderId());
        blkRecDoc.initiateDocument();
    }

    public ActionForward continueBulkReceiving(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        BulkReceivingForm blkForm = (BulkReceivingForm)form;
        BulkReceivingDocument blkRecDoc = (BulkReceivingDocument)blkForm.getDocument();
        PurchaseOrderDocument po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(blkRecDoc.getPurchaseOrderIdentifier());
        if (ObjectUtils.isNotNull((Object)po)) {
            blkRecDoc.setAccountsPayablePurchasingDocumentLinkIdentifier(po.getAccountsPayablePurchasingDocumentLinkIdentifier());
            if (!((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)blkRecDoc).isAuthorizedByTemplate((BusinessObject)blkRecDoc, "KR-NS", "Open Document", GlobalVariables.getUserSession().getPrincipalId())) {
                throw this.buildAuthorizationException("initiate document", (Document)blkRecDoc);
            }
        }
        if ((forward = this.isDuplicateDocumentEntry(mapping, form, request, response, blkRecDoc)) != null) {
            return forward;
        }
        ((BulkReceivingService)SpringContext.getBean(BulkReceivingService.class)).populateAndSaveBulkReceivingDocument(blkRecDoc);
        return mapping.findForward("basic");
    }

    public ActionForward clearInitFields(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BulkReceivingForm blkRecForm = (BulkReceivingForm)form;
        BulkReceivingDocument blkRecDoc = (BulkReceivingDocument)blkRecForm.getDocument();
        blkRecDoc.clearInitFields();
        return mapping.findForward("basic");
    }

    protected ActionForward isDuplicateDocumentEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, BulkReceivingDocument bulkReceivingDocument) throws Exception {
        ActionForward forward = null;
        HashMap<String, String> duplicateMessages = ((BulkReceivingService)SpringContext.getBean(BulkReceivingService.class)).bulkReceivingDuplicateMessages(bulkReceivingDocument);
        if (duplicateMessages != null && !duplicateMessages.isEmpty()) {
            String question = request.getParameter("questionIndex");
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "DuplicateBulkReceiving", duplicateMessages.get("DuplicateBulkReceiving"), "cf.confirmationQuestion", "route", "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if ("DuplicateBulkReceiving".equals(question) && "1".equals(buttonClicked)) {
                forward = mapping.findForward("basic");
            }
        }
        return forward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward printReceivingTicketPDF(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BulkReceivingForm blkRecForm = (BulkReceivingForm)form;
        String docId = blkRecForm.getDocId();
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        try {
            StringBuffer sbFilename = new StringBuffer();
            sbFilename.append("PURAP_RECEIVING_TICKET_");
            sbFilename.append(docId);
            sbFilename.append("_");
            sbFilename.append(System.currentTimeMillis());
            ((BulkReceivingService)SpringContext.getBean(BulkReceivingService.class)).performPrintReceivingTicketPDF(docId, baosPDF);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baosPDF, (String)sbFilename.toString());
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
        return null;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BulkReceivingForm blkRecForm = (BulkReceivingForm)form;
        BulkReceivingDocument blkRecDoc = (BulkReceivingDocument)blkRecForm.getDocument();
        String refreshCaller = blkRecForm.getRefreshCaller();
        PhoneNumberService phoneNumberService = (PhoneNumberService)SpringContext.getBean(PhoneNumberService.class);
        blkRecDoc.setInstitutionContactPhoneNumber(phoneNumberService.formatNumberIfPossible(blkRecDoc.getInstitutionContactPhoneNumber()));
        blkRecDoc.setRequestorPersonPhoneNumber(phoneNumberService.formatNumberIfPossible(blkRecDoc.getRequestorPersonPhoneNumber()));
        blkRecDoc.setDeliveryToPhoneNumber(phoneNumberService.formatNumberIfPossible(blkRecDoc.getDeliveryToPhoneNumber()));
        if (StringUtils.equals((CharSequence)refreshCaller, (CharSequence)"vendorLookupable") && blkRecDoc.getVendorDetailAssignedIdentifier() != null && blkRecDoc.getVendorHeaderGeneratedIdentifier() != null) {
            blkRecDoc.refreshReferenceObject("vendorDetail");
            blkRecDoc.setVendorName(blkRecDoc.getVendorDetail().getVendorName());
            VendorAddress defaultAddress = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDefaultAddress((Collection)blkRecDoc.getVendorDetail().getVendorAddresses(), blkRecDoc.getVendorDetail().getVendorHeader().getVendorType().getAddressType().getVendorAddressTypeCode(), "");
            if (ObjectUtils.isNotNull((Object)defaultAddress)) {
                blkRecDoc.setVendorLine1Address(defaultAddress.getVendorLine1Address());
                blkRecDoc.setVendorLine2Address(defaultAddress.getVendorLine2Address());
                blkRecDoc.setVendorCityName(defaultAddress.getVendorCityName());
                blkRecDoc.setVendorStateCode(defaultAddress.getVendorStateCode());
                blkRecDoc.setVendorPostalCode(defaultAddress.getVendorZipCode());
                blkRecDoc.setVendorCountryCode(defaultAddress.getVendorCountryCode());
            }
        }
        if (StringUtils.equals((CharSequence)refreshCaller, (CharSequence)"vendorAddressLookupable") && StringUtils.isNotEmpty((CharSequence)request.getParameter("document.vendorAddressGeneratedIdentifier"))) {
            VendorAddress refreshVendorAddress = new VendorAddress();
            refreshVendorAddress.setVendorAddressGeneratedIdentifier(blkRecDoc.getVendorAddressGeneratedIdentifier());
            refreshVendorAddress = (VendorAddress)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).retrieve((PersistableBusinessObject)refreshVendorAddress);
            if (ObjectUtils.isNotNull((Object)refreshVendorAddress)) {
                blkRecDoc.setVendorLine1Address(refreshVendorAddress.getVendorLine1Address());
                blkRecDoc.setVendorLine2Address(refreshVendorAddress.getVendorLine2Address());
                blkRecDoc.setVendorCityName(refreshVendorAddress.getVendorCityName());
                blkRecDoc.setVendorStateCode(refreshVendorAddress.getVendorStateCode());
                blkRecDoc.setVendorPostalCode(refreshVendorAddress.getVendorZipCode());
                blkRecDoc.setVendorCountryCode(refreshVendorAddress.getVendorCountryCode());
            }
        }
        if (StringUtils.equals((CharSequence)refreshCaller, (CharSequence)"cf.kualiLookupable") && request.getParameter("document.deliveryCampusCode") != null) {
            if (request.getParameter("document.deliveryBuildingName") == null) {
                blkRecDoc.setDeliveryBuildingCode("");
                blkRecDoc.setDeliveryBuildingLine1Address("");
                blkRecDoc.setDeliveryBuildingLine2Address("");
                blkRecDoc.setDeliveryBuildingRoomNumber("");
                blkRecDoc.setDeliveryCityName("");
                blkRecDoc.setDeliveryStateCode("");
                blkRecDoc.setDeliveryPostalCode("");
                blkRecDoc.setDeliveryCountryCode("");
            } else {
                blkRecDoc.setDeliveryBuildingOtherIndicator(false);
                blkRecDoc.setDeliveryBuildingRoomNumber("");
                blkRecDoc.setDeliveryBuildingLine2Address("");
            }
        }
        return super.refresh(mapping, form, request, response);
    }

    public ActionForward useOtherDeliveryBuilding(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BulkReceivingForm baseForm = (BulkReceivingForm)form;
        BulkReceivingDocument document = (BulkReceivingDocument)baseForm.getDocument();
        document.setDeliveryBuildingOtherIndicator(true);
        document.setDeliveryBuildingName("");
        document.setDeliveryBuildingCode("");
        document.setDeliveryBuildingLine1Address("");
        document.setDeliveryBuildingLine2Address("");
        document.setDeliveryBuildingRoomNumber("");
        document.setDeliveryCityName("");
        document.setDeliveryStateCode("");
        document.setDeliveryCountryCode("");
        document.setDeliveryPostalCode("");
        return mapping.findForward("basic");
    }

    protected void populateAdHocActionRequestCodes(KualiDocumentFormBase formBase) {
        Document document = formBase.getDocument();
        DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
        HashMap<String, String> adHocActionRequestCodes = new HashMap<String, String>();
        if (documentAuthorizer.canSendAdHocRequests(document, "F", GlobalVariables.getUserSession().getPerson())) {
            adHocActionRequestCodes.put("F", "FYI");
        }
        if ((document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved() || document.getDocumentHeader().getWorkflowDocument().isEnroute()) && documentAuthorizer.canSendAdHocRequests(document, "K", GlobalVariables.getUserSession().getPerson())) {
            adHocActionRequestCodes.put("K", "ACKNOWLEDGE");
        }
        formBase.setAdHocActionRequestCodes(adHocActionRequestCodes);
    }
}

