/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.purap.businessobject.LineItemReceivingItem;
import org.kuali.kfs.module.purap.document.LineItemReceivingDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.ReceivingDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.ReceivingService;
import org.kuali.kfs.module.purap.document.validation.event.AddReceivingItemEvent;
import org.kuali.kfs.module.purap.document.web.struts.LineItemReceivingForm;
import org.kuali.kfs.module.purap.document.web.struts.ReceivingBaseAction;
import org.kuali.kfs.module.purap.util.ReceivingQuestionCallback;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.BusinessObject;

public class LineItemReceivingAction
extends ReceivingBaseAction {
    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        LineItemReceivingForm rlf = (LineItemReceivingForm)kualiDocumentFormBase;
        LineItemReceivingDocument rlDoc = (LineItemReceivingDocument)rlf.getDocument();
        rlDoc.setPurchaseOrderIdentifier(rlf.getPurchaseOrderId());
        rlDoc.initiateDocument();
    }

    public ActionForward continueReceivingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LineItemReceivingForm rlf = (LineItemReceivingForm)form;
        LineItemReceivingDocument rlDoc = (LineItemReceivingDocument)rlf.getDocument();
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        boolean valid = true;
        boolean poNotNull = true;
        if (ObjectUtils.isNull((Object)rlDoc.getPurchaseOrderIdentifier())) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.required", new String[]{"Purchase Order Identifier"});
            poNotNull = false;
        }
        if (ObjectUtils.isNull((Object)rlDoc.getShipmentReceivedDate())) {
            GlobalVariables.getMessageMap().putError("shipmentReceivedDate", "error.required", new String[]{"Vendor Date"});
        }
        if (!poNotNull) {
            return mapping.findForward("basic");
        }
        PurchaseOrderDocument po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(rlDoc.getPurchaseOrderIdentifier());
        if (ObjectUtils.isNotNull((Object)po)) {
            rlDoc.setAccountsPayablePurchasingDocumentLinkIdentifier(po.getAccountsPayablePurchasingDocumentLinkIdentifier());
            if (!((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)rlDoc).isAuthorizedByTemplate((BusinessObject)rlDoc, "KR-NS", "Open Document", GlobalVariables.getUserSession().getPrincipalId())) {
                throw this.buildAuthorizationException("initiate document", (Document)rlDoc);
            }
        } else {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.invoice.purchaseOrder.notExist", new String[0]);
            return mapping.findForward("basic");
        }
        ActionForward forward = this.performDuplicateReceivingLineCheck(mapping, form, request, response, rlDoc);
        if (forward != null) {
            return forward;
        }
        if (!((ReceivingService)SpringContext.getBean(ReceivingService.class)).isPurchaseOrderActiveForLineItemReceivingDocumentCreation(rlDoc.getPurchaseOrderIdentifier())) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.receivingLine.poNotActive", new String[]{rlDoc.getPurchaseOrderIdentifier().toString()});
            valid &= false;
        }
        if (!((ReceivingService)SpringContext.getBean(ReceivingService.class)).canCreateLineItemReceivingDocument(rlDoc.getPurchaseOrderIdentifier(), rlDoc.getDocumentNumber())) {
            String inProcessDocNum = "";
            List<String> inProcessDocNumbers = ((ReceivingService)SpringContext.getBean(ReceivingService.class)).getLineItemReceivingDocumentNumbersInProcessForPurchaseOrder(rlDoc.getPurchaseOrderIdentifier(), rlDoc.getDocumentNumber());
            if (!inProcessDocNumbers.isEmpty()) {
                inProcessDocNum = inProcessDocNumbers.get(0);
            }
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.receivingLine.documentActiveForPo", new String[]{inProcessDocNum, rlDoc.getPurchaseOrderIdentifier().toString()});
            valid &= false;
        }
        if (valid) {
            ((ReceivingService)SpringContext.getBean(ReceivingService.class)).populateAndSaveLineItemReceivingDocument(rlDoc);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createReceivingCorrection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LineItemReceivingForm rlForm = (LineItemReceivingForm)form;
        LineItemReceivingDocument document = (LineItemReceivingDocument)rlForm.getDocument();
        String operation = "AddCorrectionNote ";
        ReceivingQuestionCallback callback = new ReceivingQuestionCallback(){
            public boolean questionComplete = false;
            protected String correctionDocumentnoteText;

            @Override
            public ReceivingDocument doPostQuestion(ReceivingDocument document, String noteText) throws Exception {
                this.setQuestionComplete(true);
                this.setCorrectionDocumentCreationNoteText(noteText);
                return document;
            }

            @Override
            public boolean isQuestionComplete() {
                return this.questionComplete;
            }

            @Override
            public void setQuestionComplete(boolean questionComplete) {
                this.questionComplete = questionComplete;
            }

            @Override
            public String getCorrectionDocumentCreationNoteText() {
                return this.correctionDocumentnoteText;
            }

            @Override
            public void setCorrectionDocumentCreationNoteText(String noteText) {
                this.correctionDocumentnoteText = noteText;
            }
        };
        ActionForward forward = this.askQuestionWithInput(mapping, form, request, response, "CorrectionReceivingNote", "Note entered while creating Correction Receiving: ", operation, "message.receiving.correction.note", callback);
        if (callback.isQuestionComplete()) {
            String basePath = LineItemReceivingAction.getApplicationBaseUrl();
            String methodToCallDocHandler = "docHandler";
            String methodToCallReceivingCorrection = "initiate";
            Properties parameters = new Properties();
            parameters.put("methodToCall", methodToCallDocHandler);
            parameters.put("command", methodToCallReceivingCorrection);
            parameters.put("docTypeName", "RCVC");
            parameters.put("receivingLineDocId", document.getDocumentHeader().getDocumentNumber());
            parameters.put("CorrectionReceivingNoteParameter", callback.getCorrectionDocumentCreationNoteText());
            String receivingCorrectionUrl = UrlFactory.parameterizeUrl((String)(basePath + "/purapCorrectionReceiving.do"), (Properties)parameters);
            forward = new ActionForward(receivingCorrectionUrl, true);
        }
        return forward;
    }

    public ActionForward clearInitFields(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LineItemReceivingForm rlForm = (LineItemReceivingForm)form;
        LineItemReceivingDocument rlDocument = (LineItemReceivingDocument)rlForm.getDocument();
        rlDocument.clearInitFields(rlForm.isFromPurchaseOrder());
        return mapping.findForward("basic");
    }

    protected ActionForward performDuplicateReceivingLineCheck(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, LineItemReceivingDocument lineItemReceivingDocument) throws Exception {
        ActionForward forward = null;
        HashMap<String, String> duplicateMessages = ((ReceivingService)SpringContext.getBean(ReceivingService.class)).receivingLineDuplicateMessages(lineItemReceivingDocument);
        if (duplicateMessages != null && !duplicateMessages.isEmpty()) {
            String question = request.getParameter("questionIndex");
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "DuplicateReceivingLine", duplicateMessages.get("DuplicateReceivingLine"), "cf.confirmationQuestion", "route", "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if ("DuplicateReceivingLine".equals(question) && "1".equals(buttonClicked)) {
                forward = mapping.findForward("basic");
            }
        }
        return forward;
    }

    public ActionForward addItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LineItemReceivingForm lineItemReceivingForm = (LineItemReceivingForm)form;
        LineItemReceivingItem item = lineItemReceivingForm.getNewLineItemReceivingItemLine();
        LineItemReceivingDocument lineItemReceivingDocument = (LineItemReceivingDocument)lineItemReceivingForm.getDocument();
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AddReceivingItemEvent("newLineItemReceivingItemLine", (Document)lineItemReceivingDocument, item));
        if (rulePassed) {
            lineItemReceivingForm.setHideAddUnorderedItem(true);
            item = lineItemReceivingForm.getAndResetNewReceivingItemLine();
            lineItemReceivingDocument.addItem(item);
        }
        return mapping.findForward("basic");
    }

    public ActionForward clearQty(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LineItemReceivingForm lineItemReceivingForm = (LineItemReceivingForm)form;
        LineItemReceivingDocument lineItemReceivingDocument = (LineItemReceivingDocument)lineItemReceivingForm.getDocument();
        for (LineItemReceivingItem item : lineItemReceivingDocument.getItems()) {
            item.setItemReceivedTotalQuantity(KualiDecimal.ZERO);
        }
        return mapping.findForward("basic");
    }

    public ActionForward loadQty(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LineItemReceivingForm lineItemReceivingForm = (LineItemReceivingForm)form;
        LineItemReceivingDocument lineItemReceivingDocument = (LineItemReceivingDocument)lineItemReceivingForm.getDocument();
        for (LineItemReceivingItem item : lineItemReceivingDocument.getItems()) {
            if (!item.isOrderedItem()) continue;
            if (((KualiDecimal)item.getItemOrderedQuantity().subtract((AbstractKualiDecimal)item.getItemReceivedPriorQuantity())).isGreaterEqual((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                item.setItemReceivedTotalQuantity((KualiDecimal)item.getItemOrderedQuantity().subtract((AbstractKualiDecimal)item.getItemReceivedPriorQuantity()));
                continue;
            }
            item.setItemReceivedTotalQuantity(KualiDecimal.ZERO);
        }
        return mapping.findForward("basic");
    }

    public ActionForward showAddUnorderedItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LineItemReceivingForm lineItemReceivingForm = (LineItemReceivingForm)form;
        boolean shouldGiveWarning = lineItemReceivingForm.shouldGiveAddUnorderedItemWarning();
        if (!shouldGiveWarning) {
            lineItemReceivingForm.setHideAddUnorderedItem(false);
            return mapping.findForward("basic");
        }
        String msgkey = "warning.receiving.lineitem.add.unordered";
        String msgtxt = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString(msgkey);
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, msgkey, msgtxt, "cf.confirmationQuestion", "showAddUnorderedItem", "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if (msgkey.equals(question) && "0".equals(buttonClicked)) {
            lineItemReceivingForm.setHideAddUnorderedItem(false);
        }
        return mapping.findForward("basic");
    }
}

