/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.kns.web.ui.HeaderField;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestView;
import org.kuali.kfs.module.purap.businessobject.PurApGenericAttributes;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderCapitalAssetLocation;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItemCapitalAsset;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorStipulation;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignment;
import org.kuali.kfs.module.purap.document.PurchaseOrderAmendmentDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderSplitDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.ReceivingService;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingFormBase;
import org.kuali.kfs.module.purap.util.PurApItemUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.DocumentStatusCategory;
import org.kuali.rice.kim.api.services.IdentityManagementService;

public class PurchaseOrderForm
extends PurchasingFormBase {
    protected PurchaseOrderVendorStipulation newPurchaseOrderVendorStipulationLine;
    protected PurchaseOrderVendorQuote newPurchaseOrderVendorQuote;
    protected Long awardedVendorNumber;
    protected boolean purchaseOrderPrintRequested;
    protected String[] retransmitItemsSelected = new String[0];
    protected String retransmitTransmissionMethod;
    protected String retransmitFaxNumber;
    protected String retransmitHeader;
    protected Map accountingLineEditingMode;
    protected String splitNoteText;
    protected String sensitiveDataAssignmentReason = null;
    protected SensitiveDataAssignment lastSensitiveDataAssignment = null;
    protected SensitiveData newSensitiveDataLine = null;
    protected List<SensitiveData> sensitiveDatasAssigned = null;
    protected final String PURCHASING_PROCESSOR_ROLE_NAME = "Purchasing Processor";

    public PurchaseOrderForm() {
        this.setNewPurchaseOrderVendorStipulationLine(new PurchaseOrderVendorStipulation());
        this.setNewPurchaseOrderVendorQuote(new PurchaseOrderVendorQuote());
        this.accountingLineEditingMode = new HashMap();
        this.setReadOnlyAccountDistributionMethod(true);
    }

    protected String getDefaultDocumentTypeName() {
        return "PO";
    }

    public Map getAccountingLineEditingMode() {
        return this.accountingLineEditingMode;
    }

    public void setAccountingLineEditingMode(Map accountingLineEditingMode) {
        this.accountingLineEditingMode = accountingLineEditingMode;
    }

    public Long getAwardedVendorNumber() {
        return this.awardedVendorNumber;
    }

    public void setAwardedVendorNumber(Long awardedVendorNumber) {
        this.awardedVendorNumber = awardedVendorNumber;
    }

    public PurchaseOrderVendorStipulation getNewPurchaseOrderVendorStipulationLine() {
        return this.newPurchaseOrderVendorStipulationLine;
    }

    public void setNewPurchaseOrderVendorStipulationLine(PurchaseOrderVendorStipulation newPurchaseOrderVendorStipulationLine) {
        this.newPurchaseOrderVendorStipulationLine = newPurchaseOrderVendorStipulationLine;
    }

    public PurchaseOrderVendorQuote getNewPurchaseOrderVendorQuote() {
        return this.newPurchaseOrderVendorQuote;
    }

    public void setNewPurchaseOrderVendorQuote(PurchaseOrderVendorQuote newPurchaseOrderVendorQuote) {
        this.newPurchaseOrderVendorQuote = newPurchaseOrderVendorQuote;
    }

    public String[] getRetransmitItemsSelected() {
        return this.retransmitItemsSelected;
    }

    public void setRetransmitItemsSelected(String[] retransmitItemsSelected) {
        this.retransmitItemsSelected = retransmitItemsSelected;
    }

    public PurchaseOrderDocument getPurchaseOrderDocument() {
        return (PurchaseOrderDocument)this.getDocument();
    }

    public void setPurchaseOrderDocument(PurchaseOrderDocument purchaseOrderDocument) {
        this.setDocument((Document)purchaseOrderDocument);
    }

    public String getSplitNoteText() {
        return this.splitNoteText;
    }

    public void setSplitNoteText(String splitNoteText) {
        this.splitNoteText = splitNoteText;
    }

    public String getSensitiveDataAssignmentReason() {
        return this.sensitiveDataAssignmentReason;
    }

    public void setSensitiveDataAssignmentReason(String sensitiveDataAssignmentReason) {
        this.sensitiveDataAssignmentReason = sensitiveDataAssignmentReason;
    }

    public SensitiveDataAssignment getLastSensitiveDataAssignment() {
        return this.lastSensitiveDataAssignment;
    }

    public void setLastSensitiveDataAssignment(SensitiveDataAssignment lastSensitiveDataAssignment) {
        this.lastSensitiveDataAssignment = lastSensitiveDataAssignment;
    }

    public SensitiveData getNewSensitiveDataLine() {
        return this.newSensitiveDataLine;
    }

    public void setNewSensitiveDataLine(SensitiveData newSensitiveDataLine) {
        this.newSensitiveDataLine = newSensitiveDataLine;
    }

    public List<SensitiveData> getSensitiveDatasAssigned() {
        return this.sensitiveDatasAssigned;
    }

    public void setSensitiveDatasAssigned(List<SensitiveData> poSensitiveData) {
        this.sensitiveDatasAssigned = poSensitiveData;
    }

    public boolean isPurchaseOrderPrintRequested() {
        return this.purchaseOrderPrintRequested;
    }

    public void setPurchaseOrderPrintRequested(boolean purchaseOrderPrintRequested) {
        this.purchaseOrderPrintRequested = purchaseOrderPrintRequested;
    }

    @Override
    public Class getCapitalAssetLocationClass() {
        return PurchaseOrderCapitalAssetLocation.class;
    }

    @Override
    public Class getItemCapitalAssetClass() {
        return PurchaseOrderItemCapitalAsset.class;
    }

    @Override
    public CapitalAssetLocation setupNewPurchasingCapitalAssetLocationLine() {
        PurchaseOrderCapitalAssetLocation location = new PurchaseOrderCapitalAssetLocation();
        return location;
    }

    @Override
    public PurApItem setupNewPurchasingItemLine() {
        return new PurchaseOrderItem();
    }

    @Override
    public PurchaseOrderAccount setupNewPurchasingAccountingLine() {
        return new PurchaseOrderAccount();
    }

    @Override
    public PurchaseOrderAccount setupNewAccountDistributionAccountingLine() {
        PurchaseOrderAccount account = this.setupNewPurchasingAccountingLine();
        account.setAccountLinePercent(new BigDecimal(100));
        return account;
    }

    public boolean isReadOnlyReceivingRequired() {
        PurchaseOrderDocument poDoc = this.getPurchaseOrderDocument();
        if (poDoc instanceof PurchaseOrderAmendmentDocument && !poDoc.isReceivingDocumentRequiredIndicator()) {
            if (GlobalVariables.getMessageMap().hasNoErrors()) {
                return ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).hasActivePaymentRequestsForPurchaseOrder(poDoc.getPurapDocumentIdentifier());
            }
            return true;
        }
        return false;
    }

    public PurchaseOrderVendorStipulation getAndResetNewPurchaseOrderVendorStipulationLine() {
        PurchaseOrderVendorStipulation aPurchaseOrderVendorStipulationLine = this.getNewPurchaseOrderVendorStipulationLine();
        this.setNewPurchaseOrderVendorStipulationLine(new PurchaseOrderVendorStipulation());
        aPurchaseOrderVendorStipulationLine.setDocumentNumber(this.getPurchaseOrderDocument().getDocumentNumber());
        aPurchaseOrderVendorStipulationLine.setVendorStipulationAuthorEmployeeIdentifier(GlobalVariables.getUserSession().getPerson().getPrincipalId());
        aPurchaseOrderVendorStipulationLine.setVendorStipulationCreateDate(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate());
        return aPurchaseOrderVendorStipulationLine;
    }

    public String getStatusChange() {
        if (StringUtils.isNotEmpty((CharSequence)this.getPurchaseOrderDocument().getStatusChange())) {
            return this.getPurchaseOrderDocument().getStatusChange();
        }
        if (StringUtils.equals((CharSequence)this.getPurchaseOrderDocument().getApplicationDocumentStatus(), (CharSequence)"In Process")) {
            return "In Process";
        }
        if (StringUtils.equals((CharSequence)this.getPurchaseOrderDocument().getApplicationDocumentStatus(), (CharSequence)"Waiting for Department")) {
            return "Waiting for Department";
        }
        if (StringUtils.equals((CharSequence)this.getPurchaseOrderDocument().getApplicationDocumentStatus(), (CharSequence)"Waiting for Vendor")) {
            return "Waiting for Vendor";
        }
        return null;
    }

    public void setStatusChange(String statusChange) {
        this.getPurchaseOrderDocument().setStatusChange(statusChange);
    }

    public boolean shouldMethodToCallParameterBeUsed(String methodToCallParameterName, String methodToCallParameterValue, HttpServletRequest request) {
        List<String> methodToCallList = Arrays.asList("printPurchaseOrderPDFOnly", "printingRetransmitPoOnly", "printPoQuoteListOnly");
        if ("methodToCall".equals(methodToCallParameterName) && methodToCallList.contains(methodToCallParameterValue)) {
            return true;
        }
        return super.shouldMethodToCallParameterBeUsed(methodToCallParameterName, methodToCallParameterValue, request);
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        String poIDstr = this.getPurchaseOrderDocument().getPurapDocumentIdentifier().toString();
        if ("PO".equals(workflowDocument.getDocumentTypeName()) && !workflowDocument.getStatus().getCategory().equals((Object)DocumentStatusCategory.SUCCESSFUL)) {
            String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            String namespaceCode = "KR-NS";
            String permissionTemplateName = "Full Unmask Field";
            HashMap roleQualifiers = new HashMap();
            HashMap<String, String> permissionDetails = new HashMap<String, String>();
            permissionDetails.put("componentName", PurchaseOrderDocument.class.getSimpleName());
            permissionDetails.put("propertyName", "purapDocumentIdentifier");
            IdentityManagementService identityManagementService = (IdentityManagementService)SpringContext.getBean(IdentityManagementService.class);
            Boolean isAuthorized = identityManagementService.isAuthorizedByTemplateName(principalId, namespaceCode, permissionTemplateName, permissionDetails, roleQualifiers);
            if (!isAuthorized.booleanValue()) {
                DataDictionaryService dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
                if (ObjectUtils.isNotNull((Object)this.getPurchaseOrderDocument().getPurapDocumentIdentifier())) {
                    poIDstr = "";
                    int strLength = dataDictionaryService.getAttributeMaxLength(PurApGenericAttributes.class.getName(), "purapDocumentIdentifier");
                    for (int i = 0; i < strLength; ++i) {
                        poIDstr = poIDstr.concat("*");
                    }
                }
            }
        }
        if (ObjectUtils.isNotNull((Object)this.getPurchaseOrderDocument().getPurapDocumentIdentifier())) {
            this.getDocInfo().add(new HeaderField("DataDictionary.PurchaseOrderDocument.attributes.purapDocumentIdentifier", poIDstr));
        } else {
            this.getDocInfo().add(new HeaderField("DataDictionary.PurchaseOrderDocument.attributes.purapDocumentIdentifier", "Not Available"));
        }
        if (ObjectUtils.isNotNull((Object)this.getPurchaseOrderDocument().getApplicationDocumentStatus())) {
            this.getDocInfo().add(new HeaderField("DataDictionary.PurchaseOrderDocument.attributes.applicationDocumentStatus", this.getPurchaseOrderDocument().getApplicationDocumentStatus()));
        } else {
            this.getDocInfo().add(new HeaderField("DataDictionary.PurchaseOrderDocument.attributes.applicationDocumentStatus", "Not Available"));
        }
    }

    protected boolean processPaymentRequestRulesForCanClose(PurchaseOrderDocument document) {
        boolean valid = false;
        Integer poDocId = document.getPurapDocumentIdentifier();
        boolean checkInProcess = false;
        boolean hasInProcess = false;
        Map<Object, Object> processPaymentRequestResult = new HashMap();
        processPaymentRequestResult = ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).getPaymentRequestsByStatusAndPurchaseOrderId("In Process", poDocId);
        if ("Y".equals(processPaymentRequestResult.get("hasInProcess"))) {
            hasInProcess = true;
        }
        if ("Y".equals(processPaymentRequestResult.get("checkInProcess"))) {
            checkInProcess = true;
        }
        if (checkInProcess && !hasInProcess) {
            valid = true;
        }
        return valid;
    }

    protected boolean canAmend() {
        boolean can = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).isPurchaseOrderOpenForProcessing(this.getPurchaseOrderDocument());
        if (can) {
            DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPurchaseOrderDocument());
            can = documentAuthorizer.canInitiate("POA", GlobalVariables.getUserSession().getPerson());
        }
        return can;
    }

    protected boolean canVoid() {
        boolean can;
        boolean bl = can = this.getPurchaseOrderDocument().isPurchaseOrderCurrentIndicator() && !this.getPurchaseOrderDocument().isPendingActionIndicator();
        if (can) {
            boolean pendingPrint = "Pending Print".equals(this.getPurchaseOrderDocument().getApplicationDocumentStatus());
            boolean open = "Open".equals(this.getPurchaseOrderDocument().getApplicationDocumentStatus());
            boolean errorCxml = "Error occurred sending cxml".equals(this.getPurchaseOrderDocument().getApplicationDocumentStatus());
            boolean errorFax = "Error occurred sending fax".equals(this.getPurchaseOrderDocument().getApplicationDocumentStatus());
            List<PaymentRequestView> preqViews = this.getPurchaseOrderDocument().getRelatedViews().getRelatedPaymentRequestViews();
            boolean hasPaymentRequest = preqViews != null && preqViews.size() > 0;
            boolean bl2 = can = pendingPrint || open && !hasPaymentRequest || errorCxml || errorFax;
        }
        if (can) {
            DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPurchaseOrderDocument());
            can = documentAuthorizer.canInitiate("POV", GlobalVariables.getUserSession().getPerson());
        }
        return can;
    }

    protected boolean canClose() {
        boolean can = "Open".equals(this.getPurchaseOrderDocument().getApplicationDocumentStatus());
        can = can && this.getPurchaseOrderDocument().isPurchaseOrderCurrentIndicator() && !this.getPurchaseOrderDocument().isPendingActionIndicator();
        boolean bl = can = can && this.processPaymentRequestRulesForCanClose(this.getPurchaseOrderDocument());
        if (can) {
            DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPurchaseOrderDocument());
            can = documentAuthorizer.canInitiate("POC", GlobalVariables.getUserSession().getPerson());
        }
        return can;
    }

    protected boolean canReopen() {
        boolean can = "Closed".equals(this.getPurchaseOrderDocument().getApplicationDocumentStatus());
        boolean bl = can = can && this.getPurchaseOrderDocument().isPurchaseOrderCurrentIndicator() && !this.getPurchaseOrderDocument().isPendingActionIndicator();
        if (can) {
            DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPurchaseOrderDocument());
            can = documentAuthorizer.canInitiate("POR", GlobalVariables.getUserSession().getPerson());
        }
        return can;
    }

    protected boolean canHoldPayment() {
        boolean can = "Open".equals(this.getPurchaseOrderDocument().getApplicationDocumentStatus());
        boolean bl = can = can && this.getPurchaseOrderDocument().isPurchaseOrderCurrentIndicator() && !this.getPurchaseOrderDocument().isPendingActionIndicator();
        if (can) {
            DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPurchaseOrderDocument());
            can = documentAuthorizer.canInitiate("POPH", GlobalVariables.getUserSession().getPerson());
        }
        return can;
    }

    protected boolean canRemoveHold() {
        boolean can = "Payment Hold".equals(this.getPurchaseOrderDocument().getApplicationDocumentStatus());
        boolean bl = can = can && this.getPurchaseOrderDocument().isPurchaseOrderCurrentIndicator() && !this.getPurchaseOrderDocument().isPendingActionIndicator();
        if (can) {
            DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPurchaseOrderDocument());
            can = documentAuthorizer.canInitiate("PORH", GlobalVariables.getUserSession().getPerson());
        }
        return can;
    }

    protected boolean canRetransmit() {
        boolean can = "Open".equals(this.getPurchaseOrderDocument().getApplicationDocumentStatus());
        can = can && this.getPurchaseOrderDocument().isPurchaseOrderCurrentIndicator() && !this.getPurchaseOrderDocument().isPendingActionIndicator();
        can = can && this.getPurchaseOrderDocument().getPurchaseOrderLastTransmitTimestamp() != null;
        can = can && !"B2B".equals(this.getPurchaseOrderDocument().getRequisitionSourceCode());
        boolean bl = can = can && !this.editingMode.containsKey("displayRetransmitTab");
        if (!can) {
            return false;
        }
        DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPurchaseOrderDocument());
        can = this.getPurchaseOrderDocument().getPurchaseOrderAutomaticIndicator() ? documentAuthorizer.canInitiate("PORT", GlobalVariables.getUserSession().getPerson()) : documentAuthorizer.canInitiate("PO", GlobalVariables.getUserSession().getPerson()) || documentAuthorizer.canInitiate("ACM", GlobalVariables.getUserSession().getPerson());
        return can;
    }

    protected boolean canPrintRetransmit() {
        boolean can = this.getPurchaseOrderDocument().getDocumentHeader().getWorkflowDocument().getDocumentTypeName().equals("PORT");
        boolean bl = can = can && this.editingMode.containsKey("displayRetransmitTab");
        if (can) {
            DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPurchaseOrderDocument());
            can = this.getPurchaseOrderDocument().getPurchaseOrderAutomaticIndicator() ? documentAuthorizer.canInitiate("PORT", GlobalVariables.getUserSession().getPerson()) : documentAuthorizer.canInitiate("PO", GlobalVariables.getUserSession().getPerson()) || documentAuthorizer.canInitiate("ACM", GlobalVariables.getUserSession().getPerson());
        }
        return can;
    }

    protected boolean canSplitPo() {
        boolean can = "In Process".equals(this.getPurchaseOrderDocument().getApplicationDocumentStatus());
        can = can && !this.getPurchaseOrderDocument().getDocumentHeader().getWorkflowDocument().isEnroute();
        can = can || "Awaiting Purchasing Approval".equals(this.getPurchaseOrderDocument().getApplicationDocumentStatus());
        can = can && !(this.getPurchaseOrderDocument() instanceof PurchaseOrderSplitDocument);
        can = can && !this.editingMode.containsKey("splittingItemSelection");
        boolean bl = can = can && !this.getPurchaseOrderDocument().getRequisitionSourceCode().equals("B2B");
        if (can) {
            List items = this.getPurchaseOrderDocument().getItems();
            int itemsBelowTheLine = PurApItemUtils.countBelowTheLineItems(items);
            boolean bl2 = can = items.size() - itemsBelowTheLine > 1;
        }
        if (can) {
            DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPurchaseOrderDocument());
            can = documentAuthorizer.canInitiate("POSP", GlobalVariables.getUserSession().getPerson());
        }
        return can;
    }

    protected boolean canContinuePoSplit() {
        boolean can = this.editingMode.containsKey("splittingItemSelection");
        if (can) {
            DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPurchaseOrderDocument());
            can = documentAuthorizer.canInitiate("POSP", GlobalVariables.getUserSession().getPerson());
        }
        return can;
    }

    protected boolean canCreateReceiving() {
        boolean can = ((ReceivingService)SpringContext.getBean(ReceivingService.class)).canCreateLineItemReceivingDocument(this.getPurchaseOrderDocument());
        if (can) {
            DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPurchaseOrderDocument());
            can = documentAuthorizer.canInitiate("RCVL", GlobalVariables.getUserSession().getPerson());
        }
        return can;
    }

    protected Map<String, ExtraButton> createButtonsMap() {
        HashMap<String, ExtraButton> result = new HashMap<String, ExtraButton>();
        ExtraButton retransmitButton = new ExtraButton();
        retransmitButton.setExtraButtonProperty("methodToCall.retransmitPo");
        retransmitButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_retransmit.gif");
        retransmitButton.setExtraButtonAltText("Retransmit");
        ExtraButton printingRetransmitButton = new ExtraButton();
        printingRetransmitButton.setExtraButtonProperty("methodToCall.printingRetransmitPo");
        printingRetransmitButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_retransmit.gif");
        printingRetransmitButton.setExtraButtonAltText("PrintingRetransmit");
        ExtraButton printingPreviewButton = new ExtraButton();
        printingPreviewButton.setExtraButtonProperty("methodToCall.printingPreviewPo");
        printingPreviewButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_previewpf.gif");
        printingPreviewButton.setExtraButtonAltText("PrintingPreview");
        printingPreviewButton.setExtraButtonOnclick("excludeSubmitRestriction=true");
        ExtraButton printButton = new ExtraButton();
        printButton.setExtraButtonProperty("methodToCall.firstTransmitPrintPo");
        printButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_print.gif");
        printButton.setExtraButtonAltText("Print");
        ExtraButton reopenButton = new ExtraButton();
        reopenButton.setExtraButtonProperty("methodToCall.reopenPo");
        reopenButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_openorder.gif");
        reopenButton.setExtraButtonAltText("Reopen");
        ExtraButton closeButton = new ExtraButton();
        closeButton.setExtraButtonProperty("methodToCall.closePo");
        closeButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_closeorder.gif");
        closeButton.setExtraButtonAltText("Close PO");
        ExtraButton voidButton = new ExtraButton();
        voidButton.setExtraButtonProperty("methodToCall.voidPo");
        voidButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_voidorder.gif");
        voidButton.setExtraButtonAltText("Void PO");
        ExtraButton paymentHoldButton = new ExtraButton();
        paymentHoldButton.setExtraButtonProperty("methodToCall.paymentHoldPo");
        paymentHoldButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_paymenthold.gif");
        paymentHoldButton.setExtraButtonAltText("Payment Hold");
        ExtraButton amendButton = new ExtraButton();
        amendButton.setExtraButtonProperty("methodToCall.amendPo");
        amendButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_amend.gif");
        amendButton.setExtraButtonAltText("Amend");
        ExtraButton removeHoldButton = new ExtraButton();
        removeHoldButton.setExtraButtonProperty("methodToCall.removeHoldPo");
        removeHoldButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_removehold.gif");
        removeHoldButton.setExtraButtonAltText("Remove Hold");
        ExtraButton resendPoCxmlButton = new ExtraButton();
        resendPoCxmlButton.setExtraButtonProperty("methodToCall.resendPoCxml");
        resendPoCxmlButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_resendpo.gif");
        resendPoCxmlButton.setExtraButtonAltText("Resend PO CXML");
        ExtraButton receivingButton = new ExtraButton();
        receivingButton.setExtraButtonProperty("methodToCall.createReceivingLine");
        receivingButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_receiving.gif");
        receivingButton.setExtraButtonAltText("Receiving");
        ExtraButton splitPoButton = new ExtraButton();
        splitPoButton.setExtraButtonProperty("methodToCall.splitPo");
        splitPoButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_splitorder.gif");
        splitPoButton.setExtraButtonAltText("Split this PO");
        ExtraButton continueButton = new ExtraButton();
        continueButton.setExtraButtonProperty("methodToCall.continuePurchaseOrderSplit");
        continueButton.setExtraButtonSource("${kr.externalizable.images.url}buttonsmall_continue.gif");
        continueButton.setExtraButtonAltText("Continue");
        ExtraButton cancelSplitButton = new ExtraButton();
        cancelSplitButton.setExtraButtonProperty("methodToCall.cancelPurchaseOrderSplit");
        cancelSplitButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_cancelsplit.gif");
        cancelSplitButton.setExtraButtonAltText("Cancel Splitting the PO");
        ExtraButton assignSensitiveDataButton = new ExtraButton();
        assignSensitiveDataButton.setExtraButtonProperty("methodToCall.assignSensitiveData");
        assignSensitiveDataButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_sensitivedata.gif ");
        assignSensitiveDataButton.setExtraButtonAltText("Assign sensitive data to the PO");
        ExtraButton submitSensitiveDataButton = new ExtraButton();
        submitSensitiveDataButton.setExtraButtonProperty("methodToCall.submitSensitiveData");
        submitSensitiveDataButton.setExtraButtonSource("${kr.externalizable.images.url}buttonsmall_submit.gif");
        submitSensitiveDataButton.setExtraButtonAltText("Submit sensitive data assignment");
        ExtraButton cancelSensitiveDataButton = new ExtraButton();
        cancelSensitiveDataButton.setExtraButtonProperty("methodToCall.cancelSensitiveData");
        cancelSensitiveDataButton.setExtraButtonSource("${kr.externalizable.images.url}buttonsmall_cancel.gif");
        cancelSensitiveDataButton.setExtraButtonAltText("Cancel sensitive data assignment");
        result.put(retransmitButton.getExtraButtonProperty(), retransmitButton);
        result.put(printingRetransmitButton.getExtraButtonProperty(), printingRetransmitButton);
        result.put(printingPreviewButton.getExtraButtonProperty(), printingPreviewButton);
        result.put(printButton.getExtraButtonProperty(), printButton);
        result.put(reopenButton.getExtraButtonProperty(), reopenButton);
        result.put(closeButton.getExtraButtonProperty(), closeButton);
        result.put(voidButton.getExtraButtonProperty(), voidButton);
        result.put(paymentHoldButton.getExtraButtonProperty(), paymentHoldButton);
        result.put(amendButton.getExtraButtonProperty(), amendButton);
        result.put(removeHoldButton.getExtraButtonProperty(), removeHoldButton);
        result.put(receivingButton.getExtraButtonProperty(), receivingButton);
        result.put(splitPoButton.getExtraButtonProperty(), splitPoButton);
        result.put(continueButton.getExtraButtonProperty(), continueButton);
        result.put(cancelSplitButton.getExtraButtonProperty(), cancelSplitButton);
        result.put(assignSensitiveDataButton.getExtraButtonProperty(), assignSensitiveDataButton);
        result.put(submitSensitiveDataButton.getExtraButtonProperty(), submitSensitiveDataButton);
        result.put(cancelSensitiveDataButton.getExtraButtonProperty(), cancelSensitiveDataButton);
        result.put(resendPoCxmlButton.getExtraButtonProperty(), resendPoCxmlButton);
        return result;
    }

    @Override
    public List<ExtraButton> getExtraButtons() {
        super.getExtraButtons();
        Map<String, ExtraButton> buttonsMap = this.createButtonsMap();
        if (this.getEditingMode().containsKey("assignSensitiveData")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.assignSensitiveData"));
            if (this.getPurchaseOrderDocument().getAssigningSensitiveData()) {
                this.extraButtons.clear();
                this.extraButtons.add(buttonsMap.get("methodToCall.submitSensitiveData"));
                this.extraButtons.add(buttonsMap.get("methodToCall.cancelSensitiveData"));
                return this.extraButtons;
            }
        }
        if (this.getEditingMode().containsKey("previewPrintPurchaseOrder")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.printingPreviewPo"));
        }
        if (this.getEditingMode().containsKey("printPurchaseOrder")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.firstTransmitPrintPo"));
        }
        if (this.getEditingMode().containsKey("resendPurchaseOrder")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.resendPoCxml"));
        }
        if (this.canRetransmit()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.retransmitPo"));
        }
        if (this.canPrintRetransmit()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.printingRetransmitPo"));
        }
        if (this.canReopen()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.reopenPo"));
        }
        if (this.canClose()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.closePo"));
        }
        if (this.canHoldPayment()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.paymentHoldPo"));
        }
        if (this.canAmend()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.amendPo"));
        }
        if (this.canVoid()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.voidPo"));
        }
        if (this.canRemoveHold()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.removeHoldPo"));
        }
        if (this.canCreateReceiving()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.createReceivingLine"));
        }
        if (this.canSplitPo()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.splitPo"));
        }
        if (this.canContinuePoSplit()) {
            this.extraButtons.clear();
            this.extraButtons.add(buttonsMap.get("methodToCall.continuePurchaseOrderSplit"));
            this.extraButtons.add(buttonsMap.get("methodToCall.cancelPurchaseOrderSplit"));
        }
        return this.extraButtons;
    }
}

