/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.module.purap.document.BulkReceivingDocument;
import org.kuali.kfs.module.purap.pdf.PurapPdf;

public class BulkReceivingPdf
extends PurapPdf {
    private static Log LOG = LogFactory.getLog(BulkReceivingPdf.class);
    private BulkReceivingDocument blkRecDoc;

    public void onOpenDocument(PdfWriter writer, Document document) {
        try {
            this.loadHeaderTable();
            this.tpl = writer.getDirectContent().createTemplate(100.0f, 100.0f);
            this.helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    private void loadHeaderTable() throws Exception {
        float[] headerWidths = new float[]{0.2f, 0.8f};
        this.headerTable = new PdfPTable(headerWidths);
        this.headerTable.setWidthPercentage(100.0f);
        this.headerTable.setHorizontalAlignment(1);
        this.headerTable.setSplitLate(false);
        this.headerTable.getDefaultCell().setBorderWidth(0.0f);
        this.headerTable.getDefaultCell().setHorizontalAlignment(1);
        this.headerTable.getDefaultCell().setVerticalAlignment(1);
        if (StringUtils.isNotBlank((CharSequence)this.logoImage)) {
            this.logo = Image.getInstance((String)this.logoImage);
            this.logo.scalePercent(3.0f, 3.0f);
            this.headerTable.addCell(new Phrase(new Chunk(this.logo, 0.0f, 0.0f)));
        } else {
            this.headerTable.addCell(new Phrase(new Chunk("")));
        }
        float[] nestedHeaderWidths = new float[]{0.7f, 0.3f};
        this.nestedHeaderTable = new PdfPTable(nestedHeaderWidths);
        this.nestedHeaderTable.setSplitLate(false);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph("RECEIVING TICKET", this.ver_15_normal));
        cell.setHorizontalAlignment(1);
        cell.setBorderWidth(0.0f);
        this.nestedHeaderTable.addCell(cell);
        Paragraph p = new Paragraph();
        p.add((Object)new Chunk("Doc Number: ", this.ver_11_normal));
        p.add((Object)new Chunk(this.blkRecDoc.getDocumentNumber().toString(), this.cour_10_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        cell.setBorderWidth(0.0f);
        this.nestedHeaderTable.addCell(cell);
        cell = new PdfPCell(this.nestedHeaderTable);
        cell.setHorizontalAlignment(1);
        cell.setBorderWidth(0.0f);
        this.headerTable.addCell(cell);
    }

    @Override
    public BulkReceivingPdf getPageEvents() {
        LOG.debug((Object)"getPageEvents() started.");
        return new BulkReceivingPdf();
    }

    public void generatePdf(BulkReceivingDocument blkRecDoc, ByteArrayOutputStream byteStream, String logoImage, String environment) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("generatePdf() started for bulk receiving - " + blkRecDoc.getDocumentNumber()));
        }
        Document document = null;
        try {
            document = this.getDocument(9.0f, 9.0f, 70.0f, 36.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteStream);
            this.logoImage = logoImage;
            this.blkRecDoc = blkRecDoc;
            this.environment = environment;
            BulkReceivingPdf events = new BulkReceivingPdf().getPageEvents();
            writer.setPageEvent((PdfPageEvent)this);
            document.open();
            document.add((Element)this.createVendorAndDeliveryDetailsTable());
            document.add((Element)new Paragraph("\nAdditional Details\n  ", this.ver_8_bold));
            document.add((Element)this.createAdditionalDetailsTable());
            document.close();
        }
        catch (Exception de) {
            throw new RuntimeException("Document Exception when trying to save a Bulk Receiving PDF", de);
        }
        finally {
            if (document != null && document.isOpen()) {
                document.close();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("generatePdf() completed for bulk receiving - " + blkRecDoc.getDocumentNumber()));
        }
    }

    private PdfPTable createVendorAndDeliveryDetailsTable() {
        Paragraph p = new Paragraph();
        float[] infoWidths = new float[]{0.5f, 0.5f};
        PdfPTable infoTable = new PdfPTable(infoWidths);
        infoTable.setWidthPercentage(100.0f);
        infoTable.setHorizontalAlignment(1);
        infoTable.setSplitLate(false);
        infoTable.addCell(this.getPDFCell("Vendor", this.getFormattedVendorAddress()));
        infoTable.addCell(this.getPDFCell("Delivery", this.getFormattedDeliveryAddress()));
        infoTable.addCell(this.getPDFCell("Reference Number\n", this.blkRecDoc.getShipmentReferenceNumber()));
        if (this.blkRecDoc.getCarrier() != null) {
            infoTable.addCell(this.getPDFCell("Carrier\n", this.blkRecDoc.getCarrier().getCarrierDescription()));
        } else {
            infoTable.addCell(this.getPDFCell("Carrier\n", ""));
        }
        infoTable.addCell(this.getPDFCell("Tracking/Pro Number\n", this.blkRecDoc.getTrackingNumber()));
        if (this.blkRecDoc.getPurchaseOrderIdentifier() != null) {
            infoTable.addCell(this.getPDFCell("PO\n", this.blkRecDoc.getPurchaseOrderIdentifier().toString()));
        } else {
            infoTable.addCell(this.getPDFCell("PO\n", ""));
        }
        infoTable.addCell(this.getPDFCell("# of Pieces\n", "" + this.blkRecDoc.getNoOfCartons()));
        infoTable.addCell(this.getPDFCell("Shipment Received Date\n", this.blkRecDoc.getShipmentReceivedDate().toString()));
        if (this.blkRecDoc.getShipmentWeight() != null) {
            infoTable.addCell(this.getPDFCell("Weight\n", this.blkRecDoc.getShipmentWeight().toString()));
        } else {
            infoTable.addCell(this.getPDFCell("Weight\n", ""));
        }
        infoTable.addCell(this.getPDFCell("\n", ""));
        return infoTable;
    }

    private PdfPCell getPDFCell(String fieldTitle, String fieldValue) {
        Paragraph p = new Paragraph();
        p.add((Object)new Chunk("  " + fieldTitle, this.ver_5_normal));
        if (StringUtils.isNotEmpty((CharSequence)fieldValue)) {
            p.add((Object)new Chunk("     " + fieldValue, this.cour_10_normal));
        } else {
            p.add((Object)new Chunk("  "));
        }
        PdfPCell cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        return cell;
    }

    private String getFormattedVendorAddress() {
        StringBuffer vendorInfo = new StringBuffer();
        vendorInfo.append("\n");
        if (this.blkRecDoc.getGoodsDeliveredVendorNumber() == null || this.blkRecDoc.getGoodsDeliveredVendorNumber().equals(this.blkRecDoc.getVendorNumber())) {
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getVendorName())) {
                vendorInfo.append("     " + this.blkRecDoc.getVendorName() + "\n");
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getVendorLine1Address())) {
                vendorInfo.append("     " + this.blkRecDoc.getVendorLine1Address() + "\n");
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getVendorLine2Address())) {
                vendorInfo.append("     " + this.blkRecDoc.getVendorLine2Address() + "\n");
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getVendorCityName())) {
                vendorInfo.append("     " + this.blkRecDoc.getVendorCityName());
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getVendorStateCode())) {
                vendorInfo.append(", " + this.blkRecDoc.getVendorStateCode());
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getVendorAddressInternationalProvinceName())) {
                vendorInfo.append(", " + this.blkRecDoc.getVendorAddressInternationalProvinceName());
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getVendorPostalCode())) {
                vendorInfo.append(" " + this.blkRecDoc.getVendorPostalCode() + "\n");
            } else {
                vendorInfo.append("\n");
            }
            if (!"US".equalsIgnoreCase(this.blkRecDoc.getVendorCountryCode()) && this.blkRecDoc.getVendorCountry() != null) {
                vendorInfo.append("     " + this.blkRecDoc.getVendorCountry().getName() + "\n\n");
            } else {
                vendorInfo.append("\n\n");
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getAlternateVendorDetail().getVendorName())) {
                vendorInfo.append("     " + this.blkRecDoc.getAlternateVendorDetail().getVendorName() + "\n");
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressLine1())) {
                vendorInfo.append("     " + this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressLine1() + "\n");
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressLine2())) {
                vendorInfo.append("     " + this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressLine2() + "\n");
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressCity())) {
                vendorInfo.append("     " + this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressCity());
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressStateCode())) {
                vendorInfo.append(", " + this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressStateCode());
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressInternationalProvince())) {
                vendorInfo.append(", " + this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressInternationalProvince());
            }
            if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressPostalCode())) {
                vendorInfo.append(" " + this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressPostalCode() + "\n");
            } else {
                vendorInfo.append("\n");
            }
            if (!"US".equalsIgnoreCase(this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressCountryCode()) && this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressCountryCode() != null) {
                vendorInfo.append("     " + this.blkRecDoc.getAlternateVendorDetail().getDefaultAddressCountryCode() + "\n\n");
            } else {
                vendorInfo.append("\n\n");
            }
        }
        return vendorInfo.toString();
    }

    private String getFormattedDeliveryAddress() {
        StringBuffer shipToInfo = new StringBuffer();
        shipToInfo.append("\n");
        if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getDeliveryToName())) {
            shipToInfo.append("     " + StringUtils.defaultString((String)this.blkRecDoc.getDeliveryToName()) + "\n");
        }
        String deliveryBuildingName = this.blkRecDoc.getDeliveryBuildingName();
        if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getDeliveryBuildingRoomNumber())) {
            if (StringUtils.isBlank((CharSequence)deliveryBuildingName)) {
                shipToInfo.append("     Room #" + this.blkRecDoc.getDeliveryBuildingRoomNumber() + "\n");
            } else {
                shipToInfo.append("     " + deliveryBuildingName + " Room #" + this.blkRecDoc.getDeliveryBuildingRoomNumber() + "\n");
            }
        } else if (StringUtils.isNotBlank((CharSequence)deliveryBuildingName)) {
            shipToInfo.append("     " + deliveryBuildingName + "\n");
        }
        shipToInfo.append("     " + this.blkRecDoc.getDeliveryBuildingLine1Address() + "\n");
        if (StringUtils.isNotBlank((CharSequence)this.blkRecDoc.getDeliveryBuildingLine2Address())) {
            shipToInfo.append("     " + this.blkRecDoc.getDeliveryBuildingLine2Address() + "\n");
        }
        shipToInfo.append("     " + this.blkRecDoc.getDeliveryCityName() + ", " + this.blkRecDoc.getDeliveryStateCode() + " " + this.blkRecDoc.getDeliveryPostalCode() + "\n\n");
        return shipToInfo.toString();
    }

    private PdfPTable createAdditionalDetailsTable() {
        float[] additionalInfoWidths = new float[]{0.25f, 0.75f};
        PdfPTable additionalInfoTable = new PdfPTable(additionalInfoWidths);
        additionalInfoTable.setWidthPercentage(100.0f);
        additionalInfoTable.setSplitLate(false);
        Paragraph p = new Paragraph();
        p.add((Object)new Chunk("  Notes to Vendor  ", this.ver_5_normal));
        PdfPCell cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  " + StringUtils.defaultString((String)this.blkRecDoc.getVendorNoteText()), this.cour_10_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Delivery instructions  ", this.ver_5_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  " + StringUtils.defaultString((String)this.blkRecDoc.getDeliveryInstructionText()), this.cour_10_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Additional Delivery instructions  ", this.ver_5_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  " + StringUtils.defaultString((String)this.blkRecDoc.getDeliveryAdditionalInstructionText()), this.cour_10_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        additionalInfoTable.addCell(cell);
        this.updateRequestorInfo(this.blkRecDoc, additionalInfoTable);
        String campusCode = this.blkRecDoc.getDeliveryCampusCode();
        p = new Paragraph();
        p.add((Object)new Chunk("   Contact Name ", this.ver_5_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  " + StringUtils.defaultString((String)this.blkRecDoc.getInstitutionContactName()), this.cour_10_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Contact Phone  ", this.ver_5_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  " + StringUtils.defaultString((String)this.blkRecDoc.getInstitutionContactPhoneNumber()), this.cour_10_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Contact Email  ", this.ver_5_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  " + StringUtils.defaultString((String)this.blkRecDoc.getInstitutionContactEmailAddress()), this.cour_10_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("   Signature  ", this.ver_5_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("\n\n\n\n"));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("   Date  ", this.ver_5_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("\n\n\n\n"));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        additionalInfoTable.addCell(cell);
        return additionalInfoTable;
    }

    private void updateRequestorInfo(BulkReceivingDocument blkRecDoc, PdfPTable additionalInfoTable) {
        Paragraph p = new Paragraph();
        p.add((Object)new Chunk("  Requestor Name  ", this.ver_5_normal));
        PdfPCell cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  " + StringUtils.defaultString((String)blkRecDoc.getRequestorPersonName()), this.cour_10_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Requestor Phone  ", this.ver_5_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  " + StringUtils.defaultString((String)blkRecDoc.getRequestorPersonPhoneNumber()), this.cour_10_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Requestor Email  ", this.ver_5_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(2);
        additionalInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  " + StringUtils.defaultString((String)blkRecDoc.getRequestorPersonEmailAddress()), this.cour_10_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        additionalInfoTable.addCell(cell);
    }
}

