/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterContract;
import org.kuali.kfs.coreservice.api.parameter.ParameterType;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.purap.batch.service.PurapRunDateService;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.service.PdpExtractService;
import org.kuali.kfs.module.purap.service.impl.PurapAccountingServiceImpl;
import org.kuali.kfs.module.purap.util.VendorGroupingHelper;
import org.kuali.kfs.pdp.PdpConstants;
import org.kuali.kfs.pdp.PdpParameterConstants;
import org.kuali.kfs.pdp.businessobject.Batch;
import org.kuali.kfs.pdp.businessobject.CustomerProfile;
import org.kuali.kfs.pdp.businessobject.PaymentAccountDetail;
import org.kuali.kfs.pdp.businessobject.PaymentDetail;
import org.kuali.kfs.pdp.businessobject.PaymentGroup;
import org.kuali.kfs.pdp.businessobject.PaymentNoteText;
import org.kuali.kfs.pdp.service.CustomerProfileService;
import org.kuali.kfs.pdp.service.PaymentDetailService;
import org.kuali.kfs.pdp.service.PaymentFileService;
import org.kuali.kfs.pdp.service.PaymentGroupService;
import org.kuali.kfs.pdp.service.PdpEmailService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PdpExtractServiceImpl
implements PdpExtractService {
    private static final Logger LOG = LogManager.getLogger(PdpExtractServiceImpl.class);
    protected PaymentRequestService paymentRequestService;
    protected BusinessObjectService businessObjectService;
    protected PaymentFileService paymentFileService;
    protected ParameterService parameterService;
    protected CustomerProfileService customerProfileService;
    protected DateTimeService dateTimeService;
    protected PersonService personService;
    protected PaymentGroupService paymentGroupService;
    protected PaymentDetailService paymentDetailService;
    protected CreditMemoService creditMemoService;
    protected DocumentService documentService;
    protected PurapRunDateService purapRunDateService;
    protected PdpEmailService paymentFileEmailService;
    protected BankService bankService;
    protected DataDictionaryService dataDictionaryService;
    protected PurapAccountingServiceImpl purapAccountingService;
    protected List<String> lockedDocuments;

    @Override
    public void extractImmediatePaymentsOnly() {
        LOG.debug("extractImmediatePaymentsOnly() started");
        java.util.Date processRunDate = this.dateTimeService.getCurrentDate();
        this.lockUnlockDocuments(true);
        try {
            this.extractPayments(true, processRunDate);
        }
        finally {
            this.lockUnlockDocuments(false);
        }
    }

    @Override
    public void extractPayments(java.util.Date runDate) {
        LOG.debug("extractPayments() started");
        this.extractPayments(false, runDate);
    }

    protected void extractPayments(boolean immediateOnly, java.util.Date processRunDate) {
        LOG.debug("extractPayments() started");
        Person uuser = this.getPersonService().getPersonByPrincipalName("kfs");
        if (uuser == null) {
            LOG.error("extractPayments() Unable to find user kfs");
            throw new IllegalArgumentException("Unable to find user kfs");
        }
        LOG.debug("fetched system user");
        List<String> campusesToProcess = this.getChartCodes(immediateOnly, processRunDate);
        for (String campus : campusesToProcess) {
            this.extractPaymentsForCampus(campus, uuser, processRunDate, immediateOnly);
        }
    }

    protected void extractPaymentsForCampus(String campusCode, Person puser, java.util.Date processRunDate, boolean immediateOnly) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("extractPaymentsForCampus() started for campus: " + campusCode);
        }
        Batch batch = this.createBatch(campusCode, puser, processRunDate);
        Integer count = 0;
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        Totals totals = this.extractSpecialPaymentsForChart(campusCode, puser, processRunDate, batch, immediateOnly);
        count = count + totals.count;
        totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)totals.totalAmount);
        if (!immediateOnly) {
            totals = this.extractRegularPaymentsForChart(campusCode, puser, processRunDate, batch);
            count = count + totals.count;
            totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)totals.totalAmount);
        }
        batch.setPaymentCount(new KualiInteger((long)count.intValue()));
        batch.setPaymentTotalAmount(totalAmount);
        this.businessObjectService.save((PersistableBusinessObject)batch);
        this.paymentFileEmailService.sendLoadEmail(batch);
    }

    protected Totals extractRegularPaymentsForChart(String campusCode, Person puser, java.util.Date processRunDate, Batch batch) {
        LOG.debug("START - extractRegularPaymentsForChart()");
        Totals totals = new Totals();
        Date onOrBeforePaymentRequestPayDate = KfsDateUtils.convertToSqlDate((java.util.Date)this.purapRunDateService.calculateRunDate(processRunDate));
        ArrayList<String> preqsWithOutstandingCreditMemos = new ArrayList<String>();
        Set<VendorGroupingHelper> vendors = this.creditMemoService.getVendorsOnCreditMemosToExtract(campusCode);
        for (VendorGroupingHelper vendor : vendors) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing Vendor: " + vendor);
            }
            HashMap bankCodePaymentRequests = new HashMap();
            HashMap bankCodeCreditMemos = new HashMap();
            Collection<VendorCreditMemoDocument> vendorMemos = this.creditMemoService.getCreditMemosToExtractByVendor(campusCode, vendor);
            for (VendorCreditMemoDocument cmd : vendorMemos) {
                List<VendorCreditMemoDocument> bankMemos = new ArrayList<VendorCreditMemoDocument>();
                if (bankCodeCreditMemos.containsKey(cmd.getBankCode())) {
                    bankMemos = (List)bankCodeCreditMemos.get(cmd.getBankCode());
                }
                bankMemos.add(cmd);
                bankCodeCreditMemos.put(cmd.getBankCode(), bankMemos);
            }
            Collection<PaymentRequestDocument> vendorPreqs = this.paymentRequestService.getPaymentRequestsToExtractByVendor(campusCode, vendor, onOrBeforePaymentRequestPayDate);
            for (PaymentRequestDocument prd : vendorPreqs) {
                List<PaymentRequestDocument> bankPreqs = new ArrayList<PaymentRequestDocument>();
                if (bankCodePaymentRequests.containsKey(prd.getBankCode())) {
                    bankPreqs = (List)bankCodePaymentRequests.get(prd.getBankCode());
                }
                bankPreqs.add(prd);
                bankCodePaymentRequests.put(prd.getBankCode(), bankPreqs);
            }
            if (this.bankService.isBankSpecificationEnabled()) {
                for (String bankCode : bankCodePaymentRequests.keySet()) {
                    if (!bankCodeCreditMemos.containsKey(bankCode)) continue;
                    this.processPaymentBundle((List)bankCodePaymentRequests.get(bankCode), (List)bankCodeCreditMemos.get(bankCode), totals, preqsWithOutstandingCreditMemos, puser, processRunDate, batch);
                }
                continue;
            }
            if (vendorMemos.isEmpty()) continue;
            this.processPaymentBundle((List)vendorPreqs, (List)vendorMemos, totals, preqsWithOutstandingCreditMemos, puser, processRunDate, batch);
        }
        LOG.debug("processing PREQs without CMs");
        for (PaymentRequestDocument prd : this.paymentRequestService.getPaymentRequestToExtractByChart(campusCode, onOrBeforePaymentRequestPayDate)) {
            if (preqsWithOutstandingCreditMemos.contains(prd.getDocumentNumber())) continue;
            PaymentGroup paymentGroup = this.processSinglePaymentRequestDocument(prd, batch, puser, processRunDate);
            totals.count = totals.count + paymentGroup.getPaymentDetails().size();
            totals.totalAmount = (KualiDecimal)totals.totalAmount.add((AbstractKualiDecimal)paymentGroup.getNetPaymentAmount());
        }
        LOG.debug("END - extractRegularPaymentsForChart()");
        return totals;
    }

    protected void processPaymentBundle(List<PaymentRequestDocument> paymentRequests, List<VendorCreditMemoDocument> creditMemos, Totals totals, List<String> preqsWithOutstandingCreditMemos, Person puser, java.util.Date processRunDate, Batch batch) {
        boolean bl;
        PaymentGroup paymentGroup;
        KualiDecimal paymentRequestAmount = KualiDecimal.ZERO;
        for (PaymentRequestDocument paymentRequestDocument : paymentRequests) {
            paymentRequestAmount = (KualiDecimal)paymentRequestAmount.add((AbstractKualiDecimal)paymentRequestDocument.getGrandTotal());
        }
        KualiDecimal creditMemoAmount = KualiDecimal.ZERO;
        for (VendorCreditMemoDocument creditMemoDocument : creditMemos) {
            creditMemoAmount = (KualiDecimal)creditMemoAmount.add((AbstractKualiDecimal)creditMemoDocument.getCreditMemoAmount());
        }
        boolean bl2 = false;
        if (paymentRequestAmount.compareTo((AbstractKualiDecimal)creditMemoAmount) > 0 && this.validatePaymentGroup(paymentGroup = this.buildPaymentGroup(paymentRequests, creditMemos, batch))) {
            this.businessObjectService.save((PersistableBusinessObject)paymentGroup);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created PaymentGroup: " + paymentGroup.getId());
            }
            Iterator<PaymentRequestDocument> iterator = totals;
            Integer n = ((Totals)((Object)iterator)).count;
            Integer n2 = ((Totals)((Object)iterator)).count = Integer.valueOf(((Totals)((Object)iterator)).count + 1);
            totals.totalAmount = (KualiDecimal)totals.totalAmount.add((AbstractKualiDecimal)paymentGroup.getNetPaymentAmount());
            for (VendorCreditMemoDocument cm : creditMemos) {
                this.updateCreditMemo(cm, puser, processRunDate);
            }
            for (PaymentRequestDocument pr : paymentRequests) {
                this.updatePaymentRequest(pr, puser, processRunDate);
            }
            bl = true;
        }
        if (!bl) {
            for (PaymentRequestDocument doc : paymentRequests) {
                preqsWithOutstandingCreditMemos.add(doc.getDocumentNumber());
            }
        }
    }

    protected PaymentGroup processSinglePaymentRequestDocument(PaymentRequestDocument paymentRequestDocument, Batch batch, Person puser, java.util.Date processRunDate) {
        ArrayList<PaymentRequestDocument> prds = new ArrayList<PaymentRequestDocument>();
        ArrayList<VendorCreditMemoDocument> cmds = new ArrayList<VendorCreditMemoDocument>();
        prds.add(paymentRequestDocument);
        PaymentGroup paymentGroup = this.buildPaymentGroup(prds, cmds, batch);
        if (this.validatePaymentGroup(paymentGroup)) {
            this.businessObjectService.save((PersistableBusinessObject)paymentGroup);
            this.updatePaymentRequest(paymentRequestDocument, puser, processRunDate);
        }
        return paymentGroup;
    }

    protected Totals extractSpecialPaymentsForChart(String campusCode, Person puser, java.util.Date processRunDate, Batch batch, boolean immediatesOnly) {
        Totals totals = new Totals();
        Iterator<PaymentRequestDocument> paymentRequests = null;
        if (immediatesOnly) {
            paymentRequests = this.paymentRequestService.getImmediatePaymentRequestsToExtract(campusCode).iterator();
        } else {
            Date onOrBeforePaymentRequestPayDate = KfsDateUtils.convertToSqlDate((java.util.Date)this.purapRunDateService.calculateRunDate(processRunDate));
            paymentRequests = this.paymentRequestService.getPaymentRequestsToExtractSpecialPayments(campusCode, onOrBeforePaymentRequestPayDate).iterator();
        }
        while (paymentRequests.hasNext()) {
            PaymentRequestDocument prd = paymentRequests.next();
            PaymentGroup pg = this.processSinglePaymentRequestDocument(prd, batch, puser, processRunDate);
            totals.count = totals.count + pg.getPaymentDetails().size();
            totals.totalAmount = (KualiDecimal)totals.totalAmount.add((AbstractKualiDecimal)pg.getNetPaymentAmount());
        }
        return totals;
    }

    protected void updateCreditMemo(VendorCreditMemoDocument creditMemoDocument, Person puser, java.util.Date processRunDate) {
        try {
            VendorCreditMemoDocument doc = (VendorCreditMemoDocument)this.documentService.getByDocumentHeaderId(creditMemoDocument.getDocumentNumber());
            doc.setExtractedTimestamp(new Timestamp(processRunDate.getTime()));
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)doc);
        }
        catch (WorkflowException e) {
            throw new IllegalArgumentException("Unable to retrieve credit memo: " + creditMemoDocument.getDocumentNumber());
        }
    }

    protected void updatePaymentRequest(PaymentRequestDocument paymentRequestDocument, Person puser, java.util.Date processRunDate) {
        try {
            PaymentRequestDocument doc = (PaymentRequestDocument)this.documentService.getByDocumentHeaderId(paymentRequestDocument.getDocumentNumber());
            doc.setExtractedTimestamp(new Timestamp(processRunDate.getTime()));
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)doc);
        }
        catch (WorkflowException e) {
            throw new IllegalArgumentException("Unable to retrieve payment request: " + paymentRequestDocument.getDocumentNumber());
        }
    }

    protected PaymentGroup buildPaymentGroup(List<PaymentRequestDocument> paymentRequests, List<VendorCreditMemoDocument> creditMemos, Batch batch) {
        PaymentDetail pd;
        PaymentGroup paymentGroup = null;
        if (creditMemos.size() > 0) {
            VendorCreditMemoDocument firstCmd = creditMemos.get(0);
            paymentGroup = this.populatePaymentGroup(firstCmd, batch);
        } else {
            PaymentRequestDocument firstPrd = paymentRequests.get(0);
            paymentGroup = this.populatePaymentGroup(firstPrd, batch);
        }
        for (PaymentRequestDocument pr : paymentRequests) {
            pd = this.populatePaymentDetail(pr, batch);
            paymentGroup.addPaymentDetails(pd);
        }
        for (VendorCreditMemoDocument cm : creditMemos) {
            pd = this.populatePaymentDetail(cm, batch);
            paymentGroup.addPaymentDetails(pd);
        }
        return paymentGroup;
    }

    protected boolean validatePaymentGroup(PaymentGroup paymentGroup) {
        List payDetails = paymentGroup.getPaymentDetails();
        int noteLines = 0;
        for (PaymentDetail paymentDetail : payDetails) {
            ++noteLines;
            noteLines += paymentDetail.getNotes().size();
        }
        int maxNoteLines = this.getMaxNoteLines();
        if (noteLines > maxNoteLines) {
            ArrayList<String> preqDocIds = new ArrayList<String>();
            ArrayList<String> cmDocIds = new ArrayList<String>();
            List pds = paymentGroup.getPaymentDetails();
            for (PaymentDetail payDetail : pds) {
                if ("CM".equals(payDetail.getFinancialDocumentTypeCode())) {
                    cmDocIds.add(payDetail.getCustPaymentDocNbr());
                    continue;
                }
                preqDocIds.add(payDetail.getCustPaymentDocNbr());
            }
            this.paymentFileEmailService.sendExceedsMaxNotesWarningEmail(cmDocIds, preqDocIds, noteLines, maxNoteLines);
            return false;
        }
        return true;
    }

    protected int getMaxNoteLines() {
        String maxLines = this.parameterService.getParameterValueAsString(KfsParameterConstants.PRE_DISBURSEMENT_ALL.class, PdpParameterConstants.MAX_NOTE_LINES);
        if (StringUtils.isBlank((CharSequence)maxLines)) {
            throw new RuntimeException("System parameter for max note lines is blank");
        }
        return Integer.parseInt(maxLines);
    }

    protected PaymentDetail populatePaymentDetail(VendorCreditMemoDocument creditMemoDocument, Batch batch) {
        PaymentDetail paymentDetail = new PaymentDetail();
        String invoiceNumber = creditMemoDocument.getCreditMemoNumber();
        if (invoiceNumber.length() > 25) {
            invoiceNumber = invoiceNumber.substring(0, 25);
        }
        paymentDetail.setInvoiceNbr(invoiceNumber);
        paymentDetail.setCustPaymentDocNbr(creditMemoDocument.getDocumentNumber());
        if (creditMemoDocument.getPurchaseOrderIdentifier() != null) {
            paymentDetail.setPurchaseOrderNbr(creditMemoDocument.getPurchaseOrderIdentifier().toString());
        }
        if (creditMemoDocument.getPurchaseOrderDocument() != null) {
            if (creditMemoDocument.getPurchaseOrderDocument().getRequisitionIdentifier() != null) {
                paymentDetail.setRequisitionNbr(creditMemoDocument.getPurchaseOrderDocument().getRequisitionIdentifier().toString());
            }
            if (creditMemoDocument.getDocumentHeader().getOrganizationDocumentNumber() != null) {
                paymentDetail.setOrganizationDocNbr(creditMemoDocument.getDocumentHeader().getOrganizationDocumentNumber());
            }
        }
        paymentDetail.setCustomerInstitutionNumber(StringUtils.defaultString((String)creditMemoDocument.getVendorCustomerNumber()));
        String creditMemoDocType = this.getDataDictionaryService().getDocumentTypeNameByClass(creditMemoDocument.getClass());
        paymentDetail.setFinancialDocumentTypeCode(creditMemoDocType);
        paymentDetail.setFinancialSystemOriginCode("01");
        paymentDetail.setInvoiceDate(creditMemoDocument.getCreditMemoDate());
        paymentDetail.setOrigInvoiceAmount((KualiDecimal)creditMemoDocument.getCreditMemoAmount().negated());
        paymentDetail.setNetPaymentAmount((KualiDecimal)creditMemoDocument.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount().negated());
        KualiDecimal shippingAmount = KualiDecimal.ZERO;
        KualiDecimal discountAmount = KualiDecimal.ZERO;
        KualiDecimal creditAmount = KualiDecimal.ZERO;
        KualiDecimal debitAmount = KualiDecimal.ZERO;
        for (CreditMemoItem item : creditMemoDocument.getItems()) {
            KualiDecimal itemAmount = KualiDecimal.ZERO;
            if (item.getExtendedPrice() != null) {
                itemAmount = item.getExtendedPrice();
            }
            if ("DISC".equals(item.getItemTypeCode())) {
                discountAmount = (KualiDecimal)discountAmount.subtract((AbstractKualiDecimal)itemAmount);
                continue;
            }
            if ("SPHD".equals(item.getItemTypeCode())) {
                shippingAmount = (KualiDecimal)shippingAmount.subtract((AbstractKualiDecimal)itemAmount);
                continue;
            }
            if ("FRHT".equals(item.getItemTypeCode())) {
                shippingAmount = (KualiDecimal)shippingAmount.add((AbstractKualiDecimal)itemAmount);
                continue;
            }
            if ("MNOR".equals(item.getItemTypeCode())) {
                debitAmount = (KualiDecimal)debitAmount.subtract((AbstractKualiDecimal)itemAmount);
                continue;
            }
            if (!"MISC".equals(item.getItemTypeCode())) continue;
            if (itemAmount.isNegative()) {
                creditAmount = (KualiDecimal)creditAmount.subtract((AbstractKualiDecimal)itemAmount);
                continue;
            }
            debitAmount = (KualiDecimal)debitAmount.subtract((AbstractKualiDecimal)itemAmount);
        }
        paymentDetail.setInvTotDiscountAmount(discountAmount);
        paymentDetail.setInvTotShipAmount(shippingAmount);
        paymentDetail.setInvTotOtherCreditAmount(creditAmount);
        paymentDetail.setInvTotOtherDebitAmount(debitAmount);
        paymentDetail.setPrimaryCancelledPayment(Boolean.FALSE);
        this.addAccounts(creditMemoDocument, paymentDetail, creditMemoDocType);
        this.addNotes(creditMemoDocument, paymentDetail);
        return paymentDetail;
    }

    protected PaymentDetail populatePaymentDetail(PaymentRequestDocument paymentRequestDocument, Batch batch) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Populating details for payment request document #" + paymentRequestDocument.getDocumentNumber());
        }
        PaymentDetail paymentDetail = new PaymentDetail();
        paymentDetail.setCustPaymentDocNbr(paymentRequestDocument.getDocumentNumber());
        String invoiceNumber = paymentRequestDocument.getInvoiceNumber();
        if (invoiceNumber.length() > 25) {
            invoiceNumber = invoiceNumber.substring(0, 25);
        }
        paymentDetail.setInvoiceNbr(invoiceNumber);
        if (paymentRequestDocument.getPurchaseOrderIdentifier() != null) {
            paymentDetail.setPurchaseOrderNbr(paymentRequestDocument.getPurchaseOrderIdentifier().toString());
        }
        if (paymentRequestDocument.getPurchaseOrderDocument().getRequisitionIdentifier() != null) {
            paymentDetail.setRequisitionNbr(paymentRequestDocument.getPurchaseOrderDocument().getRequisitionIdentifier().toString());
        }
        if (paymentRequestDocument.getDocumentHeader().getOrganizationDocumentNumber() != null) {
            paymentDetail.setOrganizationDocNbr(paymentRequestDocument.getDocumentHeader().getOrganizationDocumentNumber());
        }
        paymentDetail.setCustomerInstitutionNumber(StringUtils.defaultString((String)paymentRequestDocument.getVendorCustomerNumber()));
        String paymentRequestDocType = this.getDataDictionaryService().getDocumentTypeNameByClass(paymentRequestDocument.getClass());
        paymentDetail.setFinancialDocumentTypeCode(paymentRequestDocType);
        paymentDetail.setFinancialSystemOriginCode("01");
        paymentDetail.setInvoiceDate(paymentRequestDocument.getInvoiceDate());
        paymentDetail.setOrigInvoiceAmount(paymentRequestDocument.getVendorInvoiceAmount());
        if (paymentRequestDocument.isUseTaxIndicator()) {
            paymentDetail.setNetPaymentAmount(paymentRequestDocument.getGrandPreTaxTotal());
        } else {
            paymentDetail.setNetPaymentAmount(paymentRequestDocument.getGrandTotal());
        }
        KualiDecimal shippingAmount = KualiDecimal.ZERO;
        KualiDecimal discountAmount = KualiDecimal.ZERO;
        KualiDecimal creditAmount = KualiDecimal.ZERO;
        KualiDecimal debitAmount = KualiDecimal.ZERO;
        for (PaymentRequestItem item : paymentRequestDocument.getItems()) {
            KualiDecimal itemAmount = KualiDecimal.ZERO;
            if (item.getTotalRemitAmount() != null) {
                itemAmount = item.getTotalRemitAmount();
            }
            if ("DISC".equals(item.getItemTypeCode())) {
                discountAmount = (KualiDecimal)discountAmount.add((AbstractKualiDecimal)itemAmount);
                continue;
            }
            if ("SPHD".equals(item.getItemTypeCode())) {
                shippingAmount = (KualiDecimal)shippingAmount.add((AbstractKualiDecimal)itemAmount);
                continue;
            }
            if ("FRHT".equals(item.getItemTypeCode())) {
                shippingAmount = (KualiDecimal)shippingAmount.add((AbstractKualiDecimal)itemAmount);
                continue;
            }
            if ("MNOR".equals(item.getItemTypeCode())) {
                debitAmount = (KualiDecimal)debitAmount.add((AbstractKualiDecimal)itemAmount);
                continue;
            }
            if (!"MISC".equals(item.getItemTypeCode())) continue;
            if (itemAmount.isNegative()) {
                creditAmount = (KualiDecimal)creditAmount.add((AbstractKualiDecimal)itemAmount);
                continue;
            }
            debitAmount = (KualiDecimal)debitAmount.add((AbstractKualiDecimal)itemAmount);
        }
        paymentDetail.setInvTotDiscountAmount(discountAmount);
        paymentDetail.setInvTotShipAmount(shippingAmount);
        paymentDetail.setInvTotOtherCreditAmount(creditAmount);
        paymentDetail.setInvTotOtherDebitAmount(debitAmount);
        paymentDetail.setPrimaryCancelledPayment(Boolean.FALSE);
        this.addAccounts(paymentRequestDocument, paymentDetail, paymentRequestDocType);
        this.addNotes(paymentRequestDocument, paymentDetail);
        return paymentDetail;
    }

    protected void addAccounts(AccountsPayableDocument accountsPayableDocument, PaymentDetail paymentDetail, String documentType) {
        String creditMemoDocType = this.getDataDictionaryService().getDocumentTypeNameByClass(VendorCreditMemoDocument.class);
        List<SourceAccountingLine> sourceAccountingLines = this.purapAccountingService.generateSourceAccountsForVendorRemit(accountsPayableDocument);
        for (SourceAccountingLine sourceAccountingLine : sourceAccountingLines) {
            KualiDecimal lineAmount = sourceAccountingLine.getAmount();
            PaymentAccountDetail paymentAccountDetail = new PaymentAccountDetail();
            paymentAccountDetail.setAccountNbr(sourceAccountingLine.getAccountNumber());
            if (creditMemoDocType.equals(documentType)) {
                lineAmount = (KualiDecimal)lineAmount.negated();
            }
            paymentAccountDetail.setAccountNetAmount(lineAmount);
            paymentAccountDetail.setFinChartCode(sourceAccountingLine.getChartOfAccountsCode());
            paymentAccountDetail.setFinObjectCode(sourceAccountingLine.getFinancialObjectCode());
            paymentAccountDetail.setFinSubObjectCode((String)StringUtils.defaultIfEmpty((CharSequence)sourceAccountingLine.getFinancialSubObjectCode(), (CharSequence)KFSConstants.getDashFinancialSubObjectCode()));
            paymentAccountDetail.setOrgReferenceId(sourceAccountingLine.getOrganizationReferenceId());
            paymentAccountDetail.setProjectCode((String)StringUtils.defaultIfEmpty((CharSequence)sourceAccountingLine.getProjectCode(), (CharSequence)KFSConstants.getDashProjectCode()));
            paymentAccountDetail.setSubAccountNbr((String)StringUtils.defaultIfEmpty((CharSequence)sourceAccountingLine.getSubAccountNumber(), (CharSequence)KFSConstants.getDashSubAccountNumber()));
            paymentDetail.addAccountDetail(paymentAccountDetail);
        }
    }

    protected void addNotes(AccountsPayableDocument accountsPayableDocument, PaymentDetail paymentDetail) {
        PaymentNoteText pnt;
        int count = 1;
        if (accountsPayableDocument instanceof PaymentRequestDocument) {
            PaymentNoteText pnt2;
            PaymentRequestDocument prd = (PaymentRequestDocument)accountsPayableDocument;
            if (prd.getSpecialHandlingInstructionLine1Text() != null) {
                pnt2 = new PaymentNoteText();
                pnt2.setCustomerNoteLineNbr(new KualiInteger((long)count++));
                pnt2.setCustomerNoteText(prd.getSpecialHandlingInstructionLine1Text());
                paymentDetail.addNote(pnt2);
            }
            if (prd.getSpecialHandlingInstructionLine2Text() != null) {
                pnt2 = new PaymentNoteText();
                pnt2.setCustomerNoteLineNbr(new KualiInteger((long)count++));
                pnt2.setCustomerNoteText(prd.getSpecialHandlingInstructionLine2Text());
                paymentDetail.addNote(pnt2);
            }
            if (prd.getSpecialHandlingInstructionLine3Text() != null) {
                pnt2 = new PaymentNoteText();
                pnt2.setCustomerNoteLineNbr(new KualiInteger((long)count++));
                pnt2.setCustomerNoteText(prd.getSpecialHandlingInstructionLine3Text());
                paymentDetail.addNote(pnt2);
            }
        }
        if (accountsPayableDocument.getNoteLine1Text() != null) {
            pnt = new PaymentNoteText();
            pnt.setCustomerNoteLineNbr(new KualiInteger((long)count++));
            pnt.setCustomerNoteText(accountsPayableDocument.getNoteLine1Text());
            paymentDetail.addNote(pnt);
        }
        if (accountsPayableDocument.getNoteLine2Text() != null) {
            pnt = new PaymentNoteText();
            pnt.setCustomerNoteLineNbr(new KualiInteger((long)count++));
            pnt.setCustomerNoteText(accountsPayableDocument.getNoteLine2Text());
            paymentDetail.addNote(pnt);
        }
        if (accountsPayableDocument.getNoteLine3Text() != null) {
            pnt = new PaymentNoteText();
            pnt.setCustomerNoteLineNbr(new KualiInteger((long)count++));
            pnt.setCustomerNoteText(accountsPayableDocument.getNoteLine3Text());
            paymentDetail.addNote(pnt);
        }
        pnt = new PaymentNoteText();
        pnt.setCustomerNoteLineNbr(new KualiInteger((long)count++));
        pnt.setCustomerNoteText("Sales Tax: " + accountsPayableDocument.getTotalRemitTax());
    }

    protected PaymentGroup populatePaymentGroup(PaymentRequestDocument paymentRequestDocument, Batch batch) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("populatePaymentGroup() payment request documentNumber: " + paymentRequestDocument.getDocumentNumber());
        }
        PaymentGroup paymentGroup = new PaymentGroup();
        paymentGroup.setBatchId(batch.getId());
        paymentGroup.setPaymentStatusCode(KFSConstants.PdpConstants.PAYMENT_OPEN_STATUS_CODE);
        paymentGroup.setBankCode(paymentRequestDocument.getBankCode());
        String postalCode = paymentRequestDocument.getVendorPostalCode();
        if ("US".equals(paymentRequestDocument.getVendorCountry()) && postalCode.length() > 5) {
            postalCode = postalCode.substring(0, 5) + "-" + postalCode.substring(5);
        }
        paymentGroup.setPayeeName(paymentRequestDocument.getVendorName());
        paymentGroup.setPayeeId(paymentRequestDocument.getVendorHeaderGeneratedIdentifier() + "-" + paymentRequestDocument.getVendorDetailAssignedIdentifier());
        paymentGroup.setPayeeIdTypeCd(PdpConstants.PayeeIdTypeCodes.VENDOR_ID);
        if (paymentRequestDocument.getVendorDetail().getVendorHeader().getVendorOwnershipCode() != null) {
            paymentGroup.setPayeeOwnerCd(paymentRequestDocument.getVendorDetail().getVendorHeader().getVendorOwnershipCode());
        }
        paymentGroup.setLine1Address(paymentRequestDocument.getVendorLine1Address());
        paymentGroup.setLine2Address(paymentRequestDocument.getVendorLine2Address());
        paymentGroup.setLine3Address("");
        paymentGroup.setLine4Address("");
        paymentGroup.setCity(paymentRequestDocument.getVendorCityName());
        paymentGroup.setState(paymentRequestDocument.getVendorStateCode());
        paymentGroup.setZipCd(postalCode);
        paymentGroup.setCountry(paymentRequestDocument.getVendorCountryCode());
        paymentGroup.setCampusAddress(Boolean.FALSE);
        if (paymentRequestDocument.getPaymentRequestPayDate() != null) {
            paymentGroup.setPaymentDate(paymentRequestDocument.getPaymentRequestPayDate());
        }
        paymentGroup.setPymtAttachment(Boolean.valueOf(paymentRequestDocument.getPaymentAttachmentIndicator()));
        paymentGroup.setProcessImmediate(Boolean.valueOf(paymentRequestDocument.getImmediatePaymentIndicator()));
        paymentGroup.setPymtSpecialHandling(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)paymentRequestDocument.getSpecialHandlingInstructionLine1Text()) || StringUtils.isNotBlank((CharSequence)paymentRequestDocument.getSpecialHandlingInstructionLine2Text()) || StringUtils.isNotBlank((CharSequence)paymentRequestDocument.getSpecialHandlingInstructionLine3Text())));
        paymentGroup.setTaxablePayment(Boolean.FALSE);
        paymentGroup.setNraPayment(paymentRequestDocument.getVendorDetail().getVendorHeader().getVendorForeignIndicator());
        paymentGroup.setCombineGroups(Boolean.TRUE);
        return paymentGroup;
    }

    protected PaymentGroup populatePaymentGroup(VendorCreditMemoDocument creditMemoDocument, Batch batch) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("populatePaymentGroup() credit memo documentNumber: " + creditMemoDocument.getDocumentNumber());
        }
        PaymentGroup paymentGroup = new PaymentGroup();
        paymentGroup.setBatchId(batch.getId());
        paymentGroup.setPaymentStatusCode(KFSConstants.PdpConstants.PAYMENT_OPEN_STATUS_CODE);
        paymentGroup.setBankCode(creditMemoDocument.getBankCode());
        String postalCode = creditMemoDocument.getVendorPostalCode();
        if ("US".equals(creditMemoDocument.getVendorCountry()) && postalCode.length() > 5) {
            postalCode = postalCode.substring(0, 5) + "-" + postalCode.substring(5);
        }
        paymentGroup.setPayeeName(creditMemoDocument.getVendorName());
        paymentGroup.setPayeeId(creditMemoDocument.getVendorHeaderGeneratedIdentifier() + "-" + creditMemoDocument.getVendorDetailAssignedIdentifier());
        paymentGroup.setPayeeIdTypeCd(PdpConstants.PayeeIdTypeCodes.VENDOR_ID);
        if (creditMemoDocument.getVendorDetail().getVendorHeader().getVendorOwnershipCode() != null) {
            paymentGroup.setPayeeOwnerCd(creditMemoDocument.getVendorDetail().getVendorHeader().getVendorOwnershipCode());
        }
        paymentGroup.setLine1Address(creditMemoDocument.getVendorLine1Address());
        paymentGroup.setLine2Address(creditMemoDocument.getVendorLine2Address());
        paymentGroup.setLine3Address("");
        paymentGroup.setLine4Address("");
        paymentGroup.setCity(creditMemoDocument.getVendorCityName());
        paymentGroup.setState(creditMemoDocument.getVendorStateCode());
        paymentGroup.setZipCd(postalCode);
        paymentGroup.setCountry(creditMemoDocument.getVendorCountryCode());
        paymentGroup.setCampusAddress(Boolean.FALSE);
        if (creditMemoDocument.getCreditMemoDate() != null) {
            paymentGroup.setPaymentDate(creditMemoDocument.getCreditMemoDate());
        }
        paymentGroup.setPymtAttachment(Boolean.FALSE);
        paymentGroup.setProcessImmediate(Boolean.FALSE);
        paymentGroup.setPymtSpecialHandling(Boolean.FALSE);
        paymentGroup.setTaxablePayment(Boolean.FALSE);
        paymentGroup.setNraPayment(creditMemoDocument.getVendorDetail().getVendorHeader().getVendorForeignIndicator());
        paymentGroup.setCombineGroups(Boolean.TRUE);
        return paymentGroup;
    }

    protected Batch createBatch(String campusCode, Person puser, java.util.Date processRunDate) {
        String subUnitCode;
        String orgCode = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_BATCH.class, "PRE_DISBURSEMENT_EXTRACT_ORGANIZATION");
        CustomerProfile customer = this.customerProfileService.get(campusCode, orgCode, subUnitCode = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_BATCH.class, "PRE_DISBURSEMENT_EXTRACT_SUB_UNIT"));
        if (customer == null) {
            throw new IllegalArgumentException("Unable to find customer profile for " + campusCode + "/" + orgCode + "/" + subUnitCode);
        }
        Batch batch = new Batch();
        batch.setCustomerProfile(customer);
        batch.setCustomerFileCreateTimestamp(new Timestamp(processRunDate.getTime()));
        batch.setFileProcessTimestamp(new Timestamp(processRunDate.getTime()));
        batch.setPaymentFileName("extr_fr_purap");
        batch.setSubmiterUserId(puser.getPrincipalId());
        batch.setPaymentCount(KualiInteger.ZERO);
        batch.setPaymentTotalAmount(KualiDecimal.ZERO);
        this.businessObjectService.save((PersistableBusinessObject)batch);
        return batch;
    }

    protected List<String> getChartCodes(boolean immediatesOnly, java.util.Date processRunDate) {
        LOG.debug("Getting Chart Codes()");
        ArrayList<String> output = new ArrayList<String>();
        Iterator<PaymentRequestDocument> paymentRequests = null;
        if (immediatesOnly) {
            paymentRequests = this.paymentRequestService.getImmediatePaymentRequestsToExtract(null).iterator();
        } else {
            Date onOrBeforePaymentRequestPayDate = KfsDateUtils.convertToSqlDate((java.util.Date)this.purapRunDateService.calculateRunDate(processRunDate));
            paymentRequests = this.paymentRequestService.getPaymentRequestsToExtract(onOrBeforePaymentRequestPayDate).iterator();
        }
        while (paymentRequests.hasNext()) {
            PaymentRequestDocument prd = paymentRequests.next();
            if (output.contains(prd.getProcessingCampusCode())) continue;
            output.add(prd.getProcessingCampusCode());
        }
        return output;
    }

    protected void lockUnlockDocuments(boolean locked) {
        for (String documentType : this.lockedDocuments) {
            Class documentClass = this.dataDictionaryService.getDocumentClassByTypeName(documentType);
            if (this.parameterService.parameterExists(documentClass, "LOCKOUT_IND").booleanValue()) {
                Parameter existingParam = this.parameterService.getParameter(documentClass, "LOCKOUT_IND");
                Parameter.Builder updatedParam = Parameter.Builder.create((ParameterContract)existingParam);
                updatedParam.setValue(locked ? "Y" : "N");
                this.parameterService.updateParameter(updatedParam.build());
                continue;
            }
            String namespace = KRADServiceLocatorWeb.getKualiModuleService().getNamespaceCode(documentClass);
            String detailType = KRADServiceLocatorWeb.getKualiModuleService().getComponentCode(documentClass);
            Parameter.Builder newParam = Parameter.Builder.create((String)"KFS", (String)namespace, (String)detailType, (String)"LOCKOUT_IND", (ParameterType.Builder)ParameterType.Builder.create((String)"CONFG"));
            newParam.setValue("Y");
            newParam.setDescription("This parameter is to lock document during the lockout time.");
            this.parameterService.createParameter(newParam.build());
        }
    }

    public void setPaymentRequestService(PaymentRequestService paymentRequestService) {
        this.paymentRequestService = paymentRequestService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setPaymentFileService(PaymentFileService paymentFileService) {
        this.paymentFileService = paymentFileService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setCustomerProfileService(CustomerProfileService customerProfileService) {
        this.customerProfileService = customerProfileService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setPaymentGroupService(PaymentGroupService paymentGroupService) {
        this.paymentGroupService = paymentGroupService;
    }

    public void setPaymentDetailService(PaymentDetailService paymentDetailService) {
        this.paymentDetailService = paymentDetailService;
    }

    public void setCreditMemoService(CreditMemoService creditMemoService) {
        this.creditMemoService = creditMemoService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setPurapRunDateService(PurapRunDateService purapRunDateService) {
        this.purapRunDateService = purapRunDateService;
    }

    public void setPaymentFileEmailService(PdpEmailService paymentFileEmailService) {
        this.paymentFileEmailService = paymentFileEmailService;
    }

    public void setBankService(BankService bankService) {
        this.bankService = bankService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setPurapAccountingService(PurapAccountingServiceImpl purapAccountingService) {
        this.purapAccountingService = purapAccountingService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = (PersonService)SpringContext.getBean(PersonService.class);
        }
        return this.personService;
    }

    public void setLockedDocuments(List<String> lockedDocuments) {
        this.lockedDocuments = lockedDocuments;
    }

    protected class AccountingInfo {
        protected String chart;
        protected String account;
        protected String subAccount;
        protected String objectCode;
        protected String subObjectCode;
        protected String orgReferenceId;
        protected String projectCode;

        public AccountingInfo(String c, String a, String s, String o, String so, String or, String pc) {
            this.setChart(c);
            this.setAccount(a);
            this.setSubAccount(s);
            this.setObjectCode(o);
            this.setSubObjectCode(so);
            this.setOrgReferenceId(or);
            this.setProjectCode(pc);
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public void setChart(String chart) {
            this.chart = chart;
        }

        public void setObjectCode(String objectCode) {
            this.objectCode = objectCode;
        }

        public void setOrgReferenceId(String orgReferenceId) {
            this.orgReferenceId = orgReferenceId;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode == null ? KFSConstants.getDashProjectCode() : projectCode;
        }

        public void setSubAccount(String subAccount) {
            this.subAccount = subAccount == null ? KFSConstants.getDashSubAccountNumber() : subAccount;
        }

        public void setSubObjectCode(String subObjectCode) {
            this.subObjectCode = subObjectCode == null ? KFSConstants.getDashFinancialSubObjectCode() : subObjectCode;
        }

        protected String key() {
            return this.chart + "~" + this.account + "~" + this.subAccount + "~" + this.objectCode + "~" + this.subObjectCode + "~" + this.orgReferenceId + "~" + this.projectCode;
        }

        public int hashCode() {
            return new HashCodeBuilder(3, 5).append((Object)this.key()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AccountingInfo)) {
                return false;
            }
            AccountingInfo thisobj = (AccountingInfo)obj;
            return new EqualsBuilder().append((Object)this.key(), (Object)thisobj.key()).isEquals();
        }
    }

    protected class Totals {
        public Integer count = 0;
        public KualiDecimal totalAmount = KualiDecimal.ZERO;

        protected Totals() {
        }
    }
}

