/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableSummaryAccount;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.kfs.module.purap.businessobject.PurApItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountRevisionService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.PurapGeneralLedgerService;
import org.kuali.kfs.module.purap.util.SummaryAccount;
import org.kuali.kfs.module.purap.util.UseTaxContainer;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PurapGeneralLedgerServiceImpl
implements PurapGeneralLedgerService {
    private static final Logger LOG = LogManager.getLogger(PurapGeneralLedgerServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    private PaymentRequestService paymentRequestService;
    private PurapAccountingService purapAccountingService;
    private PurchaseOrderService purchaseOrderService;
    private UniversityDateService universityDateService;
    private ObjectCodeService objectCodeService;
    private PurapAccountRevisionService purapAccountRevisionService;

    @Override
    public void customizeGeneralLedgerPendingEntry(PurchasingAccountsPayableDocument purapDocument, AccountingLine accountingLine, GeneralLedgerPendingEntry explicitEntry, Integer referenceDocumentNumber, String debitCreditCode, String docType, boolean isEncumbrance) {
        ObjectCode objectCode;
        LOG.debug("customizeGeneralLedgerPendingEntry() started");
        explicitEntry.setDocumentNumber(purapDocument.getDocumentNumber());
        explicitEntry.setTransactionLedgerEntryDescription(this.entryDescription(purapDocument.getVendorName()));
        explicitEntry.setFinancialSystemOriginationCode("01");
        if (ObjectUtils.isNotNull((Object)referenceDocumentNumber)) {
            explicitEntry.setReferenceFinancialDocumentNumber(referenceDocumentNumber.toString());
            explicitEntry.setReferenceFinancialDocumentTypeCode("PO");
            explicitEntry.setReferenceFinancialSystemOriginationCode("01");
        }
        UniversityDate uDate = this.universityDateService.getCurrentUniversityDate();
        explicitEntry.setUniversityFiscalYear(uDate.getUniversityFiscalYear());
        explicitEntry.setUniversityFiscalPeriodCode(uDate.getUniversityFiscalAccountingPeriod());
        if ("PO".equals(docType)) {
            if (purapDocument.getPostingYear().compareTo(uDate.getUniversityFiscalYear()) > 0) {
                explicitEntry.setUniversityFiscalYear(purapDocument.getPostingYear());
                explicitEntry.setUniversityFiscalPeriodCode("01");
            }
        } else if ("PREQ".equals(docType)) {
            PaymentRequestDocument preq = (PaymentRequestDocument)purapDocument;
            if (this.paymentRequestService.allowBackpost(preq)) {
                LOG.debug("createGlPendingTransaction() within range to allow backpost; posting entry to period 12 of previous FY");
                explicitEntry.setUniversityFiscalYear(Integer.valueOf(uDate.getUniversityFiscalYear() - 1));
                explicitEntry.setUniversityFiscalPeriodCode("12");
            }
            if (preq.getAlternateVendorHeaderGeneratedIdentifier() != null && preq.getAlternateVendorDetailAssignedIdentifier() != null && preq.getVendorHeaderGeneratedIdentifier().compareTo(preq.getAlternateVendorHeaderGeneratedIdentifier()) == 0 && preq.getVendorDetailAssignedIdentifier().compareTo(preq.getAlternateVendorDetailAssignedIdentifier()) == 0) {
                explicitEntry.setTransactionLedgerEntryDescription(this.entryDescription(preq.getPurchaseOrderDocument().getAlternateVendorName()));
            }
        } else if ("CM".equals(docType)) {
            PaymentRequestDocument cmPR;
            VendorCreditMemoDocument cm = (VendorCreditMemoDocument)purapDocument;
            if (cm.isSourceDocumentPaymentRequest() && (cmPR = cm.getPaymentRequestDocument()).getAlternateVendorHeaderGeneratedIdentifier() != null && cmPR.getAlternateVendorDetailAssignedIdentifier() != null && cmPR.getVendorHeaderGeneratedIdentifier().compareTo(cmPR.getAlternateVendorHeaderGeneratedIdentifier()) == 0 && cmPR.getVendorDetailAssignedIdentifier().compareTo(cmPR.getAlternateVendorDetailAssignedIdentifier()) == 0) {
                PurchaseOrderDocument cmPO = cm.getPurchaseOrderDocument();
                explicitEntry.setTransactionLedgerEntryDescription(this.entryDescription(cmPO.getAlternateVendorName()));
            }
        } else {
            throw new IllegalArgumentException("purapDocument is invalid doc type: " + purapDocument.getDocumentNumber());
        }
        if (ObjectUtils.isNotNull((Object)(objectCode = this.objectCodeService.getByPrimaryId(explicitEntry.getUniversityFiscalYear(), explicitEntry.getChartOfAccountsCode(), explicitEntry.getFinancialObjectCode())))) {
            explicitEntry.setFinancialObjectTypeCode(objectCode.getFinancialObjectTypeCode());
        }
        if (isEncumbrance) {
            explicitEntry.setFinancialBalanceTypeCode("EX");
            explicitEntry.setTransactionEncumbranceUpdateCode("R");
        }
        if (accountingLine.getAmount().doubleValue() < 0.0) {
            if ("C".equals(debitCreditCode)) {
                explicitEntry.setTransactionDebitCreditCode("D");
            } else {
                explicitEntry.setTransactionDebitCreditCode("C");
            }
        } else {
            explicitEntry.setTransactionDebitCreditCode(debitCreditCode);
        }
    }

    @Override
    public void generateEntriesCancelAccountsPayableDocument(AccountsPayableDocument apDocument) {
        LOG.debug("generateEntriesCancelAccountsPayableDocument() started");
        if (apDocument instanceof PaymentRequestDocument) {
            LOG.info("generateEntriesCancelAccountsPayableDocument() cancel PaymentRequestDocument");
            this.generateEntriesCancelPaymentRequest((PaymentRequestDocument)apDocument);
        } else if (apDocument instanceof VendorCreditMemoDocument) {
            LOG.info("generateEntriesCancelAccountsPayableDocument() cancel CreditMemoDocument");
            this.generateEntriesCancelCreditMemo((VendorCreditMemoDocument)apDocument);
        }
    }

    @Override
    public void generateEntriesCreatePaymentRequest(PaymentRequestDocument preq) {
        LOG.debug("generateEntriesCreatePaymentRequest() started");
        List<SourceAccountingLine> encumbrances = this.relieveEncumbrance(preq);
        List<SummaryAccount> summaryAccounts = this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax(preq);
        this.generateEntriesPaymentRequest(preq, encumbrances, summaryAccounts, "create");
    }

    protected void generateEntriesCancelPaymentRequest(PaymentRequestDocument preq) {
        LOG.debug("generateEntriesCreatePaymentRequest() started");
        List<SourceAccountingLine> encumbrances = this.reencumberEncumbrance(preq);
        List<SummaryAccount> summaryAccounts = this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax(preq);
        this.generateEntriesPaymentRequest(preq, encumbrances, summaryAccounts, "cancel");
    }

    @Override
    public void generateEntriesModifyPaymentRequest(PaymentRequestDocument preq) {
        LOG.debug("generateEntriesModifyPaymentRequest() started");
        HashMap<SourceAccountingLine, KualiDecimal> actualsPositive = new HashMap<SourceAccountingLine, KualiDecimal>();
        List<SourceAccountingLine> newAccountingLines = this.purapAccountingService.generateSummaryWithNoZeroTotalsNoUseTax(preq.getItems());
        for (SourceAccountingLine newAccount : newAccountingLines) {
            actualsPositive.put(newAccount, newAccount.getAmount());
            LOG.debug("generateEntriesModifyPaymentRequest() actualsPositive: " + newAccount.getAccountNumber() + " = " + newAccount.getAmount());
        }
        HashMap<SourceAccountingLine, KualiDecimal> actualsNegative = new HashMap<SourceAccountingLine, KualiDecimal>();
        List oldAccountingLines = this.purapAccountingService.getAccountsPayableSummaryAccounts(preq.getPurapDocumentIdentifier(), "PREQ");
        for (AccountsPayableSummaryAccount oldAccount : oldAccountingLines) {
            actualsNegative.put(oldAccount.generateSourceAccountingLine(), oldAccount.getAmount());
            LOG.debug("generateEntriesModifyPaymentRequest() actualsNegative: " + oldAccount.getAccountNumber() + " = " + oldAccount.getAmount());
        }
        HashMap<SourceAccountingLine, KualiDecimal> glEntries = new HashMap<SourceAccountingLine, KualiDecimal>();
        LOG.debug("generateEntriesModifyPaymentRequest() Combine positive/negative entries");
        glEntries.putAll(actualsPositive);
        for (SourceAccountingLine key : actualsNegative.keySet()) {
            KualiDecimal amt;
            if (glEntries.containsKey(key)) {
                amt = (KualiDecimal)glEntries.get(key);
                amt = (KualiDecimal)amt.subtract((AbstractKualiDecimal)actualsNegative.get(key));
            } else {
                amt = KualiDecimal.ZERO;
                amt = (KualiDecimal)amt.subtract((AbstractKualiDecimal)actualsNegative.get(key));
            }
            glEntries.put(key, amt);
        }
        ArrayList<SummaryAccount> summaryAccounts = new ArrayList<SummaryAccount>();
        for (SourceAccountingLine account : glEntries.keySet()) {
            KualiDecimal amount = (KualiDecimal)glEntries.get(account);
            if (KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)amount) == 0) continue;
            account.setAmount(amount);
            SummaryAccount sa = new SummaryAccount(account);
            summaryAccounts.add(sa);
        }
        LOG.debug("generateEntriesModifyPaymentRequest() Generate GL entries");
        this.generateEntriesPaymentRequest(preq, null, summaryAccounts, "modify");
    }

    @Override
    public void generateEntriesCreateCreditMemo(VendorCreditMemoDocument cm) {
        LOG.debug("generateEntriesCreateCreditMemo() started");
        this.generateEntriesCreditMemo(cm, false);
    }

    protected void generateEntriesCancelCreditMemo(VendorCreditMemoDocument cm) {
        LOG.debug("generateEntriesCancelCreditMemo() started");
        this.generateEntriesCreditMemo(cm, true);
    }

    protected int getNextAvailableSequence(String documentNumber) {
        LOG.debug("getNextAvailableSequence() started");
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialSystemOriginationCode", "01");
        fieldValues.put("documentNumber", documentNumber);
        int count = this.businessObjectService.countMatching(GeneralLedgerPendingEntry.class, fieldValues);
        return count + 1;
    }

    protected boolean generateEntriesPaymentRequest(PaymentRequestDocument preq, List encumbrances, List summaryAccounts, String processType) {
        LOG.debug("generateEntriesPaymentRequest() started");
        boolean success = true;
        preq.setGeneralLedgerPendingEntries(new ArrayList());
        GeneralLedgerPendingEntrySequenceHelper sequenceHelper = new GeneralLedgerPendingEntrySequenceHelper(this.getNextAvailableSequence(preq.getDocumentNumber()));
        if (!(encumbrances == null || "cancel".equals(processType) && "Closed".equals(preq.getPurchaseOrderDocument().getApplicationDocumentStatus()))) {
            LOG.debug("generateEntriesPaymentRequest() generate encumbrance entries");
            if ("create".equals(processType)) {
                preq.setDebitCreditCodeForGLEntries("C");
            } else if ("cancel".equals(processType)) {
                preq.setDebitCreditCodeForGLEntries("D");
            } else if ("modify".equals(processType)) {
                // empty if block
            }
            preq.setGenerateEncumbranceEntries(true);
            for (AccountingLine accountingLine : encumbrances) {
                preq.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)accountingLine, sequenceHelper);
                sequenceHelper.increment();
            }
        }
        if (ObjectUtils.isNotNull((Object)summaryAccounts) && !summaryAccounts.isEmpty()) {
            LOG.debug("generateEntriesPaymentRequest() now book the actuals");
            preq.setGenerateEncumbranceEntries(false);
            if ("create".equals(processType) || "modify".equals(processType)) {
                preq.setDebitCreditCodeForGLEntries("D");
            } else if ("cancel".equals(processType)) {
                preq.setDebitCreditCodeForGLEntries("C");
            }
            for (Object summaryAccount : summaryAccounts) {
                preq.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)((SummaryAccount)summaryAccount).getAccount(), sequenceHelper);
                sequenceHelper.increment();
            }
            List<UseTaxContainer> useTaxContainers = this.purapAccountingService.generateUseTaxAccount(preq);
            for (UseTaxContainer useTaxContainer : useTaxContainers) {
                PurApItemUseTax offset = useTaxContainer.getUseTax();
                List<SourceAccountingLine> accounts = useTaxContainer.getAccounts();
                for (SourceAccountingLine sourceAccountingLine : accounts) {
                    preq.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)sourceAccountingLine, sequenceHelper, useTaxContainer.getUseTax());
                    sequenceHelper.increment();
                }
            }
            if ("modify".equals(processType)) {
                List<SummaryAccount> summaryAccountsForModify = this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax(preq);
                this.saveAccountsPayableSummaryAccounts(summaryAccountsForModify, preq.getPurapDocumentIdentifier(), "PREQ");
            } else {
                this.saveAccountsPayableSummaryAccounts(summaryAccounts, preq.getPurapDocumentIdentifier(), "PREQ");
            }
            if ("create".equals(processType) || "modify".equals(processType)) {
                this.purapAccountRevisionService.savePaymentRequestAccountRevisions(preq.getItems(), preq.getPostingYearFromPendingGLEntries(), preq.getPostingPeriodCodeFromPendingGLEntries());
            } else if ("cancel".equals(processType)) {
                this.purapAccountRevisionService.cancelPaymentRequestAccountRevisions(preq.getItems(), preq.getPostingYearFromPendingGLEntries(), preq.getPostingPeriodCodeFromPendingGLEntries());
            }
        }
        this.saveGLEntries(preq.getGeneralLedgerPendingEntries());
        return success;
    }

    protected boolean generateEntriesCreditMemo(VendorCreditMemoDocument cm, boolean isCancel) {
        List<SummaryAccount> summaryAccounts;
        LOG.debug("generateEntriesCreditMemo() started");
        cm.setGeneralLedgerPendingEntries(new ArrayList());
        boolean success = true;
        GeneralLedgerPendingEntrySequenceHelper sequenceHelper = new GeneralLedgerPendingEntrySequenceHelper(this.getNextAvailableSequence(cm.getDocumentNumber()));
        if (!cm.isSourceVendor()) {
            LOG.debug("generateEntriesCreditMemo() create encumbrance entries for CM against a PO or PREQ (not vendor)");
            PurchaseOrderDocument po = null;
            if (cm.isSourceDocumentPurchaseOrder()) {
                LOG.debug("generateEntriesCreditMemo() PO type");
                po = this.purchaseOrderService.getCurrentPurchaseOrder(cm.getPurchaseOrderIdentifier());
            } else if (cm.isSourceDocumentPaymentRequest()) {
                LOG.debug("generateEntriesCreditMemo() PREQ type");
                po = this.purchaseOrderService.getCurrentPurchaseOrder(cm.getPaymentRequestDocument().getPurchaseOrderIdentifier());
            }
            List<SourceAccountingLine> encumbrances = this.getCreditMemoEncumbrance(cm, po, isCancel);
            if (!"Closed".equals(po.getApplicationDocumentStatus()) && encumbrances != null) {
                cm.setGenerateEncumbranceEntries(true);
                cm.setDebitCreditCodeForGLEntries("D");
                for (AccountingLine accountingLine : encumbrances) {
                    if (accountingLine.getAmount().compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) == 0) continue;
                    cm.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)accountingLine, sequenceHelper);
                    sequenceHelper.increment();
                }
            }
        }
        if ((summaryAccounts = this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax(cm)) != null) {
            LOG.debug("generateEntriesCreditMemo() now book the actuals");
            cm.setGenerateEncumbranceEntries(false);
            if (!isCancel) {
                cm.setDebitCreditCodeForGLEntries("C");
            } else {
                cm.setDebitCreditCodeForGLEntries("D");
            }
            for (SummaryAccount summaryAccount : summaryAccounts) {
                cm.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)summaryAccount.getAccount(), sequenceHelper);
                sequenceHelper.increment();
            }
            List<UseTaxContainer> useTaxContainers = this.purapAccountingService.generateUseTaxAccount(cm);
            for (UseTaxContainer useTaxContainer : useTaxContainers) {
                PurApItemUseTax offset = useTaxContainer.getUseTax();
                List<SourceAccountingLine> accounts = useTaxContainer.getAccounts();
                for (SourceAccountingLine sourceAccountingLine : accounts) {
                    cm.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)sourceAccountingLine, sequenceHelper, useTaxContainer.getUseTax());
                    sequenceHelper.increment();
                }
            }
            if (!isCancel) {
                this.purapAccountRevisionService.saveCreditMemoAccountRevisions(cm.getItems(), cm.getPostingYearFromPendingGLEntries(), cm.getPostingPeriodCodeFromPendingGLEntries());
            } else {
                this.purapAccountRevisionService.cancelCreditMemoAccountRevisions(cm.getItems(), cm.getPostingYearFromPendingGLEntries(), cm.getPostingPeriodCodeFromPendingGLEntries());
            }
        }
        this.saveGLEntries(cm.getGeneralLedgerPendingEntries());
        LOG.debug("generateEntriesCreditMemo() ended");
        return success;
    }

    @Override
    public void generateEntriesApproveAmendPurchaseOrder(PurchaseOrderDocument po) {
        LOG.debug("generateEntriesApproveAmendPurchaseOrder() started");
        Iterator items = po.getItems().iterator();
        while (items.hasNext()) {
            PurchaseOrderItem item;
            item.setItemInvoicedTotalAmount((item = (PurchaseOrderItem)items.next()).getItemInvoicedTotalAmount() == null ? KualiDecimal.ZERO : item.getItemInvoicedTotalAmount());
            item.setItemInvoicedTotalQuantity(item.getItemInvoicedTotalQuantity() == null ? KualiDecimal.ZERO : item.getItemInvoicedTotalQuantity());
            if (!item.isItemActiveIndicator()) {
                item.setItemOutstandingEncumberedQuantity(KualiDecimal.ZERO);
                item.setItemOutstandingEncumberedAmount(KualiDecimal.ZERO);
                for (PurchaseOrderAccount purchaseOrderAccount : item.getSourceAccountingLines()) {
                    purchaseOrderAccount.setItemAccountOutstandingEncumbranceAmount(KualiDecimal.ZERO);
                    purchaseOrderAccount.setAlternateAmountForGLEntryCreation(KualiDecimal.ZERO);
                }
                continue;
            }
            if (item.getItemQuantity() != null) {
                item.setItemOutstandingEncumberedQuantity((KualiDecimal)item.getItemQuantity().subtract((AbstractKualiDecimal)item.getItemInvoicedTotalQuantity()));
            } else {
                item.setItemOutstandingEncumberedQuantity(null);
            }
            if (item.getItemOutstandingEncumberedQuantity() != null) {
                KualiDecimal itemEncumber = new KualiDecimal(item.getItemOutstandingEncumberedQuantity().bigDecimalValue().multiply(item.getItemUnitPrice()));
                KualiDecimal kualiDecimal = item.getItemTaxAmount() == null ? KualiDecimal.ZERO : item.getItemTaxAmount();
                itemEncumber = (KualiDecimal)itemEncumber.add((AbstractKualiDecimal)kualiDecimal);
                item.setItemOutstandingEncumberedAmount(itemEncumber);
            } else if (item.getItemUnitPrice() != null) {
                item.setItemOutstandingEncumberedAmount(new KualiDecimal(item.getItemUnitPrice().subtract(item.getItemInvoicedTotalAmount().bigDecimalValue())));
            }
            for (PurchaseOrderAccount purchaseOrderAccount : item.getSourceAccountingLines()) {
                BigDecimal percent = new BigDecimal(purchaseOrderAccount.getAccountLinePercent().toString());
                percent = percent.divide(new BigDecimal("100"), 3, 4);
                purchaseOrderAccount.setItemAccountOutstandingEncumbranceAmount((KualiDecimal)item.getItemOutstandingEncumberedAmount().multiply((AbstractKualiDecimal)new KualiDecimal(percent)));
                purchaseOrderAccount.setAlternateAmountForGLEntryCreation(purchaseOrderAccount.getItemAccountOutstandingEncumbranceAmount());
            }
        }
        PurchaseOrderDocument oldPO = this.purchaseOrderService.getCurrentPurchaseOrder(po.getPurapDocumentIdentifier());
        if (oldPO == null) {
            throw new IllegalArgumentException("Current Purchase Order not found - poId = " + oldPO.getPurapDocumentIdentifier());
        }
        List<SourceAccountingLine> newAccounts = this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(po.getItemsActiveOnly());
        List<SourceAccountingLine> oldAccounts = this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(oldPO.getItemsActiveOnlySetupAlternateAmount());
        HashMap<SourceAccountingLine, Object> hashMap = new HashMap<SourceAccountingLine, Object>();
        for (SourceAccountingLine newAccount : newAccounts) {
            hashMap.put(newAccount, newAccount.getAmount());
        }
        LOG.info("generateEntriesApproveAmendPurchaseOrder() combination after the add");
        for (SourceAccountingLine element : hashMap.keySet()) {
            LOG.info("generateEntriesApproveAmendPurchaseOrder() " + element + " = " + ((KualiDecimal)hashMap.get(element)).floatValue());
        }
        for (SourceAccountingLine oldAccount : oldAccounts) {
            if (hashMap.containsKey(oldAccount)) {
                KualiDecimal amount = (KualiDecimal)hashMap.get(oldAccount);
                amount = (KualiDecimal)amount.subtract((AbstractKualiDecimal)oldAccount.getAmount());
                hashMap.put(oldAccount, amount);
                continue;
            }
            hashMap.put(oldAccount, KualiDecimal.ZERO.subtract((AbstractKualiDecimal)oldAccount.getAmount()));
        }
        LOG.debug("generateEntriesApproveAmendPurchaseOrder() combination after the subtract");
        for (SourceAccountingLine element : hashMap.keySet()) {
            LOG.info("generateEntriesApproveAmendPurchaseOrder() " + element + " = " + ((KualiDecimal)hashMap.get(element)).floatValue());
        }
        ArrayList<SourceAccountingLine> encumbranceAccounts = new ArrayList<SourceAccountingLine>();
        for (SourceAccountingLine account : hashMap.keySet()) {
            KualiDecimal amount = (KualiDecimal)hashMap.get(account);
            if (KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)amount) == 0) continue;
            account.setAmount(amount);
            encumbranceAccounts.add(account);
        }
        po.setGlOnlySourceAccountingLines(encumbranceAccounts);
        this.generalLedgerPendingEntryService.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)po);
        this.saveGLEntries(po.getGeneralLedgerPendingEntries());
        LOG.debug("generateEntriesApproveAmendPo() gl entries created; exit method");
    }

    @Override
    public void generateEntriesClosePurchaseOrder(PurchaseOrderDocument po) {
        LOG.debug("generateEntriesClosePurchaseOrder() started");
        for (PurchaseOrderItem item : po.getItems()) {
            String logItmNbr = "Item # " + item.getItemLineNumber();
            if (!item.isItemActiveIndicator()) continue;
            KualiDecimal itemAmount = null;
            LOG.debug("generateEntriesClosePurchaseOrder() " + logItmNbr + " Calculate based on amounts");
            itemAmount = item.getItemOutstandingEncumberedAmount() == null ? KualiDecimal.ZERO : item.getItemOutstandingEncumberedAmount();
            KualiDecimal accountTotal = KualiDecimal.ZERO;
            PurchaseOrderAccount lastAccount = null;
            if (itemAmount.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) == 0) continue;
            Collections.sort(item.getSourceAccountingLines());
            for (PurchaseOrderAccount purchaseOrderAccount : item.getSourceAccountingLines()) {
                if (purchaseOrderAccount.isEmpty()) continue;
                KualiDecimal acctAmount = (KualiDecimal)((KualiDecimal)itemAmount.multiply((AbstractKualiDecimal)new KualiDecimal(purchaseOrderAccount.getAccountLinePercent().toString()))).divide((AbstractKualiDecimal)PurapConstants.HUNDRED);
                accountTotal = (KualiDecimal)accountTotal.add((AbstractKualiDecimal)acctAmount);
                purchaseOrderAccount.setAlternateAmountForGLEntryCreation(acctAmount);
                lastAccount = purchaseOrderAccount;
            }
            if (lastAccount == null) continue;
            KualiDecimal difference = (KualiDecimal)itemAmount.subtract((AbstractKualiDecimal)accountTotal);
            LOG.debug("generateEntriesClosePurchaseOrder() difference: " + logItmNbr + " " + difference);
            KualiDecimal kualiDecimal = lastAccount.getAlternateAmountForGLEntryCreation();
            if (ObjectUtils.isNotNull((Object)kualiDecimal)) {
                lastAccount.setAlternateAmountForGLEntryCreation((KualiDecimal)kualiDecimal.add((AbstractKualiDecimal)difference));
                continue;
            }
            lastAccount.setAlternateAmountForGLEntryCreation(difference);
        }
        po.setGlOnlySourceAccountingLines(this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(po.getItemsActiveOnly()));
        if (this.shouldGenerateGLPEForPurchaseOrder(po)) {
            this.generalLedgerPendingEntryService.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)po);
            this.saveGLEntries(po.getGeneralLedgerPendingEntries());
            LOG.debug("generateEntriesClosePurchaseOrder() gl entries created; exit method");
        }
        for (PurchaseOrderItem item : po.getItems()) {
            if (item.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
                item.setItemOutstandingEncumberedQuantity(KualiDecimal.ZERO);
            }
            item.setItemOutstandingEncumberedAmount(KualiDecimal.ZERO);
            List<PurApAccountingLine> sourceAccountingLines = item.getSourceAccountingLines();
            for (PurApAccountingLine purApAccountingLine : sourceAccountingLines) {
                PurchaseOrderAccount account = (PurchaseOrderAccount)purApAccountingLine;
                account.setItemAccountOutstandingEncumbranceAmount(KualiDecimal.ZERO);
            }
        }
    }

    protected boolean shouldGenerateGLPEForPurchaseOrder(PurchaseOrderDocument po) {
        for (SourceAccountingLine acct : po.getGlOnlySourceAccountingLines()) {
            if (acct.getAmount().compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void generateEntriesReopenPurchaseOrder(PurchaseOrderDocument po) {
        LOG.debug("generateEntriesReopenPurchaseOrder() started");
        for (PurchaseOrderItem item : po.getItems()) {
            if (item.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
                item.getItemQuantity().subtract((AbstractKualiDecimal)item.getItemInvoicedTotalQuantity());
                item.setItemOutstandingEncumberedQuantity((KualiDecimal)item.getItemQuantity().subtract((AbstractKualiDecimal)item.getItemInvoicedTotalQuantity()));
                item.setItemOutstandingEncumberedAmount(new KualiDecimal(item.getItemOutstandingEncumberedQuantity().bigDecimalValue().multiply(item.getItemUnitPrice())));
            } else {
                item.setItemOutstandingEncumberedAmount((KualiDecimal)item.getTotalAmount().subtract((AbstractKualiDecimal)item.getItemInvoicedTotalAmount()));
            }
            List<PurApAccountingLine> sourceAccountingLines = item.getSourceAccountingLines();
            for (PurApAccountingLine purApAccountingLine : sourceAccountingLines) {
                PurchaseOrderAccount account = (PurchaseOrderAccount)purApAccountingLine;
                account.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(item.getItemOutstandingEncumberedAmount().bigDecimalValue().multiply(account.getAccountLinePercent()).divide(KFSConstants.ONE_HUNDRED.bigDecimalValue())));
            }
        }
        for (PurchaseOrderItem item : po.getItems()) {
            String logItmNbr = "Item # " + item.getItemLineNumber();
            if (!item.isItemActiveIndicator()) continue;
            KualiDecimal itemAmount = null;
            if (item.getItemType().isAmountBasedGeneralLedgerIndicator()) {
                LOG.debug("generateEntriesReopenPurchaseOrder() " + logItmNbr + " Calculate based on amounts");
                itemAmount = item.getItemOutstandingEncumberedAmount() == null ? KualiDecimal.ZERO : item.getItemOutstandingEncumberedAmount();
            } else {
                LOG.debug("generateEntriesReopenPurchaseOrder() " + logItmNbr + " Calculate based on quantities");
                itemAmount = new KualiDecimal(item.getItemOutstandingEncumberedQuantity().bigDecimalValue().multiply(item.getItemUnitPrice()));
            }
            KualiDecimal accountTotal = KualiDecimal.ZERO;
            PurchaseOrderAccount lastAccount = null;
            if (itemAmount.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) == 0) continue;
            Collections.sort(item.getSourceAccountingLines());
            for (PurchaseOrderAccount purchaseOrderAccount : item.getSourceAccountingLines()) {
                if (purchaseOrderAccount.isEmpty()) continue;
                KualiDecimal acctAmount = (KualiDecimal)((KualiDecimal)itemAmount.multiply((AbstractKualiDecimal)new KualiDecimal(purchaseOrderAccount.getAccountLinePercent().toString()))).divide((AbstractKualiDecimal)PurapConstants.HUNDRED);
                accountTotal = (KualiDecimal)accountTotal.add((AbstractKualiDecimal)acctAmount);
                purchaseOrderAccount.setAlternateAmountForGLEntryCreation(acctAmount);
                lastAccount = purchaseOrderAccount;
            }
            if (lastAccount == null) continue;
            KualiDecimal difference = (KualiDecimal)itemAmount.subtract((AbstractKualiDecimal)accountTotal);
            LOG.debug("generateEntriesReopenPurchaseOrder() difference: " + logItmNbr + " " + difference);
            KualiDecimal kualiDecimal = lastAccount.getAlternateAmountForGLEntryCreation();
            if (ObjectUtils.isNotNull((Object)kualiDecimal)) {
                lastAccount.setAlternateAmountForGLEntryCreation((KualiDecimal)kualiDecimal.add((AbstractKualiDecimal)difference));
                continue;
            }
            lastAccount.setAlternateAmountForGLEntryCreation(difference);
        }
        po.setGlOnlySourceAccountingLines(this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(po.getItemsActiveOnly()));
        if (this.shouldGenerateGLPEForPurchaseOrder(po)) {
            this.generalLedgerPendingEntryService.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)po);
            this.saveGLEntries(po.getGeneralLedgerPendingEntries());
            LOG.debug("generateEntriesReopenPurchaseOrder() gl entries created; exit method");
        }
        LOG.debug("generateEntriesReopenPurchaseOrder() no gl entries created because the amount is 0; exit method");
    }

    @Override
    public void generateEntriesVoidPurchaseOrder(PurchaseOrderDocument po) {
        LOG.debug("generateEntriesVoidPurchaseOrder() started");
        for (PurchaseOrderItem item : po.getItems()) {
            String logItmNbr = "Item # " + item.getItemLineNumber();
            if (!item.isItemActiveIndicator()) continue;
            LOG.debug("generateEntriesVoidPurchaseOrder() " + logItmNbr + " Calculate based on amounts");
            KualiDecimal itemAmount = item.getItemOutstandingEncumberedAmount() == null ? KualiDecimal.ZERO : item.getItemOutstandingEncumberedAmount();
            KualiDecimal accountTotal = KualiDecimal.ZERO;
            PurchaseOrderAccount lastAccount = null;
            if (itemAmount.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) == 0) continue;
            Collections.sort(item.getSourceAccountingLines());
            for (PurchaseOrderAccount purchaseOrderAccount : item.getSourceAccountingLines()) {
                if (purchaseOrderAccount.isEmpty()) continue;
                KualiDecimal acctAmount = (KualiDecimal)((KualiDecimal)itemAmount.multiply((AbstractKualiDecimal)new KualiDecimal(purchaseOrderAccount.getAccountLinePercent().toString()))).divide((AbstractKualiDecimal)PurapConstants.HUNDRED);
                accountTotal = (KualiDecimal)accountTotal.add((AbstractKualiDecimal)acctAmount);
                purchaseOrderAccount.setAlternateAmountForGLEntryCreation(acctAmount);
                lastAccount = purchaseOrderAccount;
            }
            if (lastAccount == null) continue;
            KualiDecimal difference = (KualiDecimal)itemAmount.subtract((AbstractKualiDecimal)accountTotal);
            LOG.debug("generateEntriesVoidPurchaseOrder() difference: " + logItmNbr + " " + difference);
            KualiDecimal kualiDecimal = lastAccount.getAlternateAmountForGLEntryCreation();
            if (ObjectUtils.isNotNull((Object)kualiDecimal)) {
                lastAccount.setAlternateAmountForGLEntryCreation((KualiDecimal)kualiDecimal.add((AbstractKualiDecimal)difference));
                continue;
            }
            lastAccount.setAlternateAmountForGLEntryCreation(difference);
        }
        po.setGlOnlySourceAccountingLines(this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(po.getItemsActiveOnly()));
        this.generalLedgerPendingEntryService.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)po);
        this.saveGLEntries(po.getGeneralLedgerPendingEntries());
        LOG.debug("generateEntriesVoidPurchaseOrder() gl entries created; exit method");
    }

    protected List<SourceAccountingLine> relieveEncumbrance(PaymentRequestDocument preq) {
        LOG.debug("relieveEncumbrance() started");
        HashMap<SourceAccountingLine, Object> encumbranceAccountMap = new HashMap<SourceAccountingLine, Object>();
        PurchaseOrderDocument po = this.purchaseOrderService.getCurrentPurchaseOrder(preq.getPurchaseOrderIdentifier());
        for (PaymentRequestItem preqItem : preq.getItems()) {
            KualiDecimal encumbranceQuantity;
            KualiDecimal outstandingEncumberedQuantity;
            KualiDecimal invoiceQuantity;
            PurchaseOrderItem poItem = this.getPoItem(po, preqItem.getItemLineNumber(), preqItem.getItemType());
            boolean takeAll = false;
            KualiDecimal itemDisEncumber = null;
            String logItmNbr = "Item # " + preqItem.getItemLineNumber();
            LOG.debug("relieveEncumbrance() " + logItmNbr);
            if (poItem == null) {
                LOG.debug("relieveEncumbrance() " + logItmNbr + " No encumbrances required because po item is null");
                continue;
            }
            KualiDecimal preqItemTotalAmount = preqItem.getTotalAmount();
            if (preqItemTotalAmount == null) {
                preqItemTotalAmount = KualiDecimal.ZERO;
            }
            if (KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)preqItemTotalAmount) == 0) {
                LOG.debug("relieveEncumbrance() " + logItmNbr + " No GL encumbrances required because extended price is ZERO");
                if (poItem.getItemQuantity() == null || BigDecimal.ZERO.compareTo(poItem.getItemUnitPrice()) != 0) continue;
                LOG.debug("relieveEncumbrance() " + logItmNbr + " Calculate po oustanding encumbrance");
                if (preqItem.getItemQuantity() == null || KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)preqItem.getItemQuantity()) == 0) continue;
                invoiceQuantity = preqItem.getItemQuantity();
                KualiDecimal kualiDecimal = outstandingEncumberedQuantity = poItem.getItemOutstandingEncumberedQuantity() == null ? KualiDecimal.ZERO : poItem.getItemOutstandingEncumberedQuantity();
                if (invoiceQuantity.compareTo((AbstractKualiDecimal)outstandingEncumberedQuantity) > 0) {
                    LOG.debug("relieveEncumbrance() " + logItmNbr + " we bought more than the qty on the PO");
                    encumbranceQuantity = outstandingEncumberedQuantity;
                    poItem.setItemOutstandingEncumberedQuantity(KualiDecimal.ZERO);
                } else {
                    encumbranceQuantity = invoiceQuantity;
                    poItem.setItemOutstandingEncumberedQuantity((KualiDecimal)outstandingEncumberedQuantity.subtract((AbstractKualiDecimal)encumbranceQuantity));
                    LOG.debug("relieveEncumbrance() " + logItmNbr + " adjusting oustanding encunbrance qty - encumbranceQty " + encumbranceQuantity + " outstandingEncumberedQty " + poItem.getItemOutstandingEncumberedQuantity());
                }
                if (poItem.getItemInvoicedTotalQuantity() == null) {
                    poItem.setItemInvoicedTotalQuantity(invoiceQuantity);
                    continue;
                }
                poItem.setItemInvoicedTotalQuantity((KualiDecimal)poItem.getItemInvoicedTotalQuantity().add((AbstractKualiDecimal)invoiceQuantity));
                continue;
            }
            LOG.debug("relieveEncumbrance() " + logItmNbr + " Calculate encumbrance GL entries");
            if (poItem.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
                LOG.debug("relieveEncumbrance() " + logItmNbr + " Calculate encumbrance based on quantity");
                invoiceQuantity = preqItem.getItemQuantity() == null ? KualiDecimal.ZERO : preqItem.getItemQuantity();
                KualiDecimal kualiDecimal = outstandingEncumberedQuantity = poItem.getItemOutstandingEncumberedQuantity() == null ? KualiDecimal.ZERO : poItem.getItemOutstandingEncumberedQuantity();
                if (invoiceQuantity.compareTo((AbstractKualiDecimal)outstandingEncumberedQuantity) > 0) {
                    LOG.debug("relieveEncumbrance() " + logItmNbr + " we bought more than the qty on the PO");
                    encumbranceQuantity = outstandingEncumberedQuantity;
                    poItem.setItemOutstandingEncumberedQuantity(KualiDecimal.ZERO);
                    takeAll = true;
                } else {
                    encumbranceQuantity = invoiceQuantity;
                    poItem.setItemOutstandingEncumberedQuantity((KualiDecimal)outstandingEncumberedQuantity.subtract((AbstractKualiDecimal)encumbranceQuantity));
                    if (KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)poItem.getItemOutstandingEncumberedQuantity()) == 0) {
                        takeAll = true;
                    }
                    LOG.debug("relieveEncumbrance() " + logItmNbr + " encumbranceQty " + encumbranceQuantity + " outstandingEncumberedQty " + poItem.getItemOutstandingEncumberedQuantity());
                }
                if (poItem.getItemInvoicedTotalQuantity() == null) {
                    poItem.setItemInvoicedTotalQuantity(invoiceQuantity);
                } else {
                    poItem.setItemInvoicedTotalQuantity((KualiDecimal)poItem.getItemInvoicedTotalQuantity().add((AbstractKualiDecimal)invoiceQuantity));
                }
                itemDisEncumber = new KualiDecimal(encumbranceQuantity.bigDecimalValue().multiply(poItem.getItemUnitPrice()));
                KualiDecimal itemTaxAmount = poItem.getItemTaxAmount() == null ? KualiDecimal.ZERO : poItem.getItemTaxAmount();
                KualiDecimal encumbranceTaxAmount = (KualiDecimal)((KualiDecimal)encumbranceQuantity.divide((AbstractKualiDecimal)poItem.getItemQuantity())).multiply((AbstractKualiDecimal)itemTaxAmount);
                itemDisEncumber = (KualiDecimal)itemDisEncumber.add((AbstractKualiDecimal)encumbranceTaxAmount);
            } else {
                LOG.debug("relieveEncumbrance() " + logItmNbr + " Calculate encumbrance based on amount");
                if (poItem.getItemOutstandingEncumberedAmount().bigDecimalValue().signum() == -1 && preqItemTotalAmount.bigDecimalValue().signum() == -1) {
                    LOG.debug("relieveEncumbrance() " + logItmNbr + " Outstanding Encumbered amount is negative: " + poItem.getItemOutstandingEncumberedAmount());
                    if (preqItemTotalAmount.compareTo((AbstractKualiDecimal)poItem.getItemOutstandingEncumberedAmount()) >= 0) {
                        itemDisEncumber = preqItemTotalAmount;
                    } else {
                        takeAll = true;
                        itemDisEncumber = poItem.getItemOutstandingEncumberedAmount();
                    }
                } else {
                    LOG.debug("relieveEncumbrance() " + logItmNbr + " Outstanding Encumbered amount is positive or ZERO: " + poItem.getItemOutstandingEncumberedAmount());
                    if (poItem.getItemOutstandingEncumberedAmount().compareTo((AbstractKualiDecimal)preqItemTotalAmount) >= 0) {
                        itemDisEncumber = preqItemTotalAmount;
                    } else {
                        takeAll = true;
                        itemDisEncumber = poItem.getItemOutstandingEncumberedAmount();
                    }
                }
            }
            LOG.debug("relieveEncumbrance() " + logItmNbr + " Amount to disencumber: " + itemDisEncumber);
            KualiDecimal newOutstandingEncumberedAmount = (KualiDecimal)poItem.getItemOutstandingEncumberedAmount().subtract((AbstractKualiDecimal)itemDisEncumber);
            LOG.debug("relieveEncumbrance() " + logItmNbr + " New Outstanding Encumbered amount is : " + newOutstandingEncumberedAmount);
            poItem.setItemOutstandingEncumberedAmount(newOutstandingEncumberedAmount);
            KualiDecimal newInvoicedTotalAmount = (KualiDecimal)poItem.getItemInvoicedTotalAmount().add((AbstractKualiDecimal)preqItemTotalAmount);
            LOG.debug("relieveEncumbrance() " + logItmNbr + " New Invoiced Total Amount is: " + newInvoicedTotalAmount);
            poItem.setItemInvoicedTotalAmount(newInvoicedTotalAmount);
            Collections.sort(poItem.getSourceAccountingLines());
            PurApAccountingLineBase lastAccount = null;
            KualiDecimal accountTotal = KualiDecimal.ZERO;
            for (PurchaseOrderAccount purchaseOrderAccount : poItem.getSourceAccountingLines()) {
                if (purchaseOrderAccount.isEmpty()) continue;
                KualiDecimal encumbranceAmount = null;
                SourceAccountingLine acctString = purchaseOrderAccount.generateSourceAccountingLine();
                if (takeAll) {
                    encumbranceAmount = purchaseOrderAccount.getItemAccountOutstandingEncumbranceAmount();
                    purchaseOrderAccount.setItemAccountOutstandingEncumbranceAmount(KualiDecimal.ZERO);
                    LOG.debug("relieveEncumbrance() " + logItmNbr + " take all");
                } else {
                    encumbranceAmount = (KualiDecimal)((KualiDecimal)itemDisEncumber.multiply((AbstractKualiDecimal)new KualiDecimal(purchaseOrderAccount.getAccountLinePercent().toString()))).divide((AbstractKualiDecimal)PurapConstants.HUNDRED);
                    purchaseOrderAccount.setItemAccountOutstandingEncumbranceAmount((KualiDecimal)purchaseOrderAccount.getItemAccountOutstandingEncumbranceAmount().subtract((AbstractKualiDecimal)encumbranceAmount));
                    accountTotal = (KualiDecimal)accountTotal.add((AbstractKualiDecimal)encumbranceAmount);
                    if (!takeAll) {
                        lastAccount = purchaseOrderAccount;
                    }
                }
                LOG.debug("relieveEncumbrance() " + logItmNbr + " " + acctString + " = " + encumbranceAmount);
                if (ObjectUtils.isNull(encumbranceAccountMap.get(acctString))) {
                    encumbranceAccountMap.put(acctString, encumbranceAmount);
                    continue;
                }
                KualiDecimal amt = (KualiDecimal)encumbranceAccountMap.get(acctString);
                encumbranceAccountMap.put(acctString, amt.add((AbstractKualiDecimal)encumbranceAmount));
            }
            if (lastAccount == null) continue;
            KualiDecimal difference = (KualiDecimal)itemDisEncumber.subtract((AbstractKualiDecimal)accountTotal);
            LOG.debug("relieveEncumbrance() difference: " + logItmNbr + " " + difference);
            SourceAccountingLine sourceAccountingLine = lastAccount.generateSourceAccountingLine();
            KualiDecimal amount = (KualiDecimal)encumbranceAccountMap.get(sourceAccountingLine);
            if (ObjectUtils.isNull((Object)amount)) {
                encumbranceAccountMap.put(sourceAccountingLine, difference);
            } else {
                encumbranceAccountMap.put(sourceAccountingLine, amount.add((AbstractKualiDecimal)difference));
            }
            ((PurchaseOrderAccount)lastAccount).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)((PurchaseOrderAccount)lastAccount).getItemAccountOutstandingEncumbranceAmount().subtract((AbstractKualiDecimal)difference));
        }
        ArrayList<SourceAccountingLine> encumbranceAccounts = new ArrayList<SourceAccountingLine>();
        for (SourceAccountingLine acctString : encumbranceAccountMap.keySet()) {
            KualiDecimal amount = (KualiDecimal)encumbranceAccountMap.get(acctString);
            if (amount.doubleValue() == 0.0) continue;
            acctString.setAmount(amount);
            encumbranceAccounts.add(acctString);
        }
        this.businessObjectService.save((PersistableBusinessObject)po);
        return encumbranceAccounts;
    }

    protected List<SourceAccountingLine> reencumberEncumbrance(PaymentRequestDocument preq) {
        LOG.debug("reencumberEncumbrance() started");
        PurchaseOrderDocument po = this.purchaseOrderService.getCurrentPurchaseOrder(preq.getPurchaseOrderIdentifier());
        HashMap<SourceAccountingLine, Object> encumbranceAccountMap = new HashMap<SourceAccountingLine, Object>();
        for (PaymentRequestItem payRequestItem : preq.getItems()) {
            KualiDecimal preqItemTotalAmount;
            PurchaseOrderItem poItem = this.getPoItem(po, payRequestItem.getItemLineNumber(), payRequestItem.getItemType());
            KualiDecimal itemReEncumber = null;
            String logItmNbr = "Item # " + payRequestItem.getItemLineNumber();
            LOG.debug("reencumberEncumbrance() " + logItmNbr);
            KualiDecimal kualiDecimal = preqItemTotalAmount = payRequestItem.getTotalAmount() == null ? KualiDecimal.ZERO : payRequestItem.getTotalAmount();
            if (poItem == null || preqItemTotalAmount.doubleValue() == 0.0) {
                LOG.debug("reencumberEncumbrance() " + logItmNbr + " No encumbrances required");
                continue;
            }
            LOG.debug("reencumberEncumbrance() " + logItmNbr + " Calculate encumbrance GL entries");
            if (poItem.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
                LOG.debug("reencumberEncumbrance() " + logItmNbr + " Calculate encumbrance based on quantity");
                KualiDecimal preqQuantity = payRequestItem.getItemQuantity() == null ? KualiDecimal.ZERO : payRequestItem.getItemQuantity();
                KualiDecimal outstandingEncumberedQuantity = poItem.getItemOutstandingEncumberedQuantity() == null ? KualiDecimal.ZERO : poItem.getItemOutstandingEncumberedQuantity();
                KualiDecimal invoicedTotal = poItem.getItemInvoicedTotalQuantity() == null ? KualiDecimal.ZERO : poItem.getItemInvoicedTotalQuantity();
                poItem.setItemInvoicedTotalQuantity((KualiDecimal)invoicedTotal.subtract((AbstractKualiDecimal)preqQuantity));
                poItem.setItemOutstandingEncumberedQuantity((KualiDecimal)outstandingEncumberedQuantity.add((AbstractKualiDecimal)preqQuantity));
                itemReEncumber = new KualiDecimal(preqQuantity.bigDecimalValue().multiply(poItem.getItemUnitPrice()));
                KualiDecimal itemTaxAmount = poItem.getItemTaxAmount() == null ? KualiDecimal.ZERO : poItem.getItemTaxAmount();
                KualiDecimal encumbranceTaxAmount = (KualiDecimal)((KualiDecimal)preqQuantity.divide((AbstractKualiDecimal)poItem.getItemQuantity())).multiply((AbstractKualiDecimal)itemTaxAmount);
                itemReEncumber = (KualiDecimal)itemReEncumber.add((AbstractKualiDecimal)encumbranceTaxAmount);
            } else {
                LOG.debug("reencumberEncumbrance() " + logItmNbr + " Calculate encumbrance based on amount");
                itemReEncumber = preqItemTotalAmount;
                if (poItem.getTotalAmount() != null && poItem.getTotalAmount().bigDecimalValue().signum() < 0) {
                    if (poItem.getTotalAmount().compareTo((AbstractKualiDecimal)itemReEncumber) > 0) {
                        itemReEncumber = poItem.getTotalAmount();
                    }
                } else if (poItem.getTotalAmount() != null && poItem.getTotalAmount().bigDecimalValue().signum() >= 0 && poItem.getTotalAmount().compareTo((AbstractKualiDecimal)itemReEncumber) < 0) {
                    itemReEncumber = poItem.getTotalAmount();
                }
            }
            LOG.debug("reencumberEncumbrance() " + logItmNbr + " Amount to reencumber: " + itemReEncumber);
            KualiDecimal outstandingEncumberedAmount = poItem.getItemOutstandingEncumberedAmount() == null ? KualiDecimal.ZERO : poItem.getItemOutstandingEncumberedAmount();
            LOG.debug("reencumberEncumbrance() " + logItmNbr + " PO Item Outstanding Encumbrance Amount set to: " + outstandingEncumberedAmount);
            KualiDecimal newOutstandingEncumberedAmount = (KualiDecimal)outstandingEncumberedAmount.add((AbstractKualiDecimal)itemReEncumber);
            LOG.debug("reencumberEncumbrance() " + logItmNbr + " New PO Item Outstanding Encumbrance Amount to set: " + newOutstandingEncumberedAmount);
            poItem.setItemOutstandingEncumberedAmount(newOutstandingEncumberedAmount);
            KualiDecimal invoicedTotalAmount = poItem.getItemInvoicedTotalAmount() == null ? KualiDecimal.ZERO : poItem.getItemInvoicedTotalAmount();
            LOG.debug("reencumberEncumbrance() " + logItmNbr + " PO Item Invoiced Total Amount set to: " + invoicedTotalAmount);
            KualiDecimal newInvoicedTotalAmount = (KualiDecimal)invoicedTotalAmount.subtract((AbstractKualiDecimal)preqItemTotalAmount);
            LOG.debug("reencumberEncumbrance() " + logItmNbr + " New PO Item Invoiced Total Amount to set: " + newInvoicedTotalAmount);
            poItem.setItemInvoicedTotalAmount(newInvoicedTotalAmount);
            PurApAccountingLineBase lastAccount = null;
            KualiDecimal accountTotal = KualiDecimal.ZERO;
            Collections.sort(poItem.getSourceAccountingLines());
            for (PurchaseOrderAccount purchaseOrderAccount : poItem.getSourceAccountingLines()) {
                if (purchaseOrderAccount.isEmpty()) continue;
                SourceAccountingLine acctString = purchaseOrderAccount.generateSourceAccountingLine();
                KualiDecimal reencumbranceAmount = (KualiDecimal)((KualiDecimal)itemReEncumber.multiply((AbstractKualiDecimal)new KualiDecimal(purchaseOrderAccount.getAccountLinePercent().toString()))).divide((AbstractKualiDecimal)PurapConstants.HUNDRED);
                purchaseOrderAccount.setItemAccountOutstandingEncumbranceAmount((KualiDecimal)purchaseOrderAccount.getItemAccountOutstandingEncumbranceAmount().add((AbstractKualiDecimal)reencumbranceAmount));
                accountTotal = (KualiDecimal)accountTotal.add((AbstractKualiDecimal)reencumbranceAmount);
                lastAccount = purchaseOrderAccount;
                LOG.debug("reencumberEncumbrance() " + logItmNbr + " " + acctString + " = " + reencumbranceAmount);
                if (encumbranceAccountMap.containsKey(acctString)) {
                    KualiDecimal currentAmount = (KualiDecimal)encumbranceAccountMap.get(acctString);
                    encumbranceAccountMap.put(acctString, reencumbranceAmount.add((AbstractKualiDecimal)currentAmount));
                    continue;
                }
                encumbranceAccountMap.put(acctString, reencumbranceAmount);
            }
            if (lastAccount == null) continue;
            KualiDecimal difference = (KualiDecimal)itemReEncumber.subtract((AbstractKualiDecimal)accountTotal);
            LOG.debug("reencumberEncumbrance() difference: " + logItmNbr + " " + difference);
            SourceAccountingLine sourceAccountingLine = lastAccount.generateSourceAccountingLine();
            KualiDecimal amount = (KualiDecimal)encumbranceAccountMap.get(sourceAccountingLine);
            if (amount == null) {
                encumbranceAccountMap.put(sourceAccountingLine, difference);
            } else {
                encumbranceAccountMap.put(sourceAccountingLine, amount.add((AbstractKualiDecimal)difference));
            }
            ((PurchaseOrderAccount)lastAccount).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)((PurchaseOrderAccount)lastAccount).getItemAccountOutstandingEncumbranceAmount().add((AbstractKualiDecimal)difference));
        }
        this.businessObjectService.save((PersistableBusinessObject)po);
        ArrayList<SourceAccountingLine> encumbranceAccounts = new ArrayList<SourceAccountingLine>();
        for (SourceAccountingLine acctString : encumbranceAccountMap.keySet()) {
            KualiDecimal amount = (KualiDecimal)encumbranceAccountMap.get(acctString);
            if (amount.doubleValue() == 0.0) continue;
            acctString.setAmount(amount);
            encumbranceAccounts.add(acctString);
        }
        return encumbranceAccounts;
    }

    protected List<SourceAccountingLine> getCreditMemoEncumbrance(VendorCreditMemoDocument cm, PurchaseOrderDocument po, boolean cancel) {
        LOG.debug("getCreditMemoEncumbrance() started");
        if (ObjectUtils.isNull((Object)po)) {
            return null;
        }
        if (cancel) {
            LOG.debug("getCreditMemoEncumbrance() Receiving items back from vendor (cancelled CM)");
        } else {
            LOG.debug("getCreditMemoEncumbrance() Returning items to vendor");
        }
        HashMap<SourceAccountingLine, Object> encumbranceAccountMap = new HashMap<SourceAccountingLine, Object>();
        for (CreditMemoItem cmItem : cm.getItems()) {
            KualiDecimal cmItemTotalAmount;
            PurchaseOrderItem poItem = this.getPoItem(po, cmItem.getItemLineNumber(), cmItem.getItemType());
            KualiDecimal itemDisEncumber = null;
            KualiDecimal itemAlterInvoiceAmt = null;
            String logItmNbr = "Item # " + cmItem.getItemLineNumber();
            LOG.debug("getCreditMemoEncumbrance() " + logItmNbr);
            KualiDecimal kualiDecimal = cmItemTotalAmount = cmItem.getTotalAmount() == null ? KualiDecimal.ZERO : cmItem.getTotalAmount();
            if (poItem == null || cmItemTotalAmount == null || cmItemTotalAmount.doubleValue() == 0.0) {
                LOG.debug("getCreditMemoEncumbrance() " + logItmNbr + " No encumbrances required");
                continue;
            }
            LOG.debug("getCreditMemoEncumbrance() " + logItmNbr + " Calculate encumbrance GL entries");
            if (poItem.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
                LOG.debug("getCreditMemoEncumbrance() " + logItmNbr + " Calculate encumbrance based on quantity");
                KualiDecimal cmQuantity = cmItem.getItemQuantity() == null ? KualiDecimal.ZERO : cmItem.getItemQuantity();
                KualiDecimal encumbranceQuantityChange = this.calculateQuantityChange(cancel, poItem, cmQuantity);
                LOG.debug("getCreditMemoEncumbrance() " + logItmNbr + " encumbranceQtyChange " + encumbranceQuantityChange + " outstandingEncumberedQty " + poItem.getItemOutstandingEncumberedQuantity() + " invoicedTotalQuantity " + poItem.getItemInvoicedTotalQuantity());
                itemDisEncumber = new KualiDecimal(encumbranceQuantityChange.bigDecimalValue().multiply(poItem.getItemUnitPrice()));
                KualiDecimal itemTaxAmount = poItem.getItemTaxAmount() == null ? KualiDecimal.ZERO : poItem.getItemTaxAmount();
                KualiDecimal kualiDecimal2 = (KualiDecimal)((KualiDecimal)encumbranceQuantityChange.divide((AbstractKualiDecimal)poItem.getItemQuantity())).multiply((AbstractKualiDecimal)itemTaxAmount);
                itemDisEncumber = (KualiDecimal)itemDisEncumber.add((AbstractKualiDecimal)kualiDecimal2);
                itemAlterInvoiceAmt = cmItemTotalAmount;
                if (cancel) {
                    itemAlterInvoiceAmt = (KualiDecimal)itemAlterInvoiceAmt.multiply((AbstractKualiDecimal)new KualiDecimal("-1"));
                }
            } else {
                LOG.debug("getCreditMemoEncumbrance() " + logItmNbr + " Calculate encumbrance based on amount");
                if (cancel) {
                    itemDisEncumber = (KualiDecimal)cmItemTotalAmount.multiply((AbstractKualiDecimal)new KualiDecimal("-1"));
                    if (((KualiDecimal)poItem.getItemOutstandingEncumberedAmount().add((AbstractKualiDecimal)itemDisEncumber)).doubleValue() < 0.0) {
                        LOG.debug("getCreditMemoEncumbrance() Cancel overflow");
                        itemDisEncumber = poItem.getItemOutstandingEncumberedAmount();
                    }
                } else {
                    itemDisEncumber = cmItemTotalAmount;
                    if (((KualiDecimal)poItem.getItemOutstandingEncumberedAmount().add((AbstractKualiDecimal)itemDisEncumber)).doubleValue() > poItem.getTotalAmount().doubleValue()) {
                        LOG.debug("getCreditMemoEncumbrance() Create overflow");
                        itemDisEncumber = (KualiDecimal)poItem.getTotalAmount().subtract((AbstractKualiDecimal)poItem.getItemOutstandingEncumberedAmount());
                    }
                }
                itemAlterInvoiceAmt = itemDisEncumber;
            }
            poItem.setItemOutstandingEncumberedAmount((KualiDecimal)poItem.getItemOutstandingEncumberedAmount().add((AbstractKualiDecimal)itemDisEncumber));
            poItem.setItemInvoicedTotalAmount((KualiDecimal)poItem.getItemInvoicedTotalAmount().subtract((AbstractKualiDecimal)itemAlterInvoiceAmt));
            if (poItem.getItemInvoicedTotalAmount().compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) < 0) {
                poItem.setItemInvoicedTotalAmount(KualiDecimal.ZERO);
            }
            LOG.debug("getCreditMemoEncumbrance() " + logItmNbr + " Amount to disencumber: " + itemDisEncumber);
            Collections.sort(poItem.getSourceAccountingLines());
            PurApAccountingLineBase lastAccount = null;
            KualiDecimal accountTotal = KualiDecimal.ZERO;
            for (PurchaseOrderAccount purchaseOrderAccount : poItem.getSourceAccountingLines()) {
                if (purchaseOrderAccount.isEmpty()) continue;
                KualiDecimal encumbranceAmount = null;
                SourceAccountingLine acctString = purchaseOrderAccount.generateSourceAccountingLine();
                encumbranceAmount = (KualiDecimal)((KualiDecimal)itemDisEncumber.multiply((AbstractKualiDecimal)new KualiDecimal(purchaseOrderAccount.getAccountLinePercent().toString()))).divide((AbstractKualiDecimal)new KualiDecimal(100));
                purchaseOrderAccount.setItemAccountOutstandingEncumbranceAmount((KualiDecimal)purchaseOrderAccount.getItemAccountOutstandingEncumbranceAmount().add((AbstractKualiDecimal)encumbranceAmount));
                accountTotal = (KualiDecimal)accountTotal.add((AbstractKualiDecimal)encumbranceAmount);
                lastAccount = purchaseOrderAccount;
                LOG.debug("getCreditMemoEncumbrance() " + logItmNbr + " " + acctString + " = " + encumbranceAmount);
                if (encumbranceAccountMap.get(acctString) == null) {
                    encumbranceAccountMap.put(acctString, encumbranceAmount);
                    continue;
                }
                KualiDecimal amt = (KualiDecimal)encumbranceAccountMap.get(acctString);
                encumbranceAccountMap.put(acctString, amt.add((AbstractKualiDecimal)encumbranceAmount));
            }
            if (lastAccount == null) continue;
            KualiDecimal difference = (KualiDecimal)itemDisEncumber.subtract((AbstractKualiDecimal)accountTotal);
            LOG.debug("getCreditMemoEncumbrance() difference: " + logItmNbr + " " + difference);
            SourceAccountingLine sourceAccountingLine = lastAccount.generateSourceAccountingLine();
            KualiDecimal amount = (KualiDecimal)encumbranceAccountMap.get(sourceAccountingLine);
            if (amount == null) {
                encumbranceAccountMap.put(sourceAccountingLine, difference);
            } else {
                encumbranceAccountMap.put(sourceAccountingLine, amount.add((AbstractKualiDecimal)difference));
            }
            ((PurchaseOrderAccount)lastAccount).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)((PurchaseOrderAccount)lastAccount).getItemAccountOutstandingEncumbranceAmount().add((AbstractKualiDecimal)difference));
        }
        ArrayList<SourceAccountingLine> encumbranceAccounts = new ArrayList<SourceAccountingLine>();
        for (SourceAccountingLine acctString : encumbranceAccountMap.keySet()) {
            KualiDecimal amount = (KualiDecimal)encumbranceAccountMap.get(acctString);
            if (amount.doubleValue() == 0.0) continue;
            acctString.setAmount(amount);
            encumbranceAccounts.add(acctString);
        }
        this.businessObjectService.save((PersistableBusinessObject)po);
        return encumbranceAccounts;
    }

    protected void saveGLEntries(List<GeneralLedgerPendingEntry> glEntries) {
        LOG.debug("saveGLEntries() started");
        this.businessObjectService.save(glEntries);
    }

    protected void saveAccountsPayableSummaryAccounts(List<SummaryAccount> summaryAccounts, Integer purapDocumentIdentifier, String docType) {
        LOG.debug("saveAccountsPayableSummaryAccounts() started");
        this.purapAccountingService.deleteSummaryAccounts(purapDocumentIdentifier, docType);
        ArrayList<AccountsPayableSummaryAccount> apSummaryAccounts = new ArrayList<AccountsPayableSummaryAccount>();
        for (SummaryAccount summaryAccount : summaryAccounts) {
            apSummaryAccounts.add(new AccountsPayableSummaryAccount(summaryAccount.getAccount(), purapDocumentIdentifier, docType));
        }
        this.businessObjectService.save(apSummaryAccounts);
    }

    protected PurchaseOrderItem getPoItem(PurchaseOrderDocument po, Integer nbr, ItemType itemType) {
        LOG.debug("getPoItem() started");
        for (PurchaseOrderItem element : po.getItems()) {
            if (!(itemType.isLineItemIndicator() ? ObjectUtils.isNotNull((Object)nbr) && ObjectUtils.isNotNull((Object)element.getItemLineNumber()) && nbr.compareTo(element.getItemLineNumber()) == 0 : element.getItemTypeCode().equals(itemType.getItemTypeCode()))) continue;
            return element;
        }
        return null;
    }

    protected String entryDescription(String description) {
        if (description != null && description.length() > 40) {
            return description.toString().substring(0, 39);
        }
        return description;
    }

    protected KualiDecimal calculateQuantityChange(boolean cancel, PurchaseOrderItem poItem, KualiDecimal cmQuantity) {
        LOG.debug("calculateQuantityChange() started");
        KualiDecimal encumbranceQuantityChange = null;
        encumbranceQuantityChange = cancel ? (KualiDecimal)cmQuantity.multiply((AbstractKualiDecimal)new KualiDecimal("-1")) : cmQuantity;
        poItem.setItemInvoicedTotalQuantity((KualiDecimal)poItem.getItemInvoicedTotalQuantity().subtract((AbstractKualiDecimal)encumbranceQuantityChange));
        poItem.setItemOutstandingEncumberedQuantity((KualiDecimal)poItem.getItemOutstandingEncumberedQuantity().add((AbstractKualiDecimal)encumbranceQuantityChange));
        if (cancel) {
            if (poItem.getItemOutstandingEncumberedQuantity().doubleValue() < 0.0) {
                LOG.debug("calculateQuantityChange() Cancel overflow");
                KualiDecimal difference = (KualiDecimal)poItem.getItemOutstandingEncumberedQuantity().abs();
                poItem.setItemOutstandingEncumberedQuantity(KualiDecimal.ZERO);
                poItem.setItemInvoicedTotalQuantity(poItem.getItemQuantity());
                encumbranceQuantityChange = (KualiDecimal)encumbranceQuantityChange.add((AbstractKualiDecimal)difference);
            }
        } else if (poItem.getItemInvoicedTotalQuantity().doubleValue() < 0.0) {
            LOG.debug("calculateQuantityChange() Create overflow");
            KualiDecimal difference = (KualiDecimal)poItem.getItemInvoicedTotalQuantity().abs();
            poItem.setItemOutstandingEncumberedQuantity(poItem.getItemQuantity());
            poItem.setItemInvoicedTotalQuantity(KualiDecimal.ZERO);
            encumbranceQuantityChange = (KualiDecimal)encumbranceQuantityChange.add((AbstractKualiDecimal)difference);
        }
        return encumbranceQuantityChange;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setGeneralLedgerPendingEntryService(GeneralLedgerPendingEntryService generalLedgerPendingEntryService) {
        this.generalLedgerPendingEntryService = generalLedgerPendingEntryService;
    }

    public void setPurapAccountingService(PurapAccountingService purapAccountingService) {
        this.purapAccountingService = purapAccountingService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public void setPaymentRequestService(PaymentRequestService paymentRequestService) {
        this.paymentRequestService = paymentRequestService;
    }

    public void setPurapAccountRevisionService(PurapAccountRevisionService purapAccountRevisionService) {
        this.purapAccountRevisionService = purapAccountRevisionService;
    }
}

