/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.ReceivingThreshold;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.ThresholdService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.util.SummaryAccount;
import org.kuali.kfs.module.purap.util.ThresholdCriteria;
import org.kuali.kfs.module.purap.util.ThresholdField;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ThresholdHelper {
    private static Logger LOG = LogManager.getLogger(ThresholdHelper.class);
    private PurapAccountingService purapAccountingService;
    private ThresholdService thresholdService;
    private List<ThresholdSummary> chartCodeSummary = new ArrayList<ThresholdSummary>();
    private List<ThresholdSummary> chartCodeAndFundSummary = new ArrayList<ThresholdSummary>();
    private List<ThresholdSummary> chartCodeAndSubFundSummary = new ArrayList<ThresholdSummary>();
    private List<ThresholdSummary> chartCodeAndCommodityCodeSummary = new ArrayList<ThresholdSummary>();
    private List<ThresholdSummary> chartCodeAndObjectCodeSummary = new ArrayList<ThresholdSummary>();
    private List<ThresholdSummary> chartCodeAndOrgCodeSummary = new ArrayList<ThresholdSummary>();
    private List<ThresholdSummary> chartCodeAndVendorSummary = new ArrayList<ThresholdSummary>();
    private ThresholdSummary thresholdSummary;
    private ReceivingThreshold receivingThreshold;
    private boolean allItemsNonQty;

    public ThresholdHelper(PurchaseOrderDocument document) {
        this.purapAccountingService = (PurapAccountingService)SpringContext.getBean(PurapAccountingService.class);
        this.thresholdService = (ThresholdService)SpringContext.getBean(ThresholdService.class);
        this.setupForThresholdCheck(document);
    }

    private void setupForThresholdCheck(PurchaseOrderDocument document) {
        this.allItemsNonQty = this.checkForNonQtyItems(document);
        if (this.allItemsNonQty) {
            return;
        }
        List<SummaryAccount> accounts = this.purapAccountingService.generateSummaryAccounts(document);
        if (accounts != null) {
            for (SummaryAccount account : accounts) {
                this.updateThresholdSummary(ThresholdCriteria.CHART, account);
                this.updateThresholdSummary(ThresholdCriteria.CHART_AND_ACCOUNTTYPE, account);
                this.updateThresholdSummary(ThresholdCriteria.CHART_AND_SUBFUND, account);
                this.updateThresholdSummary(ThresholdCriteria.CHART_AND_OBJECTCODE, account);
                this.updateThresholdSummary(ThresholdCriteria.CHART_AND_ORGANIZATIONCODE, account);
                this.processVendorForThresholdSummary(account, document.getVendorHeaderGeneratedIdentifier().toString(), document.getVendorDetailAssignedIdentifier().toString());
            }
        }
        this.processCommodityCodeForThreshold(document.getItems());
    }

    private boolean checkForNonQtyItems(PurchaseOrderDocument document) {
        List items = document.getItems();
        for (int i = 0; i < items.size(); ++i) {
            if (((PurchaseOrderItem)items.get(i)).getItemType().isAdditionalChargeIndicator() || StringUtils.equals((CharSequence)((PurchaseOrderItem)items.get(i)).getItemTypeCode(), (CharSequence)"SRVC")) continue;
            return false;
        }
        return true;
    }

    private void updateThresholdSummary(ThresholdCriteria thresholdCriteria, SummaryAccount account) {
        if (thresholdCriteria != ThresholdCriteria.CHART_AND_COMMODITYCODE && thresholdCriteria != ThresholdCriteria.CHART_AND_VENDOR) {
            ThresholdSummary thresholdSummary = new ThresholdSummary(thresholdCriteria);
            thresholdSummary.setProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE, account.getAccount().getChartOfAccountsCode());
            if (thresholdCriteria == ThresholdCriteria.CHART_AND_ACCOUNTTYPE) {
                account.getAccount().refreshReferenceObject("account");
                if (StringUtils.isEmpty((CharSequence)account.getAccount().getAccount().getAccountTypeCode())) {
                    return;
                }
                thresholdSummary.setProperty(ThresholdField.ACCOUNT_TYPE_CODE, account.getAccount().getAccount().getAccountTypeCode());
            } else if (thresholdCriteria == ThresholdCriteria.CHART_AND_SUBFUND) {
                account.getAccount().refreshReferenceObject("account");
                if (StringUtils.isEmpty((CharSequence)account.getAccount().getAccount().getSubFundGroupCode())) {
                    return;
                }
                thresholdSummary.setProperty(ThresholdField.SUBFUND_GROUP_CODE, account.getAccount().getAccount().getSubFundGroupCode());
            } else if (thresholdCriteria == ThresholdCriteria.CHART_AND_OBJECTCODE) {
                if (StringUtils.isEmpty((CharSequence)account.getAccount().getFinancialObjectCode())) {
                    return;
                }
                thresholdSummary.setProperty(ThresholdField.FINANCIAL_OBJECT_CODE, account.getAccount().getFinancialObjectCode());
            } else if (thresholdCriteria == ThresholdCriteria.CHART_AND_ORGANIZATIONCODE) {
                account.getAccount().refreshReferenceObject("account");
                if (StringUtils.isEmpty((CharSequence)account.getAccount().getAccount().getOrganizationCode())) {
                    return;
                }
                thresholdSummary.setProperty(ThresholdField.ORGANIZATION_CODE, account.getAccount().getAccount().getOrganizationCode());
            }
            thresholdSummary.addTotalAmount(account.getAccount().getAmount());
            this.addToSummaryList(thresholdSummary);
        }
    }

    private void addToSummaryList(ThresholdSummary thresholdSummary) {
        List<ThresholdSummary> summaryList = this.getThresholdSummaryCollection(thresholdSummary.getThresholdCriteria());
        boolean matchFound = false;
        for (int i = 0; i < summaryList.size(); ++i) {
            if (!thresholdSummary.equals(summaryList.get(i))) continue;
            summaryList.get(i).addTotalAmount(thresholdSummary.getTotalAmount());
            matchFound = true;
            break;
        }
        if (!matchFound) {
            summaryList.add(thresholdSummary);
        }
    }

    private List<ThresholdSummary> getThresholdSummaryCollection(ThresholdCriteria thresholdCriteria) {
        if (thresholdCriteria == ThresholdCriteria.CHART) {
            return this.chartCodeSummary;
        }
        if (thresholdCriteria == ThresholdCriteria.CHART_AND_ACCOUNTTYPE) {
            return this.chartCodeAndFundSummary;
        }
        if (thresholdCriteria == ThresholdCriteria.CHART_AND_SUBFUND) {
            return this.chartCodeAndSubFundSummary;
        }
        if (thresholdCriteria == ThresholdCriteria.CHART_AND_COMMODITYCODE) {
            return this.chartCodeAndCommodityCodeSummary;
        }
        if (thresholdCriteria == ThresholdCriteria.CHART_AND_OBJECTCODE) {
            return this.chartCodeAndObjectCodeSummary;
        }
        if (thresholdCriteria == ThresholdCriteria.CHART_AND_ORGANIZATIONCODE) {
            return this.chartCodeAndOrgCodeSummary;
        }
        if (thresholdCriteria == ThresholdCriteria.CHART_AND_VENDOR) {
            return this.chartCodeAndVendorSummary;
        }
        throw new RuntimeException("Invalid ThresholdCriteria Enum - " + (Object)((Object)thresholdCriteria));
    }

    private void processVendorForThresholdSummary(SummaryAccount account, String vendorHeaderGeneratedIdentifier, String vendorDetailAssignedIdentifier) {
        ThresholdSummary thresholdSummary = new ThresholdSummary(ThresholdCriteria.CHART_AND_VENDOR);
        thresholdSummary.setProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE, account.getAccount().getChartOfAccountsCode());
        thresholdSummary.setProperty(ThresholdField.VENDOR_HEADER_GENERATED_ID, vendorHeaderGeneratedIdentifier);
        thresholdSummary.setProperty(ThresholdField.VENDOR_DETAIL_ASSIGNED_ID, vendorDetailAssignedIdentifier);
        thresholdSummary.addTotalAmount(account.getAccount().getAmount());
        this.addToSummaryList(thresholdSummary);
    }

    private void processCommodityCodeForThreshold(List<PurchaseOrderItem> items) {
        if (items != null) {
            for (PurchaseOrderItem item : items) {
                if (!item.isItemActiveIndicator()) continue;
                List<PurApAccountingLine> accountingLines = item.getSourceAccountingLines();
                for (int i = 0; i < accountingLines.size(); ++i) {
                    if (!StringUtils.isNotBlank((CharSequence)item.getPurchasingCommodityCode())) continue;
                    ThresholdSummary thresholdSummary = new ThresholdSummary(ThresholdCriteria.CHART_AND_COMMODITYCODE);
                    thresholdSummary.setProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE, accountingLines.get(i).getChartOfAccountsCode());
                    thresholdSummary.setProperty(ThresholdField.COMMODITY_CODE, item.getPurchasingCommodityCode());
                    thresholdSummary.addTotalAmount(item.getExtendedPrice());
                    this.addToSummaryList(thresholdSummary);
                }
            }
        }
    }

    public boolean isReceivingDocumentRequired() {
        if (this.allItemsNonQty) {
            return false;
        }
        for (ThresholdCriteria thresholdEnum : ThresholdCriteria.getEnumList()) {
            boolean result = this.isReceivingDocumentRequired(thresholdEnum);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public boolean isReceivingDocumentRequired(ThresholdCriteria thresholdEnum) {
        List<ThresholdSummary> summaryList = this.getThresholdSummaryCollection(thresholdEnum);
        if (summaryList != null) {
            for (ThresholdSummary summary : summaryList) {
                Collection<ReceivingThreshold> collection = null;
                if (thresholdEnum == ThresholdCriteria.CHART) {
                    collection = this.thresholdService.findByChart(summary.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE));
                } else if (thresholdEnum == ThresholdCriteria.CHART_AND_ACCOUNTTYPE) {
                    collection = this.thresholdService.findByChartAndFund(summary.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE), summary.getProperty(ThresholdField.ACCOUNT_TYPE_CODE));
                } else if (thresholdEnum == ThresholdCriteria.CHART_AND_SUBFUND) {
                    collection = this.thresholdService.findByChartAndSubFund(summary.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE), summary.getProperty(ThresholdField.SUBFUND_GROUP_CODE));
                } else if (thresholdEnum == ThresholdCriteria.CHART_AND_COMMODITYCODE) {
                    collection = this.thresholdService.findByChartAndCommodity(summary.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE), summary.getProperty(ThresholdField.COMMODITY_CODE));
                } else if (thresholdEnum == ThresholdCriteria.CHART_AND_OBJECTCODE) {
                    collection = this.thresholdService.findByChartAndObjectCode(summary.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE), summary.getProperty(ThresholdField.FINANCIAL_OBJECT_CODE));
                } else if (thresholdEnum == ThresholdCriteria.CHART_AND_ORGANIZATIONCODE) {
                    collection = this.thresholdService.findByChartAndOrg(summary.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE), summary.getProperty(ThresholdField.ORGANIZATION_CODE));
                } else if (thresholdEnum == ThresholdCriteria.CHART_AND_VENDOR) {
                    collection = this.thresholdService.findByChartAndVendor(summary.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE), summary.getProperty(ThresholdField.VENDOR_HEADER_GENERATED_ID), summary.getProperty(ThresholdField.VENDOR_DETAIL_ASSIGNED_ID));
                }
                if (collection == null) continue;
                for (ReceivingThreshold threshold : (List)collection) {
                    if (threshold.getThresholdAmount() != null && !threshold.getThresholdAmount().isLessThan((AbstractKualiDecimal)summary.getTotalAmount())) continue;
                    this.thresholdSummary = summary;
                    this.receivingThreshold = threshold;
                    return true;
                }
            }
        }
        return false;
    }

    public ThresholdSummary getThresholdSummary() {
        return this.thresholdSummary;
    }

    public ReceivingThreshold getReceivingThreshold() {
        return this.receivingThreshold;
    }

    public class ThresholdSummary {
        private ThresholdCriteria thresholdCriteria;
        private Map<ThresholdField, String> property2Value = new HashMap<ThresholdField, String>();
        private KualiDecimal totalAmount = KualiDecimal.ZERO;

        ThresholdSummary(ThresholdCriteria thresholdCriteria) {
            this.thresholdCriteria = thresholdCriteria;
        }

        void setProperty(ThresholdField thresholdField, String fieldValue) {
            if (!this.isValidProperty(thresholdField)) {
                throw new RuntimeException("Property[" + (Object)((Object)thresholdField) + "] not allowed for the threshold criteria[" + (Object)((Object)this.thresholdCriteria) + "]");
            }
            this.property2Value.put(thresholdField, fieldValue);
        }

        String getProperty(ThresholdField thresholdEnum) {
            return this.property2Value.get((Object)thresholdEnum);
        }

        public ThresholdCriteria getThresholdCriteria() {
            return this.thresholdCriteria;
        }

        public String getThresholdCriteriaName() {
            return this.thresholdCriteria.getName();
        }

        public KualiDecimal getTotalAmount() {
            return this.totalAmount;
        }

        void addTotalAmount(KualiDecimal totalAmount) {
            if (totalAmount != null) {
                this.totalAmount = (KualiDecimal)this.totalAmount.add((AbstractKualiDecimal)totalAmount);
            }
        }

        boolean isValidProperty(ThresholdField thresholdField) {
            if (this.getThresholdCriteria() == ThresholdCriteria.CHART && ThresholdField.CHART_OF_ACCOUNTS_CODE == thresholdField) {
                return true;
            }
            if (this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_ACCOUNTTYPE && (ThresholdField.CHART_OF_ACCOUNTS_CODE == thresholdField || ThresholdField.ACCOUNT_TYPE_CODE == thresholdField)) {
                return true;
            }
            if (this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_SUBFUND && (ThresholdField.CHART_OF_ACCOUNTS_CODE == thresholdField || ThresholdField.SUBFUND_GROUP_CODE == thresholdField)) {
                return true;
            }
            if (this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_COMMODITYCODE && (ThresholdField.CHART_OF_ACCOUNTS_CODE == thresholdField || ThresholdField.COMMODITY_CODE == thresholdField)) {
                return true;
            }
            if (this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_OBJECTCODE && (ThresholdField.CHART_OF_ACCOUNTS_CODE == thresholdField || ThresholdField.FINANCIAL_OBJECT_CODE == thresholdField)) {
                return true;
            }
            if (this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_ORGANIZATIONCODE && (ThresholdField.CHART_OF_ACCOUNTS_CODE == thresholdField || ThresholdField.ORGANIZATION_CODE == thresholdField)) {
                return true;
            }
            return this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_VENDOR && (ThresholdField.CHART_OF_ACCOUNTS_CODE == thresholdField || ThresholdField.VENDOR_HEADER_GENERATED_ID == thresholdField || ThresholdField.VENDOR_DETAIL_ASSIGNED_ID == thresholdField);
        }

        public boolean equals(Object obj) {
            if (obj != null) {
                if (!(obj instanceof ThresholdSummary)) {
                    return false;
                }
                ThresholdSummary thresholdItem = (ThresholdSummary)obj;
                if (this.getThresholdCriteria() == thresholdItem.getThresholdCriteria() && (this.getThresholdCriteria() == ThresholdCriteria.CHART ? StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.CHART_OF_ACCOUNTS_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE)) : (this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_ACCOUNTTYPE ? StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.CHART_OF_ACCOUNTS_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE)) && StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.ACCOUNT_TYPE_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.ACCOUNT_TYPE_CODE)) : (this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_SUBFUND ? StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.CHART_OF_ACCOUNTS_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE)) && StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.SUBFUND_GROUP_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.SUBFUND_GROUP_CODE)) : (this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_COMMODITYCODE ? StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.CHART_OF_ACCOUNTS_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE)) && StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.COMMODITY_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.COMMODITY_CODE)) : (this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_OBJECTCODE ? StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.CHART_OF_ACCOUNTS_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE)) && StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.FINANCIAL_OBJECT_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.FINANCIAL_OBJECT_CODE)) : (this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_ORGANIZATIONCODE ? StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.CHART_OF_ACCOUNTS_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE)) && StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.ORGANIZATION_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.ORGANIZATION_CODE)) : this.getThresholdCriteria() == ThresholdCriteria.CHART_AND_VENDOR && StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.CHART_OF_ACCOUNTS_CODE), (CharSequence)thresholdItem.getProperty(ThresholdField.CHART_OF_ACCOUNTS_CODE)) && StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.VENDOR_HEADER_GENERATED_ID), (CharSequence)thresholdItem.getProperty(ThresholdField.VENDOR_HEADER_GENERATED_ID)) && StringUtils.equals((CharSequence)this.property2Value.get((Object)ThresholdField.VENDOR_DETAIL_ASSIGNED_ID), (CharSequence)thresholdItem.getProperty(ThresholdField.VENDOR_DETAIL_ASSIGNED_ID))))))))) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            ToStringBuilder stringBuilder = new ToStringBuilder((Object)this);
            stringBuilder.append("ThresholdCriteria", (Object)this.getThresholdCriteria().name());
            stringBuilder.append("Amount", (Object)this.getTotalAmount());
            stringBuilder.append("Field2Values", this.property2Value);
            return stringBuilder.toString();
        }
    }
}

