/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceContact;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestHeader;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestSummary;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoicePostalAddress;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReason;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceMappingService;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.module.purap.util.cxml.CxmlHeader;

public class ElectronicInvoice {
    private static BigDecimal zero = new BigDecimal(0.0);
    public static String INVOICE_AMOUNT_TYPE_CODE_ITEM = "ITEM";
    public static String INVOICE_AMOUNT_TYPE_CODE_TAX = "TAX";
    public static String INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING = "SPHD";
    public static String INVOICE_AMOUNT_TYPE_CODE_SHIPPING = "SHIP";
    public static String INVOICE_AMOUNT_TYPE_CODE_DISCOUNT = "DISC";
    public static String INVOICE_AMOUNT_TYPE_CODE_DEPOSIT = "DPST";
    public static String INVOICE_AMOUNT_TYPE_CODE_DUE = "DUE";
    public static String INVOICE_AMOUNT_TYPE_CODE_EXMT = "EXMT";
    public static boolean FILE_REJECTED = true;
    public static boolean FILE_NOT_REJECTED = false;
    public static boolean FILE_DOES_CONTAIN_REJECTS = true;
    public static boolean FILE_DOES_NOT_CONTAIN_REJECTS = false;
    private CxmlHeader cxmlHeader;
    private String customerNumber;
    private String fileName;
    private String dunsNumber;
    private Integer vendorHeaderID = null;
    private Integer vendorDetailID = null;
    private String vendorName = null;
    private boolean fileRejected = FILE_NOT_REJECTED;
    private boolean containsRejects = FILE_DOES_NOT_CONTAIN_REJECTS;
    private List fileRejectReasons = new ArrayList();
    private ElectronicInvoiceDetailRequestHeader invoiceDetailRequestHeader;
    private List invoiceDetailOrders = new ArrayList();
    private ElectronicInvoiceDetailRequestSummary invoiceDetailRequestSummary;
    private String version = "1.2.019";
    private String timestamp;
    private String payloadID;
    private String locale;
    private String deploymentMode = "production";

    private boolean containsLineLevelAmounts() {
        return this.invoiceDetailRequestHeader.isShippingInLine() || this.invoiceDetailRequestHeader.isSpecialHandlingInLine() || this.invoiceDetailRequestHeader.isTaxInLine() || this.invoiceDetailRequestHeader.isDiscountInLine();
    }

    public void addFileRejectReasonToList(ElectronicInvoiceRejectReason reason) {
        this.fileRejectReasons.add(reason);
    }

    public ElectronicInvoicePostalAddress getCxmlPostalAddress(ElectronicInvoiceOrder eio, String roleID, String addressName) {
        if (this.invoiceDetailRequestHeader.isShippingInLine()) {
            return eio.getCxmlPostalAddressByRoleID(roleID, addressName);
        }
        return this.invoiceDetailRequestHeader.getCxmlPostalAddressByRoleID(roleID, addressName);
    }

    public ElectronicInvoiceContact getCxmlContact(ElectronicInvoiceOrder eio, String roleID) {
        if (this.invoiceDetailRequestHeader.isShippingInLine()) {
            return eio.getCxmlContactByRoleID(roleID);
        }
        return this.invoiceDetailRequestHeader.getCxmlContactByRoleID(roleID);
    }

    public String getShippingDateDisplayText(ElectronicInvoiceOrder eio) {
        Date date = null;
        String dateString = "";
        if (this.invoiceDetailRequestHeader.isShippingInLine()) {
            date = eio.getInvoiceShippingDate();
            dateString = eio.getInvoiceShippingDateString();
        } else {
            date = this.invoiceDetailRequestHeader.getShippingDate();
            dateString = this.invoiceDetailRequestHeader.getShippingDateString();
        }
        if (date != null) {
            return ElectronicInvoiceUtils.getDateDisplayText(date);
        }
        return dateString;
    }

    public String getMasterAgreementIDInfoDateDisplayText(ElectronicInvoiceOrder eio) {
        Date date = eio.getMasterAgreementIDInfoDate();
        if (date != null) {
            return ElectronicInvoiceUtils.getDateDisplayText(date);
        }
        return eio.getMasterAgreementIDInfoDateString();
    }

    public String getMasterAgreementReferenceDateDisplayText(ElectronicInvoiceOrder eio) {
        Date date = eio.getMasterAgreementReferenceDate();
        if (date != null) {
            return ElectronicInvoiceUtils.getDateDisplayText(date);
        }
        return eio.getMasterAgreementReferenceDateString();
    }

    public String getOrderIDInfoDateDisplayText(ElectronicInvoiceOrder eio) {
        Date date = eio.getOrderIDInfoDate();
        if (date != null) {
            return ElectronicInvoiceUtils.getDateDisplayText(date);
        }
        return eio.getOrderIDInfoDateString();
    }

    public String getInvoiceDateDisplayText() {
        java.sql.Date date = this.invoiceDetailRequestHeader.getInvoiceDate();
        if (date != null) {
            return ElectronicInvoiceUtils.getDateDisplayText(date);
        }
        return this.invoiceDetailRequestHeader.getInvoiceDateString();
    }

    public String getInvoiceShippingDescription(ElectronicInvoiceOrder eio) {
        if (this.invoiceDetailRequestHeader.isShippingInLine()) {
            return eio.getInvoiceShippingDescription();
        }
        return this.invoiceDetailRequestSummary.getShippingDescription();
    }

    public String getInvoiceTaxDescription(ElectronicInvoiceOrder eio) {
        if (this.invoiceDetailRequestHeader.isTaxInLine()) {
            return eio.getInvoiceTaxDescription();
        }
        return this.invoiceDetailRequestSummary.getTaxDescription();
    }

    public String getInvoiceSpecialHandlingDescription(ElectronicInvoiceOrder eio) {
        if (this.invoiceDetailRequestHeader.isSpecialHandlingInLine()) {
            return eio.getInvoiceSpecialHandlingDescription();
        }
        return this.invoiceDetailRequestSummary.getSpecialHandlingAmountDescription();
    }

    public BigDecimal getFileTotalAmountForInLineItems(String invoiceLineItemType) {
        BigDecimal total = zero;
        for (ElectronicInvoiceOrder eio : this.invoiceDetailOrders) {
            if (INVOICE_AMOUNT_TYPE_CODE_TAX.equalsIgnoreCase(invoiceLineItemType)) {
                total = total.add(eio.getInvoiceTaxAmount());
                continue;
            }
            if (INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING.equalsIgnoreCase(invoiceLineItemType)) {
                total = total.add(eio.getInvoiceSpecialHandlingAmount());
                continue;
            }
            if (INVOICE_AMOUNT_TYPE_CODE_SHIPPING.equalsIgnoreCase(invoiceLineItemType)) {
                total = total.add(eio.getInvoiceShippingAmount());
                continue;
            }
            if (!INVOICE_AMOUNT_TYPE_CODE_DISCOUNT.equalsIgnoreCase(invoiceLineItemType)) continue;
            total = total.add(eio.getInvoiceDiscountAmount());
        }
        return total;
    }

    public BigDecimal getInvoiceSubTotalAmount(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            return eio.getInvoiceSubTotalAmount();
        }
        return this.invoiceDetailRequestSummary.getInvoiceSubTotalAmount();
    }

    public BigDecimal getInvoiceTaxAmount(ElectronicInvoiceOrder eio) {
        if (this.invoiceDetailRequestHeader.isTaxInLine()) {
            return eio.getInvoiceTaxAmount();
        }
        return this.invoiceDetailRequestSummary.getInvoiceTaxAmount();
    }

    public BigDecimal getInvoiceSpecialHandlingAmount(ElectronicInvoiceOrder eio) {
        if (this.invoiceDetailRequestHeader.isSpecialHandlingInLine()) {
            return eio.getInvoiceSpecialHandlingAmount();
        }
        return this.invoiceDetailRequestSummary.getInvoiceSpecialHandlingAmount();
    }

    public BigDecimal getInvoiceShippingAmount(ElectronicInvoiceOrder eio) {
        if (this.invoiceDetailRequestHeader.isShippingInLine()) {
            return eio.getInvoiceShippingAmount();
        }
        return this.invoiceDetailRequestSummary.getInvoiceShippingAmount();
    }

    public BigDecimal getInvoiceGrossAmount(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            return eio.getInvoiceGrossAmount();
        }
        return this.invoiceDetailRequestSummary.getInvoiceGrossAmount();
    }

    public BigDecimal getInvoiceDiscountAmount(ElectronicInvoiceOrder eio) {
        if (this.invoiceDetailRequestHeader.isDiscountInLine()) {
            return eio.getInvoiceDiscountAmount();
        }
        return this.invoiceDetailRequestSummary.getInvoiceDiscountAmount();
    }

    public BigDecimal getInvoiceNetAmount(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            return eio.getInvoiceNetAmount();
        }
        return this.invoiceDetailRequestSummary.getInvoiceNetAmount();
    }

    public BigDecimal getInvoiceDepositAmount() {
        return this.invoiceDetailRequestSummary.getInvoiceDepositAmount();
    }

    public BigDecimal getInvoiceDueAmount() {
        return this.invoiceDetailRequestSummary.getInvoiceDueAmount();
    }

    public String getCodeOfLineItemThatContainsInvalidCurrency(String invoiceLineItemType) {
        for (ElectronicInvoiceOrder eio : this.invoiceDetailOrders) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                if (INVOICE_AMOUNT_TYPE_CODE_TAX.equalsIgnoreCase(invoiceLineItemType)) {
                    if (this.isCodeValidCurrency(eii.getTaxAmountCurrency())) continue;
                    return eii.getTaxAmountCurrency();
                }
                if (INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING.equalsIgnoreCase(invoiceLineItemType)) {
                    if (this.isCodeValidCurrency(eii.getInvoiceLineSpecialHandlingAmountCurrency())) continue;
                    return eii.getInvoiceLineSpecialHandlingAmountCurrency();
                }
                if (INVOICE_AMOUNT_TYPE_CODE_SHIPPING.equalsIgnoreCase(invoiceLineItemType)) {
                    if (this.isCodeValidCurrency(eii.getInvoiceLineShippingAmountCurrency())) continue;
                    return eii.getInvoiceLineShippingAmountCurrency();
                }
                if (!INVOICE_AMOUNT_TYPE_CODE_DISCOUNT.equalsIgnoreCase(invoiceLineItemType) || this.isCodeValidCurrency(eii.getInvoiceLineDiscountAmountCurrency())) continue;
                return eii.getInvoiceLineDiscountAmountCurrency();
            }
        }
        return null;
    }

    public String checkCodeForValidCurrency(String code) {
        if (!this.isCodeValidCurrency(code)) {
            return code;
        }
        return null;
    }

    public boolean isCodeValidCurrency(String code) {
        if (code != null) {
            for (int i = 0; i < ElectronicInvoiceMappingService.CXML_VALID_CURRENCY_CODES.length; ++i) {
                String validCode = ElectronicInvoiceMappingService.CXML_VALID_CURRENCY_CODES[i];
                if (!code.equalsIgnoreCase(validCode)) continue;
                return true;
            }
        }
        return false;
    }

    public String getInvoiceSubTotalCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getSubTotalAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.invoiceDetailRequestSummary.getSubTotalAmountCurrency());
    }

    public String getInvoiceTaxCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.invoiceDetailRequestHeader.isTaxInLine()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getTaxAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.invoiceDetailRequestSummary.getTaxAmountCurrency());
    }

    public String getInvoiceSpecialHandlingCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.invoiceDetailRequestHeader.isSpecialHandlingInLine()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getInvoiceLineSpecialHandlingAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.invoiceDetailRequestSummary.getSpecialHandlingAmountCurrency());
    }

    public String getInvoiceShippingCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.invoiceDetailRequestHeader.isShippingInLine()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getInvoiceLineShippingAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.invoiceDetailRequestSummary.getShippingAmountCurrency());
    }

    public String getInvoiceGrossCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getInvoiceLineGrossAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.invoiceDetailRequestSummary.getGrossAmountCurrency());
    }

    public String getInvoiceDiscountCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.invoiceDetailRequestHeader.isDiscountInLine()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getInvoiceLineDiscountAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.invoiceDetailRequestSummary.getDiscountAmountCurrency());
    }

    public String getInvoiceNetCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getInvoiceLineNetAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.invoiceDetailRequestSummary.getNetAmountCurrency());
    }

    public String getInvoiceDepositCurrencyIfNotValid() {
        return this.checkCodeForValidCurrency(this.invoiceDetailRequestSummary.getDepositAmountCurrency());
    }

    public String getInvoiceDueCurrencyIfNotValid() {
        return this.checkCodeForValidCurrency(this.invoiceDetailRequestSummary.getDueAmountCurrency());
    }

    public boolean isContainsRejects() {
        return this.containsRejects;
    }

    public void setContainsRejects(boolean containsRejects) {
        this.containsRejects = containsRejects;
    }

    public String getCustomerNumber() {
        return this.customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public CxmlHeader getCxmlHeader() {
        return this.cxmlHeader;
    }

    public void setCxmlHeader(CxmlHeader cxmlHeader) {
        this.cxmlHeader = cxmlHeader;
    }

    public String getDunsNumber() {
        return this.dunsNumber;
    }

    public void setDunsNumber(String dunsNumber) {
        this.dunsNumber = dunsNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isFileRejected() {
        return this.fileRejected;
    }

    public void setFileRejected(boolean fileRejected) {
        this.fileRejected = fileRejected;
    }

    public List<ElectronicInvoiceRejectReason> getFileRejectReasons() {
        return this.fileRejectReasons;
    }

    public void setFileRejectReasons(List<ElectronicInvoiceRejectReason> fileRejectReasons) {
        this.fileRejectReasons = fileRejectReasons;
    }

    public List<ElectronicInvoiceOrder> getInvoiceDetailOrders() {
        return this.invoiceDetailOrders;
    }

    public void setInvoiceDetailOrders(List<ElectronicInvoiceOrder> invoiceDetailOrders) {
        this.invoiceDetailOrders = invoiceDetailOrders;
    }

    public ElectronicInvoiceDetailRequestHeader getInvoiceDetailRequestHeader() {
        return this.invoiceDetailRequestHeader;
    }

    public void setInvoiceDetailRequestHeader(ElectronicInvoiceDetailRequestHeader invoiceDetailRequestHeader) {
        this.invoiceDetailRequestHeader = invoiceDetailRequestHeader;
    }

    public ElectronicInvoiceDetailRequestSummary getInvoiceDetailRequestSummary() {
        return this.invoiceDetailRequestSummary;
    }

    public void setInvoiceDetailRequestSummary(ElectronicInvoiceDetailRequestSummary invoiceDetailRequestSummary) {
        this.invoiceDetailRequestSummary = invoiceDetailRequestSummary;
    }

    public Integer getVendorDetailID() {
        return this.vendorDetailID;
    }

    public void setVendorDetailID(Integer vendorDetailID) {
        this.vendorDetailID = vendorDetailID;
    }

    public Integer getVendorHeaderID() {
        return this.vendorHeaderID;
    }

    public void setVendorHeaderID(Integer vendorHeaderID) {
        this.vendorHeaderID = vendorHeaderID;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getPayloadID() {
        return this.payloadID;
    }

    public void setPayloadID(String payloadID) {
        this.payloadID = payloadID;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void addInvoiceDetailOrder(ElectronicInvoiceOrder electronicInvoiceOrder) {
        this.invoiceDetailOrders.add(electronicInvoiceOrder);
    }

    public ElectronicInvoiceOrder[] getInvoiceDetailOrdersAsArray() {
        if (this.invoiceDetailOrders.size() > 0) {
            ElectronicInvoiceOrder[] tempOrders = new ElectronicInvoiceOrder[this.invoiceDetailOrders.size()];
            this.invoiceDetailOrders.toArray(tempOrders);
            return tempOrders;
        }
        return null;
    }

    public String getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    public String toString() {
        ToStringBuilder toString = new ToStringBuilder((Object)this);
        toString.append("version", (Object)this.getVersion());
        toString.append("timestamp", (Object)this.getTimestamp());
        toString.append("payloadID", (Object)this.getPayloadID());
        toString.append("locale", (Object)this.getLocale());
        toString.append("customerNumber", (Object)this.getCustomerNumber());
        toString.append("fileName", (Object)this.getFileName());
        toString.append("deploymentMode", (Object)this.getDeploymentMode());
        toString.append("dunsNumber", (Object)this.getDunsNumber());
        toString.append("vendorHeaderID", (Object)this.getVendorHeaderID());
        toString.append("vendorDetailID", (Object)this.getVendorDetailID());
        toString.append("vendorName", (Object)this.getVendorName());
        toString.append("cxmlHeader", (Object)this.getCxmlHeader());
        toString.append("invoiceDetailRequestHeader", (Object)this.getInvoiceDetailRequestHeader());
        toString.append("invoiceDetailOrders", this.getInvoiceDetailOrders());
        toString.append("invoiceDetailRequestSummary", (Object)this.getInvoiceDetailRequestSummary());
        return toString.toString();
    }
}

