/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceContact;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoicePostalAddress;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReason;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;

public class ElectronicInvoiceOrder {
    public static boolean INVOICE_ORDER_REJECTED = true;
    public static boolean INVOICE_ORDER_NOT_REJECTED = false;
    private String orderReferenceOrderID;
    private String orderReferenceDocumentRefPayloadID;
    private String orderReferenceDocumentRef;
    private String masterAgreementReferenceID;
    private Date masterAgreementReferenceDate;
    private String masterAgreementReferenceDateString;
    private String masterAgreementIDInfoID;
    private Date masterAgreementIDInfoDate;
    private String masterAgreementIDInfoDateString;
    private String orderIDInfoID;
    private Date orderIDInfoDate;
    private String orderIDInfoDateString;
    private String supplierOrderInfoID;
    private String invoicePurchaseOrderID;
    private String orderReferenceOrderDateString;
    private Integer purchaseOrderID = null;
    private String purchaseOrderCampusCode;
    private boolean rejected = INVOICE_ORDER_NOT_REJECTED;
    private List orderRejectReasons = new ArrayList();
    private List invoiceItems = new ArrayList();

    public ElectronicInvoiceItem getElectronicInvoiceItemByPOLineNumber(Integer poLineNumber) {
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            if (poLineNumber.compareTo(eii.getReferenceLineNumberInteger()) != 0) continue;
            return eii;
        }
        return null;
    }

    public ElectronicInvoicePostalAddress getCxmlPostalAddressByRoleID(String roleID, String addressName) {
        ElectronicInvoiceContact contact;
        if (roleID != null && (contact = this.getCxmlContactByRoleID(roleID)) != null) {
            for (ElectronicInvoicePostalAddress cpa : contact.getPostalAddresses()) {
                if (addressName == null) {
                    return cpa;
                }
                if (!addressName.equalsIgnoreCase(cpa.getName())) continue;
                return cpa;
            }
        }
        return null;
    }

    public ElectronicInvoiceContact getCxmlContactByRoleID(String roleID) {
        if (roleID != null) {
            for (ElectronicInvoiceItem eii : this.invoiceItems) {
                for (ElectronicInvoiceContact contact : eii.getInvoiceShippingContacts()) {
                    if (!roleID.equalsIgnoreCase(contact.getRole())) continue;
                    return contact;
                }
            }
        }
        return null;
    }

    public Date getInvoiceShippingDate() {
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            Date testDate = eii.getShippingDate();
            if (testDate == null) continue;
            return testDate;
        }
        return null;
    }

    public String getInvoiceShippingDateString() {
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            String testDateString = eii.getShippingDateString();
            if (testDateString == null || "".equals(testDateString)) continue;
            return testDateString;
        }
        return null;
    }

    public String getInvoiceTaxDescription() {
        BigDecimal total = BigDecimal.ZERO;
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            BigDecimal taxAmount = eii.getInvoiceLineTaxAmountBigDecimal();
            if (taxAmount == null || BigDecimal.ZERO.compareTo(taxAmount) == 0) continue;
            return eii.getTaxDescription();
        }
        return null;
    }

    public String getInvoiceShippingDescription() {
        BigDecimal total = BigDecimal.ZERO;
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            BigDecimal shippingAmount = eii.getInvoiceLineShippingAmountBigDecimal();
            if (shippingAmount == null || BigDecimal.ZERO.compareTo(shippingAmount) == 0) continue;
            return "Shipping";
        }
        return null;
    }

    public String getInvoiceSpecialHandlingDescription() {
        BigDecimal total = BigDecimal.ZERO;
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            BigDecimal specialHandlingAmount = eii.getInvoiceLineSpecialHandlingAmountBigDecimal();
            if (specialHandlingAmount == null || BigDecimal.ZERO.compareTo(specialHandlingAmount) == 0) continue;
            return "Handling";
        }
        return null;
    }

    public BigDecimal getInvoiceSubTotalAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            total = total.add(eii.getInvoiceLineSubTotalAmountBigDecimal());
        }
        return total;
    }

    public BigDecimal getInvoiceTaxAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            total = total.add(eii.getInvoiceLineTaxAmountBigDecimal());
        }
        return total;
    }

    public BigDecimal getInvoiceSpecialHandlingAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            total = total.add(eii.getInvoiceLineSpecialHandlingAmountBigDecimal());
        }
        return total;
    }

    public BigDecimal getInvoiceShippingAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            total = total.add(eii.getInvoiceLineShippingAmountBigDecimal());
        }
        return total;
    }

    public BigDecimal getInvoiceGrossAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            total = total.add(eii.getInvoiceLineGrossAmountBigDecimal());
        }
        return total;
    }

    public BigDecimal getInvoiceDiscountAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            total = total.add(eii.getInvoiceLineDiscountAmountBigDecimal());
        }
        return total;
    }

    public BigDecimal getInvoiceNetAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (ElectronicInvoiceItem eii : this.invoiceItems) {
            total = total.add(eii.getInvoiceLineNetAmountBigDecimal());
        }
        return total;
    }

    public void addRejectReasonToList(ElectronicInvoiceRejectReason reason) {
        this.orderRejectReasons.add(reason);
    }

    public void setMasterAgreementIDInfoDateString(String masterAgreementIDInfoDateString) {
        this.masterAgreementIDInfoDateString = masterAgreementIDInfoDateString;
        this.setMasterAgreementIDInfoDate(ElectronicInvoiceUtils.getDate(masterAgreementIDInfoDateString));
    }

    public void setMasterAgreementReferenceDateString(String masterAgreementReferenceDateString) {
        this.masterAgreementReferenceDateString = masterAgreementReferenceDateString;
        this.setMasterAgreementIDInfoDate(ElectronicInvoiceUtils.getDate(masterAgreementReferenceDateString));
    }

    public void setOrderIDInfoDateString(String orderIDInfoDateString) {
        this.orderIDInfoDateString = orderIDInfoDateString;
        this.setOrderIDInfoDate(ElectronicInvoiceUtils.getDate(orderIDInfoDateString));
    }

    public List<ElectronicInvoiceItem> getInvoiceItems() {
        return this.invoiceItems;
    }

    public void setInvoiceItems(List<ElectronicInvoiceItem> invoiceItems) {
        this.invoiceItems = invoiceItems;
    }

    public String getInvoicePurchaseOrderID() {
        return this.invoicePurchaseOrderID;
    }

    public void setInvoicePurchaseOrderID(String invoicePurchaseOrderID) {
        this.invoicePurchaseOrderID = invoicePurchaseOrderID;
    }

    public Date getMasterAgreementIDInfoDate() {
        return this.masterAgreementIDInfoDate;
    }

    public void setMasterAgreementIDInfoDate(Date masterAgreementIDInfoDate) {
        this.masterAgreementIDInfoDate = masterAgreementIDInfoDate;
    }

    public String getMasterAgreementIDInfoID() {
        return this.masterAgreementIDInfoID;
    }

    public void setMasterAgreementIDInfoID(String masterAgreementIDInfoID) {
        this.masterAgreementIDInfoID = masterAgreementIDInfoID;
    }

    public Date getMasterAgreementReferenceDate() {
        return this.masterAgreementReferenceDate;
    }

    public void setMasterAgreementReferenceDate(Date masterAgreementReferenceDate) {
        this.masterAgreementReferenceDate = masterAgreementReferenceDate;
    }

    public String getMasterAgreementReferenceID() {
        return this.masterAgreementReferenceID;
    }

    public void setMasterAgreementReferenceID(String masterAgreementReferenceID) {
        this.masterAgreementReferenceID = masterAgreementReferenceID;
    }

    public Date getOrderIDInfoDate() {
        return this.orderIDInfoDate;
    }

    public void setOrderIDInfoDate(Date orderIDInfoDate) {
        this.orderIDInfoDate = orderIDInfoDate;
    }

    public String getOrderIDInfoID() {
        return this.orderIDInfoID;
    }

    public void setOrderIDInfoID(String orderIDInfoID) {
        this.orderIDInfoID = orderIDInfoID;
    }

    public String getOrderReferenceDocumentRef() {
        return this.orderReferenceDocumentRef;
    }

    public void setOrderReferenceDocumentRef(String orderReferenceDocumentRef) {
        this.orderReferenceDocumentRef = orderReferenceDocumentRef;
    }

    public String getOrderReferenceDocumentRefPayloadID() {
        return this.orderReferenceDocumentRefPayloadID;
    }

    public void setOrderReferenceDocumentRefPayloadID(String orderReferenceDocumentRefPayloadID) {
        this.orderReferenceDocumentRefPayloadID = orderReferenceDocumentRefPayloadID;
    }

    public String getOrderReferenceOrderID() {
        return this.orderReferenceOrderID;
    }

    public void setOrderReferenceOrderID(String orderReferenceOrderID) {
        this.orderReferenceOrderID = orderReferenceOrderID;
    }

    public List<ElectronicInvoiceRejectReason> getOrderRejectReasons() {
        return this.orderRejectReasons;
    }

    public void setOrderRejectReasons(List<ElectronicInvoiceRejectReason> orderRejectReasons) {
        this.orderRejectReasons = orderRejectReasons;
    }

    public String getPurchaseOrderCampusCode() {
        return this.purchaseOrderCampusCode;
    }

    public void setPurchaseOrderCampusCode(String purchaseOrderCampusCode) {
        this.purchaseOrderCampusCode = purchaseOrderCampusCode;
    }

    public Integer getPurchaseOrderID() {
        return this.purchaseOrderID;
    }

    public void setPurchaseOrderID(Integer purchaseOrderID) {
        this.purchaseOrderID = purchaseOrderID;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void setRejected(boolean rejected) {
        this.rejected = rejected;
    }

    public String getSupplierOrderInfoID() {
        return this.supplierOrderInfoID;
    }

    public void setSupplierOrderInfoID(String supplierOrderInfoID) {
        this.supplierOrderInfoID = supplierOrderInfoID;
    }

    public String getMasterAgreementIDInfoDateString() {
        return this.masterAgreementIDInfoDateString;
    }

    public String getMasterAgreementReferenceDateString() {
        return this.masterAgreementReferenceDateString;
    }

    public String getOrderIDInfoDateString() {
        return this.orderIDInfoDateString;
    }

    public void addInvoiceItem(ElectronicInvoiceItem electronicInvoiceItem) {
        this.invoiceItems.add(electronicInvoiceItem);
        Collections.sort(this.invoiceItems, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ElectronicInvoiceItem)o1).getReferenceLineNumberInteger().compareTo(((ElectronicInvoiceItem)o2).getReferenceLineNumberInteger());
            }
        });
    }

    public ElectronicInvoiceItem[] getInvoiceItemsAsArray() {
        if (this.invoiceItems.size() > 0) {
            ElectronicInvoiceItem[] tempItems = new ElectronicInvoiceItem[this.invoiceItems.size()];
            this.invoiceItems.toArray(tempItems);
            return tempItems;
        }
        return null;
    }

    public String getOrderReferenceOrderDateString() {
        return this.orderReferenceOrderDateString;
    }

    public void setOrderReferenceOrderDateString(String orderReferenceOrderDateString) {
        this.orderReferenceOrderDateString = orderReferenceOrderDateString;
    }

    public String toString() {
        ToStringBuilder toString = new ToStringBuilder((Object)this);
        toString.append("orderReferenceOrderID", (Object)this.getOrderReferenceOrderID());
        toString.append("orderReferenceOrderDate", (Object)this.getOrderReferenceOrderDateString());
        toString.append("orderReferenceDocumentRefPayloadID", (Object)this.getOrderReferenceDocumentRefPayloadID());
        toString.append("orderReferenceDocumentRef", (Object)this.getOrderReferenceDocumentRef());
        toString.append("masterAgreementReferenceID", (Object)this.getMasterAgreementReferenceID());
        toString.append("masterAgreementReferenceDateString", (Object)this.getMasterAgreementReferenceDateString());
        toString.append("masterAgreementIDInfoID", (Object)this.getMasterAgreementIDInfoID());
        toString.append("masterAgreementIDInfoDateString", (Object)this.getMasterAgreementIDInfoDateString());
        toString.append("orderIDInfoID", (Object)this.getOrderIDInfoID());
        toString.append("orderIDInfoDateString", (Object)this.getOrderIDInfoDateString());
        toString.append("supplierOrderInfoID", (Object)this.getSupplierOrderInfoID());
        toString.append("invoiceItems", this.getInvoiceItems());
        return toString.toString();
    }
}

