/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurApSummaryItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PurchaseOrderItem
extends PurchasingItemBase {
    private String documentNumber;
    private KualiDecimal itemInvoicedTotalQuantity;
    private KualiDecimal itemInvoicedTotalAmount;
    private KualiDecimal itemReceivedTotalQuantity;
    private KualiDecimal itemOutstandingEncumberedQuantity;
    private KualiDecimal itemOutstandingEncumberedAmount;
    private boolean itemActiveIndicator = true;
    private KualiDecimal itemDamagedTotalQuantity;
    private PurchaseOrderDocument purchaseOrder;
    private boolean itemSelectedForRetransmitIndicator;
    private boolean movingToSplit;

    public PurchaseOrderItem() {
    }

    public PurchaseOrderItem(RequisitionItem ri, PurchaseOrderDocument po, RequisitionCapitalAssetItem reqCamsItem) {
        this.setPurchaseOrder(po);
        SequenceAccessorService sas = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
        Integer itemIdentifier = sas.getNextAvailableSequenceNumber("PO_ITM_ID", PurchaseOrderDocument.class).intValue();
        this.setItemIdentifier(itemIdentifier);
        this.setItemLineNumber(ri.getItemLineNumber());
        this.setItemUnitOfMeasureCode(ri.getItemUnitOfMeasureCode());
        this.setItemQuantity(ri.getItemQuantity());
        this.setItemCatalogNumber(ri.getItemCatalogNumber());
        this.setItemDescription(ri.getItemDescription());
        this.setItemUnitPrice(ri.getItemUnitPrice());
        this.setItemAuxiliaryPartIdentifier(ri.getItemAuxiliaryPartIdentifier());
        this.setItemAssignedToTradeInIndicator(ri.getItemAssignedToTradeInIndicator());
        this.setItemTaxAmount(ri.getItemTaxAmount());
        for (PurApItemUseTax useTaxItem : ri.getUseTaxItems()) {
            PurchaseOrderItemUseTax newItemUseTax = new PurchaseOrderItemUseTax(useTaxItem);
            newItemUseTax.setItemIdentifier(itemIdentifier);
            this.getUseTaxItems().add(newItemUseTax);
        }
        this.setExternalOrganizationB2bProductReferenceNumber(ri.getExternalOrganizationB2bProductReferenceNumber());
        this.setExternalOrganizationB2bProductTypeName(ri.getExternalOrganizationB2bProductTypeName());
        this.setItemReceivedTotalQuantity(KualiDecimal.ZERO);
        this.setItemDamagedTotalQuantity(KualiDecimal.ZERO);
        this.setItemTypeCode(ri.getItemTypeCode());
        if (ri.getSourceAccountingLines() != null && ri.getSourceAccountingLines().size() > 0 && !StringUtils.equals((CharSequence)"ORDS", (CharSequence)ri.getItemType().getItemTypeCode())) {
            ArrayList<PurApAccountingLine> accounts = new ArrayList<PurApAccountingLine>();
            for (PurApAccountingLine account : ri.getSourceAccountingLines()) {
                PurchaseOrderAccount poAccount = new PurchaseOrderAccount(account);
                poAccount.setPurchaseOrderItem(this);
                accounts.add(poAccount);
            }
            this.setSourceAccountingLines(accounts);
        }
        this.setItemActiveIndicator(true);
        this.setPurchasingCommodityCode(ri.getPurchasingCommodityCode());
        this.setCommodityCode(this.getCommodityCode());
        if (ObjectUtils.isNotNull((Object)reqCamsItem)) {
            PurchaseOrderCapitalAssetItem newPOCapitalAssetItem = new PurchaseOrderCapitalAssetItem(reqCamsItem, itemIdentifier);
            po.getPurchasingCapitalAssetItems().add(newPOCapitalAssetItem);
        }
    }

    public boolean isItemActiveIndicator() {
        return this.itemActiveIndicator;
    }

    public void setItemActiveIndicator(boolean itemActiveIndicator) {
        this.itemActiveIndicator = itemActiveIndicator;
    }

    public KualiDecimal getItemInvoicedTotalAmount() {
        return this.itemInvoicedTotalAmount;
    }

    public void setItemInvoicedTotalAmount(KualiDecimal itemInvoicedTotalAmount) {
        this.itemInvoicedTotalAmount = itemInvoicedTotalAmount;
    }

    public KualiDecimal getItemInvoicedTotalQuantity() {
        return this.itemInvoicedTotalQuantity;
    }

    public void setItemInvoicedTotalQuantity(KualiDecimal itemInvoicedTotalQuantity) {
        this.itemInvoicedTotalQuantity = itemInvoicedTotalQuantity;
    }

    public KualiDecimal getItemOutstandingEncumberedQuantity() {
        return this.itemOutstandingEncumberedQuantity;
    }

    public void setItemOutstandingEncumberedQuantity(KualiDecimal itemOutstandingEncumberedQuantity) {
        this.itemOutstandingEncumberedQuantity = itemOutstandingEncumberedQuantity;
    }

    public KualiDecimal getItemOutstandingEncumberedAmount() {
        return this.itemOutstandingEncumberedAmount;
    }

    public void setItemOutstandingEncumberedAmount(KualiDecimal itemOutstandingEncumbranceAmount) {
        this.itemOutstandingEncumberedAmount = itemOutstandingEncumbranceAmount;
    }

    public KualiDecimal getItemReceivedTotalQuantity() {
        return this.itemReceivedTotalQuantity;
    }

    public void setItemReceivedTotalQuantity(KualiDecimal itemReceivedTotalQuantity) {
        this.itemReceivedTotalQuantity = itemReceivedTotalQuantity;
    }

    public KualiDecimal getItemDamagedTotalQuantity() {
        return this.itemDamagedTotalQuantity;
    }

    public void setItemDamagedTotalQuantity(KualiDecimal itemDamagedTotalQuantity) {
        this.itemDamagedTotalQuantity = itemDamagedTotalQuantity;
    }

    public PurchaseOrderDocument getPurchaseOrder() {
        if (ObjectUtils.isNull((Object)this.purchaseOrder)) {
            this.refreshReferenceObject("purapDocument");
        }
        return (PurchaseOrderDocument)super.getPurapDocument();
    }

    public void setPurchaseOrder(PurchaseOrderDocument purchaseOrder) {
        this.setPurapDocument(purchaseOrder);
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public boolean isItemSelectedForRetransmitIndicator() {
        return this.itemSelectedForRetransmitIndicator;
    }

    public void setItemSelectedForRetransmitIndicator(boolean itemSelectedForRetransmitIndicator) {
        this.itemSelectedForRetransmitIndicator = itemSelectedForRetransmitIndicator;
    }

    public boolean isMovingToSplit() {
        return this.movingToSplit;
    }

    public void setMovingToSplit(boolean movingToSplit) {
        this.movingToSplit = movingToSplit;
    }

    @Override
    public Class getAccountingLineClass() {
        return PurchaseOrderAccount.class;
    }

    public KualiDecimal getItemPaidAmount() {
        if (!this.isItemActiveIndicator()) {
            return KualiDecimal.ZERO;
        }
        return this.getItemInvoicedTotalAmount();
    }

    public KualiDecimal getItemEncumbranceRelievedAmount() {
        if (this == null || !this.isItemActiveIndicator()) {
            return KualiDecimal.ZERO;
        }
        KualiDecimal outstandingAmount = KualiDecimal.ZERO;
        KualiDecimal totalEncumberance = this.getTotalAmount();
        ItemType iT = this.getItemType();
        if (iT.isAmountBasedGeneralLedgerIndicator()) {
            outstandingAmount = (KualiDecimal)outstandingAmount.add((AbstractKualiDecimal)this.getItemOutstandingEncumberedAmount());
        } else {
            BigDecimal qty = new BigDecimal(this.getOutstandingQuantity().toString());
            outstandingAmount = (KualiDecimal)outstandingAmount.add((AbstractKualiDecimal)new KualiDecimal(this.getItemUnitPrice().multiply(qty).setScale(2, 4)));
            KualiDecimal itemTaxAmount = this.getItemTaxAmount() == null ? KualiDecimal.ZERO : this.getItemTaxAmount();
            KualiDecimal outstandingTaxAmount = (KualiDecimal)((KualiDecimal)new KualiDecimal(qty).divide((AbstractKualiDecimal)this.getItemQuantity())).multiply((AbstractKualiDecimal)itemTaxAmount);
            outstandingAmount = (KualiDecimal)outstandingAmount.add((AbstractKualiDecimal)outstandingTaxAmount);
        }
        return (KualiDecimal)totalEncumberance.subtract((AbstractKualiDecimal)outstandingAmount);
    }

    public void setOutstandingQuantity() {
    }

    public KualiDecimal getOutstandingQuantity() {
        KualiDecimal outstandingQuantity = this.getItemQuantity() != null ? this.getItemQuantity() : KualiDecimal.ZERO;
        KualiDecimal invoicedQuantity = this.getItemInvoicedTotalQuantity() != null ? this.getItemInvoicedTotalQuantity() : KualiDecimal.ZERO;
        return (KualiDecimal)outstandingQuantity.subtract((AbstractKualiDecimal)invoicedQuantity);
    }

    public boolean isCanInactivateItem() {
        if (this.versionNumber == null) {
            return false;
        }
        return this.versionNumber != null && this.itemActiveIndicator && !this.getPurchaseOrder().getContainsUnpaidPaymentRequestsOrCreditMemos();
    }

    @Override
    public PurApSummaryItem getSummaryItem() {
        if (!this.itemActiveIndicator) {
            return null;
        }
        return super.getSummaryItem();
    }

    public boolean isNewUnorderedItem() {
        return ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).isNewUnorderedItem(this);
    }

    @Override
    public boolean isNewItemForAmendment() {
        return ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).isNewItemForAmendment(this);
    }

    @Override
    public Class getUseTaxClass() {
        return PurchaseOrderItemUseTax.class;
    }
}

