/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.SessionDocument;
import org.kuali.kfs.krad.util.NoteType;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceContact;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceLoadSummary;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoicePostalAddress;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReason;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderView;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceMappingService;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.module.purap.util.PurApRelatedViews;
import org.kuali.kfs.module.purap.util.PurapSearchUtils;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.CampusParameter;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class ElectronicInvoiceRejectDocument
extends FinancialSystemTransactionalDocumentBase
implements SessionDocument {
    private static final Logger LOG = LogManager.getLogger(ElectronicInvoiceRejectDocument.class);
    protected static BigDecimal zero = new BigDecimal(0);
    protected Integer purapDocumentIdentifier;
    protected Integer accountsPayablePurchasingDocumentLinkIdentifier;
    protected Integer invoiceLoadSummaryIdentifier;
    protected Timestamp invoiceProcessTimestamp;
    protected Boolean invoiceFileHeaderTypeIndicator = Boolean.FALSE;
    protected Boolean invoiceFileInformationOnlyIndicator = Boolean.FALSE;
    protected Boolean invoiceFileTaxInLineIndicator = Boolean.FALSE;
    protected Boolean invoiceFileSpecialHandlingInLineIndicator = Boolean.FALSE;
    protected Boolean invoiceFileShippingInLineIndicator = Boolean.FALSE;
    protected Boolean invoiceFileDiscountInLineIndicator = Boolean.FALSE;
    protected String invoiceFileName;
    protected String vendorDunsNumber;
    protected Integer vendorHeaderGeneratedIdentifier;
    protected Integer vendorDetailAssignedIdentifier;
    protected String invoiceFileDate;
    protected String invoiceFileNumber;
    protected String invoiceFilePurposeIdentifier;
    protected String invoiceFileOperationIdentifier;
    protected String invoiceFileDeploymentModeValue;
    protected String invoiceOrderReferenceOrderIdentifier;
    protected String invoiceOrderReferenceDocumentReferencePayloadIdentifier;
    protected String invoiceOrderReferenceDocumentReferenceText;
    protected String invoiceOrderMasterAgreementReferenceIdentifier;
    protected String invoiceOrderMasterAgreementReferenceDate;
    protected String invoiceOrderMasterAgreementInformationIdentifier;
    protected String invoiceOrderMasterAgreementInformationDate;
    protected String invoiceOrderPurchaseOrderIdentifier;
    protected String invoiceOrderPurchaseOrderDate;
    protected String invoiceOrderSupplierOrderInformationIdentifier;
    protected String invoiceShipDate;
    protected String invoiceShipToAddressName;
    protected String invoiceShipToAddressType;
    protected String invoiceShipToAddressLine1;
    protected String invoiceShipToAddressLine2;
    protected String invoiceShipToAddressLine3;
    protected String invoiceShipToAddressCityName;
    protected String invoiceShipToAddressStateCode;
    protected String invoiceShipToAddressPostalCode;
    protected String invoiceShipToAddressCountryCode;
    protected String invoiceShipToAddressCountryName;
    protected String invoiceBillToAddressName;
    protected String invoiceBillToAddressType;
    protected String invoiceBillToAddressLine1;
    protected String invoiceBillToAddressLine2;
    protected String invoiceBillToAddressLine3;
    protected String invoiceBillToAddressCityName;
    protected String invoiceBillToAddressStateCode;
    protected String invoiceBillToAddressPostalCode;
    protected String invoiceBillToAddressCountryCode;
    protected String invoiceBillToAddressCountryName;
    protected String invoiceRemitToAddressName;
    protected String invoiceRemitToAddressType;
    protected String invoiceRemitToAddressLine1;
    protected String invoiceRemitToAddressLine2;
    protected String invoiceRemitToAddressLine3;
    protected String invoiceRemitToAddressCityName;
    protected String invoiceRemitToAddressStateCode;
    protected String invoiceRemitToAddressPostalCode;
    protected String invoiceRemitToAddressCountryCode;
    protected String invoiceRemitToAddressCountryName;
    protected Integer paymentRequestIdentifier;
    protected String invoiceCustomerNumber;
    protected String invoicePurchaseOrderNumber;
    protected Integer purchaseOrderIdentifier;
    protected String purchaseOrderDeliveryCampusCode;
    protected String invoiceItemSubTotalCurrencyCode;
    protected String invoiceItemSpecialHandlingCurrencyCode;
    protected String invoiceItemSpecialHandlingDescription;
    protected String invoiceItemShippingCurrencyCode;
    protected String invoiceItemShippingDescription;
    protected String invoiceItemTaxCurrencyCode;
    protected String invoiceItemTaxDescription;
    protected String invoiceItemGrossCurrencyCode;
    protected String invoiceItemDiscountCurrencyCode;
    protected String invoiceItemNetCurrencyCode;
    protected BigDecimal invoiceItemSubTotalAmount;
    protected BigDecimal invoiceItemSpecialHandlingAmount;
    protected BigDecimal invoiceItemShippingAmount;
    protected BigDecimal invoiceItemTaxAmount;
    protected BigDecimal invoiceItemGrossAmount;
    protected BigDecimal invoiceItemDiscountAmount;
    protected BigDecimal invoiceItemNetAmount;
    protected boolean invoiceNumberAcceptIndicator = false;
    protected boolean invoiceResearchIndicator = false;
    protected Timestamp invoiceFileTimeStampForSearch;
    protected Timestamp accountsPayableApprovalTimestamp;
    protected transient PurApRelatedViews relatedViews;
    protected PurchaseOrderDocument currentPurchaseOrderDocument;
    protected VendorDetail vendorDetail;
    protected ElectronicInvoiceLoadSummary invoiceLoadSummary;
    protected List<ElectronicInvoiceRejectItem> invoiceRejectItems = new ArrayList<ElectronicInvoiceRejectItem>();
    protected List<ElectronicInvoiceRejectReason> invoiceRejectReasons = new ArrayList<ElectronicInvoiceRejectReason>();
    protected boolean isDocumentCreationInProgress = false;
    protected String vendorNumber;
    protected CampusParameter purchaseOrderDeliveryCampus;

    public void setFileLevelData(ElectronicInvoice ei) {
        DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.invoiceProcessTimestamp = dateTimeService.getCurrentTimestamp();
        this.invoiceFileHeaderTypeIndicator = new Boolean(ei.getInvoiceDetailRequestHeader().isHeaderInvoiceIndicator());
        this.invoiceFileInformationOnlyIndicator = new Boolean(ei.getInvoiceDetailRequestHeader().isInformationOnly());
        this.invoiceFileTaxInLineIndicator = new Boolean(ei.getInvoiceDetailRequestHeader().isTaxInLine());
        this.invoiceFileSpecialHandlingInLineIndicator = new Boolean(ei.getInvoiceDetailRequestHeader().isSpecialHandlingInLine());
        this.invoiceFileShippingInLineIndicator = new Boolean(ei.getInvoiceDetailRequestHeader().isShippingInLine());
        this.invoiceFileDiscountInLineIndicator = new Boolean(ei.getInvoiceDetailRequestHeader().isDiscountInLine());
        this.invoiceFileName = ei.getFileName();
        this.vendorDunsNumber = ei.getDunsNumber();
        this.vendorHeaderGeneratedIdentifier = ei.getVendorHeaderID();
        this.vendorDetailAssignedIdentifier = ei.getVendorDetailID();
        this.invoiceFileDate = ei.getInvoiceDateDisplayText();
        this.invoiceFileNumber = ei.getInvoiceDetailRequestHeader().getInvoiceId();
        this.invoiceFilePurposeIdentifier = ei.getInvoiceDetailRequestHeader().getPurpose();
        this.invoiceFileOperationIdentifier = ei.getInvoiceDetailRequestHeader().getOperation();
        this.invoiceFileDeploymentModeValue = ei.getDeploymentMode();
        this.invoiceCustomerNumber = ei.getCustomerNumber();
        for (ElectronicInvoiceRejectReason eirr : ei.getFileRejectReasons()) {
            ElectronicInvoiceRejectReason newReason = new ElectronicInvoiceRejectReason();
            ObjectUtil.buildObject((Object)((Object)newReason), (Object)((Object)eirr));
            this.invoiceRejectReasons.add(newReason);
        }
    }

    public void setInvoiceOrderLevelData(ElectronicInvoice ei, ElectronicInvoiceOrder eio) {
        ElectronicInvoiceContact remitToContact;
        ElectronicInvoicePostalAddress remitToAddress;
        ElectronicInvoiceContact billToContact;
        ElectronicInvoicePostalAddress billToAddress;
        this.invoiceOrderReferenceOrderIdentifier = eio.getOrderReferenceOrderID();
        this.invoiceOrderReferenceDocumentReferencePayloadIdentifier = eio.getOrderReferenceDocumentRefPayloadID();
        this.invoiceOrderReferenceDocumentReferenceText = eio.getOrderReferenceDocumentRef();
        this.invoiceOrderMasterAgreementReferenceIdentifier = eio.getMasterAgreementReferenceID();
        this.invoiceOrderMasterAgreementReferenceDate = ei.getMasterAgreementReferenceDateDisplayText(eio);
        this.invoiceOrderMasterAgreementInformationIdentifier = eio.getMasterAgreementIDInfoID();
        this.invoiceOrderMasterAgreementInformationDate = ei.getMasterAgreementIDInfoDateDisplayText(eio);
        this.invoiceOrderPurchaseOrderIdentifier = eio.getOrderIDInfoID();
        this.invoiceOrderPurchaseOrderDate = ei.getOrderIDInfoDateDisplayText(eio);
        this.invoiceOrderSupplierOrderInformationIdentifier = eio.getSupplierOrderInfoID();
        this.invoiceShipDate = ei.getShippingDateDisplayText(eio);
        ElectronicInvoiceContact shipToContact = ei.getCxmlContact(eio, "shipTo");
        ElectronicInvoicePostalAddress shipToAddress = this.getCxmlPostalAddressByAddressName(shipToContact, ElectronicInvoiceMappingService.CXML_ADDRESS_SHIP_TO_NAME);
        if (shipToAddress != null) {
            this.invoiceShipToAddressName = shipToContact.getName();
            this.invoiceShipToAddressType = shipToAddress.getType();
            this.invoiceShipToAddressLine1 = shipToAddress.getLine1();
            this.invoiceShipToAddressLine2 = shipToAddress.getLine2();
            this.invoiceShipToAddressLine3 = shipToAddress.getLine3();
            this.invoiceShipToAddressCityName = shipToAddress.getCityName();
            this.invoiceShipToAddressStateCode = shipToAddress.getStateCode();
            this.invoiceShipToAddressPostalCode = shipToAddress.getPostalCode();
            this.invoiceShipToAddressCountryCode = shipToAddress.getCountryCode();
            this.invoiceShipToAddressCountryName = shipToAddress.getCountryName();
        }
        if ((billToAddress = this.getCxmlPostalAddressByAddressName(billToContact = ei.getCxmlContact(eio, "billTo"), ElectronicInvoiceMappingService.CXML_ADDRESS_BILL_TO_NAME)) != null) {
            this.invoiceBillToAddressName = billToContact.getName();
            this.invoiceBillToAddressType = billToAddress.getType();
            this.invoiceBillToAddressLine1 = billToAddress.getLine1();
            this.invoiceBillToAddressLine2 = billToAddress.getLine2();
            this.invoiceBillToAddressLine3 = billToAddress.getLine3();
            this.invoiceBillToAddressCityName = billToAddress.getCityName();
            this.invoiceBillToAddressStateCode = billToAddress.getStateCode();
            this.invoiceBillToAddressPostalCode = billToAddress.getPostalCode();
            this.invoiceBillToAddressCountryCode = billToAddress.getCountryCode();
            this.invoiceBillToAddressCountryName = billToAddress.getCountryName();
        }
        if ((remitToAddress = this.getCxmlPostalAddressByAddressName(remitToContact = ei.getCxmlContact(eio, "remitTo"), ElectronicInvoiceMappingService.CXML_ADDRESS_REMIT_TO_NAME)) != null) {
            this.invoiceRemitToAddressName = remitToContact.getName();
            this.invoiceRemitToAddressType = remitToAddress.getType();
            this.invoiceRemitToAddressLine1 = remitToAddress.getLine1();
            this.invoiceRemitToAddressLine2 = remitToAddress.getLine2();
            this.invoiceRemitToAddressLine3 = remitToAddress.getLine3();
            this.invoiceRemitToAddressCityName = remitToAddress.getCityName();
            this.invoiceRemitToAddressStateCode = remitToAddress.getStateCode();
            this.invoiceRemitToAddressPostalCode = remitToAddress.getPostalCode();
            this.invoiceRemitToAddressCountryCode = remitToAddress.getCountryCode();
            this.invoiceRemitToAddressCountryName = remitToAddress.getCountryName();
        }
        this.invoicePurchaseOrderNumber = eio.getInvoicePurchaseOrderID();
        this.purchaseOrderIdentifier = eio.getPurchaseOrderID();
        this.purchaseOrderDeliveryCampusCode = eio.getPurchaseOrderCampusCode();
        try {
            this.invoiceItemSubTotalAmount = ei.getInvoiceSubTotalAmount(eio);
            this.invoiceItemSubTotalCurrencyCode = ei.getInvoiceSubTotalCurrencyIfNotValid(eio);
        }
        catch (Exception e) {
            this.invoiceItemSubTotalAmount = null;
            this.invoiceItemSubTotalCurrencyCode = "INVALID Amount";
        }
        try {
            this.invoiceItemSpecialHandlingAmount = ei.getInvoiceSpecialHandlingAmount(eio);
            this.invoiceItemSpecialHandlingCurrencyCode = ei.getInvoiceSpecialHandlingCurrencyIfNotValid(eio);
        }
        catch (Exception e) {
            this.invoiceItemSpecialHandlingAmount = null;
            this.invoiceItemSpecialHandlingCurrencyCode = "INVALID AMOUNT";
        }
        this.invoiceItemSpecialHandlingDescription = ei.getInvoiceSpecialHandlingDescription(eio);
        try {
            this.invoiceItemShippingAmount = ei.getInvoiceShippingAmount(eio);
            this.invoiceItemShippingCurrencyCode = ei.getInvoiceShippingCurrencyIfNotValid(eio);
        }
        catch (Exception e) {
            this.invoiceItemShippingAmount = null;
            this.invoiceItemShippingCurrencyCode = "INVALID AMOUNT";
        }
        this.invoiceItemShippingDescription = ei.getInvoiceShippingDescription(eio);
        try {
            this.invoiceItemTaxAmount = ei.getInvoiceTaxAmount(eio);
            this.invoiceItemTaxCurrencyCode = ei.getInvoiceTaxCurrencyIfNotValid(eio);
        }
        catch (Exception e) {
            this.invoiceItemTaxAmount = null;
            this.invoiceItemTaxCurrencyCode = "INVALID AMOUNT";
        }
        this.invoiceItemTaxDescription = ei.getInvoiceTaxDescription(eio);
        try {
            this.invoiceItemGrossAmount = ei.getInvoiceGrossAmount(eio);
            this.invoiceItemGrossCurrencyCode = ei.getInvoiceGrossCurrencyIfNotValid(eio);
        }
        catch (Exception e) {
            this.invoiceItemGrossAmount = null;
            this.invoiceItemGrossCurrencyCode = "INVALID AMOUNT";
        }
        try {
            this.invoiceItemDiscountAmount = ei.getInvoiceDiscountAmount(eio);
            this.invoiceItemDiscountCurrencyCode = ei.getInvoiceDiscountCurrencyIfNotValid(eio);
        }
        catch (Exception e) {
            this.invoiceItemDiscountAmount = null;
            this.invoiceItemDiscountCurrencyCode = "INVALID AMOUNT";
        }
        try {
            this.invoiceItemNetAmount = ei.getInvoiceNetAmount(eio);
            this.invoiceItemNetCurrencyCode = ei.getInvoiceNetCurrencyIfNotValid(eio);
        }
        catch (Exception e) {
            this.invoiceItemNetAmount = null;
            this.invoiceItemNetCurrencyCode = "INVALID AMOUNT";
        }
        for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
            ElectronicInvoiceRejectItem eiri = new ElectronicInvoiceRejectItem(this, eii);
            this.invoiceRejectItems.add(eiri);
        }
        for (ElectronicInvoiceRejectReason eirr : eio.getOrderRejectReasons()) {
            eirr.setElectronicInvoiceRejectDocument(this);
            this.invoiceRejectReasons.add(eirr);
        }
    }

    public String getDocumentTitle() {
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(ElectronicInvoiceRejectDocument.class, "OVERRIDE_DOCUMENT_TITLE_IND").booleanValue()) {
            return this.getCustomDocumentTitle();
        }
        return this.buildDocumentTitle(super.getDocumentTitle());
    }

    protected String getCustomDocumentTitle() {
        String poID = StringUtils.isEmpty((CharSequence)this.getInvoicePurchaseOrderNumber()) ? "UNKNOWN" : this.getInvoicePurchaseOrderNumber();
        String researchInd = this.isInvoiceResearchIndicator() ? "Y" : "N";
        VendorDetail vendorDetail = this.getVendorDetail();
        Integer headerId = this.getVendorHeaderGeneratedIdentifier();
        Integer detailId = this.getVendorDetailAssignedIdentifier();
        if (vendorDetail == null && headerId != null && detailId != null) {
            vendorDetail = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDetail(headerId, detailId);
        }
        String vendorName = vendorDetail == null || StringUtils.isEmpty((CharSequence)vendorDetail.getVendorName()) ? "UNKNOWN" : vendorDetail.getVendorName();
        String documentTitle = "Vendor: " + vendorName + " PO: " + poID + " " + researchInd;
        return documentTitle;
    }

    protected String buildDocumentTitle(String title) {
        if (this.getVendorDetail() == null) {
            return title;
        }
        Integer vendorHeaderGeneratedIdentifier = this.getVendorDetail().getVendorHeaderGeneratedIdentifier();
        if (vendorHeaderGeneratedIdentifier != null) {
            VendorService vendorService = (VendorService)SpringContext.getBean(VendorService.class);
            Object[] indicators = new String[2];
            boolean isEmployeeVendor = vendorService.isVendorInstitutionEmployee(vendorHeaderGeneratedIdentifier);
            indicators[0] = isEmployeeVendor ? "E" : "N";
            boolean isVendorForeign = vendorService.isVendorForeign(vendorHeaderGeneratedIdentifier);
            indicators[1] = isVendorForeign ? "A" : "N";
            for (String string : indicators) {
                if ("N".equals(string)) continue;
                String titlePattern = title + " [{0}:{1}]";
                return MessageFormat.format(titlePattern, indicators);
            }
        }
        return title;
    }

    protected ElectronicInvoicePostalAddress getCxmlPostalAddressByAddressName(ElectronicInvoiceContact contact, String addressName) {
        if (contact != null) {
            for (ElectronicInvoicePostalAddress cpa : contact.getPostalAddresses()) {
                if (addressName == null) {
                    return cpa;
                }
                if (!addressName.equalsIgnoreCase(cpa.getName())) continue;
                return cpa;
            }
        }
        return null;
    }

    public KualiDecimal getTotalAmount() {
        KualiDecimal returnValue = new KualiDecimal(zero);
        try {
            for (ElectronicInvoiceRejectItem eiri : this.invoiceRejectItems) {
                BigDecimal toAddAmount1 = eiri.getInvoiceItemSubTotalAmount();
                KualiDecimal toAddAmount = KualiDecimal.ZERO;
                if (toAddAmount1 != null) {
                    toAddAmount = new KualiDecimal(toAddAmount1.setScale(2, 4));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getTotalAmount() setting returnValue with arithmatic => '" + returnValue.doubleValue() + "' + '" + toAddAmount.doubleValue() + "'");
                }
                returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)toAddAmount);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getTotalAmount() returning amount " + returnValue.doubleValue());
            }
            return returnValue;
        }
        catch (NumberFormatException n) {
            LOG.error("getTotalAmount() Error attempting to calculate total amount for invoice with filename " + this.invoiceFileName);
            return new KualiDecimal(zero);
        }
    }

    public void setTotalAmount(KualiDecimal amount) {
    }

    public KualiDecimal getGrandTotalAmount() {
        KualiDecimal returnValue = new KualiDecimal(zero);
        try {
            for (ElectronicInvoiceRejectItem eiri : this.invoiceRejectItems) {
                KualiDecimal toAddAmount = new KualiDecimal(eiri.getInvoiceItemNetAmount());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getTotalAmount() setting returnValue with arithmatic => '" + returnValue.doubleValue() + "' + '" + toAddAmount.doubleValue() + "'");
                }
                returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)toAddAmount);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getTotalAmount() returning amount " + returnValue.doubleValue());
            }
            if (this.getInvoiceItemSpecialHandlingAmount() != null && zero.compareTo(this.getInvoiceItemSpecialHandlingAmount()) != 0) {
                returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)new KualiDecimal(this.getInvoiceItemSpecialHandlingAmount()));
            }
            if (this.getInvoiceItemShippingAmount() != null && zero.compareTo(this.getInvoiceItemShippingAmount()) != 0) {
                returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)new KualiDecimal(this.getInvoiceItemShippingAmount()));
            }
            if (this.getInvoiceItemDiscountAmount() != null && zero.compareTo(this.getInvoiceItemDiscountAmount()) != 0) {
                returnValue = (KualiDecimal)returnValue.subtract((AbstractKualiDecimal)new KualiDecimal(this.getInvoiceItemDiscountAmount()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getGrandTotalAmount() returning amount " + returnValue.doubleValue());
            }
            return returnValue;
        }
        catch (NumberFormatException n) {
            LOG.error("getTotalAmount() Error attempting to calculate total amount for invoice with filename " + this.invoiceFileName);
            return new KualiDecimal(zero);
        }
    }

    public void setGrandTotalAmount(KualiDecimal amount) {
    }

    public Integer getInvoiceLoadSummaryIdentifier() {
        return this.invoiceLoadSummaryIdentifier;
    }

    public void setInvoiceLoadSummaryIdentifier(Integer loadSummaryId) {
        this.invoiceLoadSummaryIdentifier = loadSummaryId;
    }

    public PurchaseOrderDocument getCurrentPurchaseOrderDocument() {
        if (StringUtils.isEmpty((CharSequence)this.getInvoicePurchaseOrderNumber()) || !NumberUtils.isDigits((String)this.getInvoicePurchaseOrderNumber())) {
            this.currentPurchaseOrderDocument = null;
        } else if (this.currentPurchaseOrderDocument == null) {
            this.currentPurchaseOrderDocument = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(new Integer(this.getInvoicePurchaseOrderNumber()));
        } else if (!StringUtils.equals((CharSequence)this.getInvoicePurchaseOrderNumber(), (CharSequence)this.currentPurchaseOrderDocument.getPurapDocumentIdentifier().toString())) {
            this.currentPurchaseOrderDocument = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(new Integer(this.getInvoicePurchaseOrderNumber()));
        }
        return this.currentPurchaseOrderDocument;
    }

    public VendorDetail getVendorDetail() {
        return this.vendorDetail;
    }

    public void setVendorDetail(VendorDetail vendorDetail) {
        this.vendorDetail = vendorDetail;
    }

    public ElectronicInvoiceLoadSummary getInvoiceLoadSummary() {
        return this.invoiceLoadSummary;
    }

    public void setInvoiceLoadSummary(ElectronicInvoiceLoadSummary electronicInvoiceLoadSummary) {
        this.invoiceLoadSummary = electronicInvoiceLoadSummary;
        this.invoiceLoadSummaryIdentifier = electronicInvoiceLoadSummary.getInvoiceLoadSummaryIdentifier();
    }

    public String getInvoiceBillToAddressCityName() {
        return this.invoiceBillToAddressCityName;
    }

    public void setInvoiceBillToAddressCityName(String billToAddressCityName) {
        this.invoiceBillToAddressCityName = billToAddressCityName;
    }

    public String getInvoiceBillToAddressCountryCode() {
        return this.invoiceBillToAddressCountryCode;
    }

    public void setInvoiceBillToAddressCountryCode(String billToAddressCountryCode) {
        this.invoiceBillToAddressCountryCode = billToAddressCountryCode;
    }

    public String getInvoiceBillToAddressCountryName() {
        return this.invoiceBillToAddressCountryName;
    }

    public void setInvoiceBillToAddressCountryName(String billToAddressCountryName) {
        this.invoiceBillToAddressCountryName = billToAddressCountryName;
    }

    public String getInvoiceBillToAddressLine1() {
        return this.invoiceBillToAddressLine1;
    }

    public void setInvoiceBillToAddressLine1(String billToAddressLine1) {
        this.invoiceBillToAddressLine1 = billToAddressLine1;
    }

    public String getInvoiceBillToAddressLine2() {
        return this.invoiceBillToAddressLine2;
    }

    public void setInvoiceBillToAddressLine2(String billToAddressLine2) {
        this.invoiceBillToAddressLine2 = billToAddressLine2;
    }

    public String getInvoiceBillToAddressLine3() {
        return this.invoiceBillToAddressLine3;
    }

    public void setInvoiceBillToAddressLine3(String billToAddressLine3) {
        this.invoiceBillToAddressLine3 = billToAddressLine3;
    }

    public String getInvoiceBillToAddressName() {
        return this.invoiceBillToAddressName;
    }

    public void setInvoiceBillToAddressName(String billToAddressName) {
        this.invoiceBillToAddressName = billToAddressName;
    }

    public String getInvoiceBillToAddressPostalCode() {
        return this.invoiceBillToAddressPostalCode;
    }

    public void setInvoiceBillToAddressPostalCode(String billToAddressPostalCode) {
        this.invoiceBillToAddressPostalCode = billToAddressPostalCode;
    }

    public String getInvoiceBillToAddressStateCode() {
        return this.invoiceBillToAddressStateCode;
    }

    public void setInvoiceBillToAddressStateCode(String billToAddressStateCode) {
        this.invoiceBillToAddressStateCode = billToAddressStateCode;
    }

    public String getInvoiceBillToAddressType() {
        return this.invoiceBillToAddressType;
    }

    public void setInvoiceBillToAddressType(String billToAddressType) {
        this.invoiceBillToAddressType = billToAddressType;
    }

    public String getInvoiceFileDeploymentModeValue() {
        return this.invoiceFileDeploymentModeValue;
    }

    public void setInvoiceFileDeploymentModeValue(String deploymentMode) {
        this.invoiceFileDeploymentModeValue = deploymentMode;
    }

    public List<ElectronicInvoiceRejectItem> getInvoiceRejectItems() {
        return this.invoiceRejectItems;
    }

    public void setInvoiceRejectItems(List<ElectronicInvoiceRejectItem> electronicInvoiceRejectItems) {
        this.invoiceRejectItems = electronicInvoiceRejectItems;
    }

    public ElectronicInvoiceRejectItem getInvoiceRejectItem(int index) {
        while (this.getInvoiceRejectItems().size() <= index) {
            this.getInvoiceRejectItems().add(new ElectronicInvoiceRejectItem());
        }
        return this.getInvoiceRejectItems().get(index);
    }

    public List<ElectronicInvoiceRejectReason> getInvoiceRejectReasons() {
        return this.invoiceRejectReasons;
    }

    public void setInvoiceRejectReasons(List<ElectronicInvoiceRejectReason> electronicInvoiceRejectReasons) {
        this.invoiceRejectReasons = electronicInvoiceRejectReasons;
    }

    public ElectronicInvoiceRejectReason getInvoiceRejectReason(int index) {
        while (this.getInvoiceRejectReasons().size() <= index) {
            this.getInvoiceRejectReasons().add(new ElectronicInvoiceRejectReason());
        }
        return this.getInvoiceRejectReasons().get(index);
    }

    public Integer getPaymentRequestIdentifier() {
        return this.paymentRequestIdentifier;
    }

    public void setPaymentRequestIdentifier(Integer paymentRequestIdentifier) {
        this.paymentRequestIdentifier = paymentRequestIdentifier;
    }

    public String getPurchaseOrderDeliveryCampusCode() {
        return this.purchaseOrderDeliveryCampusCode;
    }

    public void setPurchaseOrderDeliveryCampusCode(String poDeliveryCampusCode) {
        this.purchaseOrderDeliveryCampusCode = poDeliveryCampusCode;
    }

    public Integer getPurchaseOrderIdentifier() {
        return this.purchaseOrderIdentifier;
    }

    public void setPurchaseOrderIdentifier(Integer purchaseOrderId) {
        this.purchaseOrderIdentifier = purchaseOrderId;
    }

    public Boolean getInvoiceFileDiscountInLineIndicator() {
        return this.invoiceFileDiscountInLineIndicator;
    }

    public Boolean isInvoiceFileDiscountInLineIndicator() {
        return this.invoiceFileDiscountInLineIndicator;
    }

    public void setInvoiceFileDiscountInLineIndicator(Boolean fileDiscountInLineIndicator) {
        this.invoiceFileDiscountInLineIndicator = fileDiscountInLineIndicator;
    }

    public Boolean getInvoiceFileHeaderTypeIndicator() {
        return this.invoiceFileHeaderTypeIndicator;
    }

    public Boolean isInvoiceFileHeaderTypeIndicator() {
        return this.invoiceFileHeaderTypeIndicator;
    }

    public void setInvoiceFileHeaderTypeIndicator(Boolean fileHeaderTypeIndicator) {
        this.invoiceFileHeaderTypeIndicator = fileHeaderTypeIndicator;
    }

    public Boolean getInvoiceFileInformationOnlyIndicator() {
        return this.invoiceFileInformationOnlyIndicator;
    }

    public Boolean isInvoiceFileInformationOnlyIndicator() {
        return this.invoiceFileInformationOnlyIndicator;
    }

    public void setInvoiceFileInformationOnlyIndicator(Boolean fileInformationOnlyIndicator) {
        this.invoiceFileInformationOnlyIndicator = fileInformationOnlyIndicator;
    }

    public String getInvoiceFileOperationIdentifier() {
        return this.invoiceFileOperationIdentifier;
    }

    public void setInvoiceFileOperationIdentifier(String fileOperationId) {
        this.invoiceFileOperationIdentifier = fileOperationId;
    }

    public String getInvoiceFilePurposeIdentifier() {
        return this.invoiceFilePurposeIdentifier;
    }

    public void setInvoiceFilePurposeIdentifier(String filePurposeId) {
        this.invoiceFilePurposeIdentifier = filePurposeId;
    }

    public Boolean getInvoiceFileShippingInLineIndicator() {
        return this.invoiceFileShippingInLineIndicator;
    }

    public Boolean isInvoiceFileShippingInLineIndicator() {
        return this.invoiceFileShippingInLineIndicator;
    }

    public void setInvoiceFileShippingInLineIndicator(Boolean fileShippingInLineIndicator) {
        this.invoiceFileShippingInLineIndicator = fileShippingInLineIndicator;
    }

    public Boolean getInvoiceFileSpecialHandlingInLineIndicator() {
        return this.invoiceFileSpecialHandlingInLineIndicator;
    }

    public Boolean isInvoiceFileSpecialHandlingInLineIndicator() {
        return this.invoiceFileSpecialHandlingInLineIndicator;
    }

    public void setInvoiceFileSpecialHandlingInLineIndicator(Boolean fileSpecHandlingInLineIndicator) {
        this.invoiceFileSpecialHandlingInLineIndicator = fileSpecHandlingInLineIndicator;
    }

    public Boolean getInvoiceFileTaxInLineIndicator() {
        return this.invoiceFileTaxInLineIndicator;
    }

    public Boolean isInvoiceFileTaxInLineIndicator() {
        return this.invoiceFileTaxInLineIndicator;
    }

    public void setInvoiceFileTaxInLineIndicator(Boolean fileTaxInLineIndicator) {
        this.invoiceFileTaxInLineIndicator = fileTaxInLineIndicator;
    }

    public Integer getPurapDocumentIdentifier() {
        return this.purapDocumentIdentifier;
    }

    public void setPurapDocumentIdentifier(Integer id) {
        this.purapDocumentIdentifier = id;
    }

    public Integer getAccountsPayablePurchasingDocumentLinkIdentifier() {
        return this.accountsPayablePurchasingDocumentLinkIdentifier;
    }

    public void setAccountsPayablePurchasingDocumentLinkIdentifier(Integer accountsPayablePurchasingDocumentLinkIdentifier) {
        this.accountsPayablePurchasingDocumentLinkIdentifier = accountsPayablePurchasingDocumentLinkIdentifier;
    }

    public String getInvoiceCustomerNumber() {
        return this.invoiceCustomerNumber;
    }

    public void setInvoiceCustomerNumber(String invoiceCustomerNumber) {
        this.invoiceCustomerNumber = invoiceCustomerNumber;
    }

    public String getInvoiceFileDate() {
        return this.invoiceFileDate;
    }

    public void setInvoiceFileDate(String invoiceDate) {
        this.invoiceFileDate = invoiceDate;
    }

    public BigDecimal getInvoiceItemDiscountAmount() {
        if (this.isInvoiceFileDiscountInLineIndicator().booleanValue()) {
            BigDecimal returnValue = zero;
            try {
                for (ElectronicInvoiceRejectItem eiri : this.invoiceRejectItems) {
                    BigDecimal toAddAmount = eiri.getInvoiceItemDiscountAmount();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getTotalAmount() setting returnValue with arithmatic => '" + returnValue.doubleValue() + "' + '" + toAddAmount.doubleValue() + "'");
                    }
                    returnValue = returnValue.add(toAddAmount);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getTotalAmount() returning amount " + returnValue.doubleValue());
                }
                return returnValue;
            }
            catch (NumberFormatException n) {
                LOG.error("getTotalAmount() Error attempting to calculate total amount for invoice with filename " + this.invoiceFileName);
                return zero;
            }
        }
        return this.invoiceItemDiscountAmount;
    }

    public void setInvoiceItemDiscountAmount(BigDecimal invoiceDiscountAmount) {
        this.invoiceItemDiscountAmount = invoiceDiscountAmount;
    }

    public String getInvoiceItemDiscountCurrencyCode() {
        return this.invoiceItemDiscountCurrencyCode;
    }

    public void setInvoiceItemDiscountCurrencyCode(String invoiceDiscountAmountCurrency) {
        this.invoiceItemDiscountCurrencyCode = invoiceDiscountAmountCurrency;
    }

    public String getInvoiceFileName() {
        return this.invoiceFileName;
    }

    public void setInvoiceFileName(String invoiceFileName) {
        this.invoiceFileName = invoiceFileName;
    }

    public BigDecimal getInvoiceItemGrossAmount() {
        return this.invoiceItemGrossAmount;
    }

    public void setInvoiceItemGrossAmount(BigDecimal invoiceGrossAmount) {
        this.invoiceItemGrossAmount = invoiceGrossAmount;
    }

    public String getInvoiceItemGrossCurrencyCode() {
        return this.invoiceItemGrossCurrencyCode;
    }

    public void setInvoiceItemGrossCurrencyCode(String invoiceGrossAmountCurrency) {
        this.invoiceItemGrossCurrencyCode = invoiceGrossAmountCurrency;
    }

    public BigDecimal getInvoiceItemNetAmount() {
        return this.invoiceItemNetAmount;
    }

    public void setInvoiceItemNetAmount(BigDecimal invoiceNetAmount) {
        this.invoiceItemNetAmount = invoiceNetAmount;
    }

    public boolean isInvoiceNumberAcceptIndicator() {
        return this.invoiceNumberAcceptIndicator;
    }

    public void setInvoiceNumberAcceptIndicator(boolean invoiceNumberAcceptIndicator) {
        this.invoiceNumberAcceptIndicator = invoiceNumberAcceptIndicator;
    }

    public boolean isInvoiceResearchIndicator() {
        return this.invoiceResearchIndicator;
    }

    public boolean getInvoiceResearchIndicator() {
        return this.invoiceResearchIndicator;
    }

    public void setInvoiceResearchIndicator(boolean invoiceResearchIndicator) {
        this.invoiceResearchIndicator = invoiceResearchIndicator;
    }

    public Timestamp getAccountsPayableApprovalTimestamp() {
        return this.accountsPayableApprovalTimestamp;
    }

    public void setAccountsPayableApprovalTimestamp(Timestamp accountsPayableApprovalTimestamp) {
        this.accountsPayableApprovalTimestamp = accountsPayableApprovalTimestamp;
    }

    public String getInvoiceItemNetCurrencyCode() {
        return this.invoiceItemNetCurrencyCode;
    }

    public void setInvoiceItemNetCurrencyCode(String invoiceNetAmountCurrency) {
        this.invoiceItemNetCurrencyCode = invoiceNetAmountCurrency;
    }

    public String getInvoiceFileNumber() {
        return this.invoiceFileNumber;
    }

    public void setInvoiceFileNumber(String invoiceNumber) {
        this.invoiceFileNumber = invoiceNumber;
    }

    public String getInvoiceOrderPurchaseOrderDate() {
        return this.invoiceOrderPurchaseOrderDate;
    }

    public void setInvoiceOrderPurchaseOrderDate(String invoiceOrderDate) {
        this.invoiceOrderPurchaseOrderDate = invoiceOrderDate;
    }

    public String getInvoiceOrderPurchaseOrderIdentifier() {
        return this.invoiceOrderPurchaseOrderIdentifier;
    }

    public void setInvoiceOrderPurchaseOrderIdentifier(String invoiceOrderId) {
        this.invoiceOrderPurchaseOrderIdentifier = invoiceOrderId;
    }

    public Timestamp getInvoiceProcessTimestamp() {
        return this.invoiceProcessTimestamp;
    }

    public void setInvoiceProcessTimestamp(Timestamp invoiceProcessTimestamp) {
        this.invoiceProcessTimestamp = invoiceProcessTimestamp;
    }

    public String getInvoicePurchaseOrderNumber() {
        return this.invoicePurchaseOrderNumber;
    }

    public void setInvoicePurchaseOrderNumber(String invoicePurchaseOrderId) {
        this.invoicePurchaseOrderNumber = invoicePurchaseOrderId;
    }

    public String getInvoiceShipDate() {
        return this.invoiceShipDate;
    }

    public void setInvoiceShipDate(String invoiceShipDate) {
        this.invoiceShipDate = invoiceShipDate;
    }

    public BigDecimal getInvoiceItemShippingAmount() {
        if (this.isInvoiceFileShippingInLineIndicator().booleanValue()) {
            BigDecimal returnValue = zero;
            try {
                for (ElectronicInvoiceRejectItem eiri : this.invoiceRejectItems) {
                    BigDecimal toAddAmount = eiri.getInvoiceItemShippingAmount();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getTotalAmount() setting returnValue with arithmatic => '" + returnValue.doubleValue() + "' + '" + toAddAmount.doubleValue() + "'");
                    }
                    returnValue = returnValue.add(toAddAmount);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getTotalAmount() returning amount " + returnValue.doubleValue());
                }
                return returnValue;
            }
            catch (NumberFormatException n) {
                LOG.error("getTotalAmount() Error attempting to calculate total amount for invoice with filename " + this.invoiceFileName);
                return zero;
            }
        }
        return this.invoiceItemShippingAmount;
    }

    public void setInvoiceItemShippingAmount(BigDecimal invoiceShippingAmount) {
        this.invoiceItemShippingAmount = invoiceShippingAmount;
    }

    public String getInvoiceItemShippingCurrencyCode() {
        return this.invoiceItemShippingCurrencyCode;
    }

    public void setInvoiceItemShippingCurrencyCode(String invoiceShippingAmountCurrency) {
        this.invoiceItemShippingCurrencyCode = invoiceShippingAmountCurrency;
    }

    public String getInvoiceItemShippingDescription() {
        return this.invoiceItemShippingDescription;
    }

    public void setInvoiceItemShippingDescription(String invoiceShippingDescription) {
        this.invoiceItemShippingDescription = invoiceShippingDescription;
    }

    public BigDecimal getInvoiceItemSpecialHandlingAmount() {
        if (this.isInvoiceFileSpecialHandlingInLineIndicator().booleanValue()) {
            BigDecimal returnValue = zero;
            try {
                for (ElectronicInvoiceRejectItem eiri : this.invoiceRejectItems) {
                    BigDecimal toAddAmount = eiri.getInvoiceItemSpecialHandlingAmount();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getTotalAmount() setting returnValue with arithmatic => '" + returnValue.doubleValue() + "' + '" + toAddAmount.doubleValue() + "'");
                    }
                    returnValue = returnValue.add(toAddAmount);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getTotalAmount() returning amount " + returnValue.doubleValue());
                }
                return returnValue;
            }
            catch (NumberFormatException n) {
                LOG.error("getTotalAmount() Error attempting to calculate total amount for invoice with filename " + this.invoiceFileName);
                return zero;
            }
        }
        return this.invoiceItemSpecialHandlingAmount;
    }

    public void setInvoiceItemSpecialHandlingAmount(BigDecimal invoiceSpecialHandlingAmount) {
        this.invoiceItemSpecialHandlingAmount = invoiceSpecialHandlingAmount;
    }

    public String getInvoiceItemSpecialHandlingCurrencyCode() {
        return this.invoiceItemSpecialHandlingCurrencyCode;
    }

    public void setInvoiceItemSpecialHandlingCurrencyCode(String invoiceSpecialHandlingAmountCurrency) {
        this.invoiceItemSpecialHandlingCurrencyCode = invoiceSpecialHandlingAmountCurrency;
    }

    public String getInvoiceItemSpecialHandlingDescription() {
        return this.invoiceItemSpecialHandlingDescription;
    }

    public void setInvoiceItemSpecialHandlingDescription(String invoiceSpecialHandlingDescription) {
        this.invoiceItemSpecialHandlingDescription = invoiceSpecialHandlingDescription;
    }

    public BigDecimal getInvoiceItemSubTotalAmount() {
        return this.invoiceItemSubTotalAmount;
    }

    public void setInvoiceItemSubTotalAmount(BigDecimal invoiceSubTotalAmount) {
        this.invoiceItemSubTotalAmount = invoiceSubTotalAmount;
    }

    public String getInvoiceItemSubTotalCurrencyCode() {
        return this.invoiceItemSubTotalCurrencyCode;
    }

    public void setInvoiceItemSubTotalCurrencyCode(String invoiceSubTotalAmountCurrency) {
        this.invoiceItemSubTotalCurrencyCode = invoiceSubTotalAmountCurrency;
    }

    public BigDecimal getInvoiceItemTaxAmount() {
        BigDecimal returnValue = zero;
        boolean enableSalesTaxInd = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND");
        try {
            if (enableSalesTaxInd) {
                for (ElectronicInvoiceRejectItem eiri : this.invoiceRejectItems) {
                    BigDecimal toAddAmount = eiri.getInvoiceItemTaxAmount();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getTotalAmount() setting returnValue with arithmatic => '" + returnValue.doubleValue() + "' + '" + toAddAmount.doubleValue() + "'");
                    }
                    returnValue = returnValue.add(toAddAmount);
                }
            } else {
                returnValue = returnValue.add(this.invoiceItemTaxAmount);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getTotalAmount() returning amount " + returnValue.doubleValue());
            }
            return returnValue;
        }
        catch (NumberFormatException n) {
            LOG.error("getTotalAmount() Error attempting to calculate total amount for invoice with filename " + this.invoiceFileName);
            return zero;
        }
    }

    public void setInvoiceItemTaxAmount(BigDecimal invoiceTaxAmount) {
        this.invoiceItemTaxAmount = invoiceTaxAmount;
    }

    public String getInvoiceItemTaxCurrencyCode() {
        return this.invoiceItemTaxCurrencyCode;
    }

    public void setInvoiceItemTaxCurrencyCode(String invoiceTaxAmountCurrency) {
        this.invoiceItemTaxCurrencyCode = invoiceTaxAmountCurrency;
    }

    public String getInvoiceItemTaxDescription() {
        return this.invoiceItemTaxDescription;
    }

    public void setInvoiceItemTaxDescription(String invoiceTaxDescription) {
        this.invoiceItemTaxDescription = invoiceTaxDescription;
    }

    public String getInvoiceOrderMasterAgreementInformationDate() {
        return this.invoiceOrderMasterAgreementInformationDate;
    }

    public void setInvoiceOrderMasterAgreementInformationDate(String masterAgreementInfoDate) {
        this.invoiceOrderMasterAgreementInformationDate = masterAgreementInfoDate;
    }

    public String getInvoiceOrderMasterAgreementInformationIdentifier() {
        return this.invoiceOrderMasterAgreementInformationIdentifier;
    }

    public void setInvoiceOrderMasterAgreementInformationIdentifier(String masterAgreementInfoId) {
        this.invoiceOrderMasterAgreementInformationIdentifier = masterAgreementInfoId;
    }

    public String getInvoiceOrderMasterAgreementReferenceDate() {
        return this.invoiceOrderMasterAgreementReferenceDate;
    }

    public void setInvoiceOrderMasterAgreementReferenceDate(String masterAgreementReferenceDate) {
        this.invoiceOrderMasterAgreementReferenceDate = masterAgreementReferenceDate;
    }

    public String getInvoiceOrderMasterAgreementReferenceIdentifier() {
        return this.invoiceOrderMasterAgreementReferenceIdentifier;
    }

    public void setInvoiceOrderMasterAgreementReferenceIdentifier(String masterAgreementReferenceId) {
        this.invoiceOrderMasterAgreementReferenceIdentifier = masterAgreementReferenceId;
    }

    public String getInvoiceOrderReferenceDocumentReferencePayloadIdentifier() {
        return this.invoiceOrderReferenceDocumentReferencePayloadIdentifier;
    }

    public void setInvoiceOrderReferenceDocumentReferencePayloadIdentifier(String referenceDocumentRefPayloadId) {
        this.invoiceOrderReferenceDocumentReferencePayloadIdentifier = referenceDocumentRefPayloadId;
    }

    public String getInvoiceOrderReferenceDocumentReferenceText() {
        return this.invoiceOrderReferenceDocumentReferenceText;
    }

    public void setInvoiceOrderReferenceDocumentReferenceText(String referenceDocumentRefText) {
        this.invoiceOrderReferenceDocumentReferenceText = referenceDocumentRefText;
    }

    public String getInvoiceOrderReferenceOrderIdentifier() {
        return this.invoiceOrderReferenceOrderIdentifier;
    }

    public void setInvoiceOrderReferenceOrderIdentifier(String referenceOrderId) {
        this.invoiceOrderReferenceOrderIdentifier = referenceOrderId;
    }

    public String getInvoiceRemitToAddressCityName() {
        return this.invoiceRemitToAddressCityName;
    }

    public void setInvoiceRemitToAddressCityName(String remitToAddressCityName) {
        this.invoiceRemitToAddressCityName = remitToAddressCityName;
    }

    public String getInvoiceRemitToAddressCountryCode() {
        return this.invoiceRemitToAddressCountryCode;
    }

    public void setInvoiceRemitToAddressCountryCode(String remitToAddressCountryCode) {
        this.invoiceRemitToAddressCountryCode = remitToAddressCountryCode;
    }

    public String getInvoiceRemitToAddressCountryName() {
        return this.invoiceRemitToAddressCountryName;
    }

    public void setInvoiceRemitToAddressCountryName(String remitToAddressCountryName) {
        this.invoiceRemitToAddressCountryName = remitToAddressCountryName;
    }

    public String getInvoiceRemitToAddressLine1() {
        return this.invoiceRemitToAddressLine1;
    }

    public void setInvoiceRemitToAddressLine1(String remitToAddressLine1) {
        this.invoiceRemitToAddressLine1 = remitToAddressLine1;
    }

    public String getInvoiceRemitToAddressLine2() {
        return this.invoiceRemitToAddressLine2;
    }

    public void setInvoiceRemitToAddressLine2(String remitToAddressLine2) {
        this.invoiceRemitToAddressLine2 = remitToAddressLine2;
    }

    public String getInvoiceRemitToAddressLine3() {
        return this.invoiceRemitToAddressLine3;
    }

    public void setInvoiceRemitToAddressLine3(String remitToAddressLine3) {
        this.invoiceRemitToAddressLine3 = remitToAddressLine3;
    }

    public String getInvoiceRemitToAddressName() {
        return this.invoiceRemitToAddressName;
    }

    public void setInvoiceRemitToAddressName(String remitToAddressName) {
        this.invoiceRemitToAddressName = remitToAddressName;
    }

    public String getInvoiceRemitToAddressPostalCode() {
        return this.invoiceRemitToAddressPostalCode;
    }

    public void setInvoiceRemitToAddressPostalCode(String remitToAddressPostalCode) {
        this.invoiceRemitToAddressPostalCode = remitToAddressPostalCode;
    }

    public String getInvoiceRemitToAddressStateCode() {
        return this.invoiceRemitToAddressStateCode;
    }

    public void setInvoiceRemitToAddressStateCode(String remitToAddressStateCode) {
        this.invoiceRemitToAddressStateCode = remitToAddressStateCode;
    }

    public String getInvoiceRemitToAddressType() {
        return this.invoiceRemitToAddressType;
    }

    public void setInvoiceRemitToAddressType(String remitToAddressType) {
        this.invoiceRemitToAddressType = remitToAddressType;
    }

    public String getInvoiceShipToAddressCityName() {
        return this.invoiceShipToAddressCityName;
    }

    public void setInvoiceShipToAddressCityName(String shipToAddressCityName) {
        this.invoiceShipToAddressCityName = shipToAddressCityName;
    }

    public String getInvoiceShipToAddressCountryCode() {
        return this.invoiceShipToAddressCountryCode;
    }

    public void setInvoiceShipToAddressCountryCode(String shipToAddressCountryCode) {
        this.invoiceShipToAddressCountryCode = shipToAddressCountryCode;
    }

    public String getInvoiceShipToAddressCountryName() {
        return this.invoiceShipToAddressCountryName;
    }

    public void setInvoiceShipToAddressCountryName(String shipToAddressCountryName) {
        this.invoiceShipToAddressCountryName = shipToAddressCountryName;
    }

    public String getInvoiceShipToAddressLine1() {
        return this.invoiceShipToAddressLine1;
    }

    public void setInvoiceShipToAddressLine1(String shipToAddressLine1) {
        this.invoiceShipToAddressLine1 = shipToAddressLine1;
    }

    public String getInvoiceShipToAddressLine2() {
        return this.invoiceShipToAddressLine2;
    }

    public void setInvoiceShipToAddressLine2(String shipToAddressLine2) {
        this.invoiceShipToAddressLine2 = shipToAddressLine2;
    }

    public String getInvoiceShipToAddressLine3() {
        return this.invoiceShipToAddressLine3;
    }

    public void setInvoiceShipToAddressLine3(String shipToAddressLine3) {
        this.invoiceShipToAddressLine3 = shipToAddressLine3;
    }

    public String getInvoiceShipToAddressName() {
        return this.invoiceShipToAddressName;
    }

    public void setInvoiceShipToAddressName(String shipToAddressName) {
        this.invoiceShipToAddressName = shipToAddressName;
    }

    public String getInvoiceShipToAddressPostalCode() {
        return this.invoiceShipToAddressPostalCode;
    }

    public void setInvoiceShipToAddressPostalCode(String shipToAddressPostalCode) {
        this.invoiceShipToAddressPostalCode = shipToAddressPostalCode;
    }

    public String getInvoiceShipToAddressStateCode() {
        return this.invoiceShipToAddressStateCode;
    }

    public void setInvoiceShipToAddressStateCode(String shipToAddressStateCode) {
        this.invoiceShipToAddressStateCode = shipToAddressStateCode;
    }

    public String getInvoiceShipToAddressType() {
        return this.invoiceShipToAddressType;
    }

    public void setInvoiceShipToAddressType(String shipToAddressType) {
        this.invoiceShipToAddressType = shipToAddressType;
    }

    public String getInvoiceOrderSupplierOrderInformationIdentifier() {
        return this.invoiceOrderSupplierOrderInformationIdentifier;
    }

    public void setInvoiceOrderSupplierOrderInformationIdentifier(String supplierOrderInfoId) {
        this.invoiceOrderSupplierOrderInformationIdentifier = supplierOrderInfoId;
    }

    public Integer getVendorDetailAssignedIdentifier() {
        return this.vendorDetailAssignedIdentifier;
    }

    public void setVendorDetailAssignedIdentifier(Integer vendorDetailID) {
        this.vendorDetailAssignedIdentifier = vendorDetailID;
    }

    public String getVendorDunsNumber() {
        return this.vendorDunsNumber;
    }

    public void setVendorDunsNumber(String vendorDunsNumber) {
        this.vendorDunsNumber = vendorDunsNumber;
    }

    public Integer getVendorHeaderGeneratedIdentifier() {
        return this.vendorHeaderGeneratedIdentifier;
    }

    public void setVendorHeaderGeneratedIdentifier(Integer vendorHeaderID) {
        this.vendorHeaderGeneratedIdentifier = vendorHeaderID;
    }

    public void addRejectItem(ElectronicInvoiceRejectItem item) {
        item.setPurapDocumentIdentifier(this.purapDocumentIdentifier);
        item.setElectronicInvoiceRejectDocument(this);
        this.invoiceRejectItems.add(item);
    }

    public void addRejectReason(ElectronicInvoiceRejectReason reason) {
        reason.setPurapDocumentIdentifier(this.purapDocumentIdentifier);
        reason.setElectronicInvoiceRejectDocument(this);
        this.invoiceRejectReasons.add(reason);
    }

    public PurApRelatedViews getRelatedViews() {
        if (this.relatedViews == null) {
            this.relatedViews = new PurApRelatedViews(this.documentNumber, this.accountsPayablePurchasingDocumentLinkIdentifier);
        }
        return this.relatedViews;
    }

    public void setRelatedViews(PurApRelatedViews relatedViews) {
        this.relatedViews = relatedViews;
    }

    public boolean isBoNotesSupport() {
        return true;
    }

    public boolean isDocumentCreationInProgress() {
        return this.isDocumentCreationInProgress;
    }

    public void setDocumentCreationInProgress(boolean isDocumentCreationInProgress) {
        this.isDocumentCreationInProgress = isDocumentCreationInProgress;
    }

    public String getVendorNumber() {
        if (StringUtils.isNotEmpty((CharSequence)this.vendorNumber)) {
            return this.vendorNumber;
        }
        if (ObjectUtils.isNotNull((Object)this.vendorDetail)) {
            return this.vendorDetail.getVendorNumber();
        }
        if (this.getVendorHeaderGeneratedIdentifier() != null && this.getVendorDetailAssignedIdentifier() != null) {
            VendorDetail vendorDetail = new VendorDetail();
            vendorDetail.setVendorHeaderGeneratedIdentifier(this.getVendorHeaderGeneratedIdentifier());
            vendorDetail.setVendorDetailAssignedIdentifier(this.getVendorDetailAssignedIdentifier());
            return vendorDetail.getVendorNumber();
        }
        return "";
    }

    public void setVendorNumber(String vendorNumber) {
        this.vendorNumber = vendorNumber;
    }

    public boolean getIsATypeOfPurAPRecDoc() {
        return false;
    }

    public boolean getIsATypeOfPurDoc() {
        return false;
    }

    public boolean getIsATypeOfPODoc() {
        return false;
    }

    public boolean getIsPODoc() {
        return false;
    }

    public boolean getIsReqsDoc() {
        return false;
    }

    public boolean isInvoiceResearchIndicatorForSearching() {
        return this.invoiceResearchIndicator;
    }

    public String getInvoiceResearchIndicatorForResult() {
        if (this.isInvoiceResearchIndicator()) {
            return "Yes";
        }
        return "No";
    }

    public String getPurchaseOrderDeliveryCampusCodeForSearch() {
        return this.getPurchaseOrderDeliveryCampusCode();
    }

    public CampusParameter getPurchaseOrderDeliveryCampus() {
        return this.purchaseOrderDeliveryCampus;
    }

    public java.util.Date getAccountsPayableApprovalDateForSearch() {
        if (this.getAccountsPayableApprovalTimestamp() != null) {
            DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
            try {
                return dateTimeService.convertToSqlDate(this.getAccountsPayableApprovalTimestamp());
            }
            catch (ParseException e) {
                throw new RuntimeException("ParseException thrown when trying to convert Timestamp to sqlDate.", e);
            }
        }
        return null;
    }

    public Timestamp getInvoiceFileTimeStampForSearch() {
        Date invoiceDate = ElectronicInvoiceUtils.getDate(this.getInvoiceFileDate());
        if (invoiceDate != null) {
            return new Timestamp(invoiceDate.getTime());
        }
        return null;
    }

    public void setInvoiceFileTimeStampForSearch(Timestamp invoiceFileTimeStamp) {
    }

    public String getWorkflowStatusForResult() {
        return PurapSearchUtils.getWorkFlowStatusString(this.getDocumentHeader());
    }

    public boolean getNeedWarningRelatedPOs() {
        List<PurchaseOrderView> poViews = this.getRelatedViews().getRelatedPurchaseOrderViews();
        for (PurchaseOrderView poView : poViews) {
            if (!poView.getNeedWarning()) continue;
            return true;
        }
        return false;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        LOG.debug("doRouteStatusChange() started");
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isApproved()) {
            this.setAccountsPayableApprovalTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
        }
    }

    public List getNotes() {
        List notes = super.getNotes();
        if (!StringUtils.isBlank((CharSequence)this.getObjectId())) {
            for (Note note : notes) {
                if (StringUtils.isBlank((CharSequence)note.getObjectId())) continue;
                note.refresh();
            }
        }
        return super.getNotes();
    }

    public NoteType getNoteType() {
        return NoteType.BUSINESS_OBJECT;
    }
}

