/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapGeneralLedgerService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class PurchaseOrderReopenDocument
extends PurchaseOrderDocument {
    private static final Logger LOG = LogManager.getLogger(PurchaseOrderReopenDocument.class);

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        LOG.info("prepareForSave(KualiDocumentEvent) do not create gl entries");
        this.setSourceAccountingLines(new ArrayList());
        this.setGeneralLedgerPendingEntries(new ArrayList());
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        try {
            if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed()) {
                ((PurapGeneralLedgerService)SpringContext.getBean(PurapGeneralLedgerService.class)).generateEntriesReopenPurchaseOrder(this);
                ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForApprovedPODocuments(this);
                this.updateAndSaveAppDocStatus("Open");
            } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isDisapproved()) {
                ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForDisapprovedReopenPODocuments(this);
                try {
                    String nodeName = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).getCurrentRouteLevelName(this.getFinancialSystemDocumentHeader().getWorkflowDocument());
                    String reqStatus = PurapConstants.PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses().get(nodeName);
                    this.updateAndSaveAppDocStatus(reqStatus);
                }
                catch (WorkflowException e) {
                    this.logAndThrowRuntimeException("Error saving routing data while saving App Doc Status " + this.getDocumentNumber(), (Exception)((Object)e));
                }
            } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isCanceled()) {
                ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForCancelledReopenPODocuments(this);
                this.updateAndSaveAppDocStatus("Cancelled");
            }
        }
        catch (WorkflowException e) {
            this.logAndThrowRuntimeException("Error saving routing data while saving document with id " + this.getDocumentNumber(), (Exception)((Object)e));
        }
    }

    @Override
    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        super.customizeExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
        ((PurapGeneralLedgerService)SpringContext.getBean(PurapGeneralLedgerService.class)).customizeGeneralLedgerPendingEntry(this, (AccountingLine)postable, explicitEntry, this.getPurapDocumentIdentifier(), "D", "PO", true);
        explicitEntry.setFinancialDocumentTypeCode("POR");
        explicitEntry.setFinancialDocumentApprovedCode("A");
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        ArrayList<GeneralLedgerPendingEntrySourceDetail> accountingLines = new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
        if (this.getGlOnlySourceAccountingLines() != null) {
            Iterator<SourceAccountingLine> iter = this.getGlOnlySourceAccountingLines().iterator();
            while (iter.hasNext()) {
                accountingLines.add((GeneralLedgerPendingEntrySourceDetail)iter.next());
            }
        }
        return accountingLines;
    }
}

