/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.ReceivingAddress;
import org.kuali.kfs.module.purap.document.service.ReceivingAddressService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.kew.api.WorkflowDocument;

public class ReceivingAddressMaintainableImpl
extends FinancialSystemMaintainable {
    private static final Logger LOG = LogManager.getLogger(ReceivingAddressMaintainableImpl.class);

    public List<MaintenanceLock> generateMaintenanceLocks() {
        ReceivingAddress receivingAddress = (ReceivingAddress)this.businessObject;
        List locks = super.generateMaintenanceLocks();
        if (receivingAddress.isDefaultIndicator() && receivingAddress.isActive()) {
            locks.add(this.createMaintenanceLock(new String[]{"chartOfAccountsCode", "organizationCode", "defaultIndicator", "active"}));
        }
        return locks;
    }

    private MaintenanceLock createMaintenanceLock(String[] fieldNames) {
        MaintenanceLock lock = new MaintenanceLock();
        lock.setDocumentNumber(this.getDocumentNumber());
        lock.setLockingRepresentation(this.createLockingRepresentation(fieldNames));
        return lock;
    }

    private String createLockingRepresentation(String[] fieldNames) {
        StringBuilder lockRepresentation = new StringBuilder();
        lockRepresentation.append(ReceivingAddress.class.getName());
        lockRepresentation.append("!!");
        DataDictionaryService dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
        EncryptionService encryptionService = (EncryptionService)SpringContext.getBean(EncryptionService.class);
        int count = 0;
        for (String fieldName : fieldNames) {
            lockRepresentation.append(fieldName);
            lockRepresentation.append("^^");
            lockRepresentation.append(this.retrieveFieldValueForLock(fieldName, dataDictionaryService, encryptionService));
            if (count < fieldNames.length - 1) {
                lockRepresentation.append("::");
            }
            ++count;
        }
        return lockRepresentation.toString();
    }

    private String retrieveFieldValueForLock(String fieldName, DataDictionaryService ddService, EncryptionService encryptionService) {
        Object fieldValue = ObjectUtils.getPropertyValue((Object)this.businessObject, (String)fieldName);
        if (fieldValue == null) {
            fieldValue = "";
        }
        if (((BusinessObjectAuthorizationService)SpringContext.getBean(BusinessObjectAuthorizationService.class)).attributeValueNeedsToBeEncryptedOnFormsAndLinks(this.getBoClass(), fieldName)) {
            try {
                fieldValue = encryptionService.encrypt(fieldValue);
            }
            catch (GeneralSecurityException e) {
                LOG.error("Unable to encrypt secure field for locking representation " + e.getMessage());
                throw new RuntimeException("Unable to encrypt secure field for locking representation " + e.getMessage());
            }
        }
        return String.valueOf(fieldValue);
    }

    public void doRouteStatusChange(DocumentHeader header) {
        super.doRouteStatusChange(header);
        ReceivingAddress ra = (ReceivingAddress)this.getBusinessObject();
        if (!ra.isActive() || !ra.isDefaultIndicator()) {
            return;
        }
        WorkflowDocument workflowDoc = header.getWorkflowDocument();
        if (workflowDoc.isProcessed()) {
            Collection<ReceivingAddress> addresses = ((ReceivingAddressService)SpringContext.getBean(ReceivingAddressService.class)).findDefaultByChartOrg(ra.getChartOfAccountsCode(), ra.getOrganizationCode());
            for (ReceivingAddress rai : addresses) {
                if (rai.getReceivingAddressIdentifier().equals(ra.getReceivingAddressIdentifier())) continue;
                rai.setDefaultIndicator(false);
                ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)rai);
            }
        }
    }
}

