/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Copyable;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.BillingAddress;
import org.kuali.kfs.module.purap.businessobject.DefaultPrincipalAddress;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurchaseRequisitionItemUseTax;
import org.kuali.kfs.module.purap.businessobject.RequisitionAccount;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetSystem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.businessobject.options.RequisitionStatusValuesFinder;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocumentBase;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.PurchasingDocumentSpecificService;
import org.kuali.kfs.module.purap.document.service.PurchasingService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.vnd.businessobject.VendorContract;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.kfs.vnd.service.PhoneNumberService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class RequisitionDocument
extends PurchasingDocumentBase
implements Copyable {
    private static final Logger LOG = LogManager.getLogger(RequisitionDocument.class);
    protected String requisitionOrganizationReference1Text;
    protected String requisitionOrganizationReference2Text;
    protected String requisitionOrganizationReference3Text;
    protected String alternate1VendorName;
    protected String alternate2VendorName;
    protected String alternate3VendorName;
    protected String alternate4VendorName;
    protected String alternate5VendorName;
    protected KualiDecimal organizationAutomaticPurchaseOrderLimit;
    protected List reqStatusList;
    protected boolean isBlanketApproveRequest = false;
    private static final int ALLOW_REQS_UNLIMITED_COPY_DAYS = 9999;

    @Override
    public PurchasingDocumentSpecificService getDocumentSpecificService() {
        return (PurchasingDocumentSpecificService)SpringContext.getBean(RequisitionService.class);
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("HasAccountingLines")) {
            return !this.isMissingAccountingLines();
        }
        if (nodeName.equals("AmountRequiresSeparationOfDutiesReview")) {
            return this.isSeparationOfDutiesReviewRequired();
        }
        return super.answerSplitNodeQuestion(nodeName);
    }

    public boolean isMissingAccountingLines() {
        List<RequisitionItem> itemsWithMissingAccountingLines = this.getListOfItemsMissingAccountingLines();
        return !itemsWithMissingAccountingLines.isEmpty();
    }

    public List<RequisitionItem> getListOfItemsMissingAccountingLines() {
        ArrayList<RequisitionItem> itemsWithMissingAccountingLines = new ArrayList<RequisitionItem>();
        for (RequisitionItem item : this.getItems()) {
            if (!item.isConsideredEntered() || !item.isAccountListEmpty()) continue;
            itemsWithMissingAccountingLines.add(item);
        }
        return itemsWithMissingAccountingLines;
    }

    protected boolean isSeparationOfDutiesReviewRequired() {
        try {
            Set<Person> priorApprovers = this.getAllPriorApprovers();
            if (priorApprovers.size() > 0) {
                if (priorApprovers.size() > 1) {
                    return false;
                }
                for (Person priorApprover : priorApprovers) {
                    String initiatorPrincipalId = this.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
                    if (initiatorPrincipalId.equals(priorApprover.getPrincipalId())) continue;
                    return false;
                }
            }
            ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
            KualiDecimal maxAllowedAmount = new KualiDecimal(parameterService.getParameterValueAsString(RequisitionDocument.class, "SEPARATION_OF_DUTIES_DOLLAR_AMOUNT"));
            KualiDecimal totalAmount = this.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount();
            return !ObjectUtils.isNotNull((Object)maxAllowedAmount) || !ObjectUtils.isNotNull((Object)totalAmount) || maxAllowedAmount.compareTo((AbstractKualiDecimal)totalAmount) < 0;
        }
        catch (WorkflowException we) {
            LOG.error("Exception while attempting to retrieve all prior approvers from workflow: ", (Throwable)we);
            return false;
        }
    }

    public Set<Person> getAllPriorApprovers() throws WorkflowException {
        PersonService personService = KimApiServiceLocator.getPersonService();
        List actionsTaken = this.getFinancialSystemDocumentHeader().getWorkflowDocument().getActionsTaken();
        HashSet<String> principalIds = new HashSet<String>();
        HashSet<Person> persons = new HashSet<Person>();
        for (ActionTaken actionTaken : actionsTaken) {
            String principalId;
            if (!"A".equals(actionTaken.getActionTaken().getCode()) || principalIds.contains(principalId = actionTaken.getPrincipalId())) continue;
            principalIds.add(principalId);
            persons.add(personService.getPerson(principalId));
        }
        return persons;
    }

    @Override
    public boolean isInquiryRendered() {
        return !this.isPostingYearPrior() || !this.getApplicationDocumentStatus().equals("Closed") && !this.getApplicationDocumentStatus().equals("Cancelled");
    }

    public void initiateDocument() throws WorkflowException {
        this.setupAccountDistributionMethod();
        this.setRequisitionSourceCode("STAN");
        this.updateAndSaveAppDocStatus("In Process");
        this.setPurchaseOrderCostSourceCode("EST");
        this.setPurchaseOrderTransmissionMethodCode(this.determinePurchaseOrderTransmissionMethod());
        this.setDocumentFundingSourceCode(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(RequisitionDocument.class, "DEFAULT_FUNDING_SOURCE"));
        this.setUseTaxIndicator(((PurchasingService)SpringContext.getBean(PurchasingService.class)).getDefaultUseTaxIndicatorValue(this));
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        ChartOrgHolder purapChartOrg = ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPrimaryOrganization(currentUser, "KFS-PURAP");
        if (ObjectUtils.isNotNull((Object)purapChartOrg)) {
            this.setChartOfAccountsCode(purapChartOrg.getChartOfAccountsCode());
            this.setOrganizationCode(purapChartOrg.getOrganizationCode());
        }
        this.setDeliveryCampusCode(currentUser.getCampusCode());
        this.setDeliveryToName(currentUser.getName());
        this.setDeliveryToEmailAddress(currentUser.getEmailAddressUnmasked());
        this.setDeliveryToPhoneNumber(((PhoneNumberService)SpringContext.getBean(PhoneNumberService.class)).formatNumberIfPossible(currentUser.getPhoneNumber()));
        this.setRequestorPersonName(currentUser.getName());
        this.setRequestorPersonEmailAddress(currentUser.getEmailAddressUnmasked());
        this.setRequestorPersonPhoneNumber(((PhoneNumberService)SpringContext.getBean(PhoneNumberService.class)).formatNumberIfPossible(currentUser.getPhoneNumber()));
        DefaultPrincipalAddress defaultPrincipalAddress = new DefaultPrincipalAddress(currentUser.getPrincipalId());
        Map addressKeys = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)defaultPrincipalAddress);
        defaultPrincipalAddress = (DefaultPrincipalAddress)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(DefaultPrincipalAddress.class, addressKeys);
        if (ObjectUtils.isNotNull((Object)((Object)defaultPrincipalAddress)) && ObjectUtils.isNotNull((Object)defaultPrincipalAddress.getBuilding())) {
            if (defaultPrincipalAddress.getBuilding().isActive()) {
                this.setDeliveryCampusCode(defaultPrincipalAddress.getCampusCode());
                this.templateBuildingToDeliveryAddress(defaultPrincipalAddress.getBuilding());
                this.setDeliveryBuildingRoomNumber(defaultPrincipalAddress.getBuildingRoomNumber());
            } else {
                ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).delete((PersistableBusinessObject)defaultPrincipalAddress);
            }
        }
        this.setOrganizationAutomaticPurchaseOrderLimit(((PurapService)SpringContext.getBean(PurapService.class)).getApoLimit(this.getVendorContractGeneratedIdentifier(), this.getChartOfAccountsCode(), this.getOrganizationCode()));
        BillingAddress billingAddress = (BillingAddress)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findBySinglePrimaryKey(BillingAddress.class, (Object)this.getDeliveryCampusCode());
        this.templateBillingAddress(billingAddress);
        this.loadReceivingAddress();
        RequisitionStatusValuesFinder requisitionStatusValuesFinder = new RequisitionStatusValuesFinder();
        this.reqStatusList = requisitionStatusValuesFinder.getKeyValues();
        ((PurapService)SpringContext.getBean(PurapService.class)).addBelowLineItems(this);
        this.refreshNonUpdateableReferences();
    }

    public void templateBuildingToDeliveryAddress(Building building) {
        if (ObjectUtils.isNotNull((Object)building)) {
            this.setDeliveryBuildingCode(building.getBuildingCode());
            this.setDeliveryBuildingName(building.getBuildingName());
            this.setDeliveryBuildingLine1Address(building.getBuildingStreetAddress());
            this.setDeliveryCityName(building.getBuildingAddressCityName());
            this.setDeliveryStateCode(building.getBuildingAddressStateCode());
            this.setDeliveryPostalCode(building.getBuildingAddressZipCode());
            this.setDeliveryCountryCode(building.getBuildingAddressCountryCode());
        }
    }

    protected String determinePurchaseOrderTransmissionMethod() {
        return ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(RequisitionDocument.class, "DEFAULT_METHOD_OF_PO_TRANSMISSION");
    }

    public boolean getAllowsCopy() {
        boolean allowsCopy = super.getAllowsCopy();
        Integer allowedCopyDays = this.getRequisitionSource().getAllowCopyDays();
        if (allowedCopyDays == 0) {
            return false;
        }
        if (allowedCopyDays >= 9999) {
            return true;
        }
        if (allowedCopyDays > 0) {
            DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
            Calendar c = Calendar.getInstance();
            DateTime createDate = this.getFinancialSystemDocumentHeader().getWorkflowDocument().getDateCreated();
            c.setTime(createDate.toDate());
            c.add(5, allowedCopyDays);
            Date allowedCopyDate = c.getTime();
            Date currentDate = dateTimeService.getCurrentDate();
            allowsCopy = currentDate.before(allowedCopyDate);
        }
        return allowsCopy;
    }

    public void toCopy() throws WorkflowException, ValidationException {
        VendorDetail vendorDetail;
        super.toCopy();
        this.setAccountsPayablePurchasingDocumentLinkIdentifier(null);
        this.setRelatedViews(null);
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        ChartOrgHolder purapChartOrg = ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPrimaryOrganization(currentUser, "KFS-PURAP");
        this.setPurapDocumentIdentifier(null);
        this.updateAndSaveAppDocStatus("In Process");
        if (ObjectUtils.isNotNull((Object)purapChartOrg)) {
            this.setChartOfAccountsCode(purapChartOrg.getChartOfAccountsCode());
            this.setOrganizationCode(purapChartOrg.getOrganizationCode());
        }
        this.setPostingYear(((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear());
        boolean activeVendor = true;
        boolean activeContract = true;
        Date today = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentDate();
        VendorContract vendorContract = new VendorContract();
        vendorContract.setVendorContractGeneratedIdentifier(this.getVendorContractGeneratedIdentifier());
        Map keys = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)vendorContract);
        vendorContract = (VendorContract)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(VendorContract.class, keys);
        if (vendorContract == null || !today.after(vendorContract.getVendorContractBeginningDate()) || !today.before(vendorContract.getVendorContractEndDate())) {
            activeContract = false;
        }
        if ((vendorDetail = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDetail(this.getVendorHeaderGeneratedIdentifier(), this.getVendorDetailAssignedIdentifier())) == null || !vendorDetail.isActiveIndicator()) {
            activeVendor = false;
        }
        if (this.getRequisitionSourceCode().equals("B2B")) {
            if (!activeContract) {
                throw new ValidationException("error.requisition.copy.expired.contract");
            }
            if (!activeVendor) {
                throw new ValidationException("error.requisition.copy.inactive.vendor");
            }
        }
        if (!activeVendor) {
            this.setVendorContractGeneratedIdentifier(null);
        }
        if (!activeContract) {
            this.setVendorContractGeneratedIdentifier(null);
        }
        this.setOrganizationAutomaticPurchaseOrderLimit(null);
        this.setPurchaseOrderAutomaticIndicator(false);
        for (RequisitionItem item : this.getItems()) {
            item.setPurapDocumentIdentifier(null);
            item.setItemIdentifier(null);
            for (RequisitionAccount requisitionAccount : item.getSourceAccountingLines()) {
                requisitionAccount.setAccountIdentifier(null);
                requisitionAccount.setItemIdentifier(null);
                requisitionAccount.setObjectId(null);
                requisitionAccount.setVersionNumber(null);
            }
        }
        if (!"B2B".equals(this.getRequisitionSourceCode())) {
            ((PurapService)SpringContext.getBean(PurapService.class)).addBelowLineItems(this);
        }
        this.setOrganizationAutomaticPurchaseOrderLimit(((PurapService)SpringContext.getBean(PurapService.class)).getApoLimit(this.getVendorContractGeneratedIdentifier(), this.getChartOfAccountsCode(), this.getOrganizationCode()));
        this.clearCapitalAssetFields();
        ((PurapService)SpringContext.getBean(PurapService.class)).clearTax(this, this.isUseTaxIndicator());
        this.refreshNonUpdateableReferences();
    }

    public List<String> getWorkflowEngineDocumentIdsToLock() {
        ArrayList<String> docIdStrings = new ArrayList<String>();
        docIdStrings.add(this.getDocumentNumber());
        return docIdStrings;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        LOG.debug("doRouteStatusChange() started");
        super.doRouteStatusChange(statusChangeEvent);
        try {
            if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed()) {
                String newRequisitionStatus = "Awaiting Contract Manager Assignment";
                if (((RequisitionService)SpringContext.getBean(RequisitionService.class)).isAutomaticPurchaseOrderAllowed(this)) {
                    newRequisitionStatus = "Closed";
                    ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).createAutomaticPurchaseOrderDocument(this);
                }
                String reqStatus = this.getRequisitionAppDocStatus(newRequisitionStatus);
                this.updateAndSaveAppDocStatus(reqStatus);
            } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isDisapproved()) {
                String nodeName = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).getCurrentRouteLevelName(this.getFinancialSystemDocumentHeader().getWorkflowDocument());
                String disapprovalStatus = this.getRequisitionAppDocStatus(nodeName);
                if (StringUtils.isNotBlank((CharSequence)disapprovalStatus)) {
                    this.updateAndSaveAppDocStatus(disapprovalStatus);
                } else {
                    this.logAndThrowRuntimeException("No status found to set for document being disapproved in node '" + nodeName + "'");
                }
            } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isCanceled()) {
                String reqStatus = this.getRequisitionAppDocStatus("Cancelled");
                this.updateAndSaveAppDocStatus(reqStatus);
            }
        }
        catch (WorkflowException e) {
            this.logAndThrowRuntimeException("Error saving routing data while saving document with id " + this.getDocumentNumber(), (Exception)((Object)e));
        }
        LOG.debug("doRouteStatusChange() ending");
    }

    protected String getRequisitionAppDocStatus(String nodeName) {
        return PurapConstants.RequisitionStatuses.getRequistionAppDocStatuses().get(nodeName);
    }

    public void doRouteLevelChange(DocumentRouteLevelChange change) {
        LOG.debug("handleRouteLevelChange() started");
        super.doRouteLevelChange(change);
    }

    public Class getSourceAccountingLineClass() {
        return super.getSourceAccountingLineClass();
    }

    public String getRequisitionOrganizationReference1Text() {
        return this.requisitionOrganizationReference1Text;
    }

    public void setRequisitionOrganizationReference1Text(String requisitionOrganizationReference1Text) {
        this.requisitionOrganizationReference1Text = requisitionOrganizationReference1Text;
    }

    public String getRequisitionOrganizationReference2Text() {
        return this.requisitionOrganizationReference2Text;
    }

    public void setRequisitionOrganizationReference2Text(String requisitionOrganizationReference2Text) {
        this.requisitionOrganizationReference2Text = requisitionOrganizationReference2Text;
    }

    public String getRequisitionOrganizationReference3Text() {
        return this.requisitionOrganizationReference3Text;
    }

    public void setRequisitionOrganizationReference3Text(String requisitionOrganizationReference3Text) {
        this.requisitionOrganizationReference3Text = requisitionOrganizationReference3Text;
    }

    public String getAlternate1VendorName() {
        return this.alternate1VendorName;
    }

    public void setAlternate1VendorName(String alternate1VendorName) {
        this.alternate1VendorName = alternate1VendorName;
    }

    public String getAlternate2VendorName() {
        return this.alternate2VendorName;
    }

    public void setAlternate2VendorName(String alternate2VendorName) {
        this.alternate2VendorName = alternate2VendorName;
    }

    public String getAlternate3VendorName() {
        return this.alternate3VendorName;
    }

    public void setAlternate3VendorName(String alternate3VendorName) {
        this.alternate3VendorName = alternate3VendorName;
    }

    public String getAlternate4VendorName() {
        return this.alternate4VendorName;
    }

    public void setAlternate4VendorName(String alternate4VendorName) {
        this.alternate4VendorName = alternate4VendorName;
    }

    public String getAlternate5VendorName() {
        return this.alternate5VendorName;
    }

    public void setAlternate5VendorName(String alternate5VendorName) {
        this.alternate5VendorName = alternate5VendorName;
    }

    public KualiDecimal getOrganizationAutomaticPurchaseOrderLimit() {
        return this.organizationAutomaticPurchaseOrderLimit;
    }

    public void setOrganizationAutomaticPurchaseOrderLimit(KualiDecimal organizationAutomaticPurchaseOrderLimit) {
        this.organizationAutomaticPurchaseOrderLimit = organizationAutomaticPurchaseOrderLimit;
    }

    @Override
    public Class getItemClass() {
        return RequisitionItem.class;
    }

    @Override
    public Class getItemUseTaxClass() {
        return PurchaseRequisitionItemUseTax.class;
    }

    @Override
    public PurchasingAccountsPayableDocument getPurApSourceDocumentIfPossible() {
        return null;
    }

    @Override
    public String getPurApSourceDocumentLabelIfPossible() {
        return null;
    }

    public String getDocumentTitle() {
        String title = "";
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(RequisitionDocument.class, "OVERRIDE_DOCUMENT_TITLE_IND").booleanValue()) {
            String chartAcct;
            String docIdStr = "";
            if (this.getPurapDocumentIdentifier() != null && StringUtils.isNotBlank((CharSequence)this.getPurapDocumentIdentifier().toString())) {
                docIdStr = "Requisition: " + this.getPurapDocumentIdentifier().toString();
            }
            String chartAcctStr = (chartAcct = this.getFirstChartAccount()) == null ? "" : " - Account Number:  " + chartAcct;
            title = docIdStr + chartAcctStr;
        } else {
            title = super.getDocumentTitle();
        }
        return title;
    }

    protected String getFirstChartAccount() {
        PurApAccountingLine accountLine;
        String chartAcct = null;
        RequisitionItem item = (RequisitionItem)this.getItem(0);
        if (ObjectUtils.isNotNull((Object)item) && item.getSourceAccountingLines().size() > 0 && ObjectUtils.isNotNull((Object)(accountLine = item.getSourceAccountingLine(0))) && ObjectUtils.isNotNull((Object)accountLine.getChartOfAccountsCode()) && ObjectUtils.isNotNull((Object)accountLine.getAccountNumber())) {
            chartAcct = accountLine.getChartOfAccountsCode() + "-" + accountLine.getAccountNumber();
        }
        return chartAcct;
    }

    public Date getCreateDate() {
        return this.getFinancialSystemDocumentHeader().getWorkflowDocument().getDateCreated().toDate();
    }

    public String getUrl() {
        return ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("kew.url") + "/DocHandler.do?docId=" + this.getDocumentNumber() + "&command=displayDocSearchView";
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    @Override
    public Class getPurchasingCapitalAssetItemClass() {
        return RequisitionCapitalAssetItem.class;
    }

    @Override
    public Class getPurchasingCapitalAssetSystemClass() {
        return RequisitionCapitalAssetSystem.class;
    }

    @Override
    public boolean shouldGiveErrorForEmptyAccountsProration() {
        return !this.isDocumentStoppedInRouteNode("Organization") && !this.getApplicationDocumentStatus().equals("In Process");
    }

    public Date getCreateDateForResult() {
        return this.getCreateDate();
    }

    public boolean isBlanketApproveRequest() {
        return this.isBlanketApproveRequest;
    }

    public void setBlanketApproveRequest(boolean isBlanketApproveRequest) {
        this.isBlanketApproveRequest = isBlanketApproveRequest;
    }

    public void setupAccountDistributionMethod() {
        String defaultDistributionMethod = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString("KFS-PURAP", "Document", "DISTRIBUTION_METHOD_FOR_ACCOUNTING_LINES");
        String defaultDistributionMethodCode = "P";
        if ("P".equalsIgnoreCase(defaultDistributionMethod) || "S".equalsIgnoreCase(defaultDistributionMethod)) {
            defaultDistributionMethodCode = defaultDistributionMethod;
        } else if ("P;S".equalsIgnoreCase(defaultDistributionMethod)) {
            defaultDistributionMethodCode = "P";
        } else if ("S;P".equalsIgnoreCase(defaultDistributionMethod)) {
            defaultDistributionMethodCode = "S";
        } else {
            new RuntimeException("Error in reading system parameter values for DISTRIBUTION_METHOD_FOR_ACCOUNTING_LINES");
        }
        this.setAccountDistributionMethod(defaultDistributionMethodCode);
    }
}

