/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.dataaccess.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.dataaccess.CreditMemoDao;
import org.kuali.kfs.module.purap.util.VendorGroupingHelper;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CreditMemoDaoOjb
extends PlatformAwareDaoBaseOjb
implements CreditMemoDao {
    private static final Logger LOG = LogManager.getLogger(CreditMemoDaoOjb.class);

    @Override
    public List<VendorCreditMemoDocument> getCreditMemosToExtract(String chartCode) {
        LOG.debug("getCreditMemosToExtract() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("processingCampusCode", (Object)chartCode);
        criteria.addIsNull("extractedTimestamp");
        criteria.addEqualTo("holdIndicator", (Object)Boolean.FALSE);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(VendorCreditMemoDocument.class, criteria));
    }

    @Override
    public Collection<VendorCreditMemoDocument> getCreditMemosToExtractByVendor(String chartCode, VendorGroupingHelper vendor) {
        LOG.debug("getCreditMemosToExtractByVendor() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("processingCampusCode", (Object)chartCode);
        criteria.addIsNull("extractedTimestamp");
        criteria.addEqualTo("holdIndicator", (Object)Boolean.FALSE);
        criteria.addEqualTo("vendorHeaderGeneratedIdentifier", (Object)vendor.getVendorHeaderGeneratedIdentifier());
        criteria.addEqualTo("vendorDetailAssignedIdentifier", (Object)vendor.getVendorDetailAssignedIdentifier());
        criteria.addEqualTo("vendorCountryCode", (Object)vendor.getVendorCountry());
        if (vendor.getVendorPostalCode() == null) {
            criteria.addIsNull("vendorPostalCode");
        } else {
            criteria.addLike((Object)"vendorPostalCode", (Object)(vendor.getVendorPostalCode() + "%"));
        }
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(VendorCreditMemoDocument.class, criteria));
    }

    @Override
    public boolean duplicateExists(Integer vendorNumberHeaderId, Integer vendorNumberDetailId, String creditMemoNumber) {
        LOG.debug("duplicateExists() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("vendorHeaderGeneratedIdentifier", (Object)vendorNumberHeaderId);
        criteria.addEqualTo("vendorDetailAssignedIdentifier", (Object)vendorNumberDetailId);
        criteria.addEqualTo("creditMemoNumber", (Object)creditMemoNumber);
        int cmCount = this.getPersistenceBrokerTemplate().getCount((Query)new QueryByCriteria(VendorCreditMemoDocument.class, criteria));
        return cmCount > 0;
    }

    @Override
    public boolean duplicateExists(Integer vendorNumberHeaderId, Integer vendorNumberDetailId, Date date, KualiDecimal amount) {
        LOG.debug("duplicateExists() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("vendorHeaderGeneratedIdentifier", (Object)vendorNumberHeaderId);
        criteria.addEqualTo("vendorDetailAssignedIdentifier", (Object)vendorNumberDetailId);
        criteria.addEqualTo("creditMemoDate", (Object)date);
        criteria.addEqualTo("creditMemoAmount", (Object)amount);
        int cmCount = this.getPersistenceBrokerTemplate().getCount((Query)new QueryByCriteria(VendorCreditMemoDocument.class, criteria));
        return cmCount > 0;
    }

    @Override
    public String getDocumentNumberByCreditMemoId(Integer id) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purapDocumentIdentifier", (Object)id);
        return this.getDocumentNumberOfCreditMemoByCriteria(criteria);
    }

    protected String getDocumentNumberOfCreditMemoByCriteria(Criteria criteria) {
        LOG.debug("getDocumentNumberOfCreditMemoByCriteria() started");
        List<String> returnList = this.getDocumentNumbersOfCreditMemoByCriteria(criteria, false);
        if (returnList.isEmpty()) {
            return null;
        }
        if (returnList.size() > 1) {
            String errorMsg = "Expected single document number for given criteria but multiple (at least 2) were returned";
            LOG.error(errorMsg);
            throw new RuntimeException();
        }
        return returnList.get(0);
    }

    protected List<String> getDocumentNumbersOfCreditMemoByCriteria(Criteria criteria, boolean orderByAscending) {
        LOG.debug("getDocumentNumberOfCreditMemoByCriteria() started");
        ReportQueryByCriteria rqbc = new ReportQueryByCriteria(VendorCreditMemoDocument.class, criteria);
        if (orderByAscending) {
            rqbc.addOrderByAscending("documentNumber");
        } else {
            rqbc.addOrderByDescending("documentNumber");
        }
        List vcmds = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)rqbc);
        ArrayList<String> returnList = new ArrayList<String>();
        for (VendorCreditMemoDocument vcmd : vcmds) {
            returnList.add(vcmd.getDocumentNumber());
        }
        return returnList;
    }

    @Override
    public List<String> getActiveCreditMemoDocumentNumbersForPurchaseOrder(Integer purchaseOrderId) {
        LOG.debug("getActiveCreditmemoDocumentNumbersForPurchaseOrder() started");
        ArrayList<String> returnList = new ArrayList();
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)purchaseOrderId);
        QueryByCriteria qbc = new QueryByCriteria(PaymentRequestDocument.class, criteria);
        returnList = this.getDocumentNumbersOfCreditMemoByCriteria(criteria, false);
        return returnList;
    }
}

