/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.List;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PaymentRequestTotalsValidation
extends GenericValidation {
    public boolean validate(AttributedDocumentEvent event) {
        PaymentRequestDocument document = (PaymentRequestDocument)event.getDocument();
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        String[] excludeArray = new String[]{"DISC"};
        if (ObjectUtils.isNull((Object)document.getVendorInvoiceAmount())) {
            if (!KNSGlobalVariables.getMessageList().contains((Object)"warning.paymentRequest.vendorInvoiceAmount.invalid")) {
                KNSGlobalVariables.getMessageList().add("warning.paymentRequest.vendorInvoiceAmount.invalid", new String[0]);
            }
        } else if (document.isUseTaxIndicator()) {
            if (document.getTotalPreTaxDollarAmountAllItems(excludeArray).compareTo((AbstractKualiDecimal)document.getVendorInvoiceAmount()) != 0 && !document.isUnmatchedOverride() && !KNSGlobalVariables.getMessageList().contains((Object)"warning.paymentRequest.vendorInvoiceAmount.invalid")) {
                KNSGlobalVariables.getMessageList().add("warning.paymentRequest.vendorInvoiceAmount.invalid", new String[0]);
            }
        } else if (document.getTotalDollarAmountAllItems(excludeArray).compareTo((AbstractKualiDecimal)document.getVendorInvoiceAmount()) != 0 && !document.isUnmatchedOverride() && !KNSGlobalVariables.getMessageList().contains((Object)"warning.paymentRequest.vendorInvoiceAmount.invalid")) {
            KNSGlobalVariables.getMessageList().add("warning.paymentRequest.vendorInvoiceAmount.invalid", new String[0]);
        }
        this.flagLineItemTotals(document.getItems());
        GlobalVariables.getMessageMap().clearErrorPath();
        return true;
    }

    protected KualiDecimal getTotalExcludingItemTypes(List<PurApItem> itemList, List<String> excludedItemTypes) {
        KualiDecimal total = KualiDecimal.ZERO;
        for (PurApItem item : itemList) {
            if (item.getTotalAmount() == null || !item.getTotalAmount().isNonZero()) continue;
            boolean skipThisItem = false;
            if (excludedItemTypes.contains(item.getItemTypeCode())) {
                skipThisItem = true;
                break;
            }
            if (skipThisItem) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)item.getTotalAmount());
        }
        return total;
    }

    protected void flagLineItemTotals(List<PurApItem> itemList) {
        for (PurApItem purApItem : itemList) {
            PaymentRequestItem item = (PaymentRequestItem)purApItem;
            if (item.getItemQuantity() == null || item.getExtendedPrice() == null || item.calculateExtendedPrice().compareTo((AbstractKualiDecimal)item.getExtendedPrice()) == 0) continue;
            KNSGlobalVariables.getMessageList().add("warning.paymentRequest.item.TotalInvoice.notEqual", new String[]{item.getItemIdentifierString()});
        }
    }
}

