/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kns.rules.PromptBeforeValidationBase;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.MessageList;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public abstract class PurapDocumentPreRulesBase
extends PromptBeforeValidationBase {
    public boolean doPrompts(Document document) {
        PurchasingAccountsPayableDocument purapDocument = (PurchasingAccountsPayableDocument)document;
        boolean preRulesValid = true;
        List<PurApItem> items = purapDocument.getItems();
        for (PurApItem item : items) {
            for (PurApAccountingLine account : item.getSourceAccountingLines()) {
                account.refreshNonUpdateableReferences();
            }
        }
        if (StringUtils.isBlank((CharSequence)this.event.getQuestionContext()) || StringUtils.equals((CharSequence)this.question, (CharSequence)"FixCapitalAssetWarnings")) {
            preRulesValid &= this.confirmFixCapitalAssetWarningConditions(purapDocument);
        }
        return preRulesValid;
    }

    public boolean confirmFixCapitalAssetWarningConditions(PurchasingAccountsPayableDocument purapDocument) {
        boolean proceed = true;
        if (!this.checkCAMSWarningStatus(purapDocument)) {
            return true;
        }
        StringBuffer questionText = new StringBuffer();
        if (StringUtils.isBlank((CharSequence)this.event.getQuestionContext()) && !((CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class)).warningObjectLevelCapital((AccountingDocument)purapDocument)) {
            proceed &= false;
            questionText.append(((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("requisition.question.fix.capitalAsset.warnings"));
            MessageList warnings = KNSGlobalVariables.getMessageList();
            if (!warnings.isEmpty()) {
                questionText.append("[p]");
                for (ErrorMessage warning : warnings) {
                    questionText.append(warning.getErrorKey());
                    String[] params = warning.getMessageParameters();
                    if (params == null || params.length <= 0) continue;
                    questionText.append("(");
                    for (int i = 0; i < params.length; ++i) {
                        if (i > 0) {
                            questionText.append(", ");
                        }
                        questionText.append(params[i]);
                    }
                    questionText.append(")");
                }
                questionText.append("[/p]");
            }
        }
        if (!proceed || ObjectUtils.isNotNull((Object)this.question) && this.question.equals("FixCapitalAssetWarnings")) {
            proceed = this.askOrAnalyzeYesNoQuestion("FixCapitalAssetWarnings", questionText.toString());
        }
        this.event.setQuestionContext("FixCapitalAssetWarnings");
        this.event.setActionForwardName("basic");
        if (proceed) {
            KNSGlobalVariables.getMessageList().clear();
        }
        return proceed;
    }

    protected abstract boolean checkCAMSWarningStatus(PurchasingAccountsPayableDocument var1);
}

