/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetSystem;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.service.PurchasingService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingCapitalAssetValidation
extends GenericValidation {
    CapitalAssetManagementModuleService capitalAssetManagementModuleService;
    PurchasingService purchasingService;
    protected static String ERROR_PATH_PREFIX_FOR_IND_SYSTEM = "document.purchasingCapitalAssetItems[";
    protected static String ERROR_PATH_SUFFIX_FOR_IND_SYSTEM = "].purchasingCapitalAssetSystem";
    protected static String ERROR_PATH_PREFIX_FOR_ONE_SYSTEM = "document.purchasingCapitalAssetSystems[0]";

    public boolean validate(AttributedDocumentEvent event) {
        boolean capitalAssetRequired;
        GlobalVariables.getMessageMap().clearErrorPath();
        boolean valid = true;
        PurchasingDocument purchasingDocument = (PurchasingDocument)event.getDocument();
        boolean requiredByObjectSubType = !this.capitalAssetManagementModuleService.validatePurchasingObjectSubType((AccountingDocument)purchasingDocument);
        boolean requiredByChart = !this.capitalAssetManagementModuleService.validateAllFieldRequirementsByChart((AccountingDocument)purchasingDocument);
        boolean bl = capitalAssetRequired = requiredByObjectSubType && requiredByChart;
        if (capitalAssetRequired) {
            String typeCode = purchasingDocument.getCapitalAssetSystemTypeCode();
            if (StringUtils.isBlank((CharSequence)typeCode) || StringUtils.isBlank((CharSequence)purchasingDocument.getCapitalAssetSystemStateCode()) || purchasingDocument.getPurchasingCapitalAssetSystems() == null || purchasingDocument.getPurchasingCapitalAssetItems() == null) {
                valid = false;
            } else if ((typeCode.equals("ONE") || typeCode.equals("MUL")) && purchasingDocument.getPurchasingCapitalAssetSystems().size() == 0) {
                valid = false;
            } else if (purchasingDocument.getPurchasingCapitalAssetItems().isEmpty()) {
                valid = false;
            } else {
                int expectedCapAssetItems = 0;
                for (PurApItem purapItem : purchasingDocument.getItems()) {
                    if (!purapItem.getItemType().isLineItemIndicator() || !this.capitalAssetManagementModuleService.doesItemNeedCapitalAsset(purapItem.getItemTypeCode(), purapItem.getSourceAccountingLines())) continue;
                    ++expectedCapAssetItems;
                }
                if (purchasingDocument.getPurchasingCapitalAssetItems().size() != expectedCapAssetItems) {
                    valid = false;
                }
            }
            if (!valid) {
                String errorKey = StringUtils.isBlank((CharSequence)typeCode) ? "error.capitalAsset.required.for.purchase.order.sub.type" : "error.capitalAsset.required.for.purchase.order.sub.type.update";
                GlobalVariables.getMessageMap().putError("newPurchasingItemCapitalAssetLine", errorKey, new String[0]);
                return false;
            }
        } else if (purchasingDocument.getPurchasingCapitalAssetItems().isEmpty()) {
            purchasingDocument.setCapitalAssetSystemTypeCode(null);
            purchasingDocument.setCapitalAssetSystemStateCode(null);
        }
        if (StringUtils.isNotBlank((CharSequence)purchasingDocument.getCapitalAssetSystemTypeCode())) {
            valid = this.capitalAssetManagementModuleService.validatePurchasingData((AccountingDocument)purchasingDocument);
            if (purchasingDocument.getCapitalAssetSystemTypeCode().equals("IND")) {
                for (CapitalAssetSystem system : purchasingDocument.getPurchasingCapitalAssetSystems()) {
                    for (CapitalAssetLocation location : system.getCapitalAssetLocations()) {
                        valid &= this.purchasingService.checkCapitalAssetLocation(location);
                    }
                }
            } else if (purchasingDocument.getCapitalAssetSystemTypeCode().equals("ONE")) {
                CapitalAssetSystem system = purchasingDocument.getPurchasingCapitalAssetSystems().get(0);
                for (CapitalAssetLocation location : system.getCapitalAssetLocations()) {
                    valid &= this.purchasingService.checkCapitalAssetLocation(location);
                }
            }
            valid &= this.validateAssetTypeExistence(purchasingDocument);
        }
        return valid;
    }

    protected boolean validateAssetTypeExistence(PurchasingDocument purchasingDocument) {
        CapitalAssetSystem system;
        boolean valid = true;
        if (purchasingDocument.getCapitalAssetSystemTypeCode().equals("IND")) {
            int i = 0;
            for (PurchasingCapitalAssetItem capitalAssetItem : purchasingDocument.getPurchasingCapitalAssetItems()) {
                String assetTypeCode;
                if (ObjectUtils.isNotNull((Object)capitalAssetItem) && ObjectUtils.isNotNull((Object)capitalAssetItem.getPurchasingCapitalAssetSystem()) && StringUtils.isNotBlank((CharSequence)(assetTypeCode = capitalAssetItem.getPurchasingCapitalAssetSystem().getCapitalAssetTypeCode())) && !this.capitalAssetManagementModuleService.isAssetTypeExisting(assetTypeCode)) {
                    valid = false;
                    String errorPath = ERROR_PATH_PREFIX_FOR_IND_SYSTEM + new Integer(i).toString() + ERROR_PATH_SUFFIX_FOR_IND_SYSTEM;
                    this.addAssetTypeErrorWithFullErrorPath(errorPath);
                }
                ++i;
            }
        } else if (purchasingDocument.getCapitalAssetSystemTypeCode().equals("ONE") && ObjectUtils.isNotNull(purchasingDocument.getPurchasingCapitalAssetSystems()) && ObjectUtils.isNotNull((Object)(system = purchasingDocument.getPurchasingCapitalAssetSystems().get(0))) && StringUtils.isNotBlank((CharSequence)system.getCapitalAssetTypeCode()) && !this.capitalAssetManagementModuleService.isAssetTypeExisting(system.getCapitalAssetTypeCode())) {
            valid = false;
            String errorPath = ERROR_PATH_PREFIX_FOR_ONE_SYSTEM;
            this.addAssetTypeErrorWithFullErrorPath(errorPath);
        }
        return valid;
    }

    protected void addAssetTypeErrorWithFullErrorPath(String errorPath) {
        GlobalVariables.getMessageMap().addToErrorPath(errorPath);
        String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(RequisitionCapitalAssetSystem.class.getName()).getAttributeDefinition("capitalAssetTypeCode").getLabel();
        GlobalVariables.getMessageMap().putError("capitalAssetTypeCode", "error.existence", new String[]{label});
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
    }

    public CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return this.capitalAssetManagementModuleService;
    }

    public void setCapitalAssetManagementModuleService(CapitalAssetManagementModuleService capitalAssetManagementModuleService) {
        this.capitalAssetManagementModuleService = capitalAssetManagementModuleService;
    }

    public PurchasingService getPurchasingService() {
        return this.purchasingService;
    }

    public void setPurchasingService(PurchasingService purchasingService) {
        this.purchasingService = purchasingService;
    }
}

