/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorStipulation;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderRetransmitDocument;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.pdf.PurapPdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderParameters;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderTransmitParameters;
import org.kuali.kfs.module.purap.util.PurApDateFormatUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PurchaseOrderPdf
extends PurapPdf {
    private static Log LOG = LogFactory.getLog(PurchaseOrderPdf.class);

    public void onOpenDocument(PdfWriter writer, Document document) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("onOpenDocument() started. isRetransmit is " + this.isRetransmit));
        }
        try {
            float[] headerWidths = new float[]{0.2f, 0.8f};
            this.headerTable = new PdfPTable(headerWidths);
            this.headerTable.setWidthPercentage(100.0f);
            this.headerTable.setHorizontalAlignment(1);
            this.headerTable.setSplitLate(false);
            this.headerTable.getDefaultCell().setBorderWidth(0.0f);
            this.headerTable.getDefaultCell().setHorizontalAlignment(1);
            this.headerTable.getDefaultCell().setVerticalAlignment(1);
            Image logo = null;
            if (StringUtils.isNotBlank((CharSequence)this.logoImage)) {
                try {
                    logo = Image.getInstance((String)this.logoImage);
                }
                catch (IOException e) {
                    LOG.info((Object)("The logo image [" + this.logoImage + "] is not available.  Defaulting to the default image."));
                }
            }
            if (logo == null) {
                this.headerTable.addCell(new Phrase(new Chunk("")));
            } else {
                logo.scalePercent(3.0f, 3.0f);
                this.headerTable.addCell(new Phrase(new Chunk(logo, 0.0f, 0.0f)));
            }
            float[] nestedHeaderWidths = new float[]{0.7f, 0.3f};
            this.nestedHeaderTable = new PdfPTable(nestedHeaderWidths);
            this.nestedHeaderTable.setSplitLate(false);
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph(this.po.getBillingName(), this.ver_15_normal));
            cell.setHorizontalAlignment(1);
            cell.setBorderWidth(0.0f);
            this.nestedHeaderTable.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(" ", this.ver_15_normal));
            cell.setBorderWidth(0.0f);
            this.nestedHeaderTable.addCell(cell);
            cell = this.isRetransmit ? new PdfPCell((Phrase)new Paragraph(this.po.getRetransmitHeader(), this.ver_15_normal)) : new PdfPCell((Phrase)new Paragraph("PURCHASE ORDER", this.ver_15_normal));
            cell.setHorizontalAlignment(1);
            cell.setBorderWidth(0.0f);
            this.nestedHeaderTable.addCell(cell);
            Paragraph p = new Paragraph();
            p.add((Object)new Chunk("PO Number: ", this.ver_11_normal));
            p.add((Object)new Chunk(this.po.getPurapDocumentIdentifier().toString(), this.cour_16_bold));
            cell = new PdfPCell((Phrase)p);
            cell.setHorizontalAlignment(2);
            cell.setBorderWidth(0.0f);
            this.nestedHeaderTable.addCell(cell);
            if (!this.po.getPurchaseOrderAutomaticIndicator()) {
                p = new Paragraph();
                p.add((Object)new Chunk("Contract Manager: ", this.ver_11_normal));
                p.add((Object)new Chunk(this.po.getContractManager().getContractManagerName(), this.cour_7_normal));
                cell = new PdfPCell((Phrase)p);
                cell.setColspan(2);
                cell.setHorizontalAlignment(2);
                cell.setBorderWidth(0.0f);
                this.nestedHeaderTable.addCell(cell);
            }
            cell = new PdfPCell(this.nestedHeaderTable);
            cell.setHorizontalAlignment(1);
            cell.setBorderWidth(0.0f);
            this.headerTable.addCell(cell);
            this.tpl = writer.getDirectContent().createTemplate(100.0f, 100.0f);
            this.helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    @Override
    public PurchaseOrderPdf getPageEvents() {
        LOG.debug((Object)"getPageEvents() started.");
        return new PurchaseOrderPdf();
    }

    public void generatePdf(PurchaseOrderDocument po, PurchaseOrderTransmitParameters pdfParameters, ByteArrayOutputStream byteArrayOutputStream, boolean isRetransmit, String environment, List<PurchaseOrderItem> retransmitItems) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("generatePdf() started for po number " + po.getPurapDocumentIdentifier()));
        }
        this.isRetransmit = isRetransmit;
        String statusInquiryUrl = pdfParameters.getStatusInquiryUrl();
        String campusName = pdfParameters.getCampusParameter().getCampus().getName();
        String contractLanguage = pdfParameters.getContractLanguage();
        String logoImage = pdfParameters.getLogoImage();
        String directorSignatureImage = pdfParameters.getDirectorSignatureImage();
        String directorName = pdfParameters.getCampusParameter().getCampusPurchasingDirectorName();
        String directorTitle = pdfParameters.getCampusParameter().getCampusPurchasingDirectorTitle();
        String contractManagerSignatureImage = pdfParameters.getContractManagerSignatureImage();
        try {
            Document doc = this.getDocument(9.0f, 9.0f, 70.0f, 36.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)byteArrayOutputStream);
            this.createPdf(po, doc, writer, statusInquiryUrl, campusName, contractLanguage, logoImage, directorSignatureImage, directorName, directorTitle, contractManagerSignatureImage, isRetransmit, environment, retransmitItems);
        }
        catch (DocumentException de) {
            LOG.error((Object)("generatePdf() DocumentException: " + de.getMessage()), (Throwable)de);
            throw new PurError("Document Exception when trying to save a Purchase Order PDF", de);
        }
        catch (IOException i) {
            LOG.error((Object)("generatePdf() IOException: " + i.getMessage()), (Throwable)i);
            throw new PurError("IO Exception when trying to save a Purchase Order PDF", i);
        }
        catch (Exception t) {
            LOG.error((Object)("generatePdf() EXCEPTION: " + t.getMessage()), (Throwable)t);
            throw new PurError("Exception when trying to save a Purchase Order PDF", t);
        }
    }

    public void savePdf(PurchaseOrderDocument po, PurchaseOrderParameters pdfParameters, boolean isRetransmit, String environment) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("savePdf() started for po number " + po.getPurapDocumentIdentifier()));
        }
        PurchaseOrderTransmitParameters pdfTransmitParameters = (PurchaseOrderTransmitParameters)pdfParameters;
        this.isRetransmit = isRetransmit;
        String statusInquiryUrl = pdfTransmitParameters.getStatusInquiryUrl();
        String campusName = pdfTransmitParameters.getCampusParameter().getCampus().getName();
        String contractLanguage = pdfTransmitParameters.getContractLanguage();
        String logoImage = pdfTransmitParameters.getLogoImage();
        String directorSignatureImage = pdfTransmitParameters.getDirectorSignatureImage();
        String directorName = pdfTransmitParameters.getCampusParameter().getCampusPurchasingDirectorName();
        String directorTitle = pdfTransmitParameters.getCampusParameter().getCampusPurchasingDirectorTitle();
        String contractManagerSignatureImage = pdfTransmitParameters.getContractManagerSignatureImage();
        String pdfFileLocation = pdfTransmitParameters.getPdfFileLocation();
        String pdfFileName = pdfTransmitParameters.getPdfFileName();
        try {
            Document doc = this.getDocument(9.0f, 9.0f, 70.0f, 36.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(pdfFileLocation + pdfFileName));
            this.createPdf(po, doc, writer, statusInquiryUrl, campusName, contractLanguage, logoImage, directorSignatureImage, directorName, directorTitle, contractManagerSignatureImage, isRetransmit, environment);
        }
        catch (DocumentException de) {
            LOG.error((Object)("savePdf() DocumentException: " + de.getMessage()), (Throwable)de);
            throw new PurError("Document Exception when trying to save a Purchase Order PDF", de);
        }
        catch (FileNotFoundException f) {
            LOG.error((Object)("savePdf() FileNotFoundException: " + f.getMessage()), (Throwable)f);
            throw new PurError("FileNotFound Exception when trying to save a Purchase Order PDF", f);
        }
        catch (IOException i) {
            LOG.error((Object)("savePdf() IOException: " + i.getMessage()), (Throwable)i);
            throw new PurError("IO Exception when trying to save a Purchase Order PDF", i);
        }
        catch (Exception t) {
            LOG.error((Object)("savePdf() EXCEPTION: " + t.getMessage()), (Throwable)t);
            throw new PurError("Exception when trying to save a Purchase Order PDF", t);
        }
    }

    private void createPdf(PurchaseOrderDocument po, Document document, PdfWriter writer, String statusInquiryUrl, String campusName, String contractLanguage, String logoImage, String directorSignatureImage, String directorName, String directorTitle, String contractManagerSignatureImage, boolean isRetransmit, String environment) throws DocumentException, IOException {
        this.createPdf(po, document, writer, statusInquiryUrl, campusName, contractLanguage, logoImage, directorSignatureImage, directorName, directorTitle, contractManagerSignatureImage, isRetransmit, environment, null);
    }

    private void createPdf(PurchaseOrderDocument po, Document document, PdfWriter writer, String statusInquiryUrl, String campusName, String contractLanguage, String logoImage, String directorSignatureImage, String directorName, String directorTitle, String contractManagerSignatureImage, boolean isRetransmit, String environment, List<PurchaseOrderItem> retransmitItems) throws DocumentException, IOException {
        KualiDecimal totalDollarAmount;
        List vendorStipulationsList;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createPdf() started for po number " + po.getPurapDocumentIdentifier().toString()));
        }
        this.campusName = campusName;
        this.po = po;
        this.logoImage = logoImage;
        this.environment = environment;
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(Locale.US);
        ArrayList errors = new ArrayList();
        SimpleDateFormat sdf = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.KUALI_SIMPLE_DATE_FORMAT_2);
        PurchaseOrderPdf events = new PurchaseOrderPdf().getPageEvents();
        writer.setPageEvent((PdfPageEvent)this);
        document.open();
        Paragraph p = new Paragraph();
        LOG.debug((Object)"createPdf() info table started.");
        float[] infoWidths = new float[]{0.5f, 0.5f};
        PdfPTable infoTable = new PdfPTable(infoWidths);
        infoTable.setWidthPercentage(100.0f);
        infoTable.setHorizontalAlignment(1);
        infoTable.setSplitLate(false);
        StringBuffer vendorInfo = new StringBuffer();
        vendorInfo.append("\n");
        if (StringUtils.isNotBlank((CharSequence)po.getVendorName())) {
            vendorInfo.append("     " + po.getVendorName() + "\n");
        }
        vendorInfo.append("     ATTN: " + po.getVendorAttentionName() + "\n");
        if (StringUtils.isNotBlank((CharSequence)po.getVendorLine1Address())) {
            vendorInfo.append("     " + po.getVendorLine1Address() + "\n");
        }
        if (StringUtils.isNotBlank((CharSequence)po.getVendorLine2Address())) {
            vendorInfo.append("     " + po.getVendorLine2Address() + "\n");
        }
        if (StringUtils.isNotBlank((CharSequence)po.getVendorCityName())) {
            vendorInfo.append("     " + po.getVendorCityName());
        }
        if (StringUtils.isNotBlank((CharSequence)po.getVendorStateCode())) {
            vendorInfo.append(", " + po.getVendorStateCode());
        }
        if (StringUtils.isNotBlank((CharSequence)po.getVendorAddressInternationalProvinceName())) {
            vendorInfo.append(", " + po.getVendorAddressInternationalProvinceName());
        }
        if (StringUtils.isNotBlank((CharSequence)po.getVendorPostalCode())) {
            vendorInfo.append(" " + po.getVendorPostalCode() + "\n");
        } else {
            vendorInfo.append("\n");
        }
        if (!"US".equalsIgnoreCase(po.getVendorCountryCode()) && po.getVendorCountry() != null) {
            vendorInfo.append("     " + po.getVendorCountry().getName() + "\n\n");
        } else {
            vendorInfo.append("\n\n");
        }
        p = new Paragraph();
        p.add((Object)new Chunk(" Vendor", this.ver_5_normal));
        p.add((Object)new Chunk(vendorInfo.toString(), this.cour_7_normal));
        PdfPCell cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        StringBuffer shipToInfo = new StringBuffer();
        shipToInfo.append("\n");
        if (po.getAddressToVendorIndicator()) {
            shipToInfo.append("     " + po.getReceivingName() + "\n");
            shipToInfo.append("     " + po.getReceivingLine1Address() + "\n");
            if (StringUtils.isNotBlank((CharSequence)po.getReceivingLine2Address())) {
                shipToInfo.append("     " + po.getReceivingLine2Address() + "\n");
            }
            shipToInfo.append("     " + po.getReceivingCityName() + ", " + po.getReceivingStateCode() + " " + po.getReceivingPostalCode() + "\n");
            if (StringUtils.isNotBlank((CharSequence)po.getReceivingCountryCode()) && !"US".equalsIgnoreCase(po.getReceivingCountryCode())) {
                shipToInfo.append("     " + po.getReceivingCountryName() + "\n");
            }
        } else {
            shipToInfo.append("     " + po.getDeliveryToName() + "\n");
            String deliveryBuildingName = po.getDeliveryBuildingName() + " ";
            if (po.isDeliveryBuildingOtherIndicator()) {
                deliveryBuildingName = "";
            }
            shipToInfo.append("     " + deliveryBuildingName + "Room #" + po.getDeliveryBuildingRoomNumber() + "\n");
            shipToInfo.append("     " + po.getDeliveryBuildingLine1Address() + "\n");
            if (StringUtils.isNotBlank((CharSequence)po.getDeliveryBuildingLine2Address())) {
                shipToInfo.append("     " + po.getDeliveryBuildingLine2Address() + "\n");
            }
            shipToInfo.append("     " + po.getDeliveryCityName() + ", " + po.getDeliveryStateCode() + " " + po.getDeliveryPostalCode() + "\n");
            if (StringUtils.isNotBlank((CharSequence)po.getDeliveryCountryCode()) && !"US".equalsIgnoreCase(po.getDeliveryCountryCode())) {
                shipToInfo.append("     " + po.getDeliveryCountryName() + "\n");
            }
        }
        shipToInfo.append("     " + po.getDeliveryToPhoneNumber());
        p = new Paragraph();
        p.add((Object)new Chunk("  Shipping Address", this.ver_5_normal));
        p.add((Object)new Chunk(shipToInfo.toString(), this.cour_7_normal));
        cell = new PdfPCell((Phrase)p);
        infoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Shipping Terms\n", this.ver_5_normal));
        if (po.getVendorShippingPaymentTerms() != null && po.getVendorShippingTitle() != null) {
            p.add((Object)new Chunk("     " + po.getVendorShippingPaymentTerms().getVendorShippingPaymentTermsDescription(), this.cour_7_normal));
            p.add((Object)new Chunk(" - " + po.getVendorShippingTitle().getVendorShippingTitleDescription(), this.cour_7_normal));
        } else if (po.getVendorShippingPaymentTerms() != null && po.getVendorShippingTitle() == null) {
            p.add((Object)new Chunk("     " + po.getVendorShippingPaymentTerms().getVendorShippingPaymentTermsDescription(), this.cour_7_normal));
        } else if (po.getVendorShippingTitle() != null && po.getVendorShippingPaymentTerms() == null) {
            p.add((Object)new Chunk("     " + po.getVendorShippingTitle().getVendorShippingTitleDescription(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Payment Terms\n", this.ver_5_normal));
        if (po.getVendorPaymentTerms() != null) {
            p.add((Object)new Chunk("     " + po.getVendorPaymentTerms().getVendorPaymentTermsDescription(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Delivery Required By\n", this.ver_5_normal));
        if (po.getDeliveryRequiredDate() != null && po.getDeliveryRequiredDateReason() != null) {
            p.add((Object)new Chunk("     " + sdf.format(po.getDeliveryRequiredDate()), this.cour_7_normal));
            p.add((Object)new Chunk(" - " + po.getDeliveryRequiredDateReason().getDeliveryRequiredDateReasonDescription(), this.cour_7_normal));
        } else if (po.getDeliveryRequiredDate() != null && po.getDeliveryRequiredDateReason() == null) {
            p.add((Object)new Chunk("     " + sdf.format(po.getDeliveryRequiredDate()), this.cour_7_normal));
        } else if (po.getDeliveryRequiredDate() == null && po.getDeliveryRequiredDateReason() != null) {
            p.add((Object)new Chunk("     " + po.getDeliveryRequiredDateReason().getDeliveryRequiredDateReasonDescription(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  ", this.ver_5_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        float[] nestedInfoWidths = new float[]{0.5f, 0.5f};
        PdfPTable nestedInfoTable = new PdfPTable(nestedInfoWidths);
        nestedInfoTable.setSplitLate(false);
        p = new Paragraph();
        p.add((Object)new Chunk("  Order Date\n", this.ver_5_normal));
        String orderDate = "";
        orderDate = po.getPurchaseOrderInitialOpenTimestamp() != null ? sdf.format(po.getPurchaseOrderInitialOpenTimestamp()) : sdf.format(this.getDateTimeService().getCurrentSqlDate());
        p.add((Object)new Chunk("     " + orderDate, this.cour_7_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        nestedInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Customer #\n", this.ver_5_normal));
        if (po.getVendorCustomerNumber() != null) {
            p.add((Object)new Chunk("     " + po.getVendorCustomerNumber(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        nestedInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Delivery Instructions\n", this.ver_5_normal));
        if (StringUtils.isNotBlank((CharSequence)po.getDeliveryInstructionText())) {
            p.add((Object)new Chunk("     " + po.getDeliveryInstructionText(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        nestedInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Contract ID\n", this.ver_5_normal));
        if (po.getVendorContract() != null) {
            p.add((Object)new Chunk(po.getVendorContract().getVendorContractName(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        nestedInfoTable.addCell(cell);
        cell = new PdfPCell(nestedInfoTable);
        cell.setHorizontalAlignment(1);
        infoTable.addCell(cell);
        StringBuffer billToInfo = new StringBuffer();
        billToInfo.append("\n");
        billToInfo.append("     " + po.getBillingName() + "\n");
        billToInfo.append("     " + po.getBillingLine1Address() + "\n");
        if (po.getBillingLine2Address() != null) {
            billToInfo.append("     " + po.getBillingLine2Address() + "\n");
        }
        billToInfo.append("     " + po.getBillingCityName() + ", " + po.getBillingStateCode() + " " + po.getBillingPostalCode() + "\n");
        if (po.getBillingPhoneNumber() != null) {
            billToInfo.append("     " + po.getBillingPhoneNumber());
        }
        if (po.getBillingEmailAddress() != null) {
            billToInfo.append("\n     " + po.getBillingEmailAddress());
        }
        p = new Paragraph();
        p.add((Object)new Chunk("  Billing Address", this.ver_5_normal));
        p.add((Object)new Chunk("     " + billToInfo.toString(), this.cour_7_normal));
        p.add((Object)new Chunk("\n Invoice status inquiry: " + statusInquiryUrl, this.ver_6_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        document.add((Element)infoTable);
        PdfPTable notesStipulationsTable = new PdfPTable(1);
        notesStipulationsTable.setWidthPercentage(100.0f);
        notesStipulationsTable.setSplitLate(false);
        p = new Paragraph();
        p.add((Object)new Chunk("  Vendor Note(s)\n", this.ver_5_normal));
        if (po.getVendorNoteText() != null) {
            p.add((Object)new Chunk("     " + po.getVendorNoteText() + "\n", this.cour_7_normal));
        }
        PdfPCell tableCell = new PdfPCell((Phrase)p);
        tableCell.setHorizontalAlignment(0);
        tableCell.setVerticalAlignment(4);
        notesStipulationsTable.addCell(tableCell);
        p = new Paragraph();
        p.add((Object)new Chunk("  Vendor Stipulations and Information\n", this.ver_5_normal));
        if (po.getPurchaseOrderBeginDate() != null && po.getPurchaseOrderEndDate() != null) {
            p.add((Object)new Chunk("     Order in effect from " + sdf.format(po.getPurchaseOrderBeginDate()) + " to " + sdf.format(po.getPurchaseOrderEndDate()) + ".\n", this.cour_7_normal));
        }
        if ((vendorStipulationsList = po.getPurchaseOrderVendorStipulations()).size() > 0) {
            StringBuffer vendorStipulations = new StringBuffer();
            for (PurchaseOrderVendorStipulation povs : vendorStipulationsList) {
                vendorStipulations.append("     " + povs.getVendorStipulationDescription() + "\n");
            }
            p.add((Object)new Chunk("     " + vendorStipulations.toString(), this.cour_7_normal));
        }
        tableCell = new PdfPCell((Phrase)p);
        tableCell.setHorizontalAlignment(0);
        tableCell.setVerticalAlignment(4);
        notesStipulationsTable.addCell(tableCell);
        document.add((Element)notesStipulationsTable);
        LOG.debug((Object)"createPdf() items table started.");
        float[] itemsWidths = new float[]{0.07f, 0.1f, 0.07f, 0.45f, 0.15f, 0.15f};
        if (!po.isUseTaxIndicator()) {
            itemsWidths = ArrayUtils.add((float[])itemsWidths, (float)0.14f);
            itemsWidths = ArrayUtils.add((float[])itemsWidths, (float)0.15f);
        }
        PdfPTable itemsTable = new PdfPTable(itemsWidths.length);
        itemsTable.setWidthPercentage(100.0f);
        itemsTable.setWidths(itemsWidths);
        itemsTable.setSplitLate(false);
        tableCell = new PdfPCell((Phrase)new Paragraph("Item\nNo.", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        tableCell = new PdfPCell((Phrase)new Paragraph("Quantity", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        tableCell = new PdfPCell((Phrase)new Paragraph("UOM", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        tableCell = new PdfPCell((Phrase)new Paragraph("Description", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        tableCell = new PdfPCell((Phrase)new Paragraph("Unit Cost", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        tableCell = new PdfPCell((Phrase)new Paragraph("Extended Cost", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        if (!po.isUseTaxIndicator()) {
            tableCell = new PdfPCell((Phrase)new Paragraph("Tax Amount", this.ver_5_normal));
            tableCell.setHorizontalAlignment(1);
            itemsTable.addCell(tableCell);
            tableCell = new PdfPCell((Phrase)new Paragraph("Total Amount", this.ver_5_normal));
            tableCell.setHorizontalAlignment(1);
            itemsTable.addCell(tableCell);
        }
        List<Object> itemsList = new ArrayList();
        itemsList = isRetransmit ? retransmitItems : po.getItems();
        for (PurchaseOrderItem purchaseOrderItem : itemsList) {
            if (purchaseOrderItem.getItemType() == null || !purchaseOrderItem.getItemType().isLineItemIndicator() && !purchaseOrderItem.getItemType().getItemTypeCode().equals("SPHD") && !purchaseOrderItem.getItemType().getItemTypeCode().equals("FRHT") && !purchaseOrderItem.getItemType().getItemTypeCode().equals("ORDS") && !purchaseOrderItem.getItemType().getItemTypeCode().equals("TRDI") || !this.lineItemDisplaysOnPdf(purchaseOrderItem)) continue;
            String description = purchaseOrderItem.getItemCatalogNumber() != null ? purchaseOrderItem.getItemCatalogNumber().trim() + " - " : "";
            if (StringUtils.isNotBlank((CharSequence)(description = description + (purchaseOrderItem.getItemDescription() != null ? purchaseOrderItem.getItemDescription().trim() : ""))) && (purchaseOrderItem.getItemType().getItemTypeCode().equals("ORDS") || purchaseOrderItem.getItemType().getItemTypeCode().equals("TRDI") || purchaseOrderItem.getItemType().getItemTypeCode().equals("FRHT") || purchaseOrderItem.getItemType().getItemTypeCode().equals("SPHD"))) {
                description = purchaseOrderItem.getItemType().getItemTypeDescription() + " - " + description;
            }
            tableCell = purchaseOrderItem.getItemType().isLineItemIndicator() ? new PdfPCell((Phrase)new Paragraph(purchaseOrderItem.getItemLineNumber().toString(), this.cour_7_normal)) : new PdfPCell((Phrase)new Paragraph(" ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(1);
            itemsTable.addCell(tableCell);
            String quantity = purchaseOrderItem.getItemQuantity() != null ? purchaseOrderItem.getItemQuantity().toString() : " ";
            tableCell = new PdfPCell((Phrase)new Paragraph(quantity, this.cour_7_normal));
            tableCell.setHorizontalAlignment(1);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
            tableCell = new PdfPCell((Phrase)new Paragraph(purchaseOrderItem.getItemUnitOfMeasureCode(), this.cour_7_normal));
            tableCell.setHorizontalAlignment(1);
            itemsTable.addCell(tableCell);
            tableCell = new PdfPCell((Phrase)new Paragraph(" " + description, this.cour_7_normal));
            tableCell.setHorizontalAlignment(0);
            itemsTable.addCell(tableCell);
            String unitPrice = purchaseOrderItem.getItemUnitPrice().setScale(4, 4).toString();
            tableCell = new PdfPCell((Phrase)new Paragraph(unitPrice + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
            tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(purchaseOrderItem.getExtendedPrice()) + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
            if (po.isUseTaxIndicator()) continue;
            KualiDecimal taxAmount = purchaseOrderItem.getItemTaxAmount();
            taxAmount = taxAmount == null ? KualiDecimal.ZERO : taxAmount;
            tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(taxAmount) + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
            tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(purchaseOrderItem.getTotalAmount()) + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
        }
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        if (!po.isUseTaxIndicator()) {
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
        }
        if (!po.isUseTaxIndicator()) {
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            tableCell = new PdfPCell((Phrase)new Paragraph("Total Prior to Tax: ", this.ver_10_normal));
            tableCell.setHorizontalAlignment(2);
            itemsTable.addCell(tableCell);
            itemsTable.addCell(" ");
            totalDollarAmount = new KualiDecimal(BigDecimal.ZERO);
            totalDollarAmount = po instanceof PurchaseOrderRetransmitDocument ? ((PurchaseOrderRetransmitDocument)po).getTotalPreTaxDollarAmountForRetransmit() : po.getTotalPreTaxDollarAmount();
            tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(totalDollarAmount) + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            tableCell = new PdfPCell((Phrase)new Paragraph("Total Tax: ", this.ver_10_normal));
            tableCell.setHorizontalAlignment(2);
            itemsTable.addCell(tableCell);
            itemsTable.addCell(" ");
            totalDollarAmount = new KualiDecimal(BigDecimal.ZERO);
            totalDollarAmount = po instanceof PurchaseOrderRetransmitDocument ? ((PurchaseOrderRetransmitDocument)po).getTotalTaxDollarAmountForRetransmit() : po.getTotalTaxAmount();
            tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(totalDollarAmount) + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
        }
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        if (!po.isUseTaxIndicator()) {
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
        }
        tableCell = new PdfPCell((Phrase)new Paragraph("Total order amount: ", this.ver_10_normal));
        tableCell.setHorizontalAlignment(2);
        itemsTable.addCell(tableCell);
        itemsTable.addCell(" ");
        totalDollarAmount = new KualiDecimal(BigDecimal.ZERO);
        totalDollarAmount = po instanceof PurchaseOrderRetransmitDocument ? ((PurchaseOrderRetransmitDocument)po).getTotalDollarAmountForRetransmit() : po.getTotalDollarAmount();
        tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(totalDollarAmount) + " ", this.cour_7_normal));
        tableCell.setHorizontalAlignment(2);
        tableCell.setNoWrap(true);
        itemsTable.addCell(tableCell);
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        if (!po.isUseTaxIndicator()) {
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
        }
        document.add((Element)itemsTable);
        LOG.debug((Object)"createPdf() contract language started.");
        document.add((Element)new Paragraph(contractLanguage, this.ver_6_normal));
        document.add((Element)new Paragraph("\n", this.ver_6_normal));
        LOG.debug((Object)"createPdf() signatures table started.");
        float[] fArray = new float[]{0.3f, 0.7f};
        PdfPTable signaturesTable = new PdfPTable(fArray);
        signaturesTable.setWidthPercentage(100.0f);
        signaturesTable.setHorizontalAlignment(1);
        signaturesTable.setSplitLate(false);
        if (po.getPurchaseOrderAutomaticIndicator()) {
            cell = new PdfPCell((Phrase)new Paragraph(" ", this.cour_7_normal));
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
            p = StringUtils.isBlank((CharSequence)po.getInstitutionContactName()) || StringUtils.isBlank((CharSequence)po.getInstitutionContactPhoneNumber()) || StringUtils.isBlank((CharSequence)po.getInstitutionContactEmailAddress()) ? new Paragraph("For more information contact: " + po.getRequestorPersonName() + "  " + po.getRequestorPersonPhoneNumber() + "  " + po.getRequestorPersonEmailAddress(), this.cour_7_normal) : new Paragraph("For more information contact: " + po.getInstitutionContactName() + "  " + po.getInstitutionContactPhoneNumber() + "  " + po.getInstitutionContactEmailAddress(), this.cour_7_normal);
            cell = new PdfPCell((Phrase)p);
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(1);
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
            Image directorSignature = null;
            if (StringUtils.isNotBlank((CharSequence)directorSignatureImage)) {
                try {
                    directorSignature = Image.getInstance((String)directorSignatureImage);
                }
                catch (FileNotFoundException e) {
                    LOG.info((Object)("The director signature image [" + directorSignatureImage + "] is not available.  Defaulting to the default image."));
                }
            }
            if (directorSignature == null) {
                cell = new PdfPCell();
            } else {
                directorSignature.scalePercent(30.0f, 30.0f);
                cell = new PdfPCell(directorSignature, false);
            }
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(6);
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(" ", this.cour_7_normal));
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
        }
        p = new Paragraph();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createPdf() directorName parameter: " + directorName));
        }
        if (po.getPurchaseOrderAutomaticIndicator()) {
            p.add((Object)new Chunk(directorName, this.ver_6_normal));
        } else {
            p.add((Object)new Chunk(directorName, this.ver_10_normal));
        }
        p.add((Object)new Chunk("\n" + directorTitle, this.ver_4_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(4);
        cell.setBorderWidth(0.0f);
        signaturesTable.addCell(cell);
        if (!po.getPurchaseOrderAutomaticIndicator()) {
            Image contractManagerSignature = null;
            if (StringUtils.isNotBlank((CharSequence)contractManagerSignatureImage)) {
                try {
                    contractManagerSignature = Image.getInstance((String)contractManagerSignatureImage);
                }
                catch (IOException e) {
                    LOG.info((Object)("The contract manager image [" + contractManagerSignatureImage + "] is not available.  Defaulting to the default image."));
                }
            }
            if (contractManagerSignature == null) {
                cell = new PdfPCell();
            } else {
                contractManagerSignature.scalePercent(15.0f, 15.0f);
                cell = new PdfPCell(contractManagerSignature, false);
            }
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(6);
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(" ", this.ver_10_normal));
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(po.getContractManager().getContractManagerName() + "  " + po.getContractManager().getContractManagerPhoneNumber(), this.cour_7_normal));
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(4);
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
        } else {
            cell = new PdfPCell((Phrase)new Paragraph(" ", this.ver_10_normal));
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
        }
        document.add((Element)signaturesTable);
        document.close();
        LOG.debug((Object)"createPdf()pdf document closed.");
    }

    private boolean lineItemDisplaysOnPdf(PurchaseOrderItem poi) {
        LOG.debug((Object)"lineItemDisplaysOnPdf() started");
        if (poi.getItemType() != null && (poi.getItemType().getItemTypeCode().equals("SPHD") || poi.getItemType().getItemTypeCode().equals("FRHT") || poi.getItemType().getItemTypeCode().equals("ORDS") || poi.getItemType().getItemTypeCode().equals("TRDI"))) {
            if (poi.getItemUnitPrice() != null && (poi.getItemUnitPrice().compareTo(zero.bigDecimalValue()) == 1 || poi.getItemType().getItemTypeCode().equals("ORDS") || poi.getItemType().getItemTypeCode().equals("TRDI"))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("lineItemDisplaysOnPdf() Item type is " + poi.getItemType().getItemTypeCode() + ". Unit price is " + poi.getItemUnitPrice() + ". Display on pdf."));
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("lineItemDisplaysOnPdf() Item type is " + poi.getItemType().getItemTypeCode() + ". Unit price is " + poi.getItemUnitPrice() + ". Don't display on pdf."));
            }
            return false;
        }
        if (poi.getItemType() != null && poi.getItemType().isLineItemIndicator()) {
            if (poi.getItemQuantity() == null && poi.getItemUnitPrice() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("lineItemDisplaysOnPdf() Item type is " + poi.getItemType().getItemTypeCode() + " OrderQuantity and unit price are both null. Display on pdf."));
                }
                return true;
            }
            if (poi.getItemType().isAmountBasedGeneralLedgerIndicator() && poi.getItemUnitPrice() != null && poi.getItemUnitPrice().compareTo(zero.bigDecimalValue()) >= 0 || poi.getItemType().isQuantityBasedGeneralLedgerIndicator() && poi.getItemQuantity().isGreaterThan((AbstractKualiDecimal)zero) && poi.getItemUnitPrice() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("lineItemDisplaysOnPdf() Item type is " + poi.getItemType().getItemTypeCode() + " OrderQuantity is " + poi.getItemQuantity() + ". Unit price is " + poi.getItemUnitPrice() + ". Display on pdf."));
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("lineItemDisplaysOnPdf() Item type is " + poi.getItemType().getItemTypeCode() + " and item order quantity is " + poi.getItemQuantity() + " and item unit price is " + poi.getItemUnitPrice() + ". Don't display on pdf."));
            }
        }
        return false;
    }
}

