/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.text.DecimalFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.purap.document.ContractManagerAssignmentDocument;
import org.kuali.kfs.module.purap.exception.PurapConfigurationException;
import org.kuali.kfs.module.purap.service.ImageService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class ImageServiceImpl
implements ImageService {
    private static Log LOG = LogFactory.getLog(ImageServiceImpl.class);
    private ConfigurationService configurationService;
    private ParameterService parameterService;

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public String getPurchasingDirectorImage(String key, String campusCode, String location) {
        LOG.debug((Object)"getPurchasingDirectorImage() started");
        String prefix = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_DIRECTOR_IMAGE_PREFIX");
        String extension = "." + this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_DIRECTOR_IMAGE_EXTENSION");
        return this.getFile(prefix, campusCode, key, extension, location);
    }

    @Override
    public String getContractManagerImage(String key, Integer contractManagerId, String location) {
        LOG.debug((Object)"getContractManagerImage() started");
        DecimalFormat formatter = new DecimalFormat("00");
        String cm = formatter.format(contractManagerId);
        String prefix = this.parameterService.getParameterValueAsString(ContractManagerAssignmentDocument.class, "PDF_IMAGE_PREFIX");
        String extension = "." + this.parameterService.getParameterValueAsString(ContractManagerAssignmentDocument.class, "PDF_IMAGE_EXTENSION");
        return this.getFile(prefix, cm, key, extension, location);
    }

    @Override
    public String getLogo(String key, String campusCode, String location) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getLogo() started. key is " + key + ". campusCode is " + campusCode));
        }
        String prefix = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_LOGO_IMAGE_PREFIX");
        String extension = "." + this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_LOGO_IMAGE_EXTENSION");
        return this.getFile(prefix, campusCode, key, extension, location);
    }

    protected String getFile(String prefix, String fileKey, String key, String extension, String location) {
        LOG.debug((Object)"getFile() started");
        String urlpath = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_IMAGE_LOCATION_URL");
        if (StringUtils.isEmpty((CharSequence)urlpath)) {
            urlpath = this.configurationService.getPropertyValueAsString("externalizable.images.url");
        }
        if (urlpath == null) {
            throw new PurapConfigurationException("Application Setting externalizable.images.url is missing");
        }
        if (location == null) {
            throw new PurapConfigurationException("Valid location to store temp image files was null");
        }
        String completeUrl = urlpath + prefix + "_" + fileKey.toLowerCase() + extension;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getFile() URL = " + completeUrl));
        }
        return completeUrl;
    }
}

