/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableItem;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItemUseTax;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.fixture.PaymentRequestDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PaymentRequestItemFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.vnd.businessobject.PaymentTermType;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;

@ConfigureContext(session=UserNameFixture.appleton)
public class PaymentRequestDocumentTest
extends KualiTestBase {
    public static final Class<PaymentRequestDocument> DOCUMENT_CLASS = PaymentRequestDocument.class;
    private static final String ACCOUNT_REVIEW = "Account";
    protected static DocumentService documentService = null;
    protected static PurchaseOrderService purchaseOrderService = null;
    private PaymentRequestDocument paymentRequestDocument = null;
    protected static PurchaseOrderDocument purchaseOrderDocument = null;

    protected void setUp() throws Exception {
        documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        purchaseOrderService = (PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.paymentRequestDocument = null;
        super.tearDown();
    }

    private int getExpectedPrePeCount() {
        return 4;
    }

    public final void testAddItem() throws Exception {
        ArrayList<AccountsPayableItem> items = new ArrayList<AccountsPayableItem>();
        items.add(PaymentRequestItemFixture.PREQ_QTY_UNRESTRICTED_ITEM_1.createPaymentRequestItem());
        int expectedItemTotal = items.size();
        AccountsPayableDocument document = (AccountsPayableDocument)DocumentTestUtils.createDocument((DocumentService)documentService, DOCUMENT_CLASS);
        PaymentRequestDocumentTest.assertTrue((String)"no items found", (items.size() > 0 ? 1 : 0) != 0);
        PaymentRequestDocumentTest.assertEquals((int)0, (int)document.getItems().size());
        items.forEach(arg_0 -> ((AccountsPayableDocument)document).addItem(arg_0));
        PaymentRequestDocumentTest.assertEquals((String)"item count mismatch", (int)expectedItemTotal, (int)document.getItems().size());
    }

    public final void testGetNewDocument() throws Exception {
        AccountingDocumentTestUtils.testGetNewDocument_byDocumentClass(DOCUMENT_CLASS, (DocumentService)documentService);
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=false)
    public final void testConvertIntoErrorCorrection() throws Exception {
        purchaseOrderDocument = this.createPurchaseOrderDocument(PurchaseOrderDocumentFixture.PO_APPROVAL_REQUIRED, false);
        this.paymentRequestDocument = this.createPaymentRequestDocument(PaymentRequestDocumentFixture.PREQ_APPROVAL_REQUIRED, purchaseOrderDocument, true, new KualiDecimal[]{new KualiDecimal(100)});
        AccountingDocumentTestUtils.testConvertIntoErrorCorrection((AccountingDocument)this.paymentRequestDocument, (int)this.getExpectedPrePeCount(), (DocumentService)documentService);
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=false)
    public final void testSaveDocument() throws Exception {
        purchaseOrderDocument = this.createPurchaseOrderDocument(PurchaseOrderDocumentFixture.PO_APPROVAL_REQUIRED, false);
        this.paymentRequestDocument = this.createPaymentRequestDocument(PaymentRequestDocumentFixture.PREQ_APPROVAL_REQUIRED, purchaseOrderDocument, true, new KualiDecimal[]{new KualiDecimal(100)});
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=false)
    public final void testRouteDocument() throws Exception {
        purchaseOrderDocument = this.createPurchaseOrderDocument(PurchaseOrderDocumentFixture.PO_APPROVAL_REQUIRED, true);
        purchaseOrderDocument.setAccountDistributionMethod("S");
        this.paymentRequestDocument = this.createPaymentRequestDocument(PaymentRequestDocumentFixture.PREQ_APPROVAL_REQUIRED, purchaseOrderDocument, true, new KualiDecimal[]{new KualiDecimal(100)});
        this.paymentRequestDocument.setAccountDistributionMethod("S");
        AccountingDocumentTestUtils.testRouteDocument((FinancialSystemTransactionalDocument)this.paymentRequestDocument, (DocumentService)documentService);
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=false)
    public final void testRouteDocumentToFinal() throws Exception {
        purchaseOrderDocument = this.createPurchaseOrderDocument(PurchaseOrderDocumentFixture.PO_APPROVAL_REQUIRED, true);
        this.paymentRequestDocument = this.createPaymentRequestDocument(PaymentRequestDocumentFixture.PREQ_APPROVAL_REQUIRED, purchaseOrderDocument, true, new KualiDecimal[]{new KualiDecimal(100)});
        String docId = this.paymentRequestDocument.getDocumentNumber();
        AccountingDocumentTestUtils.routeDocument((AccountingDocument)this.paymentRequestDocument, (DocumentService)documentService);
        WorkflowTestUtils.waitForNodeChange((WorkflowDocument)this.paymentRequestDocument.getDocumentHeader().getWorkflowDocument(), (String)ACCOUNT_REVIEW);
        this.changeCurrentUser(UserNameFixture.rorenfro);
        this.paymentRequestDocument = (PaymentRequestDocument)documentService.getByDocumentHeaderId(docId);
        PaymentRequestDocumentTest.assertTrue((String)"At incorrect node.", (boolean)WorkflowTestUtils.isAtNode((Document)this.paymentRequestDocument, (String)ACCOUNT_REVIEW));
        PaymentRequestDocumentTest.assertTrue((String)"Document should be enroute.", (boolean)this.paymentRequestDocument.getDocumentHeader().getWorkflowDocument().isEnroute());
        PaymentRequestDocumentTest.assertTrue((String)"rorenfro should have an approve request.", (boolean)this.paymentRequestDocument.getDocumentHeader().getWorkflowDocument().isApprovalRequested());
        documentService.approveDocument((Document)this.paymentRequestDocument, "Test approving as rorenfro", null);
        WorkflowTestUtils.waitForDocumentApproval((String)this.paymentRequestDocument.getDocumentNumber());
        this.paymentRequestDocument = (PaymentRequestDocument)documentService.getByDocumentHeaderId(docId);
        PaymentRequestDocumentTest.assertTrue((String)"Document should now be final.", (boolean)this.paymentRequestDocument.getDocumentHeader().getWorkflowDocument().isFinal());
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=false)
    public final void testUseTax() throws Exception {
        purchaseOrderDocument = this.createPurchaseOrderDocument(PurchaseOrderDocumentFixture.PO_APPROVAL_REQUIRED, true);
        purchaseOrderDocument.setDeliveryBuildingCode("BL");
        purchaseOrderDocument.setDeliveryBuildingLine1Address("2332 Correa Rd");
        purchaseOrderDocument.setDeliveryBuildingRoomNumber("124");
        purchaseOrderDocument.setDeliveryCityName("Tuscon");
        purchaseOrderDocument.setDeliveryStateCode("AZ");
        purchaseOrderDocument.setDeliveryPostalCode("85034");
        purchaseOrderDocument.setDeliveryCountryCode("US");
        purchaseOrderDocument.setBillingLine1Address("2332 Correa Rd");
        purchaseOrderDocument.setBillingCityName("Tuscon");
        purchaseOrderDocument.setBillingStateCode("AZ");
        purchaseOrderDocument.setBillingPostalCode("85034");
        purchaseOrderDocument.setBillingCountryCode("US");
        purchaseOrderDocument.setVendorName("Prepotech");
        purchaseOrderDocument.setVendorCityName("Rocky Hill");
        purchaseOrderDocument.setVendorNumber("4105-0");
        purchaseOrderDocument.setVendorStateCode("NJ");
        purchaseOrderDocument.setVendorPostalCode("08553");
        purchaseOrderDocument.setVendorCountryCode("US");
        purchaseOrderDocument.setUseTaxIndicator(true);
        List<PurchaseOrderItem> poiList = this.generateItems();
        purchaseOrderDocument.setItems(poiList);
        purchaseOrderDocument.fixItemReferences();
        purchaseOrderDocument.setTotalDollarAmount(new KualiDecimal(1000));
        this.paymentRequestDocument = this.createPaymentRequestDocument(PaymentRequestDocumentFixture.PREQ_APPROVAL_REQUIRED, purchaseOrderDocument, true, new KualiDecimal[]{new KualiDecimal(1)});
        for (PurchaseOrderItem poi : poiList) {
            if (!poi.isItemActiveIndicator() || !poi.getItemQuantity().isPositive() || poi.getItemUnitPrice().intValue() <= 0) continue;
            PaymentRequestItem pri = new PaymentRequestItem(poi, this.paymentRequestDocument);
            this.paymentRequestDocument.addItem((PurApItem)pri);
        }
        this.updateQuantityAndPrice(this.paymentRequestDocument, new KualiDecimal[]{new KualiDecimal(1)});
        this.paymentRequestDocument.setUseTaxIndicator(true);
        AccountingDocumentTestUtils.testSaveDocument((FinancialSystemTransactionalDocument)this.paymentRequestDocument, (DocumentService)documentService);
        String preqDocId = this.paymentRequestDocument.getDocumentNumber();
        this.paymentRequestDocument = (PaymentRequestDocument)documentService.getByDocumentHeaderId(preqDocId);
        String docId = this.paymentRequestDocument.getDocumentNumber();
        AccountingDocumentTestUtils.routeDocument((AccountingDocument)this.paymentRequestDocument, (DocumentService)documentService);
        WorkflowTestUtils.waitForNodeChange((WorkflowDocument)this.paymentRequestDocument.getDocumentHeader().getWorkflowDocument(), (String)ACCOUNT_REVIEW);
        this.changeCurrentUser(UserNameFixture.rorenfro);
        this.paymentRequestDocument = (PaymentRequestDocument)documentService.getByDocumentHeaderId(docId);
        PaymentRequestDocumentTest.assertTrue((String)"At incorrect node.", (boolean)WorkflowTestUtils.isAtNode((Document)this.paymentRequestDocument, (String)ACCOUNT_REVIEW));
        PaymentRequestDocumentTest.assertTrue((String)"Document should be enroute.", (boolean)this.paymentRequestDocument.getDocumentHeader().getWorkflowDocument().isEnroute());
        PaymentRequestDocumentTest.assertTrue((String)"rorenfro should have an approve request.", (boolean)this.paymentRequestDocument.getDocumentHeader().getWorkflowDocument().isApprovalRequested());
        documentService.approveDocument((Document)this.paymentRequestDocument, "Test approving as rorenfro", null);
        WorkflowTestUtils.waitForDocumentApproval((String)this.paymentRequestDocument.getDocumentNumber());
        this.paymentRequestDocument = (PaymentRequestDocument)documentService.getByDocumentHeaderId(docId);
        PaymentRequestDocumentTest.assertTrue((String)"Document should now be final.", (boolean)this.paymentRequestDocument.getDocumentHeader().getWorkflowDocument().isFinal());
    }

    public final PurchaseOrderDocument createPurchaseOrderDocument(PurchaseOrderDocumentFixture poFixture, boolean routePO) throws Exception {
        return this.createPurchaseOrderDocument(poFixture, routePO, null);
    }

    public final PurchaseOrderDocument createPurchaseOrderDocument(PurchaseOrderDocumentFixture poFixture, boolean routePO, Integer accountsPayablePurchasingDocumentLinkIdentifier) throws Exception {
        if (documentService == null) {
            documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        this.changeCurrentUser(UserNameFixture.parke);
        PurchaseOrderDocument po = poFixture.createPurchaseOrderDocument();
        po.setApplicationDocumentStatus("Open");
        po.refreshNonUpdateableReferences();
        if (ObjectUtils.isNotNull((Object)accountsPayablePurchasingDocumentLinkIdentifier)) {
            po.setAccountsPayablePurchasingDocumentLinkIdentifier(accountsPayablePurchasingDocumentLinkIdentifier);
        }
        AccountingDocumentTestUtils.testSaveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)documentService);
        String poDocId = po.getDocumentNumber();
        po = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(poDocId);
        if (routePO) {
            AccountingDocumentTestUtils.testRouteDocument((FinancialSystemTransactionalDocument)po, (DocumentService)documentService);
            WorkflowTestUtils.waitForDocumentApproval((String)po.getDocumentNumber());
            po = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(poDocId);
        }
        po.setAccountDistributionMethod("S");
        return po;
    }

    private PurchaseOrderItem createPoItem() {
        String chart_code = "BL";
        BigDecimal percentage = BigDecimal.valueOf(100L);
        String item_desc = "Iphones";
        String item_um = "CT";
        String item_catalog_number = "1F742";
        PurchaseOrderItem poi = new PurchaseOrderItem();
        SequenceAccessorService sas = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
        Integer itemIdentifier = sas.getNextAvailableSequenceNumber("PO_ITM_ID", PurchaseOrderDocument.class).intValue();
        poi.setItemIdentifier(itemIdentifier);
        poi.setItemDescription(item_desc);
        poi.setItemUnitOfMeasureCode(item_um);
        poi.setItemUnitPrice(BigDecimal.valueOf(100L));
        poi.setItemTypeCode("ITEM");
        poi.setItemQuantity(new KualiDecimal(2));
        poi.setItemLineNumber(new Integer(1));
        poi.setItemUnitPrice(BigDecimal.valueOf(100L));
        poi.setTotalAmount(new KualiDecimal(5000));
        poi.setItemCatalogNumber(item_catalog_number);
        itemIdentifier = sas.getNextAvailableSequenceNumber("PO_ITM_ID", PurchaseOrderDocument.class).intValue();
        PurchaseOrderItemUseTax newItemUseTax = new PurchaseOrderItemUseTax();
        newItemUseTax.setChartOfAccountsCode(chart_code);
        newItemUseTax.setAccountNumber("0102395");
        newItemUseTax.setFinancialObjectCode("9016");
        newItemUseTax.setTaxAmount(new KualiDecimal(56));
        newItemUseTax.setRateCode("5");
        newItemUseTax.setItemIdentifier(itemIdentifier);
        poi.getUseTaxItems().add(newItemUseTax);
        itemIdentifier = sas.getNextAvailableSequenceNumber("PO_ITM_ID", PurchaseOrderDocument.class).intValue();
        newItemUseTax = new PurchaseOrderItemUseTax();
        newItemUseTax.setChartOfAccountsCode(chart_code);
        newItemUseTax.setAccountNumber("0102395");
        newItemUseTax.setFinancialObjectCode("9015");
        newItemUseTax.setTaxAmount(new KualiDecimal(20));
        newItemUseTax.setRateCode("7");
        newItemUseTax.setItemIdentifier(itemIdentifier);
        poi.getUseTaxItems().add(newItemUseTax);
        itemIdentifier = sas.getNextAvailableSequenceNumber("PO_ITM_ID", PurchaseOrderDocument.class).intValue();
        newItemUseTax = new PurchaseOrderItemUseTax();
        newItemUseTax.setChartOfAccountsCode(chart_code);
        newItemUseTax.setAccountNumber("0102395");
        newItemUseTax.setFinancialObjectCode("9016");
        newItemUseTax.setTaxAmount(new KualiDecimal(7));
        newItemUseTax.setRateCode("12");
        newItemUseTax.setItemIdentifier(itemIdentifier);
        poi.getUseTaxItems().add(newItemUseTax);
        ArrayList<PurchaseOrderAccount> lines = new ArrayList<PurchaseOrderAccount>();
        PurchaseOrderAccount poAccount = new PurchaseOrderAccount();
        poAccount.setAccountNumber("1031400");
        poAccount.setAccountLinePercent(BigDecimal.valueOf(70L));
        poAccount.setAmount(new KualiDecimal(70));
        poAccount.setChartOfAccountsCode(chart_code);
        poAccount.setFinancialObjectCode("5000");
        lines.add(poAccount);
        PurchaseOrderAccount poAccount1 = new PurchaseOrderAccount();
        poAccount1.setAccountNumber("1031420");
        poAccount1.setAccountLinePercent(BigDecimal.valueOf(30L));
        poAccount1.setAmount(new KualiDecimal(30));
        poAccount1.setChartOfAccountsCode(chart_code);
        poAccount1.setFinancialObjectCode("5000");
        lines.add(poAccount1);
        poi.setSourceAccountingLines(lines);
        poi.setItemActiveIndicator(true);
        poi.refreshNonUpdateableReferences();
        return poi;
    }

    private List<PurchaseOrderItem> generateItems() throws Exception {
        ArrayList<PurchaseOrderItem> items = new ArrayList<PurchaseOrderItem>();
        items.add(this.createPoItem());
        return items;
    }

    public final PaymentRequestDocument createPaymentRequestDocument(PaymentRequestDocumentFixture preqFixture, PurchaseOrderDocument po, boolean copyPoItems, KualiDecimal[] itemQuantityList) throws Exception {
        if (documentService == null) {
            documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        this.changeCurrentUser(UserNameFixture.appleton);
        PaymentRequestDocument preq = preqFixture.createPaymentRequestDocument();
        preq.initiateDocument();
        if (copyPoItems) {
            preq.populatePaymentRequestFromPurchaseOrder(po, new HashMap());
        } else {
            this.populatePaymentRequestFromPurchaseOrderWithoutItems(preq, po);
        }
        this.updateQuantityAndPrice(preq, itemQuantityList);
        AccountingDocumentTestUtils.testSaveDocument((FinancialSystemTransactionalDocument)preq, (DocumentService)documentService);
        String preqDocId = preq.getDocumentNumber();
        preq = (PaymentRequestDocument)documentService.getByDocumentHeaderId(preqDocId);
        preq.setAccountDistributionMethod("S");
        return preq;
    }

    private void populatePaymentRequestFromPurchaseOrderWithoutItems(PaymentRequestDocument preq, PurchaseOrderDocument po) {
        preq.setPurchaseOrderIdentifier(po.getPurapDocumentIdentifier());
        preq.getDocumentHeader().setOrganizationDocumentNumber(po.getDocumentHeader().getOrganizationDocumentNumber());
        preq.setPostingYear(po.getPostingYear());
        preq.setVendorCustomerNumber(po.getVendorCustomerNumber());
        if (po.getPurchaseOrderCostSource() != null) {
            preq.setPaymentRequestCostSource(po.getPurchaseOrderCostSource());
            preq.setPaymentRequestCostSourceCode(po.getPurchaseOrderCostSourceCode());
        }
        if (po.getVendorShippingPaymentTerms() != null) {
            preq.setVendorShippingPaymentTerms(po.getVendorShippingPaymentTerms());
            preq.setVendorShippingPaymentTermsCode(po.getVendorShippingPaymentTermsCode());
        }
        if (po.getRecurringPaymentType() != null) {
            preq.setRecurringPaymentType(po.getRecurringPaymentType());
            preq.setRecurringPaymentTypeCode(po.getRecurringPaymentTypeCode());
        }
        preq.setVendorHeaderGeneratedIdentifier(po.getVendorHeaderGeneratedIdentifier());
        preq.setVendorDetailAssignedIdentifier(po.getVendorDetailAssignedIdentifier());
        preq.setVendorCustomerNumber(po.getVendorCustomerNumber());
        preq.setVendorName(po.getVendorName());
        String userCampus = GlobalVariables.getUserSession().getPerson().getCampusCode();
        VendorAddress vendorAddress = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDefaultAddress(po.getVendorHeaderGeneratedIdentifier(), po.getVendorDetailAssignedIdentifier(), "RM", userCampus);
        if (vendorAddress != null) {
            preq.templateVendorAddress(vendorAddress);
            preq.setVendorAddressGeneratedIdentifier(vendorAddress.getVendorAddressGeneratedIdentifier());
        } else {
            preq.setVendorAddressGeneratedIdentifier(po.getVendorAddressGeneratedIdentifier());
            preq.setVendorLine1Address(po.getVendorLine1Address());
            preq.setVendorLine2Address(po.getVendorLine2Address());
            preq.setVendorCityName(po.getVendorCityName());
            preq.setVendorStateCode(po.getVendorStateCode());
            preq.setVendorPostalCode(po.getVendorPostalCode());
            preq.setVendorCountryCode(po.getVendorCountryCode());
        }
        if (po.getVendorPaymentTerms() == null || "".equals(po.getVendorPaymentTerms().getVendorPaymentTermsCode())) {
            preq.setVendorPaymentTerms(new PaymentTermType());
            preq.setVendorPaymentTermsCode("");
        } else {
            preq.setVendorPaymentTermsCode(po.getVendorPaymentTermsCode());
            preq.setVendorPaymentTerms(po.getVendorPaymentTerms());
        }
        preq.setPaymentRequestPayDate(((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).calculatePayDate(preq.getInvoiceDate(), preq.getVendorPaymentTerms()));
        ((PurapService)SpringContext.getBean(PurapService.class)).addBelowLineItems((PurchasingAccountsPayableDocument)preq);
        preq.setAccountsPayablePurchasingDocumentLinkIdentifier(po.getAccountsPayablePurchasingDocumentLinkIdentifier());
        preq.refreshNonUpdateableReferences();
    }

    public void updateQuantityAndPrice(PaymentRequestDocument preq, KualiDecimal[] quantityList) {
        int quantityIndex = 0;
        KualiDecimal quantity = null;
        for (PaymentRequestItem pri : preq.getItems()) {
            if (pri.getItemType().isLineItemIndicator()) {
                if (pri.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
                    quantity = quantityIndex <= quantityList.length - 1 ? quantityList[quantityIndex] : new KualiDecimal(0);
                    pri.setItemQuantity(quantity);
                    pri.setExtendedPrice(pri.calculateExtendedPrice());
                    BigDecimal bigDecimal = pri.getItemUnitPrice().multiply(pri.getItemQuantity().bigDecimalValue());
                } else {
                    pri.setExtendedPrice(pri.calculateExtendedPrice());
                }
            } else {
                pri.setExtendedPrice(pri.calculateExtendedPrice());
            }
            for (PurApAccountingLine accountingLine : pri.getSourceAccountingLines()) {
                accountingLine.setAmount((KualiDecimal)((KualiDecimal)pri.getExtendedPrice().multiply((AbstractKualiDecimal)new KualiDecimal(accountingLine.getAccountLinePercent()))).divide((AbstractKualiDecimal)new KualiDecimal(100)));
            }
        }
    }
}

