/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderItemAccountsFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.DocumentStatus;

@ConfigureContext(session=UserNameFixture.parke)
public class PurchaseOrderDocumentTest
extends KualiTestBase {
    public static final Class<PurchaseOrderDocument> DOCUMENT_CLASS = PurchaseOrderDocument.class;

    private List<PurchaseOrderItemAccountsFixture> getItemParametersFromFixtures() {
        ArrayList<PurchaseOrderItemAccountsFixture> list = new ArrayList<PurchaseOrderItemAccountsFixture>();
        list.add(PurchaseOrderItemAccountsFixture.WITH_DESC_WITH_UOM_WITH_PRICE_WITH_ACCOUNT);
        return list;
    }

    private int getExpectedPrePeCount() {
        return 0;
    }

    public final void testAddItem() throws Exception {
        ArrayList<PurchaseOrderItem> items = new ArrayList<PurchaseOrderItem>();
        for (PurchaseOrderItem item : this.generateItems()) {
            items.add(item);
        }
        int expectedItemTotal = items.size();
        PurchasingDocument document = (PurchasingDocument)DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), DOCUMENT_CLASS);
        PurchaseOrderDocumentTest.assertTrue((String)"no items found", (items.size() > 0 ? 1 : 0) != 0);
        PurchaseOrderDocumentTest.assertEquals((int)0, (int)document.getItems().size());
        items.forEach(arg_0 -> ((PurchasingDocument)document).addItem(arg_0));
        PurchaseOrderDocumentTest.assertEquals((String)"item count mismatch", (int)expectedItemTotal, (int)document.getItems().size());
    }

    public final void testGetNewDocument() throws Exception {
        AccountingDocumentTestUtils.testGetNewDocument_byDocumentClass(DOCUMENT_CLASS, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    public final void testConvertIntoErrorCorrection_documentAlreadyCorrected() throws Exception {
        AccountingDocumentTestUtils.testConvertIntoErrorCorrection_documentAlreadyCorrected((AccountingDocument)this.buildSimpleDocument());
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void testConvertIntoErrorCorrection() throws Exception {
        AccountingDocumentTestUtils.testConvertIntoErrorCorrection((AccountingDocument)this.buildSimpleDocument(), (int)this.getExpectedPrePeCount(), (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void testRouteDocument() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimpleDocument();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        poDocument.prepareForSave();
        PurchaseOrderDocumentTest.assertFalse((String)"Document should not have been in ENROUTE status.", (boolean)DocumentStatus.ENROUTE.equals((Object)poDocument.getDocumentHeader().getWorkflowDocument().getStatus()));
        AccountingDocumentTestUtils.routeDocument((FinancialSystemTransactionalDocument)poDocument, (String)"test annotation", null, (DocumentService)documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)poDocument.getDocumentNumber());
        WorkflowDocument workflowDocument = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).loadWorkflowDocument(poDocument.getDocumentNumber(), UserNameFixture.kfs.getPerson());
        PurchaseOrderDocumentTest.assertTrue((String)"Document should now be final.", (boolean)workflowDocument.isFinal());
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void testSaveDocument() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimpleDocument();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        poDocument.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)poDocument, (DocumentService)documentService);
        PurchaseOrderDocument result = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(poDocument.getDocumentNumber());
        PurchaseOrderDocumentTest.assertMatch(poDocument, result);
    }

    public final void testHandleNegativeEntryAmount() {
        PurchaseOrderDocument doc = new PurchaseOrderDocument();
        GeneralLedgerPendingEntry entry = new GeneralLedgerPendingEntry();
        entry.setTransactionLedgerEntryAmount(new KualiDecimal(-1));
        doc.handleNegativeEntryAmount(entry);
        PurchaseOrderDocumentTest.assertEquals((Object)new KualiDecimal(1), (Object)entry.getTransactionLedgerEntryAmount());
        PurchaseOrderDocumentTest.assertEquals((String)"C", (String)entry.getTransactionDebitCreditCode());
    }

    public final void testHandleNegativeEntryAmountNonNegative() {
        PurchaseOrderDocument doc = new PurchaseOrderDocument();
        GeneralLedgerPendingEntry entry = new GeneralLedgerPendingEntry();
        entry.setTransactionLedgerEntryAmount(new KualiDecimal(1));
        doc.handleNegativeEntryAmount(entry);
        PurchaseOrderDocumentTest.assertEquals((Object)new KualiDecimal(1), (Object)entry.getTransactionLedgerEntryAmount());
        PurchaseOrderDocumentTest.assertEquals((String)"D", (String)entry.getTransactionDebitCreditCode());
    }

    public final void testDeliveryBuildingCodeUppercase() {
        PurchaseOrderDocument doc = new PurchaseOrderDocument();
        doc.setDeliveryBuildingCode("bl103");
        PurchaseOrderDocumentTest.assertEquals((String)"Delivery building code not uppercased", (String)"BL103", (String)doc.getDeliveryBuildingCode());
    }

    public static void assertMatch(PurchaseOrderDocument doc1, PurchaseOrderDocument doc2) {
        Assert.assertEquals((String)doc1.getDocumentNumber(), (String)doc2.getDocumentNumber());
        Assert.assertEquals((String)doc1.getDocumentHeader().getWorkflowDocument().getDocumentTypeName(), (String)doc2.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        if (StringUtils.isNotBlank((CharSequence)doc1.getPostingPeriodCode()) && StringUtils.isNotBlank((CharSequence)doc2.getPostingPeriodCode())) {
            Assert.assertEquals((String)doc1.getPostingPeriodCode(), (String)doc2.getPostingPeriodCode());
        }
        Assert.assertEquals((Object)doc1.getPostingYear(), (Object)doc2.getPostingYear());
        Assert.assertEquals((Object)doc1.getVendorHeaderGeneratedIdentifier(), (Object)doc2.getVendorHeaderGeneratedIdentifier());
        Assert.assertEquals((Object)doc1.getVendorDetailAssignedIdentifier(), (Object)doc2.getVendorDetailAssignedIdentifier());
        Assert.assertEquals((String)doc1.getVendorName(), (String)doc2.getVendorName());
        Assert.assertEquals((String)doc1.getVendorNumber(), (String)doc2.getVendorNumber());
        Assert.assertEquals((String)doc1.getApplicationDocumentStatus(), (String)doc2.getApplicationDocumentStatus());
        Assert.assertEquals((String)doc1.getChartOfAccountsCode(), (String)doc2.getChartOfAccountsCode());
        Assert.assertEquals((String)doc1.getOrganizationCode(), (String)doc2.getOrganizationCode());
        Assert.assertEquals((String)doc1.getDeliveryCampusCode(), (String)doc2.getDeliveryCampusCode());
        Assert.assertEquals((Object)doc1.getDeliveryRequiredDate(), (Object)doc2.getDeliveryRequiredDate());
        Assert.assertEquals((String)doc1.getRequestorPersonName(), (String)doc2.getRequestorPersonName());
        Assert.assertEquals((Object)doc1.getContractManagerCode(), (Object)doc2.getContractManagerCode());
        Assert.assertEquals((String)doc1.getVendorContractName(), (String)doc2.getVendorContractName());
        Assert.assertEquals((boolean)doc1.getPurchaseOrderAutomaticIndicator(), (boolean)doc2.getPurchaseOrderAutomaticIndicator());
        Assert.assertEquals((String)doc1.getPurchaseOrderTransmissionMethodCode(), (String)doc2.getPurchaseOrderTransmissionMethodCode());
        Assert.assertEquals((Object)doc1.getRequisitionIdentifier(), (Object)doc2.getRequisitionIdentifier());
        Assert.assertEquals((Object)doc1.getPurchaseOrderPreviousIdentifier(), (Object)doc2.getPurchaseOrderPreviousIdentifier());
        Assert.assertEquals((boolean)doc1.isPurchaseOrderCurrentIndicator(), (boolean)doc2.isPurchaseOrderCurrentIndicator());
        Assert.assertEquals((Object)doc1.getPurchaseOrderCreateTimestamp(), (Object)doc2.getPurchaseOrderCreateTimestamp());
        Assert.assertEquals((Object)doc1.getPurchaseOrderLastTransmitTimestamp(), (Object)doc2.getPurchaseOrderLastTransmitTimestamp());
    }

    private List<PurchaseOrderItem> generateItems() throws Exception {
        ArrayList<PurchaseOrderItem> items = new ArrayList<PurchaseOrderItem>();
        for (PurchaseOrderItemAccountsFixture itemFixture : this.getItemParametersFromFixtures()) {
            items.add(itemFixture.populateItem());
        }
        return items;
    }

    public PurchaseOrderDocument buildSimpleDocument() throws Exception {
        return PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS.createPurchaseOrderDocument();
    }

    private UserNameFixture getInitialUserName() {
        return UserNameFixture.rjweiss;
    }

    protected UserNameFixture getTestUserName() {
        return UserNameFixture.rorenfro;
    }
}

