/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurchasingItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionAccount;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentWithCommodityCodeFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionItemFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;

@ConfigureContext(session=UserNameFixture.khuntley)
public class RequisitionDocumentTest
extends KualiTestBase {
    public static final Class<RequisitionDocument> DOCUMENT_CLASS = RequisitionDocument.class;
    private static final String ACCOUNT_REVIEW = "Account";
    private RequisitionDocument requisitionDocument = null;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.requisitionDocument = null;
        super.tearDown();
    }

    private int getExpectedPrePeCount() {
        return 0;
    }

    public final void testAddItem() throws Exception {
        ArrayList<PurchasingItem> items = new ArrayList<PurchasingItem>();
        items.add(RequisitionItemFixture.REQ_ITEM_NO_APO.createRequisitionItem());
        int expectedItemTotal = items.size();
        PurchasingDocument document = (PurchasingDocument)DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), DOCUMENT_CLASS);
        RequisitionDocumentTest.assertTrue((String)"no items found", (items.size() > 0 ? 1 : 0) != 0);
        RequisitionDocumentTest.assertEquals((int)0, (int)document.getItems().size());
        items.forEach(arg_0 -> ((PurchasingDocument)document).addItem(arg_0));
        RequisitionDocumentTest.assertEquals((String)"item count mismatch", (int)expectedItemTotal, (int)document.getItems().size());
    }

    public final void testGetNewDocument() throws Exception {
        AccountingDocumentTestUtils.testGetNewDocument_byDocumentClass(DOCUMENT_CLASS, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    public final void testConvertIntoCopy_copyDisallowed() throws Exception {
        RequisitionDocument doc = this.buildSimpleDocument();
        doc.getRequisitionSource().setAllowCopyDays(Integer.valueOf(0));
        AccountingDocumentTestUtils.testConvertIntoCopy_copyDisallowed((AccountingDocument)doc, (DataDictionaryService)((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)));
    }

    public final void testConvertIntoErrorCorrection_documentAlreadyCorrected() throws Exception {
        AccountingDocumentTestUtils.testConvertIntoErrorCorrection_documentAlreadyCorrected((AccountingDocument)this.buildSimpleDocument());
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=true)
    public final void testConvertIntoErrorCorrection() throws Exception {
        this.requisitionDocument = this.buildSimpleDocument();
        AccountingDocumentTestUtils.testConvertIntoErrorCorrection((AccountingDocument)this.requisitionDocument, (int)this.getExpectedPrePeCount(), (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=true)
    public final void testRouteDocument() throws Exception {
        this.requisitionDocument = this.buildSimpleDocument();
        AccountingDocumentTestUtils.testRouteDocument((FinancialSystemTransactionalDocument)this.requisitionDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=true)
    public final void testSaveDocument() throws Exception {
        this.requisitionDocument = this.buildSimpleDocument();
        AccountingDocumentTestUtils.testSaveDocument((FinancialSystemTransactionalDocument)this.requisitionDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=true)
    public final void testSaveDocumentWithItemDeletion() throws Exception {
        this.requisitionDocument = this.buildSimpleDocument();
        AccountingDocumentTestUtils.testSaveDocument((FinancialSystemTransactionalDocument)this.requisitionDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        List items = this.requisitionDocument.getItems();
        RequisitionItem item = (RequisitionItem)items.get(0);
        this.requisitionDocument.deleteItem(0);
        AccountingDocumentTestUtils.testSaveDocument((FinancialSystemTransactionalDocument)this.requisitionDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=true)
    public final void testRouteSavedDocumentWithAccountDeletion() throws Exception {
        this.requisitionDocument = this.buildComplexDocument();
        List items = this.requisitionDocument.getItems();
        RequisitionItem item = (RequisitionItem)items.get(0);
        List accounts = item.getSourceAccountingLines();
        AccountingDocumentTestUtils.testSaveDocument((FinancialSystemTransactionalDocument)this.requisitionDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        this.requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(this.requisitionDocument.getDocumentNumber());
        RequisitionAccount account = (RequisitionAccount)item.getSourceAccountingLine(0);
        account.setAccountLinePercent(new BigDecimal(100.0));
        accounts.remove(0);
        account = (RequisitionAccount)item.getSourceAccountingLine(0);
        account.setAccountLinePercent(new BigDecimal(100.0));
        account.setAmount((KualiDecimal)((KualiDecimal)item.calculateExtendedPrice().multiply((AbstractKualiDecimal)new KualiDecimal(account.getAccountLinePercent()))).divide((AbstractKualiDecimal)new KualiDecimal(100)));
        AccountingDocumentTestUtils.testRouteDocument((FinancialSystemTransactionalDocument)this.requisitionDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=true)
    public final void testConvertIntoCopy() throws Exception {
        this.requisitionDocument = this.buildSimpleDocument();
        AccountingDocumentTestUtils.testConvertIntoCopy((AccountingDocument)this.requisitionDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), (int)this.getExpectedPrePeCount());
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=true)
    public final void testRouteDocumentToFinal() throws Exception {
        this.requisitionDocument = RequisitionDocumentFixture.REQ_NO_APO_VALID.createRequisitionDocument();
        String docId = this.requisitionDocument.getDocumentNumber();
        AccountingDocumentTestUtils.routeDocument((AccountingDocument)this.requisitionDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        WorkflowTestUtils.waitForNodeChange((WorkflowDocument)this.requisitionDocument.getDocumentHeader().getWorkflowDocument(), (String)ACCOUNT_REVIEW);
        this.changeCurrentUser(UserNameFixture.sterner);
        this.requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        RequisitionDocumentTest.assertTrue((String)"At incorrect node.", (boolean)WorkflowTestUtils.isAtNode((Document)this.requisitionDocument, (String)ACCOUNT_REVIEW));
        RequisitionDocumentTest.assertTrue((String)"Document should be enroute.", (boolean)this.requisitionDocument.getDocumentHeader().getWorkflowDocument().isEnroute());
        RequisitionDocumentTest.assertTrue((String)"sterner should have an approve request.", (boolean)this.requisitionDocument.getDocumentHeader().getWorkflowDocument().isApprovalRequested());
        ((DocumentService)SpringContext.getBean(DocumentService.class)).approveDocument((Document)this.requisitionDocument, "Test approving as sterner", null);
        this.changeCurrentUser(UserNameFixture.jgerhart);
        this.requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        ((DocumentService)SpringContext.getBean(DocumentService.class)).acknowledgeDocument((Document)this.requisitionDocument, "Acknowledging as jgerhart", null);
        WorkflowTestUtils.waitForDocumentApproval((String)this.requisitionDocument.getDocumentNumber());
        this.changeCurrentUser(UserNameFixture.khuntley);
        this.requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        RequisitionDocumentTest.assertTrue((String)"Document should now be final.", (boolean)this.requisitionDocument.getDocumentHeader().getWorkflowDocument().isFinal());
    }

    @ConfigureContext(session=UserNameFixture.rorenfro, shouldCommitTransactions=true)
    public final void testCreateAPOAlternateRequisition() throws Exception {
        RequisitionDocument altAPORequisition = RequisitionDocumentFixture.REQ_ALTERNATE_APO.createRequisitionDocument();
        AccountingDocumentTestUtils.testSaveDocument((FinancialSystemTransactionalDocument)altAPORequisition, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=true)
    public final void testRouteDocumentToFinalWithBasicActiveCommodityCode() throws Exception {
        this.requisitionDocument = RequisitionDocumentWithCommodityCodeFixture.REQ_VALID_ACTIVE_COMMODITY_CODE.createRequisitionDocument();
        String docId = this.requisitionDocument.getDocumentNumber();
        AccountingDocumentTestUtils.routeDocument((AccountingDocument)this.requisitionDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        WorkflowTestUtils.waitForNodeChange((WorkflowDocument)this.requisitionDocument.getDocumentHeader().getWorkflowDocument(), (String)ACCOUNT_REVIEW);
        this.changeCurrentUser(UserNameFixture.sterner);
        this.requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        RequisitionDocumentTest.assertTrue((String)"At incorrect node.", (boolean)WorkflowTestUtils.isAtNode((Document)this.requisitionDocument, (String)ACCOUNT_REVIEW));
        RequisitionDocumentTest.assertTrue((String)"Document should be enroute.", (boolean)this.requisitionDocument.getDocumentHeader().getWorkflowDocument().isEnroute());
        RequisitionDocumentTest.assertTrue((String)"sterner should have an approve request.", (boolean)this.requisitionDocument.getDocumentHeader().getWorkflowDocument().isApprovalRequested());
        ((DocumentService)SpringContext.getBean(DocumentService.class)).approveDocument((Document)this.requisitionDocument, "Test approving as sterner", null);
        this.changeCurrentUser(UserNameFixture.jkitchen);
        this.requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        this.changeCurrentUser(UserNameFixture.jgerhart);
        this.requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        ((DocumentService)SpringContext.getBean(DocumentService.class)).acknowledgeDocument((Document)this.requisitionDocument, "Acknowledging as jgerhart", null);
        WorkflowTestUtils.waitForDocumentApproval((String)this.requisitionDocument.getDocumentNumber());
        this.changeCurrentUser(UserNameFixture.khuntley);
        this.requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        RequisitionDocumentTest.assertTrue((String)"Document should now be final.", (boolean)this.requisitionDocument.getDocumentHeader().getWorkflowDocument().isFinal());
    }

    public final void testDeliveryBuildingCodeUppercase() {
        RequisitionDocument doc = new RequisitionDocument();
        doc.setDeliveryBuildingCode("bl103");
        RequisitionDocumentTest.assertEquals((String)"Delivery building code not uppercased", (String)"BL103", (String)doc.getDeliveryBuildingCode());
    }

    private RequisitionDocument buildSimpleDocument() {
        return RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
    }

    private RequisitionDocument buildComplexDocument() {
        return RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS_MULTIPLE_ACCOUNTS.createRequisitionDocument();
    }

    public void testRouteBrokenDocument_ItemQuantityBased_NoQuantity() {
        this.requisitionDocument = RequisitionDocumentFixture.REQ_INVALID_ITEM_QUANTITY_BASED_NO_QUANTITY.createRequisitionDocument();
        ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new RouteDocumentEvent((Document)this.requisitionDocument));
        RequisitionDocumentTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
    }
}

