/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderAmendmentDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.authorization.PurchaseOrderAmendmentDocumentPresentationController;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PurchaseOrderAmendmentDocumentPresentationControllerTest {
    private PurchaseOrderAmendmentDocumentPresentationController cut;
    @Mock
    private BankService bankSvcMock;
    @Mock
    private ParameterService parameterSvcMock;
    @Mock
    private PurchaseOrderAmendmentDocument poDocMock;
    @Mock
    private PurapService purapSvcMock;
    @Mock
    private WorkflowDocument workflowDocMock;
    private Set<String> expectedEditModes;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupBaseExpectedEditModesFromSuperclassCalls();
        this.setupPoDocMock();
        this.cut = new PurchaseOrderAmendmentDocumentPresentationController();
        this.cut.setPurapService(this.purapSvcMock);
        PurchaseOrderAmendmentDocumentPresentationController.setBankService((BankService)this.bankSvcMock);
        PurchaseOrderAmendmentDocumentPresentationController.setParameterService((ParameterService)this.parameterSvcMock);
    }

    private void setupBaseExpectedEditModesFromSuperclassCalls() {
        this.expectedEditModes = new HashSet<String>(Arrays.asList("lockVendorEntry", "amountTotaling", "assignSensitiveData"));
    }

    private void setupPoDocMock() {
        FinancialSystemDocumentHeader finSysDocHeaderMock = (FinancialSystemDocumentHeader)Mockito.mock(FinancialSystemDocumentHeader.class);
        Mockito.when((Object)finSysDocHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocMock);
        Mockito.when((Object)this.poDocMock.getFinancialSystemDocumentHeader()).thenReturn((Object)finSysDocHeaderMock);
    }

    @Test
    public void getEditModes_NothingAddedToBaseEditModes() {
        Set editModes = this.cut.getEditModes((Document)this.poDocMock);
        Assert.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    public void getEditModes_AppdocChangeInProcess_NotInitiatedSavedOrCompletionRequested_NothingAddedToBaseEditModes() {
        Mockito.when((Object)this.poDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Change in Process");
        Set editModes = this.cut.getEditModes((Document)this.poDocMock);
        Assert.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    public void getEditModes_AppdocChangeInProcess_Initiated_AmendmentEntryEditModeAdded() {
        this.expectedEditModes.add("amendmentEntry");
        Mockito.when((Object)this.poDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Change in Process");
        Mockito.when((Object)this.workflowDocMock.isInitiated()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.poDocMock);
        Assert.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    public void getEditModes_AppdocChangeInProcess_Saved_AmendmentEntryEditModeAdded() {
        this.expectedEditModes.add("amendmentEntry");
        Mockito.when((Object)this.poDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Change in Process");
        Mockito.when((Object)this.workflowDocMock.isSaved()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.poDocMock);
        Assert.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    public void getEditModes_AppdocChangeInProcess_CompletionRequested_AmendmentEntryEditModeAdded() {
        this.expectedEditModes.add("amendmentEntry");
        Mockito.when((Object)this.poDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Change in Process");
        Mockito.when((Object)this.workflowDocMock.isCompletionRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.poDocMock);
        Assert.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    public void getEditModes_AppdocAwaitNewUnorderedItemReview_AmendmentEntryEditModeAdded() {
        this.expectedEditModes.add("amendmentEntry");
        Mockito.when((Object)this.poDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Awaiting New Unordered Item Review");
        Set editModes = this.cut.getEditModes((Document)this.poDocMock);
        Assert.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    public void getEditModes_StoppedInNewUnorderedItemsRouteNode_UnorderedItemAccountEntryEditModeAdded() {
        this.expectedEditModes.add("unorderedItemAccountEntry");
        Mockito.when((Object)this.purapSvcMock.isDocumentStoppedInRouteNode((PurchasingAccountsPayableDocument)this.poDocMock, "New Unordered Items")).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.poDocMock);
        Assert.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    public void getEditModes_HasAboveTheLineItems_AllEditable_NothingAddedToBaseEditModes() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        items.add(this.buildAboveTheLinePoItem(true));
        items.add(this.buildAboveTheLinePoItem(true));
        Mockito.when((Object)this.poDocMock.getItems()).thenReturn(items);
        Set editModes = this.cut.getEditModes((Document)this.poDocMock);
        Assert.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    private PurApItem buildAboveTheLinePoItem(boolean editable) {
        PurchaseOrderItem poItem = new PurchaseOrderItem();
        ItemType itemType = new ItemType();
        itemType.setItemTypeCode("ITEM");
        poItem.setItemType(itemType);
        poItem.getSourceAccountingLines().add(new PurchaseOrderAccount());
        poItem.getSourceAccountingLines().add(new PurchaseOrderAccount());
        poItem.setItemActiveIndicator(editable);
        return poItem;
    }

    @Test
    public void getEditModes_HasAboveTheLineItems_OneEditable_DisableRemoveAccountsEditModeAddedToBaseEditModes() {
        this.expectedEditModes.add("disableRemoveAccounts");
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        items.add(this.buildAboveTheLinePoItem(true));
        items.add(this.buildAboveTheLinePoItem(false));
        Mockito.when((Object)this.poDocMock.getItems()).thenReturn(items);
        Set editModes = this.cut.getEditModes((Document)this.poDocMock);
        Assert.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    public void getEditModes_HasAboveTheLineItems_NoneEditable_DisableRemoveAccountsEditModeAddedToBaseEditModes() {
        this.expectedEditModes.add("disableRemoveAccounts");
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        items.add(this.buildAboveTheLinePoItem(false));
        items.add(this.buildAboveTheLinePoItem(false));
        Mockito.when((Object)this.poDocMock.getItems()).thenReturn(items);
        Set editModes = this.cut.getEditModes((Document)this.poDocMock);
        Assert.assertEquals(this.expectedEditModes, (Object)editModes);
    }
}

